/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.magic.execute;

import com.seeyon.cap4.form.bean.FormRelationshipBean;
import com.seeyon.cap4.form.bean.FormRelationshipMapBean;
import com.seeyon.cap4.form.bean.FormTriggerActionBean;
import com.seeyon.cap4.form.bean.FormTriggerBean;
import com.seeyon.cap4.form.bean.SimpleObjectBean;
import com.seeyon.cap4.form.modules.engin.relation.FormRelationEnums;
import com.seeyon.cap4.form.modules.engin.trigger.FormTriggerActionContext;
import com.seeyon.cap4.magic.dao.IMagicReflectionRelationDao;
import com.seeyon.cap4.magic.execute.ICAP4MagicExecuteManager;
import com.seeyon.cap4.magic.execute.MagicExecuteByVersionManager;
import com.seeyon.cap4.magic.initializer.CAP4MagicCacheInitializer;
import com.seeyon.cap4.magic.po.MagicReflectionRelationPO;
import com.seeyon.cap4.magic.vo.MagicEnums;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.FlipInfo;
import com.seeyon.ctp.util.Strings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;

public class CAP4MagicExecuteManagerImpl
implements ICAP4MagicExecuteManager {
    private IMagicReflectionRelationDao magicReflectionRelationDao;
    private static final Log LOGGER = CtpLogFactory.getLog(CAP4MagicExecuteManagerImpl.class);

    @Override
    public Map<String, Object> getFormRelationDatasByMagic(Map<String, Object> params, FormRelationshipBean formRelationshipBean, FormRelationshipMapBean formRelationshipMapBean) throws BusinessException {
        String selectedField = formRelationshipMapBean.getSelectedField();
        String point = formRelationshipMapBean.getRelationshipBean().getId() + "_" + selectedField;
        List<MagicReflectionRelationPO> reflectionRelation = this.magicReflectionRelationDao.getReflectionRelationByCallPoint(point);
        ArrayList list = new ArrayList(formRelationshipMapBean.getShowFieldList().size());
        for (SimpleObjectBean simpleObjectBean : formRelationshipMapBean.getShowFieldList()) {
            HashMap<String, String> dataMap = new HashMap<String, String>(4);
            String showValue = simpleObjectBean.getValue();
            if (Strings.isNotBlank((String)showValue) && showValue.indexOf(40) > -1) {
                showValue = showValue.substring(showValue.indexOf(40) + 1, showValue.indexOf(41));
            }
            dataMap.put("title", showValue);
            dataMap.put("field", simpleObjectBean.getName());
            if (MagicEnums.ServiceOwnerType.DEFAULT_FORM_CAP3.getType().equals(formRelationshipMapBean.getRelationshipBean().getTargetFormVersion()) && simpleObjectBean.getName().contains("_")) {
                dataMap.put("field", simpleObjectBean.getName().split("[.]")[1]);
            }
            dataMap.put("fieldType", "");
            dataMap.put("inputType", "");
            list.add(dataMap);
        }
        if (reflectionRelation != null && !reflectionRelation.isEmpty()) {
            MagicReflectionRelationPO relation = reflectionRelation.get(0);
            MagicExecuteByVersionManager execute = CAP4MagicCacheInitializer.getExecuteByVersionManager(relation.getVersionId());
            Map<String, Object> result = execute.relation(params, formRelationshipBean, formRelationshipMapBean, null, relation);
            if (result != null && !result.containsKey("columnFields")) {
                result.put("columnFields", list);
            }
            return result;
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("page", "0");
        result.put("pageSize", "0");
        result.put("dataCount", "0");
        result.put("total", "0");
        result.put("columnFields", list);
        result.put("code", "2000");
        return result;
    }

    @Override
    public Map<String, Object> getRelationAutoIncreaseRow(FlipInfo flipInfo, Map<String, Object> params, FormRelationshipBean formRelationshipBean, FormRelationshipMapBean formRelationshipMapBean) throws BusinessException {
        String point = formRelationshipMapBean.getRelationshipBean().getId() + "_" + FormRelationEnums.ViewSelectType.auto_increase_row.name();
        List<MagicReflectionRelationPO> reflectionRelation = this.magicReflectionRelationDao.getReflectionRelationByCallPoint(point);
        if (reflectionRelation != null && !reflectionRelation.isEmpty()) {
            MagicReflectionRelationPO relation = reflectionRelation.get(0);
            MagicExecuteByVersionManager execute = CAP4MagicCacheInitializer.getExecuteByVersionManager(relation.getVersionId());
            if (params == null) {
                params = new HashMap<String, Object>();
            }
            params.put("flipInfo", flipInfo);
            return execute.relation(params, formRelationshipBean, formRelationshipMapBean, null, relation);
        }
        return Collections.emptyMap();
    }

    @Override
    public void dealSysRelationDataByMagic(Map<String, Object> params, FormRelationshipMapBean formRelationshipMapBean, Set<String> fillBackFields) throws BusinessException {
        Long selectedField = formRelationshipMapBean.getConditionFormulaId();
        String point = formRelationshipMapBean.getRelationshipBean().getId() + "_" + selectedField;
        List<MagicReflectionRelationPO> reflectionRelation = this.magicReflectionRelationDao.getReflectionRelationByCallPoint(point);
        if (reflectionRelation != null && !reflectionRelation.isEmpty()) {
            MagicReflectionRelationPO relation = reflectionRelation.get(0);
            MagicExecuteByVersionManager execute = CAP4MagicCacheInitializer.getExecuteByVersionManager(relation.getVersionId());
            execute.relation(params, formRelationshipMapBean.getRelationshipBean(), formRelationshipMapBean, fillBackFields, relation);
        }
    }

    @Override
    public Map<String, Object> getRelationData(Map<String, Object> params, FormRelationshipMapBean formRelationshipMapBean) throws BusinessException {
        Long selectedField = formRelationshipMapBean.getConditionFormulaId();
        String point = formRelationshipMapBean.getRelationshipBean().getId() + "_" + selectedField;
        List<MagicReflectionRelationPO> reflectionRelation = this.magicReflectionRelationDao.getReflectionRelationByCallPoint(point);
        if (reflectionRelation != null && !reflectionRelation.isEmpty()) {
            MagicReflectionRelationPO relation = reflectionRelation.get(0);
            MagicExecuteByVersionManager execute = CAP4MagicCacheInitializer.getExecuteByVersionManager(relation.getVersionId());
            return execute.getRelationData(params, formRelationshipMapBean.getRelationshipBean(), formRelationshipMapBean, relation);
        }
        return Collections.emptyMap();
    }

    @Override
    public Map<String, Object> triggerPreWrite(FormTriggerBean triggerBean, FormTriggerActionBean actionBean, Map<String, Object> param) throws BusinessException {
        FormTriggerActionContext context = new FormTriggerActionContext(param, triggerBean, actionBean, null);
        HashMap<String, Object> result = new HashMap<String, Object>();
        String point = triggerBean.getId() + "_" + actionBean.getId();
        List<MagicReflectionRelationPO> reflectionRelation = this.magicReflectionRelationDao.getReflectionRelationByCallPoint(point);
        if (reflectionRelation == null || reflectionRelation.isEmpty()) {
            LOGGER.warn((Object)("\u65e0\u6cd5\u627e\u5230\u89e6\u53d1\u70b9 = " + point + ",\u7684\u6620\u5c04\u914d\u7f6e\uff0c\u5c06\u4e0d\u6267\u884c\u9884\u5199"));
            return result;
        }
        MagicExecuteByVersionManager execute = CAP4MagicCacheInitializer.getExecuteByVersionManager(reflectionRelation.get(0).getVersionId());
        if (execute != null) {
            execute.trigger(context, reflectionRelation.get(0), 1);
        }
        return result;
    }

    public IMagicReflectionRelationDao getMagicReflectionRelationDao() {
        return this.magicReflectionRelationDao;
    }

    public void setMagicReflectionRelationDao(IMagicReflectionRelationDao magicReflectionRelationDao) {
        this.magicReflectionRelationDao = magicReflectionRelationDao;
    }
}

