/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.magic.execute;

import com.seeyon.cap4.magic.dao.IMagicInterfaceDefineDao;
import com.seeyon.cap4.magic.dao.IMagicProviderDao;
import com.seeyon.cap4.magic.execute.MagicExecuteByVersionManager;
import com.seeyon.cap4.magic.po.MagicInterfaceDefineEntity;
import com.seeyon.cap4.magic.po.MagicReflectionRelationPO;
import com.seeyon.cap4.magic.po.MagicServiceProviderPO;
import com.seeyon.cap4.magic.utils.JSONUtils;
import com.seeyon.cap4.magic.vo.MagicEnums;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.datamagic.engine.domain.mapping.MethodMappingConfig;
import java.util.ArrayList;

public abstract class MagicExecuteByVersionBaseManager
implements MagicExecuteByVersionManager {
    private IMagicInterfaceDefineDao magicInterfaceDefineDao;
    private IMagicProviderDao magicProviderDao;

    protected MagicInterfaceDefineEntity getServiceByRelation(MagicReflectionRelationPO po) throws BusinessException {
        String cbid = po.getCalleeBusinessId();
        String cvid = po.getCalleeVersionId();
        String mappingConfig = po.getMappingConfig();
        ArrayList mmcList = new ArrayList();
        JSONUtils.parseJSonListObj_Class(mappingConfig, mmcList, MethodMappingConfig.class);
        if (mmcList.isEmpty()) {
            return null;
        }
        MagicInterfaceDefineEntity interfaceEntity = null;
        for (MethodMappingConfig t : mmcList) {
            interfaceEntity = this.magicInterfaceDefineDao.loadDefineById(cbid, cvid, t.getMethodName());
            if (interfaceEntity != null && MagicEnums.BusinessMethodType.QUERY.getType() != interfaceEntity.getServiceType()) continue;
        }
        return interfaceEntity;
    }

    protected MagicServiceProviderPO getServiceProvider(MagicInterfaceDefineEntity interfaceEntity) throws BusinessException {
        return this.magicProviderDao.loadProviders(interfaceEntity.getBusinessId(), interfaceEntity.getVersionId(), MagicEnums.ProviderStatus.ON);
    }

    public IMagicInterfaceDefineDao getMagicInterfaceDefineDao() {
        return this.magicInterfaceDefineDao;
    }

    public void setMagicInterfaceDefineDao(IMagicInterfaceDefineDao magicInterfaceDefineDao) {
        this.magicInterfaceDefineDao = magicInterfaceDefineDao;
    }

    public IMagicProviderDao getMagicProviderDao() {
        return this.magicProviderDao;
    }

    public void setMagicProviderDao(IMagicProviderDao magicProviderDao) {
        this.magicProviderDao = magicProviderDao;
    }
}

