/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.magic.execute.external;

import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormDataMasterBean;
import com.seeyon.cap4.form.bean.FormDataSubBean;
import com.seeyon.cap4.form.bean.FormFieldBean;
import com.seeyon.cap4.form.bean.FormFieldComEnum;
import com.seeyon.cap4.form.bean.FormFormulaBean;
import com.seeyon.cap4.form.bean.FormRelationshipMapBean;
import com.seeyon.cap4.form.bean.FormTriggerActionBean;
import com.seeyon.cap4.form.bean.FormTriggerBean;
import com.seeyon.cap4.form.bean.SimpleObjectBean;
import com.seeyon.cap4.form.bean.fieldCtrl.FormFieldFlowDealOption;
import com.seeyon.cap4.form.bean.fieldCtrl.FormFieldUtil;
import com.seeyon.cap4.form.modules.engin.base.formData.CAP4FormDataManager;
import com.seeyon.cap4.form.modules.engin.relation.FormRelationEnums;
import com.seeyon.cap4.form.modules.engin.relation.bo.CAP4RelationFillDataBO;
import com.seeyon.cap4.form.modules.engin.trigger.FormTriggerActionContext;
import com.seeyon.cap4.form.modules.engin.trigger.FormTriggerUtil;
import com.seeyon.cap4.form.po.CAP4FormTriggerRecord;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.cap4.form.util.FormUtil;
import com.seeyon.cap4.magic.execute.MagicProviderExecuteBaseManager;
import com.seeyon.cap4.magic.p0000100053d1b8a3ba72.v1.vo.DataPageList;
import com.seeyon.cap4.magic.p0000100053d1b8a3ba72.v1.vo.OutServiceTriggerResult;
import com.seeyon.cap4.magic.p0000100053d1b8a3ba72.v1.vo.PageDataItem;
import com.seeyon.cap4.magic.p0000100053d1b8a3ba72.v1.vo.QueryCondition;
import com.seeyon.cap4.magic.p00001000d59cda72a276.v1.vo.FormDataItem;
import com.seeyon.cap4.magic.p1000.v1.C0000100053d1b8a3ba72a1bd79caa868dd5ad677;
import com.seeyon.cap4.magic.p1000.v1.C00001000d59cda72a276820f27236daffdcdebd3;
import com.seeyon.cap4.magic.po.MagicInterfaceDefineEntity;
import com.seeyon.cap4.magic.po.MagicReflectionRelationPO;
import com.seeyon.cap4.magic.po.MagicServiceProviderPO;
import com.seeyon.cap4.magic.po.MagicServiceSummary;
import com.seeyon.cap4.magic.utils.JSONUtils;
import com.seeyon.cap4.magic.utils.MagicPrivateUtils;
import com.seeyon.cap4.magic.utils.PrivateFileUtils;
import com.seeyon.cap4.magic.vo.AttributeType;
import com.seeyon.cap4.magic.vo.MagicEnums;
import com.seeyon.cap4.magic.vo.MagicServiceDetail;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.lock.manager.LockManager;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.monitor.perf.jdbcmonitor.JMCallingObj;
import com.seeyon.ctp.organization.bo.V3xOrgAccount;
import com.seeyon.ctp.organization.bo.V3xOrgDepartment;
import com.seeyon.ctp.organization.bo.V3xOrgMember;
import com.seeyon.ctp.organization.bo.V3xOrgPost;
import com.seeyon.ctp.organization.manager.OrgManager;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.ParamUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.UUIDLong;
import com.seeyon.datamagic.engine.domain.base.DataMagicContext;
import com.seeyon.datamagic.engine.loader.PrivateClassLoader;
import com.seeyon.datamagic.engine.utils.GenerateUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;

public class MagicExternalExceuteManager
extends MagicProviderExecuteBaseManager {
    private static final Log LOGGER = CtpLogFactory.getLog(MagicExternalExceuteManager.class);
    private CAP4FormDataManager cap4FormDataManager;
    private OrgManager orgManager;
    private LockManager lockManager;

    @Override
    public String getProviderType() {
        return MagicEnums.ServiceOwnerType.DEFAULT_EXTERNAL.getType();
    }

    private static void getNewRecord(FormTriggerActionContext context, Long contentId, String desc, FormTriggerBean.TriggerState state, Collection<Long> subDataIds) throws BusinessException {
        if (Strings.isEmpty(subDataIds)) {
            MagicExternalExceuteManager.getNewRecord(context, contentId, desc, state, 0L);
        } else {
            for (Long subId : subDataIds) {
                MagicExternalExceuteManager.getNewRecord(context, contentId, desc, state, subId);
            }
        }
    }

    @Override
    public boolean transPreTrigger(FormTriggerActionContext context, MagicReflectionRelationPO relation, MagicInterfaceDefineEntity entry, MagicServiceProviderPO provider) throws BusinessException {
        return true;
    }

    private static void getNewRecord(FormTriggerActionContext context, Long contentId, String desc, FormTriggerBean.TriggerState state, Long subDataId) throws BusinessException {
        FormTriggerBean triggerBean = context.getTriggerBean();
        FormTriggerActionBean actionBean = context.getActionBean();
        if (context.isMagic()) {
            actionBean = context.getMagicAction();
        }
        CAP4FormTriggerRecord record = new CAP4FormTriggerRecord();
        record.setNewId();
        record.setSourceMasterId(context.getMasterBean().getId());
        record.setSourceSubId(subDataId);
        record.setTargetFormId(Long.valueOf(triggerBean.getTargetFormId()));
        record.setTriggerId(triggerBean.getId());
        record.setActionId(actionBean.getId());
        record.setActionType(actionBean.getType());
        record.setTriggerContentId(contentId);
        record.setTriggerContentDesc(desc);
        record.setState(Integer.valueOf(state.getKey()));
        record.setLastTriggerTime(DateUtil.currentDate());
        record.setCreateId(Long.valueOf(AppContext.currentUserId()));
        record.setTriggerJson(context.getTriggerBean().toJSon4Record());
        context.getRecords().add(record);
    }

    private void compound(FormTriggerActionContext context, Map<String, Object> mainData, Map<String, List<Map<String, Object>>> subData) throws NumberFormatException, BusinessException {
        FormTriggerActionBean fta = context.getActionBean();
        FormBean fromFormBean = context.getFormBean();
        FormDataMasterBean formDataBean = context.getMasterBean();
        List fillBackList = (List)fta.getParam("outServiceParams");
        if (fillBackList != null) {
            HashMap<Object, ArrayList<SimpleObjectBean>> convertedFillBackMap = new HashMap<Object, ArrayList<SimpleObjectBean>>();
            for (SimpleObjectBean s : fillBackList) {
                String sourceTableName = s.getValue().split("[.]")[0];
                ArrayList<SimpleObjectBean> fieldList = (ArrayList<SimpleObjectBean>)convertedFillBackMap.get(sourceTableName);
                if (fieldList == null) {
                    fieldList = new ArrayList<SimpleObjectBean>();
                    convertedFillBackMap.put(sourceTableName, fieldList);
                }
                fieldList.add(s);
            }
            String masterTableName = fromFormBean.getMasterTableBean().getTableName();
            List fillBackMasterFields = (List)convertedFillBackMap.remove(masterTableName);
            if (Strings.isNotEmpty((Collection)fillBackMasterFields)) {
                for (SimpleObjectBean field : fillBackMasterFields) {
                    String value = field.getValue();
                    String sFieldName = value.split("[.]")[1];
                    Object values = formDataBean.getFieldValue(sFieldName);
                    FormFieldBean fromFieldBean = fromFormBean.getFieldBeanByName(sFieldName);
                    if (values != null && FormFieldUtil.getFormFieldCtrl((String)fromFieldBean.getInputType()) instanceof FormFieldFlowDealOption && fromFieldBean.getFormatType().contains(Enums.FlowDealOptionsType.signet.getKey())) {
                        values = FormUtil.replaceDealOptionSinget((String)String.valueOf(values));
                    }
                    mainData.put(sFieldName, values);
                }
            }
            mainData.put("sourceDataId", formDataBean.getId());
            if (!convertedFillBackMap.isEmpty()) {
                FormDataMasterBean cloneMasterBean = FormTriggerUtil.cloneNowMasterBean(context, formDataBean);
                for (Map.Entry entry : convertedFillBackMap.entrySet()) {
                    String sourceTableName = (String)entry.getKey();
                    List subDataList = cloneMasterBean.getSubData(sourceTableName);
                    List fillBackSubFields = (List)entry.getValue();
                    ArrayList valueMapList = new ArrayList();
                    for (FormDataSubBean subBean : subDataList) {
                        HashMap<String, Object> valueMap = new HashMap<String, Object>();
                        for (SimpleObjectBean sub : fillBackSubFields) {
                            String value = sub.getValue();
                            String sFieldName = value.split("[.]")[1];
                            FormFieldBean fromFieldBean = fromFormBean.getFieldBeanByName(sFieldName);
                            Object dataValue = subBean.getFieldValue(sFieldName);
                            if (dataValue != null && FormFieldUtil.getFormFieldCtrl((String)fromFieldBean.getInputType()) instanceof FormFieldFlowDealOption && fromFieldBean.getFormatType().contains(Enums.FlowDealOptionsType.signet.getKey())) {
                                dataValue = FormUtil.replaceDealOptionSinget((String)String.valueOf(dataValue));
                            }
                            valueMap.put(sFieldName, dataValue);
                        }
                        valueMap.put("sourceDataId", formDataBean.getId());
                        valueMap.put("subDataId", subBean.getId());
                        valueMapList.add(valueMap);
                    }
                    subData.put(sourceTableName, valueMapList);
                }
            }
        }
    }

    private boolean triggerFormStanderd(FormTriggerActionContext context, MagicServiceSummary serviceSummary, MagicReflectionRelationPO relation, MagicInterfaceDefineEntity interfaceEntity) throws BusinessException {
        FormDataItem formData = new FormDataItem();
        HashMap<String, Object> masterData = new HashMap<String, Object>();
        formData.setMasterData(masterData);
        HashMap<String, List<Map<String, Object>>> subTableDataList = new HashMap<String, List<Map<String, Object>>>();
        formData.setSubTableDataList(subTableDataList);
        this.compound(context, masterData, subTableDataList);
        C00001000d59cda72a276820f27236daffdcdebd3 implementationClass = super.load(relation, serviceSummary.getId(), true);
        FormBean sourceFormBean = context.getFormBean();
        FormDataMasterBean formDataBean = context.getMasterBean();
        DataMagicContext dcontext = new DataMagicContext();
        dcontext.addExtAttr("masterDataId", (Object)formDataBean.getId());
        dcontext.addExtAttr("moduleId", (Object)context.getModuleId());
        if (sourceFormBean != null) {
            dcontext.addExtAttr("formId", (Object)sourceFormBean.getId());
            dcontext.addExtAttr("sourceFormName", (Object)sourceFormBean.getFormName());
            dcontext.addExtAttr("sourceFormType", (Object)(sourceFormBean.isFlowForm() ? "1" : "0"));
        }
        dcontext.addExtAttr("actionBean", (Object)context.getActionBean());
        List<com.seeyon.cap4.magic.p00001000d59cda72a276.v1.vo.OutServiceTriggerResult> result = implementationClass.outTrigger(dcontext, formData, Collections.<String, Object>emptyMap(), 0);
        try {
            this.lockManager.lock(AppContext.currentUserId(), formDataBean.getId().longValue());
            FormDataMasterBean dataMaster = context.getMasterBean();
            if (result != null && !result.isEmpty()) {
                com.seeyon.cap4.magic.p00001000d59cda72a276.v1.vo.OutServiceTriggerResult resultItem = result.get(0);
                Map<String, Object> data = resultItem.getData();
                this.setResultToMasterBean(data, dataMaster, sourceFormBean);
            }
        }
        catch (Exception e1) {
            LOGGER.warn((Object)("\u56de\u586b\u5931\u8d25 \u5f53\u524d\u6570\u636eID" + formDataBean.getId()));
            throw new BusinessException(e1.getLocalizedMessage());
        }
        finally {
            this.lockManager.unlock(formDataBean.getId().longValue());
            MagicExternalExceuteManager.getNewRecord(context, formDataBean.getId(), "", FormTriggerBean.TriggerState.TRIGGERED, context.getDateSubIds());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean triggerForOther(FormTriggerActionContext context, MagicServiceSummary serviceSummary, MagicReflectionRelationPO relation, MagicInterfaceDefineEntity interfaceEntity) throws BusinessException {
        final C0000100053d1b8a3ba72a1bd79caa868dd5ad677 service = this.loadOther(relation, serviceSummary.getId(), true);
        if (service == null) {
            LOGGER.warn((Object)("\u6570\u636e\u9b54\u65b9 \u65e0\u6cd5\u89e6\u53d1\u4efb\u52a1  \u539f\u56e0 \u65e0\u6cd5\u627e\u5230\u63a5\u53e3\u8c03\u7528\u7c7b refelctionId  = " + relation.getId()));
            return true;
        }
        String preExecute = ParamUtil.getString(context.getParam(), (String)"preExecute");
        if ("1".equals(preExecute)) {
            return true;
        }
        FormBean sourceFormBean = context.getFormBean();
        FormDataMasterBean formDataBean = context.getMasterBean();
        final HashMap<String, Object> formData = new HashMap<String, Object>();
        if (formDataBean != null) {
            formData.putAll(formDataBean.getAllDataMap());
            formData.putAll(super.getSysValue(formDataBean));
        }
        FormBean sourceForm = context.getFormBean();
        FormTriggerActionBean actionBean = context.getActionBean();
        if (actionBean.getParam() != null && actionBean.getParam().containsKey("outServiceParams") && formDataBean != null) {
            List outServiceParams = (List)actionBean.getParam("outServiceParams");
            for (SimpleObjectBean e : outServiceParams) {
                String type = e.getType();
                String value = e.getValue();
                if (!"user_input".equals(type)) continue;
                formData.put(value, value);
            }
        }
        if (MagicEnums.ServiceOwnerType.DEFAULT_DEE.getType().equals(serviceSummary.getOwnerType())) {
            JMCallingObj jmCallingObj = null;
            try {
                String name = "";
                if (Strings.isNotBlank((String)interfaceEntity.getOtherAttr())) {
                    Map other = JSONUtils.parseJSonStr_Class(interfaceEntity.getOtherAttr(), Map.class);
                    name = ParamUtil.getString((Map)other, (String)"flowName", (String)"");
                }
                String curName = AppContext.currentUserName() != null ? AppContext.currentUserName() : "";
                jmCallingObj = super.getJmMonitorService().putJMCall(sourceForm.getId().longValue(), (Object)("DEE|" + name), interfaceEntity.getMethodName(), curName);
            }
            catch (Throwable throwable) {
                try {
                    if (jmCallingObj != null) {
                        super.getJmMonitorService().endJMCall(jmCallingObj);
                    }
                }
                catch (BusinessException e) {
                    LOGGER.error((Object)("end monitor exceptions:" + (Object)((Object)e)));
                }
                throw throwable;
            }
            try {
                if (jmCallingObj != null) {
                    super.getJmMonitorService().endJMCall(jmCallingObj);
                }
            }
            catch (BusinessException e) {
                LOGGER.error((Object)("end monitor exceptions:" + (Object)((Object)e)));
            }
        }
        final DataMagicContext dcontext = new DataMagicContext();
        dcontext.addExtAttr("masterDataId", (Object)formDataBean.getId());
        if (sourceForm != null) {
            dcontext.addExtAttr("formId", (Object)sourceForm.getId());
            dcontext.addExtAttr("sourceFormName", (Object)sourceForm.getFormName());
            dcontext.addExtAttr("sourceFormType", (Object)(sourceForm.isFlowForm() ? "1" : "0"));
        }
        ExecutorService executorService = Executors.newCachedThreadPool(new ThreadFactory(){
            private AtomicInteger threadNum = new AtomicInteger(1);

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "Cap4Magic_Thread_" + this.threadNum.getAndIncrement());
            }
        });
        Future<List<OutServiceTriggerResult>> future = executorService.submit(new Callable<List<OutServiceTriggerResult>>(){

            @Override
            public List<OutServiceTriggerResult> call() throws Exception {
                return service.outTrigger(dcontext, formData, formData, 0);
            }
        });
        try {
            this.lockManager.lock(AppContext.currentUserId(), formDataBean.getId().longValue());
            List<OutServiceTriggerResult> result = future.get(30L, TimeUnit.SECONDS);
            FormDataMasterBean dataMaster = context.getMasterBean();
            if (result != null && !result.isEmpty()) {
                OutServiceTriggerResult resultItem = result.get(0);
                Map<String, Object> data = resultItem.getData();
                this.setResultToMasterBean(data, dataMaster, sourceFormBean);
            }
        }
        catch (Exception e1) {
            LOGGER.warn((Object)("dee\u56de\u586b\u5931\u8d25 \u5f53\u524d\u6570\u636eID" + formDataBean.getId()));
        }
        finally {
            this.lockManager.unlock(formDataBean.getId().longValue());
            MagicExternalExceuteManager.getNewRecord(context, (Long)0L, "", FormTriggerBean.TriggerState.TRIGGERED, context.getDateSubIds());
        }
        return true;
    }

    private void setResultToMasterBean(Map<String, Object> data, FormDataMasterBean dataMaster, FormBean sourceFormBean) throws BusinessException {
        if (data != null && !data.isEmpty()) {
            for (Map.Entry<String, Object> entry : data.entrySet()) {
                FormFieldBean ffb;
                String key = entry.getKey();
                if (key.contains(".")) {
                    key = key.substring(key.indexOf(46) + 1, key.length());
                }
                if ((ffb = sourceFormBean.getFieldBeanByName(key)) == null) continue;
                Object value = entry.getValue();
                if (!ffb.isMasterField() || value == null) continue;
                dataMaster.addFieldValue(key, value);
            }
            ArrayList<FormDataMasterBean> masterBeans = new ArrayList<FormDataMasterBean>();
            masterBeans.add(dataMaster);
            String flag = FormTriggerUtil.validateCheckRule(sourceFormBean, masterBeans);
            if (Strings.isEmpty((String)flag)) {
                try {
                    this.cap4FormDataManager.insertOrUpdateMasterData(dataMaster);
                }
                catch (SQLException e) {
                    throw new BusinessException((Throwable)e);
                }
            }
        }
    }

    @Override
    public boolean transTrigger(FormTriggerActionContext context, MagicReflectionRelationPO relation, MagicInterfaceDefineEntity interfaceEntity, MagicServiceProviderPO provider) throws BusinessException {
        MagicServiceSummary serviceSummary = this.getMagicServiceSummaryDao().loadServiceInfo(interfaceEntity.getBusinessId(), interfaceEntity.getVersionId());
        if (relation.getBusinessId().equals("00001000d59cda72a276820f27236daffdcdebd3")) {
            return this.triggerFormStanderd(context, serviceSummary, relation, interfaceEntity);
        }
        return this.triggerForOther(context, serviceSummary, relation, interfaceEntity);
    }

    private PageDataItem convertResult(PageDataItem data, String fieldName, FormBean fb) throws BusinessException {
        FormFieldBean ffb = fb.getFieldBeanByName(fieldName);
        if (ffb != null && data != null) {
            Object value = data.getValue();
            if (value == null || Strings.isBlank((String)data.toString())) {
                return data;
            }
            FormFieldComEnum inputEnum = ffb.getInputTypeEnum();
            String id = value.toString();
            switch (inputEnum) {
                case EXTEND_ACCOUNT: {
                    V3xOrgAccount entity;
                    if (!MagicPrivateUtils.isNumeric(id) || (entity = this.orgManager.getAccountById(Long.valueOf(Long.parseLong(id)))) == null) break;
                    data.setShowValue(entity.getName());
                    break;
                }
                case EXTEND_DEPARTMENT: {
                    V3xOrgDepartment entity;
                    if (!MagicPrivateUtils.isNumeric(id) || (entity = this.orgManager.getDepartmentById(Long.valueOf(Long.parseLong(id)))) == null) break;
                    data.setShowValue(entity.getName());
                    break;
                }
                case EXTEND_POST: {
                    V3xOrgPost entity;
                    if (!MagicPrivateUtils.isNumeric(id) || (entity = this.orgManager.getPostById(Long.valueOf(Long.parseLong(id)))) == null) break;
                    data.setShowValue(entity.getName());
                    break;
                }
                case EXTEND_MEMBER: {
                    V3xOrgMember entity;
                    if (MagicPrivateUtils.isNumeric(id) && (entity = this.orgManager.getMemberById(Long.valueOf(Long.parseLong(id)))) != null) {
                        data.setShowValue(entity.getName());
                    }
                }
                case EXTEND_LEVEL: {
                    V3xOrgMember entity;
                    if (!MagicPrivateUtils.isNumeric(id) || (entity = this.orgManager.getLevelById(Long.valueOf(Long.parseLong(id)))) == null) break;
                    data.setShowValue(entity.getName());
                    break;
                }
                case EXTEND_MULTI_ACCOUNT: 
                case EXTEND_MULTI_DEPARTMENT: 
                case EXTEND_MULTI_POST: 
                case EXTEND_MULTI_MEMBER: 
                case EXTEND_MULTI_LEVEL: {
                    break;
                }
                case TEXT: 
                case TEXTAREA: {
                    String text = value.toString();
                    String length = ffb.getFieldLength();
                    if (!MagicPrivateUtils.isNumeric(length)) break;
                    int l = Integer.parseInt(length);
                    if (text.length() > l) {
                        text = text.substring(0, l);
                    }
                    data.setValue(text);
                    data.setShowValue(text);
                    break;
                }
                case FLOWDEALOPITION: {
                    data.setShowValue(value.toString());
                    break;
                }
                case EXTEND_DATE: 
                case EXTEND_DATETIME: {
                    Object[] datasss = ffb.getDisplayValue(value, false);
                    if (datasss == null || datasss.length <= 1) break;
                    data.setValue(datasss[0]);
                    data.setShowValue(String.valueOf(datasss[1]));
                    data.setShowValue2(DateUtil.format((Date)((Date)datasss[0]), (String)"yyyy-MM-dd HH:mm:ss"));
                    break;
                }
                default: {
                    if (MagicPrivateUtils.isNumeric(value.toString())) break;
                    data.setValue(null);
                    data.setShowValue("");
                }
            }
        }
        return data;
    }

    @Override
    public Map<String, Object> relation(Map<String, Object> params, FormRelationshipMapBean formRelationshipMapBean, MagicReflectionRelationPO relation, MagicInterfaceDefineEntity interfaceEntity, MagicServiceProviderPO provider, Set<String> fillbackList) throws BusinessException {
        MagicServiceSummary serviceSummary = this.getMagicServiceSummaryDao().loadServiceInfo(interfaceEntity.getBusinessId(), interfaceEntity.getVersionId());
        if (FormRelationEnums.ViewSelectType.user.getKey() == formRelationshipMapBean.getRelationshipBean().getRelationType()) {
            if (MagicEnums.ServiceOwnerType.DEFAULT_DEE.getType().equals(serviceSummary.getOwnerType()) && !AppContext.hasPlugin((String)"dee")) {
                throw new BusinessException(ResourceUtil.getString((String)"dee.form.hasplugin.off"));
            }
            return this.userRelation(params, formRelationshipMapBean, relation, interfaceEntity, provider, serviceSummary.getId());
        }
        if (MagicEnums.ServiceOwnerType.DEFAULT_DEE.getType().equals(serviceSummary.getOwnerType()) && !AppContext.hasPlugin((String)"dee")) {
            return Collections.emptyMap();
        }
        return this.sysRelation(params, formRelationshipMapBean, relation, interfaceEntity, provider, fillbackList, serviceSummary.getId());
    }

    @Override
    protected List<Map<String, Object>> getProviderRelationData(Map<String, Object> params, FormRelationshipMapBean formRelationshipMapBean, MagicReflectionRelationPO relation, Long serviceId) throws BusinessException {
        return this.getSysRelationData(params, formRelationshipMapBean, relation, serviceId);
    }

    private List<Map<String, Object>> getSysRelationData(Map<String, Object> params, FormRelationshipMapBean formRelationshipMapBean, MagicReflectionRelationPO relation, Long serviceId) throws BusinessException {
        List<Map<String, PageDataItem>> datas;
        HashSet fillBackSubFields;
        DataMagicContext context = new DataMagicContext();
        ArrayList<QueryCondition> condition = new ArrayList<QueryCondition>();
        HashMap<String, Object> formData = new HashMap<String, Object>();
        Integer page = ParamUtil.getInt(params, (String)"page", (int)1);
        Integer pageSize = ParamUtil.getInt(params, (String)"pageSize", (int)1);
        String selectedToMasterDataId = ParamUtil.getString(params, (String)"selectedMasterDataId");
        Long masterId = ParamUtil.getLong(params, (String)"fromDataId", (Long)0L);
        FormDataMasterBean formCacheDataMasterBean = (FormDataMasterBean)params.get("formCacheDataMasterBean");
        if (formCacheDataMasterBean != null) {
            formData.putAll(formCacheDataMasterBean.getAllDataMap());
            formData.putAll(super.getSysValue(formCacheDataMasterBean));
        }
        long formRecordId = ParamUtil.getLong(params, (String)"formRecordId", (Long)0L);
        long sourceFormId = formRelationshipMapBean.getRelationshipBean().getSourceFormId();
        FormBean fromFormBean = this.getCap4FormCacheManager().getForm(sourceFormId);
        if (formRelationshipMapBean.getParams() != null && formRelationshipMapBean.getParams().containsKey("outServiceParams") && formCacheDataMasterBean != null) {
            List outServiceParams = (List)formRelationshipMapBean.getParams("outServiceParams");
            for (Object e : outServiceParams) {
                String type = ParamUtil.getString((Map)e, (String)"type");
                String value = ParamUtil.getString((Map)e, (String)"value", (String)"");
                if ("formField".equals(type)) {
                    Map subDataMap;
                    FormFieldBean formFieldBean = fromFormBean.getFieldBeanByName(value);
                    if (formFieldBean == null || !formFieldBean.isSubField() || (subDataMap = formCacheDataMasterBean.getSubDataMapById(formFieldBean.getOwnerTableName(), Long.valueOf(formRecordId))) == null || subDataMap.isEmpty()) continue;
                    formData.put(formFieldBean.getName(), subDataMap.get(formFieldBean.getName()));
                    continue;
                }
                if (!"user_input".equals(type)) continue;
                formData.put(value, value);
            }
        }
        FormFormulaBean formFormulaBean = formRelationshipMapBean.getConditionFormula();
        Map contionFieldMap = FormUtil.getRelationFormulaFieldMap((FormFormulaBean)formFormulaBean);
        for (Map.Entry entry : contionFieldMap.entrySet()) {
            Map subData;
            Object value;
            FormFieldBean formFieldBean = fromFormBean.getFieldBeanByName((String)entry.getKey());
            QueryCondition qc = new QueryCondition();
            qc.setFieldName((String)entry.getValue());
            qc.setOperation("Equal");
            qc.setRowOperation("and");
            if (formFieldBean.isMasterField()) {
                value = formCacheDataMasterBean.getFieldValue((String)entry.getKey());
                if (value != null && !StringUtils.isEmpty((CharSequence)String.valueOf(value))) {
                    qc.setFieldValue(value);
                }
            } else if (formRecordId != 0L && (subData = formCacheDataMasterBean.getSubDataMapById(formFieldBean.getOwnerTableName(), Long.valueOf(formRecordId))) != null && subData.get(entry.getKey()) != null && !StringUtils.isEmpty((CharSequence)String.valueOf(subData.get(entry.getKey())))) {
                qc.setFieldValue(subData.get(entry.getKey()));
            }
            if (qc.getFieldValue() != null) {
                value = qc.getFieldValue();
                qc.setFieldValue(value);
            }
            if (!formFieldBean.isMasterField() && formRecordId == 0L) continue;
            condition.add(qc);
        }
        C0000100053d1b8a3ba72a1bd79caa868dd5ad677 service = this.loadOther(relation, serviceId, true);
        HashMap sysRelationCacheData = (HashMap)formCacheDataMasterBean.getExtraMap().get("sysRelationCacheData");
        if (sysRelationCacheData == null) {
            sysRelationCacheData = new HashMap();
            formCacheDataMasterBean.getExtraMap().put("sysRelationCacheData", sysRelationCacheData);
        }
        if ((fillBackSubFields = (HashSet)formCacheDataMasterBean.getExtraMap().get("fillBackSubFields")) == null) {
            fillBackSubFields = new HashSet();
            formCacheDataMasterBean.getExtraMap().put("fillBackSubFields", fillBackSubFields);
        }
        context.addExtAttr("masterDataId", (Object)masterId);
        if (fromFormBean != null) {
            context.addExtAttr("sourceFormName", (Object)fromFormBean.getFormName());
            context.addExtAttr("sourceFormType", (Object)(fromFormBean.isFlowForm() ? "1" : "0"));
        }
        DataPageList dataPage = null;
        try {
            dataPage = service.outRelation(context, condition, selectedToMasterDataId, page, pageSize, formData);
        }
        catch (Exception e) {
            LOGGER.warn((Object)"\u7cfb\u7edf\u5173\u8054\u83b7\u53d6\u6570\u636e\u5931\u8d25");
        }
        ArrayList<Map<String, Object>> relationDatas = new ArrayList<Map<String, Object>>();
        if (dataPage != null && (datas = dataPage.getData()) != null && !datas.isEmpty()) {
            for (Map<String, PageDataItem> dataI : datas) {
                HashMap<String, Object> temp = new HashMap<String, Object>();
                for (Map.Entry<String, PageDataItem> entry : dataI.entrySet()) {
                    PageDataItem item = entry.getValue();
                    if (item == null) continue;
                    temp.put(entry.getKey(), item.getValue());
                }
                relationDatas.add(temp);
            }
        }
        return relationDatas;
    }

    Map<String, Object> sysRelation(Map<String, Object> params, FormRelationshipMapBean formRelationshipMapBean, MagicReflectionRelationPO relation, MagicInterfaceDefineEntity interfaceEntity, MagicServiceProviderPO provider, Set<String> fillbackList, Long serviceId) throws BusinessException {
        List<Map<String, PageDataItem>> datas;
        HashSet fillBackSubFields;
        DataMagicContext context = new DataMagicContext();
        ArrayList<QueryCondition> condition = new ArrayList<QueryCondition>();
        HashMap<String, Object> formData = new HashMap<String, Object>();
        Integer page = ParamUtil.getInt(params, (String)"page", (int)1);
        Integer pageSize = ParamUtil.getInt(params, (String)"pageSize", (int)-1);
        String selectedToMasterDataId = ParamUtil.getString(params, (String)"selectedMasterDataId");
        Long masterId = ParamUtil.getLong(params, (String)"fromDataId", (Long)0L);
        FormDataMasterBean formCacheDataMasterBean = (FormDataMasterBean)params.get("formCacheDataMasterBean");
        if (formCacheDataMasterBean != null) {
            formData.putAll(formCacheDataMasterBean.getAllDataMap());
            formData.putAll(super.getSysValue(formCacheDataMasterBean));
        }
        long formRecordId = ParamUtil.getLong(params, (String)"formRecordId", (Long)0L);
        long sourceFormId = formRelationshipMapBean.getRelationshipBean().getSourceFormId();
        FormBean fromFormBean = this.getCap4FormCacheManager().getForm(sourceFormId);
        if (formRelationshipMapBean.getParams() != null && formRelationshipMapBean.getParams().containsKey("outServiceParams") && formCacheDataMasterBean != null) {
            List outServiceParams = (List)formRelationshipMapBean.getParams("outServiceParams");
            for (Map e : outServiceParams) {
                String type = ParamUtil.getString((Map)e, (String)"type");
                String value = ParamUtil.getString((Map)e, (String)"value", (String)"");
                if ("formField".equals(type)) {
                    Map subDataMap;
                    FormFieldBean formFieldBean = fromFormBean.getFieldBeanByName(value);
                    if (formFieldBean == null || !formFieldBean.isSubField() || (subDataMap = formCacheDataMasterBean.getSubDataMapById(formFieldBean.getOwnerTableName(), Long.valueOf(formRecordId))) == null || subDataMap.isEmpty()) continue;
                    formData.put(formFieldBean.getName(), subDataMap.get(formFieldBean.getName()));
                    continue;
                }
                if (!"user_input".equals(type)) continue;
                formData.put(value, value);
            }
        }
        boolean mappingHasMaster = false;
        boolean mappingHasSon = false;
        boolean conditionHasMaster = false;
        boolean conditionHasSon = false;
        Map relationFieldMap = formRelationshipMapBean.getFormRelationFieldMap();
        for (String fromFieldName : relationFieldMap.keySet()) {
            FormFieldBean formFieldBean = fromFormBean.getFieldBeanByName(fromFieldName);
            if (formFieldBean.isMasterField()) {
                mappingHasMaster = true;
            }
            if (!formFieldBean.isSubField()) continue;
            mappingHasSon = true;
        }
        HashMap sonTableFieldContionfieldMap = new HashMap();
        String fromSonTableName = "";
        FormFormulaBean formFormulaBean = formRelationshipMapBean.getConditionFormula();
        Map contionFieldMap = FormUtil.getRelationFormulaFieldMap((FormFormulaBean)formFormulaBean);
        for (Map.Entry entry : contionFieldMap.entrySet()) {
            FormFieldBean formFieldBean = fromFormBean.getFieldBeanByName((String)entry.getKey());
            if (formFieldBean.isMasterField()) continue;
            conditionHasSon = true;
            sonTableFieldContionfieldMap.put(formFieldBean.getName(), entry.getValue());
            fromSonTableName = formFieldBean.getOwnerTableName();
        }
        boolean conditionAllNull = true;
        for (Map.Entry entry : contionFieldMap.entrySet()) {
            Object value;
            FormFieldBean formFieldBean = fromFormBean.getFieldBeanByName((String)entry.getKey());
            QueryCondition qc = new QueryCondition();
            qc.setFieldName((String)entry.getValue());
            qc.setOperation("Equal");
            qc.setRowOperation("and");
            if (formFieldBean.isMasterField()) {
                value = formCacheDataMasterBean.getFieldValue((String)entry.getKey());
                if (value != null && !StringUtils.isEmpty((CharSequence)String.valueOf(value))) {
                    qc.setFieldValue(value);
                }
                if (conditionAllNull && value != null) {
                    conditionAllNull = false;
                }
            } else {
                conditionHasSon = true;
                sonTableFieldContionfieldMap.put(formFieldBean.getName(), entry.getValue());
                fromSonTableName = formFieldBean.getOwnerTableName();
                if (formRecordId != 0L) {
                    Map subData = formCacheDataMasterBean.getSubDataMapById(formFieldBean.getOwnerTableName(), Long.valueOf(formRecordId));
                    Object value2 = subData.get(entry.getKey());
                    if (value2 != null && !StringUtils.isEmpty((CharSequence)String.valueOf(subData.get(entry.getKey())))) {
                        qc.setFieldValue(subData.get(entry.getKey()));
                    }
                    if (conditionAllNull && value2 != null) {
                        conditionAllNull = false;
                    }
                }
            }
            if (qc.getFieldValue() != null) {
                value = qc.getFieldValue();
                qc.setFieldValue(value);
            }
            if (!formFieldBean.isMasterField() && formRecordId == 0L) continue;
            condition.add(qc);
        }
        C0000100053d1b8a3ba72a1bd79caa868dd5ad677 service = this.loadOther(relation, serviceId, true);
        Map map = (Map)formCacheDataMasterBean.getExtraMap().get("sysRelationCacheData");
        if (map == null) {
            HashMap hashMap = new HashMap();
            formCacheDataMasterBean.getExtraMap().put("sysRelationCacheData", hashMap);
        }
        if ((fillBackSubFields = (HashSet)formCacheDataMasterBean.getExtraMap().get("fillBackSubFields")) == null) {
            fillBackSubFields = new HashSet();
            formCacheDataMasterBean.getExtraMap().put("fillBackSubFields", fillBackSubFields);
        }
        context.addExtAttr("masterDataId", (Object)masterId);
        if (fromFormBean != null) {
            context.addExtAttr("sourceFormName", (Object)fromFormBean.getFormName());
            context.addExtAttr("sourceFormType", (Object)(fromFormBean.isFlowForm() ? "1" : "0"));
        }
        DataPageList dataPage = null;
        try {
            dataPage = service.outRelation(context, condition, selectedToMasterDataId, page, pageSize, formData);
        }
        catch (Exception e) {
            LOGGER.warn((Object)"\u7cfb\u7edf\u5173\u8054\u83b7\u53d6\u6570\u636e\u5931\u8d25");
        }
        ArrayList<Map<String, Object>> relationDatas = new ArrayList<Map<String, Object>>();
        if (dataPage != null && (datas = dataPage.getData()) != null && !datas.isEmpty()) {
            for (Map<String, PageDataItem> dataI : datas) {
                HashMap<String, Object> temp = new HashMap<String, Object>();
                for (Map.Entry<String, PageDataItem> entry : dataI.entrySet()) {
                    PageDataItem item = entry.getValue();
                    if (item == null) continue;
                    temp.put(entry.getKey(), item.getValue());
                }
                relationDatas.add(temp);
            }
        }
        CAP4RelationFillDataBO bo = new CAP4RelationFillDataBO();
        bo.setFormCacheDataMasterBean(formCacheDataMasterBean);
        bo.setRelationDatas(relationDatas);
        bo.setFormRecordId(formRecordId);
        bo.setFormRelationshipMapBean(formRelationshipMapBean);
        bo.setConditionAllNull(super.checkConditionAllNull(params, formRelationshipMapBean));
        super.getCap4FormRelationActionManager().dealFillOrCleanSysRelationData(bo, fillbackList);
        return Collections.emptyMap();
    }

    private Map<String, Object> userRelation(Map<String, Object> params, FormRelationshipMapBean formRelationshipMapBean, MagicReflectionRelationPO relation, MagicInterfaceDefineEntity interfaceEntity, MagicServiceProviderPO provider, Long serviceId) throws BusinessException {
        Integer page = ParamUtil.getInt(params, (String)"page", (int)1);
        Integer pageSize = ParamUtil.getInt(params, (String)"pageSize", (int)1);
        String selectedToMasterDataId = ParamUtil.getString(params, (String)"selectedMasterDataId");
        int isMainSelecter = ParamUtil.getInt(params, (String)"isMainSelecter", (int)1);
        String fromRelationAttr = ParamUtil.getString(params, (String)"fromRelationAttr");
        long formRecordId = ParamUtil.getLong(params, (String)"fromRecordId", (Long)0L);
        Long masterId = ParamUtil.getLong(params, (String)"fromDataId", (Long)0L);
        String isInit = ParamUtil.getString(params, (String)"isInit", (String)"");
        FormDataMasterBean dataMaster = this.getCap4FormManager().getSessioMasterDataBean(masterId);
        C0000100053d1b8a3ba72a1bd79caa868dd5ad677 service = this.loadOther(relation, serviceId, true);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("page", page + "");
        result.put("pageSize", pageSize + "");
        result.put("dataCount", "0");
        result.put("total", "0");
        if (service == null) {
            result.put("data", Collections.emptyList());
            LOGGER.warn((Object)("\u6570\u636e\u9b54\u65b9 \u65e0\u6cd5\u89e6\u53d1\u4efb\u52a1  \u539f\u56e0 \u65e0\u6cd5\u627e\u5230\u63a5\u53e3\u8c03\u7528\u7c7b refelctionId  = " + relation.getId()));
            return result;
        }
        MagicServiceDetail serviceDetail = MagicPrivateUtils.convert(interfaceEntity);
        List attributeTypes = serviceDetail.getResultConfig().getAttrs();
        HashMap<String, AttributeType> resultKeyMapper = new HashMap<String, AttributeType>(attributeTypes.size());
        for (AttributeType s : attributeTypes) {
            resultKeyMapper.put(s.getName(), s);
        }
        DataMagicContext context = new DataMagicContext();
        HashMap<String, Object> formData = new HashMap<String, Object>();
        if (dataMaster != null) {
            formData.putAll(dataMaster.getAllDataMap());
            formData.putAll(super.getSysValue(dataMaster));
        }
        long sourceFormId = formRelationshipMapBean.getRelationshipBean().getSourceFormId();
        FormBean fromFormBean = this.getCap4FormCacheManager().getForm(sourceFormId);
        if (formRelationshipMapBean.getParams() != null && formRelationshipMapBean.getParams().containsKey("outServiceParams")) {
            List outServiceParams = (List)formRelationshipMapBean.getParams("outServiceParams");
            for (Map e : outServiceParams) {
                String type = ParamUtil.getString((Map)e, (String)"type");
                String value = ParamUtil.getString((Map)e, (String)"value", (String)"");
                if ("formField".equals(type)) {
                    Map subDataMap;
                    FormFieldBean formFieldBean = fromFormBean.getFieldBeanByName(value);
                    if (formFieldBean == null || !formFieldBean.isSubField() || (subDataMap = dataMaster.getSubDataMapById(formFieldBean.getOwnerTableName(), Long.valueOf(formRecordId))) == null || subDataMap.isEmpty()) continue;
                    formData.put(formFieldBean.getName(), subDataMap.get(formFieldBean.getName()));
                    continue;
                }
                if (!"user_input".equals(type)) continue;
                formData.put(value, value);
            }
        }
        List condition = null;
        List conditions = params.get("conditions") != null ? (List)params.get("conditions") : null;
        condition = conditions != null && !conditions.isEmpty() ? ParamUtil.mapsToBeans((List)conditions, QueryCondition.class, (boolean)false) : Collections.emptyList();
        context.addExtAttr("masterDataId", (Object)masterId);
        if (fromFormBean != null) {
            context.addExtAttr("sourceFormName", (Object)fromFormBean.getFormName());
            context.addExtAttr("sourceFormType", (Object)(fromFormBean.isFlowForm() ? "1" : "0"));
        }
        ArrayList contents = new ArrayList();
        DataPageList dataPage = service.outRelation(context, condition, selectedToMasterDataId, page, pageSize, formData);
        try {
            if (dataPage == null) {
                dataPage = new DataPageList();
                dataPage.setData(Collections.<Map<String, PageDataItem>>emptyList());
                dataPage.setTotal(0);
            }
            if ("1".equals(isInit)) {
                MagicServiceDetail serviceDetails = MagicPrivateUtils.convert(interfaceEntity);
                result.put("filterFields", this.getRelationFilterFields(serviceDetails, formRelationshipMapBean, -1L));
            }
            List<String> mergeFieldList = this.getCap4FormRelationActionManager().getRelationQueryFields(formRelationshipMapBean);
            ArrayList<String> showFieldList = new ArrayList<String>();
            HashMap<String, String> fieldNameToShowValue = new HashMap<String, String>();
            ArrayList columnFields = new ArrayList(formRelationshipMapBean.getShowFieldList().size());
            for (SimpleObjectBean temp : formRelationshipMapBean.getShowFieldList()) {
                showFieldList.add(temp.getName());
                AttributeType resultKey = (AttributeType)resultKeyMapper.get(temp.getName());
                if (resultKey == null) continue;
                String showValue = temp.getValue() != null && temp.getValue().indexOf(40) > -1 ? temp.getValue().substring(temp.getValue().indexOf(40) + 1, temp.getValue().indexOf(41)) : resultKey.getDisplayName();
                fieldNameToShowValue.put(temp.getName(), showValue);
                HashMap<String, String> dataMap = new HashMap<String, String>(4);
                dataMap.put("title", showValue);
                dataMap.put("field", resultKey.getName());
                dataMap.put("fieldType", "");
                dataMap.put("inputType", "");
                columnFields.add(dataMap);
            }
            result.put("columnFields", columnFields);
            Map relationFieldMap = formRelationshipMapBean.getFormRelationFieldMap();
            for (Map<String, PageDataItem> t : dataPage.getData()) {
                String dataId = "";
                HashMap<String, Object> content = new HashMap<String, Object>();
                content.put("unique", String.valueOf(UUIDLong.longUUID()));
                HashMap mergeRecordData = new HashMap();
                for (Map.Entry entry : relationFieldMap.entrySet()) {
                    String tempV = (String)entry.getValue();
                    PageDataItem dataItem = t.get(tempV);
                    if (dataItem == null) {
                        dataItem = new PageDataItem();
                    }
                    if (Strings.isBlank((String)dataId)) {
                        dataId = dataItem.getId();
                    }
                    HashMap<String, String> toContentValue = new HashMap<String, String>();
                    toContentValue.put("value", dataItem.getValue() == null ? "" : dataItem.getValue().toString());
                    toContentValue.put("showValue", dataItem.getShowValue() == null ? "" : dataItem.getShowValue());
                    toContentValue.put("showValue2", dataItem.getShowValue2() == null ? "" : dataItem.getShowValue2());
                    toContentValue.put("display", dataItem.getDisplay());
                    toContentValue.put("isAttach", dataItem.getIsAttach() == null ? "0" : String.valueOf(dataItem.getIsAttach()));
                    if (!StringUtils.isEmpty((CharSequence)dataItem.getAttachments())) {
                        toContentValue.put("attachments", dataItem.getAttachments());
                    }
                    mergeRecordData.put(tempV, toContentValue);
                }
                for (int k = 0; k < mergeFieldList.size(); ++k) {
                    String rShowField = mergeFieldList.get(k);
                    PageDataItem dataItem = t.get(rShowField);
                    if (dataItem == null) {
                        dataItem = new PageDataItem();
                    }
                    if (Strings.isBlank((String)dataId)) {
                        dataId = dataItem.getId();
                    }
                    HashMap<String, String> toContentValue = new HashMap<String, String>();
                    toContentValue.put("value", dataItem.getValue() == null ? "" : dataItem.getValue().toString());
                    toContentValue.put("showValue", dataItem.getShowValue() == null ? "" : dataItem.getShowValue());
                    toContentValue.put("showValue2", dataItem.getShowValue2() == null ? "" : dataItem.getShowValue2());
                    String display = (String)fieldNameToShowValue.get(rShowField);
                    toContentValue.put("display", display != null ? display : dataItem.getDisplay());
                    toContentValue.put("isAttach", dataItem.getIsAttach() == null ? "0" : String.valueOf(dataItem.getIsAttach()));
                    if (!StringUtils.isEmpty((CharSequence)dataItem.getAttachments())) {
                        toContentValue.put("attachments", dataItem.getAttachments());
                    }
                    mergeRecordData.put(rShowField, toContentValue);
                }
                HashMap fromKeyDatas = new HashMap();
                Iterator iteratorField = relationFieldMap.keySet().iterator();
                while (iteratorField.hasNext()) {
                    String key = iteratorField.next().toString();
                    if (FormRelationEnums.SpecialRelationItem.FLOW_NAME.getKey().equals(relationFieldMap.get(key))) continue;
                    HashMap tempData = (HashMap)mergeRecordData.get(relationFieldMap.get(key));
                    if (tempData == null) {
                        tempData = new HashMap();
                    }
                    HashMap<String, String> newData = new HashMap<String, String>();
                    FormFieldBean fromFieldBean = fromFormBean.getFieldBeanByName(key);
                    if (fromFieldBean == null) continue;
                    newData.put("tableName", fromFieldBean.getOwnerTableName());
                    newData.put("value", (String)tempData.get("value"));
                    newData.put("showValue", (String)tempData.get("showValue"));
                    newData.put("showValue2", (String)tempData.get("showValue2"));
                    newData.put("toIsAttach", tempData.get("isAttach") == null ? "0" : tempData.get("isAttach"));
                    fromKeyDatas.put(key, newData);
                }
                content.put("showData", mergeRecordData);
                content.put("showDataList", showFieldList);
                content.put("relationData", fromKeyDatas);
                if (Strings.isBlank((String)dataId)) {
                    LOGGER.warn((Object)"dataId is null ,set default -1");
                    dataId = "-1";
                }
                content.put("masterId", dataId);
                content.put("dataId", dataId);
                content.put("isMainSelecter", String.valueOf(isMainSelecter));
                content.put("fromRelationAttr", fromRelationAttr);
                content.put("toFormType", "-1");
                content.put("toFormId", "-1");
                contents.add(content);
            }
            result.put("dataCount", String.valueOf(dataPage.getTotal()));
            result.put("total", String.valueOf(dataPage.getTotal()));
        }
        catch (Exception e) {
            LOGGER.error((Object)("getFormRelationDatas is error . param is " + params.toString()), (Throwable)e);
            String name = formRelationshipMapBean.getRelationshipBean().getName();
            throw new BusinessException("\u5173\u8054\u3010" + name + "\u3011\u83b7\u53d6\u6570\u636e\u5f02\u5e38!\u539f\u56e0:" + e.getMessage());
        }
        result.put("data", contents);
        result.put("page", String.valueOf(page));
        result.put("pageSize", String.valueOf(pageSize));
        result.put("toFormId", "");
        result.put("toFormType", "");
        result.put("code", "2000");
        return result;
    }

    private C0000100053d1b8a3ba72a1bd79caa868dd5ad677 loadOther(MagicReflectionRelationPO relcation, Long serviceConfigId, boolean firstTime) throws BusinessException {
        if (relcation == null) {
            return null;
        }
        String identifier = relcation.getIdentifier();
        C0000100053d1b8a3ba72a1bd79caa868dd5ad677 result = (C0000100053d1b8a3ba72a1bd79caa868dd5ad677)this.seeyonInvokeForOuterMapper.get(identifier);
        if (result != null) {
            return result;
        }
        String sBid = relcation.getBusinessId();
        String sVid = relcation.getVersionId();
        String tBid = relcation.getCalleeBusinessId();
        String tVid = relcation.getCalleeVersionId();
        List<MagicServiceProviderPO> providers = this.getMagicProviderDao().loadProviders(tBid, tVid);
        ArrayList<String> extFiles = new ArrayList<String>();
        for (MagicServiceProviderPO p : providers) {
            if (!MagicEnums.ArticulatedType.EXTEND_JAVA_SOURCE.getType().equals(p.getSourceType()) && !MagicEnums.ArticulatedType.EXTEND_CLASS.getType().equals(p.getSourceType()) || !Strings.isNotBlank((String)p.getSource())) continue;
            extFiles.add(p.getSource());
        }
        PrivateClassLoader pcl = PrivateFileUtils.getClassLoader(sBid, sVid, tBid, tVid, extFiles, serviceConfigId);
        String sserviceImplPath = GenerateUtils.generateServiceImplPath((String)sBid);
        String sclassName = GenerateUtils.generateServiceImplName((String)tBid, (String)tVid, (String)String.valueOf(relcation.getId()));
        try {
            Class classz = pcl.loadClass(sserviceImplPath + "." + sclassName);
            C0000100053d1b8a3ba72a1bd79caa868dd5ad677 c = (C0000100053d1b8a3ba72a1bd79caa868dd5ad677)classz.newInstance();
            if (c != null) {
                this.seeyonInvokeForOuterMapper.put(identifier, c);
                return c;
            }
        }
        catch (ClassNotFoundException e) {
            if (firstTime) {
                this.getMagicCompilerManager().generateByRelation(relcation);
                return this.loadOther(relcation, serviceConfigId, false);
            }
            throw new BusinessException(ResourceUtil.getString((String)"cap.magic.execute.error"));
        }
        catch (InstantiationException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    @Override
    public void removeCacheExecute(String businessId, String verionId) throws BusinessException {
        List<MagicReflectionRelationPO> all = this.getMagicReflectionRelationDao().getReflectionByCallId(businessId, verionId);
        if (all != null) {
            for (MagicReflectionRelationPO p : all) {
                this.seeyonInvokeForOuterMapper.remove(p.getIdentifier());
                this.seeyonInvokeMapper.remove(p.getIdentifier());
            }
        }
    }

    public CAP4FormDataManager getCap4FormDataManager() {
        return this.cap4FormDataManager;
    }

    public void setCap4FormDataManager(CAP4FormDataManager cap4FormDataManager) {
        this.cap4FormDataManager = cap4FormDataManager;
    }

    public OrgManager getOrgManager() {
        return this.orgManager;
    }

    public void setOrgManager(OrgManager orgManager) {
        this.orgManager = orgManager;
    }

    public LockManager getLockManager() {
        return this.lockManager;
    }

    public void setLockManager(LockManager lockManager) {
        this.lockManager = lockManager;
    }
}

