/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.magic.execute.internal;

import com.seeyon.apps.collaboration.api.CollaborationApi;
import com.seeyon.apps.collaboration.constants.ColConstant;
import com.seeyon.apps.collaboration.po.ColSummary;
import com.seeyon.cap4.form.bean.FormDataMasterBean;
import com.seeyon.cap4.form.bean.FormDataSubBean;
import com.seeyon.cap4.form.bean.FormFormulaBean;
import com.seeyon.cap4.form.bean.FormRelationshipMapBean;
import com.seeyon.cap4.form.bean.FormTriggerActionBean;
import com.seeyon.cap4.form.bean.FormTriggerBean;
import com.seeyon.cap4.form.bean.SimpleObjectBean;
import com.seeyon.cap4.form.modules.business.BizConfigBean;
import com.seeyon.cap4.form.modules.business.BusinessManager;
import com.seeyon.cap4.form.modules.engin.formula.FormulaEnums;
import com.seeyon.cap4.form.modules.engin.relation.CAP4FormRelationActionManager;
import com.seeyon.cap4.form.modules.engin.relation.bo.CAP4RelationQueryParamsBO;
import com.seeyon.cap4.form.modules.engin.trigger.CAP4FormTriggerManager;
import com.seeyon.cap4.form.modules.engin.trigger.FormTriggerActionContext;
import com.seeyon.cap4.form.modules.engin.trigger.TriggerActionContext;
import com.seeyon.cap4.form.modules.log.CapRunningLogManager;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.cap4.form.util.FormSearchUtil;
import com.seeyon.cap4.magic.utils.MagicHandleFormUtils;
import com.seeyon.cap4.magic.utils.MagicPrivateUtils;
import com.seeyon.cap4.magic.utils.UpdateArgsEntity;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.constants.ApplicationCategoryEnum;
import com.seeyon.ctp.common.content.mainbody.MainbodyStatus;
import com.seeyon.ctp.common.ctpenumnew.manager.EnumManager;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.filemanager.manager.AttachmentManager;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.lbs.manager.LbsManager;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.po.ctpenumnew.CtpEnumItem;
import com.seeyon.ctp.common.po.filemanager.Attachment;
import com.seeyon.ctp.common.po.template.CtpTemplate;
import com.seeyon.ctp.common.processlog.ProcessLogAction;
import com.seeyon.ctp.common.processlog.manager.ProcessLogManager;
import com.seeyon.ctp.common.usermessage.MessageContent;
import com.seeyon.ctp.common.usermessage.MessageReceiver;
import com.seeyon.ctp.common.usermessage.UserMessageManager;
import com.seeyon.ctp.form.bean.FormAuthViewBean;
import com.seeyon.ctp.form.bean.FormBean;
import com.seeyon.ctp.form.bean.FormBindAuthBean;
import com.seeyon.ctp.form.bean.FormDataBean;
import com.seeyon.ctp.form.bean.FormFieldBean;
import com.seeyon.ctp.form.bean.FormFieldComBean;
import com.seeyon.ctp.form.bean.FormTableBean;
import com.seeyon.ctp.form.modules.bind.FormLogManager;
import com.seeyon.ctp.form.modules.engin.base.formData.FormDataDAO;
import com.seeyon.ctp.form.modules.engin.base.formData.FormDataManager;
import com.seeyon.ctp.form.modules.engin.relation.FormRelationEnums;
import com.seeyon.ctp.form.modules.engin.relation.FormRelationManager;
import com.seeyon.ctp.form.modules.serialNumber.SerialCalRecordManager;
import com.seeyon.ctp.form.modules.trigger.FormTriggerManager;
import com.seeyon.ctp.form.po.FormRelation;
import com.seeyon.ctp.form.service.FormCacheManager;
import com.seeyon.ctp.form.service.FormManager;
import com.seeyon.ctp.form.util.Enums;
import com.seeyon.ctp.form.util.FormTriggerUtil;
import com.seeyon.ctp.form.util.FormUtil;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.FlipInfo;
import com.seeyon.ctp.util.ParamUtil;
import com.seeyon.ctp.util.StringUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.UUIDLong;
import com.seeyon.datamagic.engine.domain.base.DataMagicContext;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;

public class MagicHandleCAP3FormUtils {
    private static final Log LOGGER = CtpLogFactory.getLog(MagicHandleCAP3FormUtils.class);

    private static Object getEnumValue(long enumId, Object value) throws BusinessException {
        EnumManager enumManagerNew;
        CtpEnumItem item;
        if (enumId != 0L && !StringUtil.checkNull((String)String.valueOf(value)) && (item = (enumManagerNew = (EnumManager)AppContext.getBean((String)"enumManagerNew")).getCtpEnumItem(Long.valueOf(value.toString()))) != null) {
            return item.getEnumvalue();
        }
        return value;
    }

    public static FlipInfo getReletionList2Magic(Map<String, Object> params, List<Map<String, Object>> conditions, int page, int pageSize, String selectedToMasterDataId) throws BusinessException {
        FormFieldBean ffb;
        FlipInfo info = new FlipInfo(page, pageSize);
        FormCacheManager formCacheManager = (FormCacheManager)AppContext.getBean((String)"formCacheManager");
        CAP4FormRelationActionManager cap4FormRelationActionManager = (CAP4FormRelationActionManager)AppContext.getBean((String)"cap4FormRelationActionManager");
        CollaborationApi collaborationApi = (CollaborationApi)AppContext.getBean((String)"collaborationApi");
        long targetFormId = ParamUtil.getLong(params, (String)"targetFormId");
        FormBean toFormBean = formCacheManager.getForm(targetFormId);
        if (toFormBean == null) {
            info.setData(Collections.emptyList());
            info.setTotal(0);
            return info;
        }
        long fromFormId = ParamUtil.getLong(params, (String)"fromFormId", (Long)0L);
        ArrayList<String> customShowFields = new ArrayList<String>();
        String fromRelationAttr = ParamUtil.getString(params, (String)"fromRelationAttr");
        Long fromDataId = ParamUtil.getLong(params, (String)"fromDataId");
        Long fromRecordId = ParamUtil.getLong(params, (String)"fromRecordId");
        CAP4RelationQueryParamsBO cap4RelationQueryParamsBO = new CAP4RelationQueryParamsBO();
        Object fromRelationShip = params.get("formRelationshipMapBean");
        FormRelationshipMapBean formRelationshipMapBean = null;
        if (fromRelationShip != null) {
            formRelationshipMapBean = (FormRelationshipMapBean)fromRelationShip;
            formRelationshipMapBean.getRelationshipBean().setTargetFormId(targetFormId);
            FormFormulaBean formFormulaBean = formRelationshipMapBean.getConditionFormula();
            String subTableName = null;
            if (formFormulaBean != null && formRelationshipMapBean.getRelationshipBean().getRelationType() == 2) {
                Map contionFieldMap = com.seeyon.cap4.form.util.FormUtil.getRelationFormulaFieldMap((FormFormulaBean)formFormulaBean);
                for (Map.Entry entry : contionFieldMap.entrySet()) {
                    String fieldName = (String)entry.getValue();
                    FormFieldBean formFieldBean = toFormBean.getFieldBeanByName(fieldName);
                    if (formFieldBean == null || !formFieldBean.isSubField()) continue;
                    subTableName = formFieldBean.getOwnerTableName();
                    break;
                }
                try {
                    List customShowFieldsTemp = (List)params.get("customShowFields");
                    for (String k : customShowFieldsTemp) {
                        ffb = toFormBean.getFieldBeanByName(k);
                        if (ffb == null) continue;
                        if (ffb.isMasterField()) {
                            customShowFields.add(k);
                            continue;
                        }
                        if (subTableName != null && !subTableName.equals(ffb.getOwnerTableName())) continue;
                        customShowFields.add(k);
                    }
                }
                catch (Exception e) {
                    LOGGER.info((Object)e.getLocalizedMessage());
                }
            }
        }
        List relationFieldMap = formRelationshipMapBean == null ? null : formRelationshipMapBean.getRelationFieldMap();
        boolean isRelMasterTable = true;
        if (relationFieldMap != null && !relationFieldMap.isEmpty() && Strings.isNotBlank((String)formRelationshipMapBean.getSelectedField())) {
            String toRelationAttr = (String)((Map)relationFieldMap.get(0)).get(formRelationshipMapBean.getSelectedField());
            FormFieldBean toRelationFieldBean = toFormBean.getFieldBeanByName(toRelationAttr);
            boolean bl = isRelMasterTable = toRelationFieldBean == null || toRelationFieldBean.isMasterField();
        }
        if (conditions != null && !conditions.isEmpty()) {
            ArrayList<Map<String, Object>> checkedCondition = new ArrayList<Map<String, Object>>();
            for (Map<String, Object> c : conditions) {
                String tempFieldName = ParamUtil.getString(c, (String)"fieldName");
                if (Strings.isBlank((String)tempFieldName)) continue;
                if (tempFieldName.equals(FormulaEnums.SystemDataField.approvalState.getKey()) || tempFieldName.equals(FormulaEnums.SystemDataField.ratifyState.getKey()) || tempFieldName.equals(FormulaEnums.SystemDataField.flowState.getKey()) || tempFieldName.equals(FormulaEnums.SystemDataField.creator.getKey()) || tempFieldName.equals(FormulaEnums.SystemDataField.createDate.getKey()) || tempFieldName.equals(FormulaEnums.SystemDataField.modify_date.getKey())) {
                    c.put("aliasTableName", toFormBean.getMasterTableBean().getTableName());
                    checkedCondition.add(c);
                    continue;
                }
                ffb = toFormBean.getFieldBeanByName(tempFieldName);
                if (ffb == null) continue;
                c.put("aliasTableName", ffb.getOwnerTableName());
                checkedCondition.add(c);
            }
            conditions = checkedCondition;
        }
        AppContext.putThreadContext((String)"magicCAP3FormBean", (Object)toFormBean);
        List<Map<String, Object>> queryConditions = FormSearchUtil.getUserConditions(null, conditions);
        AppContext.removeThreadContext((String)"magicCAP3FormBean");
        cap4RelationQueryParamsBO.setFromFormId(fromFormId);
        cap4RelationQueryParamsBO.setFromDataId(fromDataId);
        cap4RelationQueryParamsBO.setFromRecordId(fromRecordId);
        cap4RelationQueryParamsBO.setCustomShowFields(customShowFields);
        cap4RelationQueryParamsBO.setFromRelationAttr(fromRelationAttr);
        cap4RelationQueryParamsBO.setFormRelationshipMapBean(formRelationshipMapBean);
        if (MagicPrivateUtils.isNumeric(selectedToMasterDataId)) {
            if (Enums.FormType.processesForm.getKey() == toFormBean.getFormType()) {
                ColSummary colSummary = collaborationApi.getColSummary(Long.valueOf(Long.parseLong(selectedToMasterDataId)));
                cap4RelationQueryParamsBO.setSelectedToMasterDataId(colSummary.getFormRecordid());
            } else {
                cap4RelationQueryParamsBO.setSelectedToMasterDataId(Long.parseLong(selectedToMasterDataId));
            }
        }
        if (isRelMasterTable) {
            cap4FormRelationActionManager.getFormRelationDataList(info, cap4RelationQueryParamsBO, queryConditions);
        } else {
            cap4FormRelationActionManager.getFormRelationSubDataList(info, cap4RelationQueryParamsBO, queryConditions);
        }
        return info;
    }

    public static Map<com.seeyon.ctp.form.bean.FormDataMasterBean, List<Long>> queryForUpdate(DataMagicContext context, FormBean toFormBean, Map<String, Object> condition) {
        HashMap<com.seeyon.ctp.form.bean.FormDataMasterBean, List<Long>> result = new HashMap<com.seeyon.ctp.form.bean.FormDataMasterBean, List<Long>>();
        ArrayList<Object> paramSQL = new ArrayList<Object>();
        ArrayList<Object> paramSQL4enum = new ArrayList<Object>();
        StringBuilder whereSb = new StringBuilder();
        FormTableBean targetSubTableBean = null;
        String sql = null;
        for (Map.Entry<String, Object> entity : condition.entrySet()) {
            String key = entity.getKey();
            FormFieldBean ffb = toFormBean.getFieldBeanByName(key);
            if (ffb == null) continue;
            try {
                whereSb.append(key).append(" = ").append("? ");
                whereSb.append(" and ");
                paramSQL.add(entity.getValue());
                paramSQL4enum.add(MagicHandleCAP3FormUtils.getEnumValue(toFormBean.getFieldBeanByName(key).getEnumId(), entity.getValue()));
                if (ffb.isMasterField()) continue;
                String subTableName = ffb.getOwnerTableName();
                targetSubTableBean = toFormBean.getTableByTableName(subTableName);
            }
            catch (BusinessException e) {
                LOGGER.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            catch (NumberFormatException e) {
                LOGGER.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        sql = whereSb.toString();
        sql = sql.substring(0, sql.length() - 4);
        try {
            FormDataDAO formDataDAO = (FormDataDAO)AppContext.getBean((String)"formDataDAO");
            FormManager formManager = (FormManager)AppContext.getBean((String)"formManager");
            LOGGER.info((Object)("\u6570\u636e\u9b54\u65b9\u89e6\u53d1\u66f4\u65b0   \u6761\u4ef6sql param " + paramSQL));
            List queryResult = formDataDAO.selectTargetDataId(toFormBean.getMasterTableBean(), targetSubTableBean, sql, paramSQL);
            if (Strings.isEmpty((Collection)queryResult)) {
                queryResult = formDataDAO.selectTargetDataId(toFormBean.getMasterTableBean(), targetSubTableBean, sql, paramSQL4enum);
            }
            if (queryResult != null) {
                for (Map s : queryResult) {
                    com.seeyon.ctp.form.bean.FormDataMasterBean targetMasterBean = formManager.getDataMasterBeanById(Long.valueOf(String.valueOf(s.get("id"))), toFormBean, null);
                    if (targetMasterBean == null) continue;
                    if (s.containsKey("slave_id")) {
                        Long subId = Long.valueOf(String.valueOf(s.get("slave_id")));
                        ArrayList<Long> subIds = (ArrayList<Long>)result.get(targetMasterBean);
                        if (subIds == null) {
                            subIds = new ArrayList<Long>();
                            result.put(targetMasterBean, subIds);
                        }
                        if (subIds.contains(subId)) continue;
                        subIds.add(subId);
                        continue;
                    }
                    result.put(targetMasterBean, new ArrayList());
                }
            }
        }
        catch (BusinessException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (NumberFormatException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public static Long getAttchSubReference(boolean isUpdate, Map<String, Map<Long, Set<Long>>> attachmentMap, FormFieldBean tempField, Object oldValue, Object sourceSub, Object value) throws BusinessException {
        Long newSub = UUIDLong.longUUID();
        if (newSub != null && value != null) {
            Long subReference;
            Set<Long> tempList;
            Map<Long, Set<Long>> temp = attachmentMap.get(tempField.getName());
            if (temp == null) {
                temp = new HashMap<Long, Set<Long>>();
            }
            if ((tempList = temp.get(subReference = Long.valueOf(Long.parseLong(value.toString())))) == null) {
                tempList = new HashSet<Long>();
            }
            tempList.add(newSub);
            temp.put(subReference, tempList);
            attachmentMap.put(tempField.getName(), temp);
        }
        return newSub;
    }

    public static void fillMapLocateMap(FormFieldBean toFieldBean, Object value, Map<String, Map<Long, Set<String>>> mapLocateIdMap, com.seeyon.ctp.form.bean.FormDataSubBean newSubBean) {
        if (toFieldBean.getInputTypeEnum() == FormFieldComBean.FormFieldComEnum.MAP_MARKED) {
            Long subReference;
            Set<String> set;
            if (StringUtil.checkNull((String)String.valueOf(value))) {
                return;
            }
            Map<Long, Set<String>> temp = mapLocateIdMap.get(toFieldBean.getName());
            if (temp == null) {
                temp = new HashMap<Long, Set<String>>();
            }
            if ((set = temp.get(subReference = Long.valueOf(Long.parseLong(value.toString())))) == null) {
                set = new HashSet<String>();
            }
            Long newSub = UUIDLong.longUUID();
            String valueStr = newSubBean != null ? newSub + "_" + newSubBean.getId() : newSub + "_0";
            set.add(valueStr);
            temp.put(subReference, set);
            mapLocateIdMap.put(toFieldBean.getName(), temp);
        }
    }

    public static String validateData(FormBean formBean, Map<Long, List<com.seeyon.ctp.form.bean.FormDataMasterBean>> masterBeans) throws BusinessException, SQLException {
        com.seeyon.ctp.form.bean.FormDataMasterBean masterBean;
        String result = "";
        FormDataManager dataManager = (FormDataManager)AppContext.getBean((String)"formDataManager");
        LinkedList targetMasterList = new LinkedList();
        for (Map.Entry<Long, List<com.seeyon.ctp.form.bean.FormDataMasterBean>> master : masterBeans.entrySet()) {
            targetMasterList.addAll(master.getValue());
        }
        Iterator<Map.Entry<Long, List<Object>>> iterator = targetMasterList.iterator();
        while (iterator.hasNext() && !Strings.isNotBlank((String)(result = FormTriggerUtil.validateFormCheckRule((FormBean)formBean, (com.seeyon.ctp.form.bean.FormDataMasterBean)(masterBean = (com.seeyon.ctp.form.bean.FormDataMasterBean)iterator.next()))))) {
        }
        if (Strings.isBlank((String)result)) {
            dataManager.insertOrUpdateMasterData(targetMasterList);
            result = FormTriggerUtil.validateData((FormBean)formBean, targetMasterList, null);
            if (Strings.isNotBlank((String)result)) {
                dataManager.deleteMasterData(targetMasterList);
            }
        }
        return result;
    }

    public static void fillOtherInfo(FormBean toFormBean, com.seeyon.ctp.form.bean.FormDataMasterBean formDataMasterBean, FormAuthViewBean authViewBean, Map<String, Map<Long, Set<String>>> mapLocateIdMap) throws BusinessException {
        FormManager formManager = (FormManager)AppContext.getBean((String)"formManager");
        FormRelationManager relationManager = (FormRelationManager)AppContext.getBean((String)"formRelationManager");
        formDataMasterBean.putExtraAttr("moduleId", (Object)formDataMasterBean.getId());
        FormTriggerUtil.procDefaultValue4TriggerSerialNumber((FormBean)toFormBean, (com.seeyon.ctp.form.bean.FormDataMasterBean)formDataMasterBean, (FormAuthViewBean)authViewBean);
        formManager.putSessioMasterDataBean(toFormBean, formDataMasterBean, false, false);
        formDataMasterBean.putExtraAttr("needProduceValue", "true");
        if (mapLocateIdMap != null && !mapLocateIdMap.isEmpty()) {
            FormTriggerUtil.dealMapLocate((Long)formDataMasterBean.getId(), (FormBean)toFormBean, mapLocateIdMap);
            LbsManager lbsManager = (LbsManager)AppContext.getBean((String)"lbsManager");
            lbsManager.updateStateByMasterDataId(formDataMasterBean.getId().longValue(), 2);
        }
        relationManager.dealAllOrgFieldRelation(toFormBean, formDataMasterBean, authViewBean, true, false);
        formManager.refreshFormData(toFormBean.getId(), formDataMasterBean, authViewBean, true, true, true, formDataMasterBean.getId(), true);
        FormTriggerUtil.validateTriggerData((FormBean)toFormBean, (com.seeyon.ctp.form.bean.FormDataMasterBean)formDataMasterBean);
    }

    public static List<Map<String, Object>> saveFlowDataBean(DataMagicContext context, Map<Long, List<com.seeyon.ctp.form.bean.FormDataMasterBean>> masterBeans, FormBean toFormBean, CtpTemplate template, Map<String, Map<Long, Set<Long>>> attachmentMap) throws BusinessException, SQLException {
        CollaborationApi service = (CollaborationApi)AppContext.getBean((String)"collaborationApi");
        FormTriggerActionContext actionContext = (FormTriggerActionContext)context.getExtAttrs().get("triggerContext");
        for (Map.Entry<Long, List<com.seeyon.ctp.form.bean.FormDataMasterBean>> masterEntry : masterBeans.entrySet()) {
            long sender = masterEntry.getKey();
            for (com.seeyon.ctp.form.bean.FormDataMasterBean formDataMasterBean : masterEntry.getValue()) {
                MagicHandleCAP3FormUtils.refreshData(actionContext, toFormBean, formDataMasterBean, formDataMasterBean.getId(), attachmentMap, true);
                service.transSendColl(ColConstant.SendType.auto, template.getId(), Long.valueOf(sender), formDataMasterBean.getId(), null, formDataMasterBean.getId());
                FormTriggerUtil.saveOfficeContent((FormBean)toFormBean, (com.seeyon.ctp.form.bean.FormDataMasterBean)formDataMasterBean);
                MagicHandleCAP3FormUtils.saveFlowLog(actionContext, toFormBean, true, template.getSubject(), null, true);
            }
        }
        return Collections.emptyList();
    }

    public static List<Map<String, Object>> saveUnFlowDataBean(DataMagicContext context, Map<Long, List<com.seeyon.ctp.form.bean.FormDataMasterBean>> masterBeans, FormBean toFormBean, Long templateId, Map<String, Map<Long, Set<Long>>> attachmentMap) throws BusinessException, SQLException {
        FormDataManager dataManager = (FormDataManager)AppContext.getBean((String)"formDataManager");
        FormTriggerManager triggerManager = (FormTriggerManager)AppContext.getBean((String)"formTriggerManager");
        FormTriggerActionContext actionContext = (FormTriggerActionContext)context.getExtAttrs().get("triggerContext");
        FormAuthViewBean authViewBean = FormTriggerUtil.getFormAuth4UnflowTemplate((FormBean)toFormBean, (Long)templateId, (Enums.FormAuthorizationType)Enums.FormAuthorizationType.add, (FormBindAuthBean.AuthName)FormBindAuthBean.AuthName.ADD);
        for (Map.Entry<Long, List<com.seeyon.ctp.form.bean.FormDataMasterBean>> masterEntry : masterBeans.entrySet()) {
            long sender = masterEntry.getKey();
            for (com.seeyon.ctp.form.bean.FormDataMasterBean formDataMasterBean : masterEntry.getValue()) {
                MagicHandleCAP3FormUtils.refreshData(actionContext, toFormBean, formDataMasterBean, formDataMasterBean.getId(), attachmentMap, false);
                dataManager.saveDataAndContent(toFormBean, formDataMasterBean, sender, templateId.longValue(), "");
                triggerManager.doTrigger(Enums.FormType.getEnumByKey((int)toFormBean.getFormType()).getModuleType().getKey(), formDataMasterBean.getId().longValue(), toFormBean.getId().longValue(), false);
                MagicHandleCAP3FormUtils.saveFlowLog(actionContext, toFormBean, true, toFormBean.getFormName(), "", false);
            }
        }
        return Collections.emptyList();
    }

    private static void refreshData(FormTriggerActionContext context, FormBean toFormBean, com.seeyon.ctp.form.bean.FormDataMasterBean formDataMasterBean, long moduleId, Map<String, Map<Long, Set<Long>>> attachmentMap, boolean isFlow) throws BusinessException, SQLException {
        FormDataManager dataManager = (FormDataManager)AppContext.getBean((String)"formDataManager");
        dataManager.deleteNotInFormDataLbs(formDataMasterBean, FormFieldComBean.FormFieldComEnum.MAP_MARKED.getKey());
        if (isFlow) {
            dataManager.insertOrUpdateMasterData(formDataMasterBean);
        }
        if (isFlow) {
            List serialRecordList = (List)formDataMasterBean.getExtraAttr("serialCalRecords");
            if (Strings.isNotEmpty((Collection)serialRecordList)) {
                SerialCalRecordManager serialCalRecordManager = (SerialCalRecordManager)AppContext.getBean((String)"serialCalRecordManager");
                serialCalRecordManager.save(serialRecordList);
            }
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append(ResourceUtil.getString((String)"form.trigger.triggerSet.unflow.log", (Object)context.getTitle(), (Object)ResourceUtil.getString((String)"form.businesstype.trigger.create.unflow.label"), (Object)ResourceUtil.getString((String)"form.oper.new.label")));
            FormLogManager logManager = (FormLogManager)AppContext.getBean((String)"formLogManager");
            String log = logManager.getLogs(formDataMasterBean, MainbodyStatus.STATUS_POST_SAVE, toFormBean);
            if (Strings.isNotBlank((String)log)) {
                sb.append(",").append(log);
            }
            try {
                logManager.saveOrUpdateLog(toFormBean.getId(), toFormBean.getFormType(), formDataMasterBean.getId(), Long.valueOf(0L), Enums.FormLogOperateType.INSERT.getKey(), sb.toString(), Long.valueOf(formDataMasterBean.getStartMemberId()), formDataMasterBean.getStartDate());
            }
            catch (Exception e) {
                LOGGER.error((Object)"\u65e5\u5fd7\u8bb0\u5f55\u5f02\u5e38\uff01", (Throwable)e);
            }
        }
        if (attachmentMap != null && !attachmentMap.isEmpty()) {
            FormTriggerUtil.dealAttachment((Long)context.getModuleId(), (Long)moduleId, attachmentMap);
            MagicHandleCAP3FormUtils.updateImageAttType(moduleId);
        }
        MagicHandleCAP3FormUtils.getNewRecord(context, (Long)moduleId, toFormBean.getId() + "|" + moduleId + "|" + formDataMasterBean.getId(), FormTriggerBean.TriggerState.TRIGGERED, context.getDateSubIds());
    }

    private static void updateImageAttType(Long moduleId) {
        AttachmentManager attachmentManager = (AttachmentManager)AppContext.getBean((String)"attachmentManager");
        List newAttList = attachmentManager.getByReference(moduleId);
        if (Strings.isNotEmpty((Collection)newAttList)) {
            for (Attachment att : newAttList) {
                if (!att.getMimeType().contains("image") || att.getType() == 0) continue;
                att.setType(Integer.valueOf(0));
                attachmentManager.update(att);
            }
        }
    }

    private static void saveFlowLog(FormTriggerActionContext context, FormBean toFormBean, boolean isSuccess, String templateName, String reason, boolean isFlow) throws BusinessException {
        com.seeyon.cap4.form.bean.FormBean formBean = context.getFormBean();
        FormDataMasterBean masterBean = context.getMasterBean();
        String msg = reason;
        Enums.CapLogType type = Enums.CapLogType.MAGICCREATEFLOW;
        msg = ResourceUtil.getString((String)"form.business.relation.trigger.run.success2", (Object)templateName);
        if (formBean.isFlowForm()) {
            ProcessLogManager processLogManager = (ProcessLogManager)AppContext.getBean((String)"processLogManager");
            processLogManager.insertLog(AppContext.getCurrentUser(), Long.parseLong(com.seeyon.cap4.form.modules.engin.trigger.FormTriggerUtil.getColSummaryByContent(context.getModuleId()).getProcessId()), 1L, isFlow ? ProcessLogAction.createFlow : ProcessLogAction.createUnFlow, new String[]{msg});
        }
        MagicHandleCAP3FormUtils.saveLog(formBean, masterBean, msg, type, AppContext.currentUserId(), AppContext.currentAccountName(), AppContext.getRemoteAddr());
    }

    public static String getMsgForValidateResult(String formName, String validateResult) {
        String error = "uniqueMarked".equals(validateResult) ? "form.unique.marked.label" : "form.baseinfo.checkRule.label";
        return ResourceUtil.getString((String)"form.business.relation.trigger.run.error7", (Object)ResourceUtil.getString((String)"form.business.relation.trigger.run.error11"), (Object)ResourceUtil.getString((String)error));
    }

    private static void getNewRecord(FormTriggerActionContext context, Long contentId, String desc, FormTriggerBean.TriggerState state, Collection<Long> subDataIds) throws BusinessException {
        if (Strings.isEmpty(subDataIds)) {
            MagicHandleCAP3FormUtils.getNewRecord(context, contentId, desc, state, 0L);
        } else {
            for (Long subId : subDataIds) {
                MagicHandleCAP3FormUtils.getNewRecord(context, contentId, desc, state, subId);
            }
        }
    }

    public static void getNewRecord(FormTriggerActionContext context, Long contentId, String desc, FormTriggerBean.TriggerState state, Long subDataId) throws BusinessException {
        CAP4FormTriggerManager cap4FormTriggerManager = (CAP4FormTriggerManager)AppContext.getBean((String)"cap4FormTriggerManager");
        cap4FormTriggerManager.getNewRecord((TriggerActionContext)context, contentId, desc, state, subDataId);
    }

    public static List<Map<String, Object>> updateUnflowData(DataMagicContext context, FormBean toFormBean, UpdateArgsEntity updateArgsEntity) {
        ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>();
        try {
            Long sourceDataId = updateArgsEntity.getSourceDataId();
            FormDataDAO formDataDAO = (FormDataDAO)AppContext.getBean((String)"formDataDAO");
            com.seeyon.ctp.form.bean.FormDataMasterBean targetMasterData = formDataDAO.selectDataByMasterId(sourceDataId, toFormBean, null);
            if (targetMasterData == null) {
                return results;
            }
            com.seeyon.ctp.form.bean.FormDataMasterBean oldTargetBean = (com.seeyon.ctp.form.bean.FormDataMasterBean)targetMasterData.clone();
            HashMap<String, Map<Long, Set<Long>>> attachmentMap = new HashMap<String, Map<Long, Set<Long>>>();
            FormTriggerActionContext actionContext = (FormTriggerActionContext)context.getExtAttrs().get("triggerContext");
            Set<String> fillBackFieldList = MagicHandleCAP3FormUtils.getFillBackFieldList(actionContext);
            MagicHandleCAP3FormUtils.setFieldValue(oldTargetBean, toFormBean, (FormDataBean)targetMasterData, updateArgsEntity.getMasterData(), fillBackFieldList, attachmentMap);
            Map<String, List<Map<String, Object>>> subDataListMap = updateArgsEntity.getSubData();
            if (subDataListMap != null && !subDataListMap.isEmpty()) {
                String subTableName;
                if (actionContext.getActionBean().needAddSlaveRow()) {
                    for (Map.Entry<String, List<Map<String, Object>>> entry : subDataListMap.entrySet()) {
                        FormTableBean toTableBean;
                        subTableName = entry.getKey();
                        List<Map<String, Object>> subDataList = entry.getValue();
                        if (Strings.isEmpty(subDataList) || (toTableBean = toFormBean.getTableByTableName(subTableName)) == null) continue;
                        FormUtil.deleteNullDataOfSubdataBean((String)subTableName, (com.seeyon.ctp.form.bean.FormDataMasterBean)targetMasterData, (FormBean)toFormBean, (boolean)false);
                        for (Map<String, Object> subData : subDataList) {
                            com.seeyon.ctp.form.bean.FormDataSubBean subDataBean = MagicHandleCAP3FormUtils.addNewSubBean(targetMasterData, toTableBean, UUIDLong.longUUID());
                            MagicHandleCAP3FormUtils.setFieldValue(oldTargetBean, toFormBean, (FormDataBean)subDataBean, subData, fillBackFieldList, attachmentMap);
                            targetMasterData.addSubData(subTableName, subDataBean);
                        }
                    }
                } else {
                    for (Map.Entry<String, List<Map<String, Object>>> sub : subDataListMap.entrySet()) {
                        FormTableBean toTableBean;
                        subTableName = sub.getKey();
                        List<Map<String, Object>> subDataList = sub.getValue();
                        if (Strings.isEmpty(subDataList) || (toTableBean = toFormBean.getTableByTableName(subTableName)) == null) continue;
                        for (Map<String, Object> subData : subDataList) {
                            Long recordId = ParamUtil.getLong(subData, (String)"sourceDataId", (Long)UUIDLong.longUUID());
                            com.seeyon.ctp.form.bean.FormDataSubBean subDataBean = targetMasterData.getFormDataSubBeanById(subTableName, recordId);
                            if (subDataBean == null) {
                                LOGGER.warn((Object)("\u65e0\u6cd5\u627e\u5230\u91cd\u8868\u8bb0\u5f55\u4e3a " + recordId + "\u7684\u6570\u636e  \u65e0\u6cd5\u66f4\u65b0"));
                                continue;
                            }
                            MagicHandleCAP3FormUtils.setFieldValue(oldTargetBean, toFormBean, (FormDataBean)subDataBean, subData, fillBackFieldList, attachmentMap);
                        }
                    }
                }
            }
            boolean success = MagicHandleCAP3FormUtils.dealData(actionContext, toFormBean, targetMasterData, oldTargetBean, fillBackFieldList, null, attachmentMap);
            HashMap<String, String> resultData = new HashMap<String, String>();
            if (success) {
                MagicHandleCAP3FormUtils.doSaveData(actionContext, toFormBean, targetMasterData);
                resultData.put("success", "1");
                resultData.put("msg", "\u66f4\u65b0\u300a" + toFormBean.getFormName() + "\u300b\u6210\u529f\uff01");
                results.add(resultData);
                String log = "\u300a" + actionContext.getTitle() + "\u300b\u66f4\u65b0\u300a" + toFormBean.getFormName() + "\u300b\u6210\u529f\uff01\u5173\u7cfb\u300a" + actionContext.getTriggerBean().getName() + "\u300b.";
                MagicHandleCAP3FormUtils.saveLog(actionContext.getFormBean(), actionContext.getMasterBean(), log, Enums.CapLogType.MAGICUPDATE);
            }
        }
        catch (Exception e) {
            HashMap<String, String> resultData = new HashMap<String, String>();
            resultData.put("success", "0");
            resultData.put("msg", e.getLocalizedMessage());
            results.add(resultData);
            LOGGER.warn((Object)"\u66f4\u65b0\u5931\u8d25");
        }
        return results;
    }

    private static Set<String> getFillBackFieldList(FormTriggerActionContext actionContext) {
        HashSet<String> result = new HashSet<String>();
        FormTriggerActionBean actionBean = actionContext.getActionBean();
        List fillBackList = (List)actionBean.getParam(FormTriggerBean.ActionParam.FillBack.getKey());
        for (SimpleObjectBean sob : fillBackList) {
            String[] valueArray = sob.getName().split("[.]");
            result.add(valueArray[1]);
        }
        return result;
    }

    private static com.seeyon.ctp.form.bean.FormDataSubBean addNewSubBean(com.seeyon.ctp.form.bean.FormDataMasterBean toMasterBean, FormTableBean toTableBean, Long recordId) {
        HashMap<String, Long> valueMap = new HashMap<String, Long>();
        valueMap.put(Enums.SubTableField.id.getKey(), recordId);
        valueMap.put(Enums.SubTableField.formmain_id.getKey(), toMasterBean.getId());
        return new com.seeyon.ctp.form.bean.FormDataSubBean(valueMap, toTableBean, toMasterBean, new boolean[]{true});
    }

    private static void setFieldValue(com.seeyon.ctp.form.bean.FormDataMasterBean oldTargetBean, FormBean toFormBean, FormDataBean dataBean, Map<String, Object> valueMap, Set<String> fillBackFieldList, Map<String, Map<Long, Set<Long>>> attachmentMap) throws BusinessException {
        for (Map.Entry<String, Object> sub : valueMap.entrySet()) {
            String key = sub.getKey();
            Object value = sub.getValue();
            if (!key.startsWith("field") || !fillBackFieldList.contains(key)) continue;
            FormFieldBean fieldBean = toFormBean.getFieldBeanByName(key);
            if (fieldBean != null && fieldBean.isAttachment(true, true)) {
                Object oldValue = null;
                if (fieldBean.getInputTypeEnum() == FormFieldComBean.FormFieldComEnum.OUTWRITE && "multiattachment".equals(fieldBean.getFormatType())) {
                    if (fieldBean.isMasterField()) {
                        oldValue = oldTargetBean.getFieldValue(key);
                    } else {
                        Map oldSubData = oldTargetBean.getSubDataMapById(fieldBean.getOwnerTableName(), dataBean.getId());
                        if (oldSubData != null) {
                            oldValue = oldSubData.get(key);
                        }
                    }
                    if (oldValue == null) {
                        oldValue = MagicHandleCAP3FormUtils.getAttchSubReference(true, attachmentMap, fieldBean, null, null, value);
                    }
                    if (oldValue != null && !StringUtil.checkNull((String)String.valueOf(value))) {
                        Long subReference;
                        Set<Long> tempList;
                        Map<Long, Set<Long>> temp = attachmentMap.get(fieldBean.getName());
                        if (temp == null) {
                            temp = new HashMap<Long, Set<Long>>();
                        }
                        if ((tempList = temp.get(subReference = Long.valueOf(Long.parseLong(value.toString())))) == null) {
                            tempList = new HashSet<Long>();
                        }
                        tempList.add(Long.parseLong(oldValue.toString()));
                        temp.put(subReference, tempList);
                        attachmentMap.put(fieldBean.getName(), temp);
                    }
                    dataBean.addFieldValue(key, oldValue);
                    continue;
                }
                Long newId = MagicHandleCAP3FormUtils.getAttchSubReference(true, attachmentMap, fieldBean, null, null, value);
                dataBean.addFieldValue(key, (Object)newId);
                continue;
            }
            dataBean.addFieldValue(key, value);
        }
    }

    private static boolean dealData(FormTriggerActionContext context, FormBean toFormBean, com.seeyon.ctp.form.bean.FormDataMasterBean targetMasterBean, com.seeyon.ctp.form.bean.FormDataMasterBean oldTargetBean, Set<String> changeField, Map<String, Map<Long, Set<String>>> mapLocateIdMap, Map<String, Map<Long, Set<Long>>> attachmentMap) throws BusinessException, SQLException, CloneNotSupportedException {
        String error;
        FormManager formManager = (FormManager)AppContext.getBean((String)"formManager");
        FormRelationManager relationManager = (FormRelationManager)AppContext.getBean((String)"formRelationManager");
        targetMasterBean.setModifyDate((Date)DateUtil.currentTimestamp());
        if (mapLocateIdMap != null && !mapLocateIdMap.isEmpty()) {
            FormTriggerUtil.dealMapLocate((Long)targetMasterBean.getId(), (FormBean)toFormBean, mapLocateIdMap);
            LbsManager lbsManager = (LbsManager)AppContext.getBean((String)"lbsManager");
            lbsManager.updateStateByMasterDataId(targetMasterBean.getId().longValue(), 2);
        }
        relationManager.dealAllOrgFieldRelation(toFormBean, targetMasterBean, null, false, false);
        try {
            formManager.refreshFormData(toFormBean.getId(), targetMasterBean, null, false, false, true);
        }
        catch (Exception e) {
            return false;
        }
        FormLogManager logManager = (FormLogManager)AppContext.getBean((String)"formLogManager");
        String log = logManager.getLogs(targetMasterBean, MainbodyStatus.STATUS_POST_UPDATE, toFormBean, oldTargetBean);
        ArrayList<String> modifyFieldList = new ArrayList<String>();
        String rule = MagicHandleCAP3FormUtils.validateData(toFormBean, targetMasterBean, modifyFieldList, oldTargetBean);
        String string = "checkRule".equals(rule) ? "form.baseinfo.checkRule.label" : (error = "uniqueMarked".equals(rule) || "unique".equals(rule) ? "form.unique.marked.label" : null);
        if (Strings.isNotBlank((String)error)) {
            error = rule + "\u300a" + context.getFormBean().getFormName() + "\u300b\u66f4\u65b0\u300a" + toFormBean.getFormName() + "\u300b\u5931\u8d25\uff0c\u66f4\u65b0\u7684\u6570\u636e\u4e0d\u7b26\u5408\u8868\u5355" + ResourceUtil.getString((String)error) + "\u7684\u89c4\u5219\u5b9a\u4e49\uff0c\u66f4\u65b0\u8bb0\u5f55\u5931\u8d25\uff01";
            MagicHandleCAP3FormUtils.sendErrorMsg(context, toFormBean, error, true);
            return false;
        }
        AppContext.putThreadContext((String)("fill_back_modifyFields_" + targetMasterBean.getId()), modifyFieldList);
        if (attachmentMap != null && !attachmentMap.isEmpty()) {
            FormTriggerUtil.dealAttachment((Long)context.getModuleId(), (Long)targetMasterBean.getId(), attachmentMap);
            MagicHandleCAP3FormUtils.updateImageAttType(targetMasterBean.getId());
        }
        FormDataManager dataManager = (FormDataManager)AppContext.getBean((String)"formDataManager");
        dataManager.deleteNotInFormDataLbs(targetMasterBean, FormFieldComBean.FormFieldComEnum.MAP_MARKED.getKey());
        StringBuilder info = new StringBuilder();
        info.append(ResourceUtil.getString((String)"form.trigger.triggerSet.unflow.log", (Object)("\u300a" + context.getTitle() + "\u300b"), (Object)ResourceUtil.getString((String)"form.businesstype.trigger.update.label"), (Object)ResourceUtil.getString((String)"form.trigger.triggerSet.modify.label")));
        try {
            if (Strings.isNotBlank((String)log)) {
                info.append(",").append(log);
            } else {
                StringBuilder fieldNames = new StringBuilder();
                for (String string2 : changeField) {
                    FormFieldBean fieldBean = toFormBean.getFieldBeanByName(string2);
                    fieldNames.append(fieldBean.getDisplay()).append(",");
                }
                if (Strings.isNotBlank((String)fieldNames.toString())) {
                    fieldNames.setLength(fieldNames.length() - 1);
                    info.append("\u57df\uff1a").append(fieldNames.toString());
                } else {
                    info.append(",\u4f46\u5f53\u524d\u8868\u5355\u300a").append(toFormBean.getFormName()).append("\u300b\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u53ef\u4fee\u6539\u7684\u6570\u636e\u57df\uff01");
                }
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)(context.getTriggerBean().getName() + "\u65e5\u5fd7\u8bb0\u5f55\u5f02\u5e38"), (Throwable)e);
            info.append(",\u65e5\u5fd7\u8bb0\u5f55\u5f02\u5e38");
        }
        logManager.saveOrUpdateLog(toFormBean.getId(), toFormBean.getFormType(), targetMasterBean.getId(), targetMasterBean.getId(), Long.valueOf(0L), Enums.FormLogOperateType.MODIFY.getKey(), info.toString(), Long.valueOf(targetMasterBean.getStartMemberId()), targetMasterBean.getStartDate());
        return true;
    }

    private static String validateData(FormBean formBean, com.seeyon.ctp.form.bean.FormDataMasterBean masterBean, List<String> changeFieldList, com.seeyon.ctp.form.bean.FormDataMasterBean oldDataBean) throws BusinessException, SQLException {
        String result = FormTriggerUtil.validateFormCheckRule((FormBean)formBean, (com.seeyon.ctp.form.bean.FormDataMasterBean)masterBean);
        if (Strings.isBlank((String)result)) {
            if (changeFieldList != null) {
                changeFieldList.addAll(masterBean.getModifiedFields((FormDataBean)oldDataBean));
            }
            FormDataManager dataManager = (FormDataManager)AppContext.getBean((String)"formDataManager");
            dataManager.insertOrUpdateMasterData(masterBean);
            ArrayList<com.seeyon.ctp.form.bean.FormDataMasterBean> dataList = new ArrayList<com.seeyon.ctp.form.bean.FormDataMasterBean>();
            dataList.add(masterBean);
            result = FormTriggerUtil.validateData((FormBean)formBean, dataList, changeFieldList);
            if (Strings.isNotBlank((String)result)) {
                dataManager.insertOrUpdateMasterData(oldDataBean);
            }
        }
        return result;
    }

    private static void doSaveData(FormTriggerActionContext context, FormBean toFormBean, com.seeyon.ctp.form.bean.FormDataMasterBean targetMasterBean) throws BusinessException, SQLException {
        List serialRecordList;
        LinkedHashSet needUpdateEnumsSet = new LinkedHashSet();
        List allFields = toFormBean.getAllFieldBeans();
        for (Object field : allFields) {
            boolean updateEnumTag = false;
            if (field.getInputTypeEnum().getKey().equalsIgnoreCase(FormFieldComBean.FormFieldComEnum.SELECT.getKey()) || field.getInputTypeEnum().getKey().equalsIgnoreCase(FormFieldComBean.FormFieldComEnum.RADIO.getKey())) {
                updateEnumTag = true;
            } else if (field.getInputTypeEnum().getKey().equalsIgnoreCase(FormFieldComBean.FormFieldComEnum.RELATION.getKey())) {
                String inputType;
                FormRelation dataRelation = field.getFormRelation();
                if (dataRelation != null && dataRelation.getToRelationAttrType().intValue() == FormRelationEnums.ToRelationAttrType.data_relation_multiEnum.getKey()) {
                    updateEnumTag = true;
                } else if (dataRelation != null && dataRelation.getToRelationAttrType().intValue() == FormRelationEnums.ToRelationAttrType.data_relation_member.getKey() && (inputType = FormRelationEnums.ViewAttrValue.getEnumByKey((String)dataRelation.getViewAttr()).getInputType()) != null && (inputType.equalsIgnoreCase(FormFieldComBean.FormFieldComEnum.SELECT.getKey()) || inputType.equalsIgnoreCase(FormFieldComBean.FormFieldComEnum.RADIO.getKey()))) {
                    updateEnumTag = true;
                }
            }
            if (!updateEnumTag) continue;
            needUpdateEnumsSet.addAll(targetMasterBean.getDataList(field.getName()));
        }
        if (needUpdateEnumsSet.size() > 0) {
            try {
                EnumManager enumManagerNew = (EnumManager)AppContext.getBean((String)"enumManagerNew");
                for (Object objval : needUpdateEnumsSet) {
                    if (StringUtil.checkNull((String)String.valueOf(objval)) || "0".equals(String.valueOf(objval))) continue;
                    enumManagerNew.updateEnumItemRef(Long.valueOf(new BigDecimal(String.valueOf(objval)).longValue()));
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)"\u66f4\u65b0\u679a\u4e3e\u72b6\u6001\u5f02\u5e38\u2026\u2026", (Throwable)e);
            }
        }
        if (Strings.isNotEmpty((Collection)(serialRecordList = (List)targetMasterBean.getExtraAttr("serialCalRecords")))) {
            SerialCalRecordManager serialCalRecordManager = (SerialCalRecordManager)AppContext.getBean((String)"serialCalRecordManager");
            serialCalRecordManager.save(serialRecordList);
        }
        FormTriggerManager triggerManager = (FormTriggerManager)AppContext.getBean((String)"formTriggerManager");
        List md = (List)AppContext.getThreadContext((String)("fill_back_modifyFields_" + targetMasterBean.getId()));
        triggerManager.doTrigger(Enums.FormType.getEnumByKey((int)toFormBean.getFormType()).getModuleType().getKey(), targetMasterBean.getId().longValue(), toFormBean.getId().longValue(), null, md, false);
        MagicHandleCAP3FormUtils.getNewRecord(context, targetMasterBean.getId(), toFormBean.getId() + "|" + targetMasterBean.getId() + "|" + targetMasterBean.getId(), FormTriggerBean.TriggerState.TRIGGERED, context.getDateSubIds());
        LOGGER.info((Object)(context.getTriggerBean().getName() + "\u6570\u636e\u4fdd\u5b58\u5b8c\u6210\uff1a" + toFormBean.getFormName() + toFormBean.getId() + targetMasterBean.getId()));
    }

    public static void sendNoMatchDataWarn(FormTriggerActionContext context, FormDataSubBean sourceSubBean, boolean isPre) throws BusinessException {
        String error = "noDataWarn" + (sourceSubBean == null ? "" : "\u660e\u7ec6\u8868\u7b2c " + sourceSubBean.getSort() + " \u884c") + "\u66f4\u65b0\u8bb0\u5f55\u6ca1\u6709\u5339\u914d\u5230\u76ee\u6807\u6570\u636e";
        if (!isPre) {
            MagicHandleCAP3FormUtils.sendErrorMsg(context, null, error, true);
        }
        if (isPre) {
            String msg = (String)AppContext.getThreadContext((String)"DATA_MSG");
            msg = StringUtil.checkNull((String)msg) ? error + ";" : msg + error + ";";
            AppContext.putThreadContext((String)"DATA_MSG", (Object)msg);
        }
    }

    public static void sendErrorMsg(FormTriggerActionContext context, FormBean toFormBean, String string, boolean needSend) throws BusinessException {
        Set<Long> errorReceivers = context.getErrorReceivers();
        String msg = "\u8868\u5355 " + context.getFormBean().getFormName() + " \u540d\u79f0\u4e3a\u3010" + context.getTriggerBean().getName() + "\u3011\u7684\u66f4\u65b0\u5931\u8d25\uff01\uff01 \u539f\u56e0\uff1a";
        String errorMsg = msg + string.replace("noDataWarn", "");
        errorMsg = errorMsg.replace("uniqueMarked", "").replace("unique", "");
        LOGGER.error((Object)errorMsg);
        if (needSend) {
            if ((string.contains("noDataWarn") || string.contains("uniqueMarked") || string.contains("unique")) && context.getActionBean().needNoDataWarn()) {
                UserMessageManager messageManager = (UserMessageManager)AppContext.getBean((String)"userMessageManager");
                messageManager.sendSystemMessage(MessageContent.get((String)errorMsg, (Object[])new Object[0]), ApplicationCategoryEnum.cap4Form, 2L, MessageReceiver.get((Long)-1L, errorReceivers), new Object[0]);
            }
            if (context.getFormBean().isFlowForm()) {
                ProcessLogManager processLogManager = (ProcessLogManager)AppContext.getBean((String)"processLogManager");
                processLogManager.insertLog(AppContext.getCurrentUser(), Long.parseLong(FormTriggerUtil.getColSummaryByContent((long)context.getModuleId()).getProcessId()), 1L, ProcessLogAction.updateData, new String[]{errorMsg});
                MagicHandleCAP3FormUtils.getNewRecord(context, (Long)0L, "", FormTriggerBean.TriggerState.TRIGGERED, 0L);
            }
            if (toFormBean == null && context.getActionBean() != null) {
                Map params = context.getActionBean().getParam();
                String businessId = ParamUtil.getString((Map)params, (String)"businessId", (String)"");
                String versionId = ParamUtil.getString((Map)params, (String)"versionId", (String)"");
                String methodId = ParamUtil.getString((Map)params, (String)"methodName", (String)"");
                long formId = MagicHandleFormUtils.getProviderFormId(businessId, versionId, methodId);
                FormCacheManager formCacheManager = (FormCacheManager)AppContext.getBean((String)"formCacheManager");
                toFormBean = formCacheManager.getForm(formId);
            }
            if (toFormBean != null) {
                MagicHandleCAP3FormUtils.saveFailMsg(toFormBean, "fillBack", context.getTitle(), errorMsg, AppContext.getCurrentUser().getId());
            }
            MagicHandleCAP3FormUtils.saveCheckErrMsg(context, errorMsg, Enums.CapLogType.MAGICUPDATE);
        }
    }

    private static void saveFailMsg(FormBean formBean, String operateType, String flowTitle, String errorMsg, long userId) {
        try {
            String msg = ResourceUtil.getString((String)"form.trigger.operate.fail.all.label") + errorMsg;
            if ("fillBack".equals(operateType)) {
                msg = "\u300a" + flowTitle + "\u300b\u8bd5\u56fe\u901a\u8fc7\u66f4\u65b0\u8bb0\u5f55\u4fee\u6539\u6570\u636e\u4f46\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + errorMsg;
            } else if ("triggerUnFlow".equals(operateType)) {
                msg = "\u300a" + flowTitle + "\u300b" + ResourceUtil.getString((String)"form.businesstype.trigger.create.unflow.label") + "\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + errorMsg;
            }
            LOGGER.error((Object)msg);
            FormLogManager logManager = (FormLogManager)AppContext.getBean((String)"formLogManager");
            logManager.saveOrUpdateLog(formBean.getId(), formBean.getFormType(), Long.valueOf(0L), Long.valueOf(0L), Enums.FormLogOperateType.OPERATEFAIL.getKey(), msg, Long.valueOf(userId), DateUtil.currentDate());
        }
        catch (Exception e) {
            LOGGER.error((Object)"\u64cd\u4f5c\u65e5\u5fd7\u8bb0\u5f55\u5f02\u5e38......", (Throwable)e);
        }
    }

    public static void saveCheckErrMsg(FormTriggerActionContext context, String reason, Enums.CapLogType type) {
        String errorMsg = type.getText() + "\uff1a" + reason;
        MagicHandleCAP3FormUtils.saveLog(context.getFormBean(), context.getMasterBean(), errorMsg, type);
    }

    public static void saveFailMsg(com.seeyon.cap4.form.bean.FormBean toFormBean, Enums.CapLogType operateType, String flowTitle, String errorMsg) {
        try {
            String msg;
            CapRunningLogManager capRunningLogManager = (CapRunningLogManager)AppContext.getBean((String)"capRunningLogManager");
            BusinessManager businessManager4 = (BusinessManager)AppContext.getBean((String)"businessManager4");
            switch (operateType) {
                case CREATEUNFLOW: {
                    msg = "\u300a" + flowTitle + "\u300b\u8bd5\u56fe\u901a\u8fc7\u65b0\u5efa\u8bb0\u5f55\u8bbe\u7f6e\u4fee\u6539\u6570\u636e\u4f46\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + errorMsg;
                    break;
                }
                case UPDATE: {
                    msg = "\u300a" + flowTitle + "\u300b\u8bd5\u56fe\u901a\u8fc7\u66f4\u65b0\u8bb0\u5f55\u8bbe\u7f6e\u4fee\u6539\u6570\u636e\u4f46\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + errorMsg;
                    break;
                }
                case DISTRIBUTE: {
                    msg = "\u300a" + flowTitle + "\u300b\u8bd5\u56fe\u901a\u8fc7\u65b0\u5efa\u5e76\u540c\u6b65\u66f4\u65b0\u8bbe\u7f6e\u65b0\u5efa/\u4fee\u6539\u6570\u636e\u4f46\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + errorMsg;
                    break;
                }
                default: {
                    msg = ResourceUtil.getString((String)"form.trigger.operate.fail.all.label") + errorMsg;
                }
            }
            LOGGER.error((Object)msg);
            BizConfigBean bizConfig = businessManager4.findBizConfigByFormId(toFormBean.getId());
            capRunningLogManager.saveRunningLog(bizConfig.getId(), bizConfig.getName(), toFormBean.getId(), toFormBean.getFormName(), 0L, operateType.getKey(), msg, 0L, AppContext.currentUserId(), DateUtil.currentDate(), AppContext.currentAccountName(), AppContext.getRemoteAddr());
        }
        catch (Exception e) {
            LOGGER.error((Object)"\u64cd\u4f5c\u65e5\u5fd7\u8bb0\u5f55\u5f02\u5e38......", (Throwable)e);
        }
    }

    private static void saveLog(com.seeyon.cap4.form.bean.FormBean formBean, FormDataMasterBean masterBean, String logDesc, Enums.CapLogType type) {
        MagicHandleCAP3FormUtils.saveLog(formBean, masterBean, logDesc, type, AppContext.currentUserId(), AppContext.currentAccountName(), AppContext.getRemoteAddr());
    }

    private static void saveLog(com.seeyon.cap4.form.bean.FormBean formBean, FormDataMasterBean masterBean, String logDesc, Enums.CapLogType type, Long operatorId, String operatorOrgName, String ipAddress) {
        try {
            CapRunningLogManager capRunningLogManager = (CapRunningLogManager)AppContext.getBean((String)"capRunningLogManager");
            BusinessManager businessManager4 = (BusinessManager)AppContext.getBean((String)"businessManager4");
            BizConfigBean bizConfig = businessManager4.findBizConfigByFormId(formBean.getId());
            capRunningLogManager.saveRunningLog(bizConfig.getId(), bizConfig.getName(), formBean.getId(), formBean.getFormName(), masterBean.getId(), type.getKey(), logDesc, operatorId, masterBean.getStartMemberId(), masterBean.getStartDate(), operatorOrgName, ipAddress);
        }
        catch (Exception e) {
            LOGGER.error((Object)"\u65e5\u5fd7\u8bb0\u5f55\u5f02\u5e38\uff01", (Throwable)e);
        }
    }
}

