/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.magic.generator.cap3;

import com.seeyon.cap4.magic.business.create.utils.MagicCreateServiceUtils;
import com.seeyon.cap4.magic.dao.IMagicInterfaceDefineDao;
import com.seeyon.cap4.magic.dao.IMagicProviderDao;
import com.seeyon.cap4.magic.dao.IMagicServiceSummaryDao;
import com.seeyon.cap4.magic.po.MagicInterfaceDefineEntity;
import com.seeyon.cap4.magic.po.MagicServiceProviderPO;
import com.seeyon.cap4.magic.po.MagicServiceSummary;
import com.seeyon.cap4.magic.utils.JSONUtils;
import com.seeyon.cap4.magic.utils.MagicHandleFormUtils;
import com.seeyon.cap4.magic.utils.MagicPrivateUtils;
import com.seeyon.cap4.magic.vo.MagicEnums;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.po.template.CtpTemplateCategory;
import com.seeyon.ctp.common.template.manager.TemplateManager;
import com.seeyon.ctp.form.bean.FormBean;
import com.seeyon.ctp.form.bean.FormFieldBean;
import com.seeyon.ctp.form.bean.FormTableBean;
import com.seeyon.ctp.form.service.FormCacheManager;
import com.seeyon.ctp.form.util.Enums;
import com.seeyon.ctp.form.util.TreeNodeUtil;
import com.seeyon.ctp.form.vo.FormTreeNode;
import com.seeyon.ctp.util.ParamUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.json.JSONUtil;
import com.seeyon.datamagic.engine.domain.metadata.Metadata;
import com.seeyon.datamagic.engine.domain.metadata.MetadataConfig;
import com.seeyon.datamagic.engine.domain.service.ServiceConfig;
import com.seeyon.datamagic.engine.domain.service.ServiceMethodConfig;
import com.seeyon.datamagic.engine.out.service.OutService;
import com.seeyon.datamagic.engine.out.service.entry.OutServiceInfo;
import com.seeyon.datamagic.engine.out.service.entry.ServiceProvider;
import com.seeyon.datamagic.engine.out.service.entry.ServiceQueryCondition;
import com.seeyon.datamagic.engine.out.service.entry.ServiceSummary;
import com.seeyon.datamagic.engine.out.service.entry.ServicesCategoryTree;
import com.seeyon.datamagic.engine.template.DataMagicMatchValue;
import com.seeyon.datamagic.engine.template.TemplateFormatUtls;
import com.seeyon.datamagic.engine.template.vo.TemplateVo;
import com.seeyon.datamagic.engine.utils.PrivateUtils;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.songjian.utils.ScriptReplace;
import org.songjian.utils.StreamUtils;

public class CAP3FormJoinService
implements OutService {
    private IMagicInterfaceDefineDao magicInterfaceDefineDao;
    private IMagicProviderDao magicProviderDao;
    private FormCacheManager formCacheManager;
    private TemplateManager templateManager;
    private IMagicServiceSummaryDao magicServiceSummaryDao;
    private static final Log LOGGER = CtpLogFactory.getLog(CAP3FormJoinService.class);
    private static final String relationResultValueSetTemplate = "                    toFormFieldBean = toFormBean.getFieldBeanByName(${doubleQuote}${fieldName}${doubleQuote});${lineSeparator}                    if(toFormFieldBean != null) {${lineSeparator}                    toFormFieldBean = toFormFieldBean.findRealFieldBean();${lineSeparator}                    vs=relationData.get(${doubleQuote}${fieldName}${doubleQuote});${lineSeparator}                    values = toFormFieldBean.getDisplayValue(vs);                    ${resultValueObj} ${fieldName} = new ${resultValueObj}();${lineSeparator}                    ${fieldName}.setId(relationData.get(${doubleQuote}formmain_id${doubleQuote}) != null ? relationData.get(${doubleQuote}formmain_id${doubleQuote}).toString() :relationData.get(${doubleQuote}id${doubleQuote}).toString());// Id${lineSeparator}                    ${fieldName}.setSubDataId(relationData.get(${doubleQuote}formmain_id${doubleQuote}) != null ? relationData.get(${doubleQuote}id${doubleQuote}).toString():null);// Id${lineSeparator}                    ${fieldName}.setValue(vs);// \u771f\u5b9e\u503c${lineSeparator}                    ${fieldName}.setShowValue(values[1] == null ? ${doubleQuote}${doubleQuote} : String.valueOf(values[1]));// \u663e\u793a\u503c${lineSeparator}                    ${fieldName}.setShowValue2(values[2] == null ? ${doubleQuote}${doubleQuote} : String.valueOf(values[2]));// \u53c2\u4e0e\u8ba1\u7b97\u7684\u503c${lineSeparator}                    ${fieldName}.setDisplay(toFormFieldBean.getDisplay());${lineSeparator}                    resultData.set${resultItemName}(${fieldName});${lineSeparator}                    }${lineSeparator}";

    public ServiceConfig convert(int arg0, ServiceSummary arg1) throws BusinessException {
        return null;
    }

    public TemplateVo generateMethodContent(int arg0, ServiceConfig sc, ServiceMethodConfig arg3) throws BusinessException {
        TemplateVo vo = new TemplateVo();
        try {
            MagicInterfaceDefineEntity entity = MagicCreateServiceUtils.convertMethodToPo(sc.getOwnerType(), sc.getOwner(), sc.getBusinessId(), sc.getVersion(), arg3);
            MagicEnums.BusinessMethodType serviceType = MagicEnums.BusinessMethodType.valueOfType((int)entity.getServiceType());
            String businessId = entity.getBusinessId();
            String versionId = entity.getVersionId();
            MagicEnums.ProviderStatus status = MagicEnums.ProviderStatus.ON;
            MagicServiceSummary sm = this.magicServiceSummaryDao.loadServiceInfo(businessId, versionId);
            ArrayList metadatas = new ArrayList();
            JSONUtils.parseJSonListObj_Class(sm.getMetadata(), metadatas, MetadataConfig.class);
            Metadata metadata = new Metadata();
            metadata.setMetadatas(metadatas);
            metadata.setBusinessId(businessId);
            metadata.setVersion(versionId);
            MagicServiceProviderPO provider = this.magicProviderDao.loadProviders(businessId, versionId, status);
            switch (serviceType) {
                case RELATION: 
                case RELATION_SYS: 
                case RELATION_USER: {
                    vo = this.generateSysRelationContent(metadata, entity, provider);
                    break;
                }
                case TRIGGER_CREATE: {
                    vo = this.generateCreateContent(metadata, entity, provider);
                    break;
                }
                case TRIGGER_UPDATE: {
                    vo = this.generateUpdateContent(metadata, entity, provider);
                    break;
                }
                case QUERY: {
                    vo = this.generateQueryContent(metadata, entity, provider);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getLocalizedMessage());
        }
        return vo;
    }

    private TemplateVo generateSysRelationContent(Metadata metadata, MagicInterfaceDefineEntity entity, MagicServiceProviderPO provider) {
        List resultKey;
        Map extMapp;
        InputStream is = this.getClass().getResourceAsStream("sysRelationImplTemplate_1.txt");
        String template = StreamUtils.readStreamText((InputStream)is, (String)"UTF-8", (boolean)true);
        String exit1 = entity.getExt1();
        String targetId = String.valueOf(entity.getFormId());
        ArrayList<String> resultFiledList = new ArrayList<String>();
        if (exit1 != null && (extMapp = (Map)JSONUtil.parseJSONString((String)exit1, Map.class)) != null && (resultKey = (List)extMapp.get("resultKey")) != null) {
            for (Object temp : resultKey) {
                resultFiledList.add(temp.toString());
            }
        }
        ArrayList ext = new ArrayList();
        HashMap<String, String> e = new HashMap<String, String>();
        Map<String, String> objectNames = MagicPrivateUtils.getObjectNames(entity, metadata, MagicEnums.BusinessMethodType.RELATION);
        e.put("resultListItemEntityName", objectNames.get("resultListItemEntityName"));
        e.put("resultListDefineName", objectNames.get("resultListDefineName"));
        ext.add(e);
        DataMagicMatchValue dmv = new DataMagicMatchValue();
        dmv.put("businessId", entity.getBusinessId());
        dmv.put("versionId", entity.getVersionId());
        dmv.put("methodName", entity.getMethodName());
        DataMagicMatchValue valueSetMatch = new DataMagicMatchValue();
        for (String string : resultFiledList) {
            String names = objectNames.get(string);
            if (!Strings.isNotBlank((String)names)) continue;
            valueSetMatch.put("resultValueObj", names);
            valueSetMatch.put("fieldName", string);
            valueSetMatch.put("resultItemName", PrivateUtils.toUpperInitial((String)string));
            dmv.put("resultValueSetItem", TemplateFormatUtls.convert((String)relationResultValueSetTemplate, (ScriptReplace.IMatchValue)valueSetMatch));
            valueSetMatch.clear();
        }
        if (provider != null) {
            dmv.put("targetFormId", provider.getSource() + "L");
        } else {
            dmv.put("targetFormId", targetId + "L");
        }
        dmv.put("toRelationAttr", (String)resultFiledList.get(0));
        for (String string : resultFiledList) {
            dmv.put("resultFieldList", "resultFieldList.add(\"" + string + "\");");
        }
        for (Map map : ext) {
            for (Map.Entry entry : map.entrySet()) {
                dmv.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
        String conditionName = MagicPrivateUtils.getRelationConditionName(entity.getBusinessId(), entity.getVersionId());
        dmv.put("conditionName", conditionName);
        String string = TemplateFormatUtls.convert((String)template, (ScriptReplace.IMatchValue)dmv);
        TemplateVo result = new TemplateVo();
        result.setContent(string);
        result.setDependences(this.getSysRelationDepends());
        return result;
    }

    public Set<String> getUserRelationDepends() {
        return this.getSysRelationDepends();
    }

    public Set<String> getUpdateDepends() {
        HashSet<String> result = new HashSet<String>();
        result.add("java.util.ArrayList");
        result.add("java.util.List");
        result.add("java.util.Map");
        result.add("java.util.Map.Entry");
        result.add("com.seeyon.cap4.magic.execute.internal.MagicHandleCAP3FormUtils");
        result.add("com.seeyon.cap4.magic.convertor.MagicProviderDefaultConvertor");
        result.add("com.seeyon.cap4.magic.utils.MagicHandleFormUtils");
        result.add("com.seeyon.cap4.magic.utils.UpdateArgsEntity");
        result.add("com.seeyon.ctp.common.AppContext");
        result.add("com.seeyon.ctp.form.bean.FormAuthViewBean");
        result.add("com.seeyon.ctp.form.bean.FormBean");
        result.add("com.seeyon.ctp.form.service.FormCacheManager");
        result.add("com.seeyon.ctp.util.ParamUtil");
        result.add("com.seeyon.ctp.util.Strings");
        result.add("com.seeyon.ctp.form.util.Enums.FieldType");
        result.add("java.math.BigDecimal");
        result.add("com.seeyon.datamagic.engine.domain.base.DataMagicContext");
        result.add("com.seeyon.ctp.form.util.FormTriggerUtil");
        return result;
    }

    public Set<String> getQueryDepends() {
        HashSet<String> result = new HashSet<String>();
        result.add("java.math.BigDecimal");
        result.add("java.util.ArrayList");
        result.add("java.util.HashMap");
        result.add("java.util.List");
        result.add("java.util.Map");
        result.add("java.util.Map.Entry");
        result.add("com.seeyon.cap4.magic.execute.internal.MagicHandleCAP3FormUtils");
        result.add("com.seeyon.cap4.magic.utils.MagicHandleFormUtils");
        result.add("com.seeyon.ctp.common.AppContext");
        result.add("com.seeyon.ctp.form.bean.FormBean");
        result.add("com.seeyon.ctp.form.bean.FormDataMasterBean");
        result.add("com.seeyon.ctp.form.bean.FormDataSubBean");
        result.add("com.seeyon.ctp.form.bean.FormFieldBean");
        result.add("com.seeyon.ctp.form.service.FormCacheManager");
        result.add("com.seeyon.ctp.form.util.Enums.FieldType");
        result.add("com.seeyon.datamagic.engine.domain.base.DataMagicContext");
        result.addAll(this.getCreateUnFlowDepends());
        return result;
    }

    public Set<String> getCreateFlowDepends() {
        return this.getCreateUnFlowDepends();
    }

    public Set<String> getCreateUnFlowDepends() {
        HashSet<String> result = new HashSet<String>();
        result.add("java.util.ArrayList");
        result.add("java.util.HashMap");
        result.add("java.util.LinkedHashMap");
        result.add("java.util.List");
        result.add("java.util.Map");
        result.add("java.util.Set");
        result.add("com.seeyon.ctp.form.bean.FormBindAuthBean");
        result.add("com.seeyon.ctp.form.bean.FormBindAuthBean.AuthName");
        result.add("com.seeyon.cap4.magic.execute.internal.MagicHandleCAP3FormUtils");
        result.add("com.seeyon.cap4.magic.utils.MagicHandleFormUtils");
        result.add("com.seeyon.ctp.common.AppContext");
        result.add("com.seeyon.ctp.common.exceptions.BusinessException");
        result.add("com.seeyon.ctp.common.po.template.CtpTemplate");
        result.add("com.seeyon.ctp.common.template.manager.TemplateManager");
        result.add("com.seeyon.ctp.form.bean.FormAuthViewBean");
        result.add("com.seeyon.ctp.form.bean.FormBean");
        result.add("com.seeyon.ctp.form.bean.FormDataMasterBean");
        result.add("com.seeyon.ctp.form.bean.FormDataSubBean");
        result.add("com.seeyon.ctp.form.bean.FormFieldBean");
        result.add("com.seeyon.ctp.form.bean.FormTableBean");
        result.add("com.seeyon.ctp.form.service.FormCacheManager");
        result.add("com.seeyon.ctp.form.util.Enums");
        result.add("com.seeyon.ctp.form.util.FormUtil");
        result.add("com.seeyon.ctp.util.DateUtil");
        result.add("com.seeyon.ctp.util.ParamUtil");
        result.add("com.seeyon.ctp.util.Strings");
        result.add("com.seeyon.ctp.workflow.exception.BPMException");
        result.add("java.sql.SQLException");
        result.add("com.seeyon.ctp.workflow.wapi.WorkflowApiManager");
        result.add("com.seeyon.datamagic.engine.domain.base.DataMagicContext");
        result.add("com.seeyon.ctp.form.util.Enums.FormAuthorizationType");
        result.add("com.seeyon.cap4.magic.convertor.MagicProviderDefaultConvertor");
        result.add("com.seeyon.ctp.form.bean.FormAuthViewBean");
        result.add("com.seeyon.ctp.form.util.FormTriggerUtil");
        return result;
    }

    private Set<String> getSysRelationDepends() {
        HashSet<String> result = new HashSet<String>();
        result.add(" com.seeyon.datamagic.engine.domain.base.DataMagicContext");
        result.add(" java.util.ArrayList");
        result.add(" java.util.HashMap");
        result.add(" java.util.List");
        result.add(" java.util.Map");
        result.add(" com.seeyon.cap4.form.modules.engin.relation.CAP4FormRelationActionManager");
        result.add(" com.seeyon.cap4.magic.execute.internal.MagicHandleCAP3FormUtils");
        result.add(" com.seeyon.cap4.magic.convertor.MagicProviderDefaultConvertor");
        result.add(" com.seeyon.cap4.magic.utils.MagicHandleFormUtils");
        result.add(" com.seeyon.ctp.common.AppContext");
        result.add(" com.seeyon.ctp.common.ctpenumnew.manager.EnumManager");
        result.add(" com.seeyon.ctp.common.exceptions.BusinessException");
        result.add(" com.seeyon.ctp.form.bean.FormBean");
        result.add(" com.seeyon.ctp.form.bean.FormFieldBean");
        result.add(" com.seeyon.ctp.form.service.FormCacheManager");
        result.add(" com.seeyon.ctp.util.FlipInfo");
        result.add(ParamUtil.class.getName());
        return result;
    }

    private TemplateVo generateCreateContent(Metadata metadata, MagicInterfaceDefineEntity service, MagicServiceProviderPO provider) {
        String source;
        TemplateVo vo = new TemplateVo();
        vo.setBusinessId(service.getBusinessId());
        vo.setVersion(service.getVersionId());
        if (provider == null) {
            vo.setContent("return null;");
        }
        String string = source = provider == null ? "" : provider.getSource();
        if (!MagicPrivateUtils.isNumeric(source)) {
            vo.setContent("return null;");
        } else {
            FormBean formBean = this.formCacheManager.getForm(Long.parseLong(source));
            if (formBean == null) {
                vo.setContent("return null;");
            } else if (formBean.getFormType() == Enums.FormType.processesForm.getKey()) {
                vo.setContent(this.generateCreateFlowContent(metadata, service, provider, formBean));
                vo.setDependences(this.getCreateFlowDepends());
            } else if (formBean.getFormType() == Enums.FormType.baseInfo.getKey() || formBean.getFormType() == Enums.FormType.manageInfo.getKey()) {
                vo.setContent(this.generateCreateUnflowContent(metadata, service, provider, formBean));
                vo.setDependences(this.getCreateUnFlowDepends());
            } else {
                vo.setContent("return null;");
            }
        }
        return vo;
    }

    private String generateCreateUnflowContent(Metadata metadata, MagicInterfaceDefineEntity entity, MagicServiceProviderPO provider, FormBean formBean) {
        List fields;
        Map extMapper;
        InputStream is = this.getClass().getResourceAsStream("triggerCreateUnflowImplTemplate_1.txt");
        String template = StreamUtils.readStreamText((InputStream)is, (String)"UTF-8", (boolean)true);
        String bid = entity.getBusinessId();
        String vid = entity.getVersionId();
        DataMagicMatchValue match = new DataMagicMatchValue();
        String ext1 = entity.getExt1();
        long toFormId = formBean.getId();
        match.put("formId", toFormId + "L");
        ArrayList<String> fieldList = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)ext1) && (extMapper = (Map)JSONUtil.parseJSONString((String)ext1, Map.class)) != null && (fields = (List)extMapper.get("fillback")) != null) {
            for (Object temp : fields) {
                fieldList.add(temp.toString());
            }
        }
        Map<String, String> toTableMapping = MagicHandleFormUtils.getFormTableMapping(entity.getBusinessId(), entity.getVersionId(), entity.getMethodName(), true);
        HashMap<String, HashSet<FormFieldBean>> fillBackFieldBean = new HashMap<String, HashSet<FormFieldBean>>();
        for (String fieldName : fieldList) {
            FormFieldBean currentFieldBean = formBean.getFieldBeanByName(fieldName);
            if (currentFieldBean == null) continue;
            String ownerTableName = currentFieldBean.getOwnerTableName();
            HashSet<FormFieldBean> tempFieldSet = (HashSet<FormFieldBean>)fillBackFieldBean.get(ownerTableName);
            if (tempFieldSet == null) {
                tempFieldSet = new HashSet<FormFieldBean>();
                fillBackFieldBean.put(ownerTableName, tempFieldSet);
            }
            tempFieldSet.add(currentFieldBean);
        }
        Map<String, String> objectNames = MagicPrivateUtils.getObjectNames(entity, metadata, MagicEnums.BusinessMethodType.TRIGGER_CREATE);
        match.put("returnEntityName", objectNames.get("returnEntityName"));
        String argsFormData = MagicPrivateUtils.getArgsObjName(bid, vid, fieldList);
        match.put("formDataEntityName", argsFormData);
        match.put("businessId", entity.getBusinessId());
        match.put("versionId", entity.getVersionId());
        match.put("methodName", entity.getMethodName());
        FormTableBean masterTableBean = formBean.getMasterTableBean();
        Set masterFieldList = (Set)fillBackFieldBean.remove(masterTableBean.getTableName());
        String matserTemplate = "Object ${fieldName} = ${temp}.get${UpperFieldName}();${lineSeparator}FormFieldBean ${fieldName}Bean = toFormBean.getFieldBeanByName(${doubleQuote}${fieldName}${doubleQuote});${lineSeparator}if(${fieldName}Bean != null && ${fieldName}Bean.isAttachment(true, true)) {${lineSeparator}Long newSub = MagicHandleCAP3FormUtils.getAttchSubReference(false, attachmentMap, ${fieldName}Bean, null, null, ${fieldName});${lineSeparator}${datamasterBean}.addFieldValue(${doubleQuote}${fieldName}${doubleQuote}, newSub);${lineSeparator} } else {${lineSeparator}  ${datamasterBean}.addFieldValue(${doubleQuote}${fieldName}${doubleQuote},  ${fieldName});${lineSeparator} }${lineSeparator}MagicHandleCAP3FormUtils.fillMapLocateMap(${fieldName}Bean,${fieldName}, mapLocateIdMap, ${newSubDataBean});";
        if (masterFieldList != null && !masterFieldList.isEmpty()) {
            for (FormFieldBean temp : masterFieldList) {
                DataMagicMatchValue masterMatch = new DataMagicMatchValue();
                String tempName = temp.getName();
                String tempName1 = PrivateUtils.toUpperInitial((String)tempName);
                masterMatch.put("fieldName", tempName);
                masterMatch.put("UpperFieldName", tempName1);
                masterMatch.put("dataBean", "datamasterBean");
                masterMatch.put("temp", "temp");
                masterMatch.put("datamasterBean", "datamasterBean");
                masterMatch.put("newSubDataBean", "null");
                String content = TemplateFormatUtls.convert((String)matserTemplate, (ScriptReplace.IMatchValue)masterMatch);
                match.put("assignDataContent", content);
            }
        }
        if (!fillBackFieldBean.isEmpty()) {
            Map<String, String> argsAttrMap = MagicPrivateUtils.getArgsAttrMap(metadata, entity, MagicEnums.BusinessMethodType.TRIGGER_CREATE);
            String subTableTemplat = "String ${subTableName} = ${doubleQuote}${subTable}${doubleQuote};FormTableBean ${formTableBeanName} = toFormBean.getTableByTableName(${subTableName});fillSubTables.add(${subTableName});${lineSeparator}List<${subMetaType}> ${tempsubName}= temp.get${upperSubObjName}(); if(${tempsubName} != null){for(${subMetaType} ${temp} : ${tempsubName}){FormDataSubBean ${subData} = new FormDataSubBean(authViewBean,${formTableBeanName}, datamasterBean, true);${subData}.addFieldValue(Enums.SubTableField.formmain_id.getKey(),datamasterBean.getId());${assignDataContent} Map<String, Object> ${toSubTemp} = toSub.get(String.valueOf(${temp}.getSourceDataId()));if(${toSubTemp} == null) {    ${toSubTemp} = new HashMap<String, Object>();    toSub.put(String.valueOf(${temp}.getSourceDataId()),${toSubTemp});}${toSubTemp}.put(${subTableName}, ${subTableName}+${doubleQuote},${doubleQuote} + ${subData}.getId());datamasterBean.addSubData(${subTableName}, ${subData});}}";
            for (Map.Entry sub : fillBackFieldBean.entrySet()) {
                String subTableName = "sub" + PrivateUtils.randomInt((int)Integer.MAX_VALUE);
                String formTableBeanName = "form" + PrivateUtils.randomInt((int)Integer.MAX_VALUE);
                String subData = "subData" + PrivateUtils.randomInt((int)Integer.MAX_VALUE);
                String tempsubName = "temp" + PrivateUtils.randomInt((int)Integer.MAX_VALUE);
                String temp = "ft" + PrivateUtils.randomInt((int)Integer.MAX_VALUE);
                String toSubTemp = "toSub" + PrivateUtils.randomInt((int)Integer.MAX_VALUE);
                DataMagicMatchValue subMatch = new DataMagicMatchValue();
                subMatch.put("subTableName", subTableName);
                subMatch.put("toSubTemp", toSubTemp);
                subMatch.put("formTableBeanName", formTableBeanName);
                subMatch.put("subData", subData);
                subMatch.put("tempsubName", tempsubName);
                subMatch.put("temp", temp);
                Set subFieldBeans = (Set)sub.getValue();
                String key = (String)sub.getKey();
                if (subFieldBeans == null || subFieldBeans.isEmpty()) continue;
                subMatch.put("subTable", key);
                subMatch.put("upperSubObjName", PrivateUtils.toUpperInitial((String)toTableMapping.get(key)));
                for (FormFieldBean f : subFieldBeans) {
                    DataMagicMatchValue masterMatch = new DataMagicMatchValue();
                    String tempName = f.getName();
                    String tempName1 = PrivateUtils.toUpperInitial((String)tempName);
                    masterMatch.put("fieldName", tempName);
                    masterMatch.put("UpperFieldName", tempName1);
                    masterMatch.put("dataBean", subData);
                    masterMatch.put("temp", temp);
                    masterMatch.put("newSubDataBean", subData);
                    masterMatch.put("datamasterBean", subData);
                    String content = TemplateFormatUtls.convert((String)matserTemplate, (ScriptReplace.IMatchValue)masterMatch);
                    subMatch.put("assignDataContent", content);
                }
                subMatch.put("subMetaType", argsAttrMap.get(toTableMapping.get(key)));
                String assignDataContent = TemplateFormatUtls.convert((String)subTableTemplat, (ScriptReplace.IMatchValue)subMatch);
                match.put("assignDataContent", assignDataContent);
            }
        }
        String content = TemplateFormatUtls.convert((String)template, (ScriptReplace.IMatchValue)match);
        return content;
    }

    private String generateCreateFlowContent(Metadata metadata, MagicInterfaceDefineEntity entity, MagicServiceProviderPO provider, FormBean formBean) {
        List fields;
        Map extMapper;
        InputStream is = this.getClass().getResourceAsStream("triggerCreateFlowImplTemplate_1.txt");
        String template = StreamUtils.readStreamText((InputStream)is, (String)"UTF-8", (boolean)true);
        String bid = entity.getBusinessId();
        String vid = entity.getVersionId();
        DataMagicMatchValue match = new DataMagicMatchValue();
        String ext1 = entity.getExt1();
        long toFormId = formBean.getId();
        ArrayList<String> fieldList = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)ext1) && (extMapper = (Map)JSONUtil.parseJSONString((String)ext1, Map.class)) != null && (fields = (List)extMapper.get("fillback")) != null) {
            for (Object temp : fields) {
                fieldList.add(temp.toString());
            }
        }
        if (provider != null) {
            match.put("formId", provider.getSource() + "L");
        } else {
            match.put("formId", toFormId + "L");
        }
        Map<String, String> toTableMapping = MagicHandleFormUtils.getFormTableMapping(entity.getBusinessId(), entity.getVersionId(), entity.getMethodName(), true);
        HashMap<String, HashSet<FormFieldBean>> fillBackFieldBean = new HashMap<String, HashSet<FormFieldBean>>();
        for (String fieldName : fieldList) {
            FormFieldBean currentFieldBean = formBean.getFieldBeanByName(fieldName);
            String ownerTableName = currentFieldBean.getOwnerTableName();
            HashSet<FormFieldBean> tempFieldSet = (HashSet<FormFieldBean>)fillBackFieldBean.get(ownerTableName);
            if (tempFieldSet == null) {
                tempFieldSet = new HashSet<FormFieldBean>();
                fillBackFieldBean.put(ownerTableName, tempFieldSet);
            }
            tempFieldSet.add(currentFieldBean);
        }
        Map<String, String> objectNames = MagicPrivateUtils.getObjectNames(entity, metadata, MagicEnums.BusinessMethodType.TRIGGER_CREATE);
        match.put("returnEntityName", objectNames.get("returnEntityName"));
        String argsFormData = MagicPrivateUtils.getArgsObjName(bid, vid, fieldList);
        match.put("formDataEntityName", argsFormData);
        match.put("businessId", entity.getBusinessId());
        match.put("versionId", entity.getVersionId());
        match.put("methodName", entity.getMethodName());
        FormTableBean masterTableBean = formBean.getMasterTableBean();
        Set masterFieldList = (Set)fillBackFieldBean.remove(masterTableBean.getTableName());
        String matserTemplate = "Object ${fieldName} = ${temp}.get${UpperFieldName}();${lineSeparator}FormFieldBean ${fieldName}Bean = toFormBean.getFieldBeanByName(${doubleQuote}${fieldName}${doubleQuote});${lineSeparator}if(${fieldName}Bean != null &&${fieldName}Bean.isAttachment(true, true)) {${lineSeparator}Long newSub = MagicHandleCAP3FormUtils.getAttchSubReference(false, attachmentMap, ${fieldName}Bean, null, null, ${fieldName});${lineSeparator}${datamasterBean}.addFieldValue(${doubleQuote}${fieldName}${doubleQuote}, newSub);${lineSeparator} } else {${lineSeparator}  ${datamasterBean}.addFieldValue(${doubleQuote}${fieldName}${doubleQuote},  ${fieldName});${lineSeparator} }${lineSeparator}MagicHandleCAP3FormUtils.fillMapLocateMap(${fieldName}Bean,${fieldName}, mapLocateIdMap, ${newSubDataBean});";
        if (masterFieldList != null && !masterFieldList.isEmpty()) {
            for (FormFieldBean temp : masterFieldList) {
                DataMagicMatchValue masterMatch = new DataMagicMatchValue();
                String tempName = temp.getName();
                String tempName1 = PrivateUtils.toUpperInitial((String)tempName);
                masterMatch.put("fieldName", tempName);
                masterMatch.put("UpperFieldName", tempName1);
                masterMatch.put("dataBean", "datamasterBean");
                masterMatch.put("temp", "temp");
                masterMatch.put("datamasterBean", "datamasterBean");
                masterMatch.put("newSubDataBean", "null");
                String content = TemplateFormatUtls.convert((String)matserTemplate, (ScriptReplace.IMatchValue)masterMatch);
                match.put("assignDataContent", content);
            }
        }
        if (!fillBackFieldBean.isEmpty()) {
            Map<String, String> argsAttrMap = MagicPrivateUtils.getArgsAttrMap(metadata, entity, MagicEnums.BusinessMethodType.TRIGGER_CREATE);
            String subTableTemplat = "String ${subTableName} = ${doubleQuote}${subTable}${doubleQuote};${lineSeparator}FormTableBean ${formTableBeanName} = toFormBean.getTableByTableName(${subTableName});${lineSeparator}fillSubTables.add(${subTableName});${lineSeparator}List<${subMetaType}> ${tempsubName}= temp.get${upperSubObjName}(); if(${tempsubName} != null){for(${subMetaType} ${temp} : ${tempsubName}){FormDataSubBean ${subData} = new FormDataSubBean(authViewBean,${formTableBeanName}, datamasterBean, true);${subData}.addFieldValue(Enums.SubTableField.formmain_id.getKey(),datamasterBean.getId());${assignDataContent} Map<String, Object> ${toSubTemp} = toSub.get(String.valueOf(${temp}.getSourceDataId()));if(${toSubTemp} == null) {    ${toSubTemp} = new HashMap<String, Object>();    toSub.put(String.valueOf(${temp}.getSourceDataId()),${toSubTemp});}${toSubTemp}.put(${subTableName}, ${subTableName}+${doubleQuote},${doubleQuote} + ${subData}.getId());datamasterBean.addSubData(${subTableName}, ${subData});}}";
            for (Map.Entry sub : fillBackFieldBean.entrySet()) {
                String subTableName = "sub" + PrivateUtils.randomInt((int)Integer.MAX_VALUE);
                String formTableBeanName = "form" + PrivateUtils.randomInt((int)Integer.MAX_VALUE);
                String subData = "subData" + PrivateUtils.randomInt((int)Integer.MAX_VALUE);
                String tempsubName = "temp" + PrivateUtils.randomInt((int)Integer.MAX_VALUE);
                String temp = "ft" + PrivateUtils.randomInt((int)Integer.MAX_VALUE);
                String toSubTemp = "toSub" + PrivateUtils.randomInt((int)Integer.MAX_VALUE);
                DataMagicMatchValue subMatch = new DataMagicMatchValue();
                subMatch.put("subTableName", subTableName);
                subMatch.put("formTableBeanName", formTableBeanName);
                subMatch.put("toSubTemp", toSubTemp);
                subMatch.put("subData", subData);
                subMatch.put("tempsubName", tempsubName);
                subMatch.put("temp", temp);
                Set subFieldBeans = (Set)sub.getValue();
                String key = (String)sub.getKey();
                if (subFieldBeans == null || subFieldBeans.isEmpty()) continue;
                subMatch.put("subTable", (String)sub.getKey());
                subMatch.put("upperSubObjName", PrivateUtils.toUpperInitial((String)toTableMapping.get(key)));
                for (FormFieldBean f : subFieldBeans) {
                    DataMagicMatchValue masterMatch = new DataMagicMatchValue();
                    String tempName = f.getName();
                    String tempName1 = PrivateUtils.toUpperInitial((String)tempName);
                    masterMatch.put("fieldName", tempName);
                    masterMatch.put("UpperFieldName", tempName1);
                    masterMatch.put("dataBean", subData);
                    masterMatch.put("temp", temp);
                    masterMatch.put("datamasterBean", subData);
                    masterMatch.put("newSubDataBean", subData);
                    String content = TemplateFormatUtls.convert((String)matserTemplate, (ScriptReplace.IMatchValue)masterMatch);
                    subMatch.put("assignDataContent", content);
                }
                subMatch.put("subMetaType", argsAttrMap.get(toTableMapping.get(key)));
                String assignDataContent = TemplateFormatUtls.convert((String)subTableTemplat, (ScriptReplace.IMatchValue)subMatch);
                match.put("assignDataContent", assignDataContent);
            }
        }
        return TemplateFormatUtls.convert((String)template, (ScriptReplace.IMatchValue)match);
    }

    private TemplateVo generateQueryContent(Metadata metadata, MagicInterfaceDefineEntity entity, MagicServiceProviderPO provider) {
        InputStream is = this.getClass().getResourceAsStream("queryImplTemplate_1.txt");
        String template = StreamUtils.readStreamText((InputStream)is, (String)"UTF-8", (boolean)true);
        DataMagicMatchValue dmv = new DataMagicMatchValue();
        Map<String, String> objectNames = MagicPrivateUtils.getObjectNames(entity, metadata, MagicEnums.BusinessMethodType.QUERY);
        dmv.put("returnEntityName", objectNames.get("returnEntityName"));
        dmv.put("fieldValueObj", objectNames.get("feedBackItemValue"));
        dmv.put("businessId", entity.getBusinessId());
        dmv.put("versionId", entity.getVersionId());
        dmv.put("methodName", entity.getMethodName());
        dmv.put("formId", provider.getSource() + "L");
        TemplateVo result = new TemplateVo();
        String content = TemplateFormatUtls.convert((String)template, (ScriptReplace.IMatchValue)dmv);
        result.setContent(content);
        result.setDependences(this.getQueryDepends());
        return result;
    }

    private TemplateVo generateUpdateContent(Metadata metadata, MagicInterfaceDefineEntity entity, MagicServiceProviderPO provider) {
        Map extMapp;
        long toFormId = Long.parseLong(provider.getSource());
        FormBean formBean = this.formCacheManager.getForm(toFormId);
        if (formBean == null) {
            TemplateVo result = new TemplateVo();
            result.setContent("return null;");
            return result;
        }
        InputStream is = this.getClass().getResourceAsStream("triggerUpdateImplTemplate_1.txt");
        String template = StreamUtils.readStreamText((InputStream)is, (String)"UTF-8", (boolean)true);
        DataMagicMatchValue dmv = new DataMagicMatchValue();
        dmv.put("businessId", entity.getBusinessId());
        dmv.put("versionId", entity.getVersionId());
        dmv.put("methodName", entity.getMethodName());
        String businessId = entity.getBusinessId();
        String versionId = entity.getVersionId();
        String exit1 = entity.getExt1();
        ArrayList<String> fillback = new ArrayList<String>();
        ArrayList<String> condition = new ArrayList<String>();
        if (exit1 != null && (extMapp = (Map)JSONUtil.parseJSONString((String)exit1, Map.class)) != null) {
            Object fillBackArray;
            List conditionArray = (List)extMapp.get("condition");
            if (conditionArray != null) {
                for (Object temp : conditionArray) {
                    condition.add(temp.toString());
                }
            }
            if ((fillBackArray = (List)extMapp.get("fillback")) != null) {
                Object temp;
                temp = fillBackArray.iterator();
                while (temp.hasNext()) {
                    Object temp2 = temp.next();
                    fillback.add(temp2.toString());
                }
            }
        }
        String fillBackEntityName = MagicPrivateUtils.getArgsObjName(businessId, versionId, fillback);
        HashMap<String, HashSet<FormFieldBean>> fillBackFieldBean = new HashMap<String, HashSet<FormFieldBean>>();
        for (String fieldName : fillback) {
            FormFieldBean currentFieldBean = formBean.getFieldBeanByName(fieldName);
            String ownerTableName = currentFieldBean.getOwnerTableName();
            HashSet<FormFieldBean> tempFieldSet = (HashSet<FormFieldBean>)fillBackFieldBean.get(ownerTableName);
            if (tempFieldSet == null) {
                tempFieldSet = new HashSet<FormFieldBean>();
                fillBackFieldBean.put(ownerTableName, tempFieldSet);
            }
            tempFieldSet.add(currentFieldBean);
        }
        FormTableBean masterTableBean = formBean.getMasterTableBean();
        Set masterFieldList = (Set)fillBackFieldBean.remove(masterTableBean.getTableName());
        Map<String, String> objectNames = MagicPrivateUtils.getObjectNames(entity, metadata, MagicEnums.BusinessMethodType.TRIGGER_UPDATE);
        String matserTemplate = "Object ${fieldName} = ${temp}.get${UpperFieldName}();${lineSeparator}${dataBean}.addMaster(${doubleQuote}${fieldName}${doubleQuote}, ${fieldName});";
        if (masterFieldList != null && !masterFieldList.isEmpty()) {
            DataMagicMatchValue masterMatch = new DataMagicMatchValue();
            for (FormFieldBean temp : masterFieldList) {
                String tempName = temp.getName();
                String string = PrivateUtils.toUpperInitial((String)tempName);
                masterMatch.put("fieldName", tempName);
                masterMatch.put("UpperFieldName", string);
                masterMatch.put("dataBean", "fillBack");
                masterMatch.put("temp", "fill");
                String content = TemplateFormatUtls.convert((String)matserTemplate, (ScriptReplace.IMatchValue)masterMatch);
                dmv.put("fillBackContent", content);
                masterMatch.clear();
            }
        }
        Map<String, String> formTableMapping = MagicHandleFormUtils.getFormTableMapping(businessId, versionId, entity.getMethodName(), true);
        String subTemplate = " List<${subObjEntity}> ${subTableName} = fill.get${UppersubTableName}();if (${subTableName} != null) {    for (${subObjEntity} temp : ${subTableName}) {        Map<String, Object> map = new HashMap<String, Object>();        ParamUtil.beanToMap(temp, map,true,DateUtil.YMDHMS_PATTERN);        fillBack.addSub(formTableMapping.get(${doubleQuote}${subTableName}${doubleQuote}), map);    }}";
        DataMagicMatchValue subMatch = new DataMagicMatchValue();
        for (Map.Entry entry : fillBackFieldBean.entrySet()) {
            String key = (String)entry.getKey();
            key = formTableMapping.get(key);
            Set value = (Set)entry.getValue();
            String subObjEntity = objectNames.get(key);
            if (key == null || value == null || value.isEmpty() || Strings.isBlank((String)subObjEntity)) continue;
            subMatch.put("subTableName", key);
            subMatch.put("UppersubTableName", PrivateUtils.toUpperInitial((String)key));
            subMatch.put("subObjEntity", subObjEntity);
            dmv.put("fillBackContent", TemplateFormatUtls.convert((String)subTemplate, (ScriptReplace.IMatchValue)subMatch));
            subMatch.clear();
        }
        dmv.put("returnEntityName", objectNames.get("returnEntityName"));
        if (provider != null) {
            dmv.put("formId", provider.getSource() + "L");
        } else {
            dmv.put("formId", toFormId + "L");
        }
        dmv.put("formDataEntityName", fillBackEntityName);
        dmv.put("conditionEntityName", MagicPrivateUtils.getArgsObjName(businessId, versionId, condition));
        TemplateVo result = new TemplateVo();
        String string = TemplateFormatUtls.convert((String)template, (ScriptReplace.IMatchValue)dmv);
        result.setContent(string);
        result.setDependences(this.getUpdateDepends());
        return result;
    }

    public OutServiceInfo getServiceInfo() {
        OutServiceInfo info = new OutServiceInfo();
        info.setName(ResourceUtil.getString((String)"cap4.form.business.businessset") + "/" + ResourceUtil.getString((String)"application.67.label"));
        info.setIdentity(MagicEnums.ProviderType.DEFAULT_FORM_CAP3.getType());
        boolean formBiz = AppContext.hasPlugin((String)"formBiz");
        boolean form = AppContext.hasPlugin((String)"form");
        info.setEnabled(form || formBiz);
        info.setSort(2);
        info.addSupportType(MagicEnums.BusinessMethodType.RELATION_USER.getName());
        info.addSupportType(MagicEnums.BusinessMethodType.RELATION_SYS.getName());
        info.addSupportType(MagicEnums.BusinessMethodType.TRIGGER_CREATE.getName());
        info.addSupportType(MagicEnums.BusinessMethodType.TRIGGER_UPDATE.getName());
        return info;
    }

    public List<ServiceSummary> loadAllServices(int arg0, ServicesCategoryTree arg1, ServiceQueryCondition arg2) {
        String conditon = arg2.getCondition();
        ArrayList<MagicEnums.BusinessMethodType> serviceType = new ArrayList<MagicEnums.BusinessMethodType>();
        ArrayList<ServiceSummary> result = new ArrayList<ServiceSummary>();
        String otherParentId = "123456";
        boolean formBiz = AppContext.hasPlugin((String)"formBiz");
        boolean form = AppContext.hasPlugin((String)"form");
        if (!formBiz && !form) {
            return Collections.emptyList();
        }
        try {
            if (arg0 == MagicEnums.BusinessMethodType.RELATION_SYS.getType()) {
                serviceType.add(MagicEnums.BusinessMethodType.RELATION_SYS);
                serviceType.add(MagicEnums.BusinessMethodType.RELATION);
            } else if (arg0 == MagicEnums.BusinessMethodType.RELATION_USER.getType()) {
                serviceType.add(MagicEnums.BusinessMethodType.RELATION_USER);
                serviceType.add(MagicEnums.BusinessMethodType.RELATION);
            } else if (arg0 == MagicEnums.BusinessMethodType.OUTERTRGGER.getType()) {
                serviceType.add(MagicEnums.BusinessMethodType.TRIGGER_CREATE);
                serviceType.add(MagicEnums.BusinessMethodType.TRIGGER_UPDATE);
            } else if (arg0 == MagicEnums.BusinessMethodType.RELATION.getType()) {
                serviceType.add(MagicEnums.BusinessMethodType.RELATION_USER);
                serviceType.add(MagicEnums.BusinessMethodType.RELATION);
                serviceType.add(MagicEnums.BusinessMethodType.RELATION_SYS);
            }
            ArrayList<FormTreeNode> nodes = new ArrayList<FormTreeNode>();
            FormTreeNode rootNode = new FormTreeNode();
            rootNode.setId(Enums.FormType.manageInfo.getKey() + "");
            rootNode.setName(ResourceUtil.getString((String)"cap.magic.info.port.form"));
            nodes.add(rootNode);
            HashMap<String, CtpTemplateCategory> catgMap = new HashMap<String, CtpTemplateCategory>();
            ArrayList<ServiceSummary> others = new ArrayList<ServiceSummary>();
            List<MagicInterfaceDefineEntity> servicesList = this.magicInterfaceDefineDao.loadDefines(serviceType, conditon);
            ServiceSummary ss = null;
            HashMap<String, MagicInterfaceDefineEntity> mapper = new HashMap<String, MagicInterfaceDefineEntity>();
            for (MagicInterfaceDefineEntity magicInterfaceDefineEntity : servicesList) {
                FormTreeNode node;
                if (!MagicEnums.ProviderType.DEFAULT_FORM_CAP3.getType().equals(magicInterfaceDefineEntity.getSubType())) continue;
                FormBean fb = this.formCacheManager.getForm(magicInterfaceDefineEntity.getFormId());
                mapper.put(String.valueOf(magicInterfaceDefineEntity.getId()), magicInterfaceDefineEntity);
                if (fb == null) {
                    ss = new ServiceSummary();
                    ss.setBusinessId(magicInterfaceDefineEntity.getBusinessId());
                    ss.setVersion(magicInterfaceDefineEntity.getVersionId());
                    ss.setServiceName(magicInterfaceDefineEntity.getMethodName());
                    ss.setId(String.valueOf(magicInterfaceDefineEntity.getId()));
                    ss.setName(magicInterfaceDefineEntity.getName(AppContext.getLocale()));
                    ss.setParentId(otherParentId);
                    others.add(ss);
                    continue;
                }
                if (fb.getOwnerId() != AppContext.currentUserId()) continue;
                CtpTemplateCategory currentTemplate = this.templateManager.getCtpTemplateCategory(Long.valueOf(fb.getCategoryId()));
                if (currentTemplate == null) {
                    ss = new ServiceSummary();
                    ss.setBusinessId(magicInterfaceDefineEntity.getBusinessId());
                    ss.setId(String.valueOf(magicInterfaceDefineEntity.getId()));
                    ss.setName(magicInterfaceDefineEntity.getName(AppContext.getLocale()));
                    ss.setParentId(otherParentId);
                    others.add(ss);
                    continue;
                }
                if (Enums.FormType.processesForm.getKey() == fb.getFormType() && form) {
                    catgMap.put(currentTemplate.getName(), currentTemplate);
                    node = new FormTreeNode();
                    node.setName(magicInterfaceDefineEntity.getName(AppContext.getLocale()));
                    node.setId(currentTemplate.getId().toString());
                    node.setParentId(currentTemplate.getName());
                    node.setFormId(String.valueOf(magicInterfaceDefineEntity.getId()));
                    nodes.add(node);
                    continue;
                }
                if (!formBiz) continue;
                catgMap.put(currentTemplate.getName(), currentTemplate);
                node = new FormTreeNode();
                node.setName(magicInterfaceDefineEntity.getName(AppContext.getLocale()));
                node.setId(currentTemplate.getId().toString());
                node.setParentId(currentTemplate.getName());
                node.setFormId(String.valueOf(magicInterfaceDefineEntity.getId()));
                nodes.add(node);
            }
            TreeNodeUtil.getTreeNode4Catg(catgMap, (FormTreeNode)rootNode, nodes, (String)"", catgMap);
            HashMap<String, List<FormTreeNode>> nodeMapper = new HashMap<String, List<FormTreeNode>>();
            for (FormTreeNode node : nodes) {
                if (node.getId().equals(rootNode.getId())) continue;
                LinkedList<FormTreeNode> childen = (LinkedList<FormTreeNode>)nodeMapper.get(node.getParentId());
                if (childen == null) {
                    childen = new LinkedList<FormTreeNode>();
                    nodeMapper.put(node.getParentId(), childen);
                }
                childen.add(node);
            }
            nodes.clear();
            this.sortFormNodes(nodes, rootNode, nodeMapper);
            if (nodes != null && !nodes.isEmpty()) {
                ServiceSummary serviceSummary = new ServiceSummary();
                serviceSummary.setName(rootNode.getName());
                serviceSummary.setParentId(rootNode.getParentId());
                serviceSummary.setId(rootNode.getId());
                serviceSummary.setCategory(rootNode.getFormId() == null);
                result.add(serviceSummary);
                for (FormTreeNode ftn : nodes) {
                    ServiceSummary serviceSummary2 = new ServiceSummary();
                    serviceSummary2.setName(ftn.getName());
                    serviceSummary2.setParentId(ftn.getParentId());
                    serviceSummary2.setCategory(ftn.getFormId() == null);
                    if (serviceSummary2.isCategory()) {
                        serviceSummary2.setId(ftn.getId());
                    } else {
                        MagicInterfaceDefineEntity entry = (MagicInterfaceDefineEntity)mapper.get(ftn.getFormId());
                        if (entry != null) {
                            serviceSummary2.setBusinessId(entry.getBusinessId());
                            serviceSummary2.setVersion(entry.getVersionId());
                            serviceSummary2.setServiceName(entry.getMethodName());
                        }
                        serviceSummary2.setId(ftn.getFormId());
                    }
                    result.add(serviceSummary2);
                }
            }
            if (!others.isEmpty()) {
                ServiceSummary serviceSummary = new ServiceSummary();
                serviceSummary.setId(otherParentId);
                serviceSummary.setName(ResourceUtil.getString((String)"com.cap.businessrelation.condition.other.label"));
                result.add(serviceSummary);
                result.addAll(others);
            }
        }
        catch (BusinessException e) {
            LOGGER.error((Object)e.getLocalizedMessage());
        }
        return result;
    }

    public void sortFormNodes(List<FormTreeNode> sortedNodes, FormTreeNode root, Map<String, List<FormTreeNode>> nodes) {
        List<FormTreeNode> childen = nodes.remove(root.getId());
        if (childen != null && !childen.isEmpty()) {
            for (FormTreeNode child : childen) {
                sortedNodes.add(child);
                this.sortFormNodes(sortedNodes, child, nodes);
            }
        }
    }

    public ServiceProvider provider(String arg0, String arg1, String methodName, ServiceSummary arg2) {
        return null;
    }

    public IMagicInterfaceDefineDao getMagicInterfaceDefineDao() {
        return this.magicInterfaceDefineDao;
    }

    public void setMagicInterfaceDefineDao(IMagicInterfaceDefineDao magicInterfaceDefineDao) {
        this.magicInterfaceDefineDao = magicInterfaceDefineDao;
    }

    public IMagicProviderDao getMagicProviderDao() {
        return this.magicProviderDao;
    }

    public void setMagicProviderDao(IMagicProviderDao magicProviderDao) {
        this.magicProviderDao = magicProviderDao;
    }

    public FormCacheManager getFormCacheManager() {
        return this.formCacheManager;
    }

    public void setFormCacheManager(FormCacheManager formCacheManager) {
        this.formCacheManager = formCacheManager;
    }

    public TemplateManager getTemplateManager() {
        return this.templateManager;
    }

    public void setTemplateManager(TemplateManager templateManager) {
        this.templateManager = templateManager;
    }

    public IMagicServiceSummaryDao getMagicServiceSummaryDao() {
        return this.magicServiceSummaryDao;
    }

    public void setMagicServiceSummaryDao(IMagicServiceSummaryDao magicServiceSummaryDao) {
        this.magicServiceSummaryDao = magicServiceSummaryDao;
    }
}

