/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.magic.initializer;

import com.seeyon.cap4.magic.business.bind.IMagicBusinessBindService;
import com.seeyon.cap4.magic.business.update.IMagicServiceUpdate;
import com.seeyon.cap4.magic.dao.IMagicProviderDao;
import com.seeyon.cap4.magic.execute.MagicExecuteByVersionManager;
import com.seeyon.cap4.magic.execute.MagicProviderExecuteManager;
import com.seeyon.cap4.magic.manager.ICAP4MagicManager;
import com.seeyon.cap4.magic.vo.MagicEnums;
import com.seeyon.ctp.common.AbstractSystemInitializer;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.Strings;
import com.seeyon.datamagic.engine.out.service.OutService;
import com.seeyon.datamagic.engine.out.service.entry.OutServiceInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;

public class CAP4MagicCacheInitializer
extends AbstractSystemInitializer {
    private static Map<String, MagicProviderExecuteManager> magicExecuteByProviderManager = new HashMap<String, MagicProviderExecuteManager>();
    private static Map<String, MagicExecuteByVersionManager> magicExecuteByVersionManager = new HashMap<String, MagicExecuteByVersionManager>();
    private static Map<String, IMagicBusinessBindService> magicBindServiceManager = new HashMap<String, IMagicBusinessBindService>();
    private static final Log LOGGER = CtpLogFactory.getLog(CAP4MagicCacheInitializer.class);
    private IMagicProviderDao magicProviderDao;

    public void initialize() {
        this.magicProviderDao.init();
        Map bindService = AppContext.getBeansOfType(IMagicBusinessBindService.class);
        for (Object b : bindService.values()) {
            magicBindServiceManager.put(b.getBindType(), (IMagicBusinessBindService)b);
        }
        Map executeManager = AppContext.getBeansOfType(MagicProviderExecuteManager.class);
        for (Object x : executeManager.values()) {
            String providerType = x.getProviderType();
            if (Strings.isBlank((String)providerType)) {
                LOGGER.warn((Object)("\u52a0\u8f7d\u6267\u884c\u670d\u52a1\u51fa\u5dee\u3002\u539f\u56e0 \u6267\u884c\u670d\u52a1\u7c7b\u578b\u4e3a\u7a7a\uff0c\u5c06\u4e0d\u52a0\u8f7d\u6b64\u6267\u884c\u670d\u52a1" + x.getClass().getName()));
                continue;
            }
            if (magicExecuteByProviderManager.containsKey(providerType)) {
                LOGGER.warn((Object)("\u52a0\u8f7d\u6267\u884c\u670d\u52a1\u7c7b\u578b\u4e3a" + providerType + "\u65f6\u51fa\u5dee\uff0c\u539f\u56e0\u662f\u6b64\u6267\u884c\u670d\u52a1\u5df2\u5b58\u5728" + x.getClass().getName()));
                continue;
            }
            if (MagicEnums.ServiceOwnerType.DEFAULT_EXTERNAL.getType().equals(providerType)) {
                magicExecuteByProviderManager.put(MagicEnums.ServiceOwnerType.DEFAULT_DEE.getType(), (MagicProviderExecuteManager)x);
                magicExecuteByProviderManager.put(MagicEnums.ServiceOwnerType.DEFAULT_CAP4_BIZ.getType(), (MagicProviderExecuteManager)x);
                magicExecuteByProviderManager.put(MagicEnums.ArticulatedType.EXTEND_JAVA_SOURCE.getType(), (MagicProviderExecuteManager)x);
                magicExecuteByProviderManager.put(MagicEnums.ArticulatedType.EXTEND_CLASS.getType(), (MagicProviderExecuteManager)x);
                magicExecuteByProviderManager.put(MagicEnums.ServiceOwnerType.DEFAULT_EXTERNAL.getType(), (MagicProviderExecuteManager)x);
                continue;
            }
            magicExecuteByProviderManager.put(providerType, (MagicProviderExecuteManager)x);
        }
        Map outService = AppContext.getBeansOfType(OutService.class);
        for (OutService o : outService.values()) {
            String k = o.getServiceInfo().getIdentity();
            if (magicExecuteByProviderManager.containsKey(k)) continue;
            magicExecuteByProviderManager.put(k, magicExecuteByProviderManager.get(MagicEnums.ServiceOwnerType.DEFAULT_DEE.getType()));
        }
        Map executeVersionManager = AppContext.getBeansOfType(MagicExecuteByVersionManager.class);
        for (MagicExecuteByVersionManager x : executeVersionManager.values()) {
            String version = x.getExecuteVersion();
            if (Strings.isBlank((String)version)) {
                LOGGER.warn((Object)("\u52a0\u8f7d\u6267\u884c\u670d\u52a1\u51fa\u5dee\u3002\u539f\u56e0 \u6267\u884c\u670d\u52a1\u7248\u672c\u4e3a\u7a7a\uff0c\u5c06\u4e0d\u52a0\u8f7d\u6b64\u6267\u884c\u670d\u52a1" + x.getClass().getName()));
                continue;
            }
            if (magicExecuteByVersionManager.containsKey(version)) {
                LOGGER.warn((Object)("\u52a0\u8f7d\u6267\u884c\u670d\u52a1\u7248\u672c\u4e3a" + version + "\u65f6\u51fa\u5dee\uff0c\u539f\u56e0\u662f\u6b64\u7248\u672c\u7684\u670d\u52a1\u5df2\u5b58\u5728" + x.getClass().getName()));
                continue;
            }
            magicExecuteByVersionManager.put(version, x);
        }
        this.update();
    }

    private void update() {
        try {
            ICAP4MagicManager cap4MagicManager = (ICAP4MagicManager)AppContext.getBean((String)"cap4MagicManager");
            cap4MagicManager.updateMagic();
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public static int getLatestUpdateVersion() {
        int updateSort = 0;
        Map allUpdateServices = AppContext.getBeansOfType(IMagicServiceUpdate.class);
        for (IMagicServiceUpdate su : allUpdateServices.values()) {
            if (su.updateSort() <= updateSort) continue;
            updateSort = su.updateSort();
        }
        return updateSort;
    }

    public static MagicProviderExecuteManager getExecuteByProviderManager(String type) {
        if (type == null) {
            return null;
        }
        return magicExecuteByProviderManager.get(type);
    }

    public static MagicExecuteByVersionManager getExecuteByVersionManager(String version) {
        if (version == null) {
            return null;
        }
        return magicExecuteByVersionManager.get(version);
    }

    public static List<OutService> getAllMagicOutService() {
        ArrayList<OutService> result1 = new ArrayList<OutService>(CAP4MagicCacheInitializer.loadAllMagicOutService().values());
        return result1;
    }

    private static Map<String, OutService> loadAllMagicOutService() {
        HashMap<String, OutService> result = new HashMap<String, OutService>();
        Map allLoadDataService = AppContext.getBeansOfType(OutService.class);
        for (OutService s : allLoadDataService.values()) {
            OutServiceInfo info = s.getServiceInfo();
            if (info == null || !info.isEnabled()) {
                LOGGER.warn((Object)("\u52a0\u8f7d\u7b2c3\u65b9\u6570\u636e\u63a5\u53e3\u670d\u52a1\u65f6 \u670d\u52a1\u4fe1\u606f\u6ca1\u6709\u8bbe\u7f6e \u5c06\u8df3\u8fc7\u6b64\u52a0\u8f7d," + s.getClass().getName()));
                continue;
            }
            String name = info.getName();
            if (Strings.isBlank((String)name) || Strings.isBlank((String)info.getIdentity())) {
                LOGGER.warn((Object)("\u52a0\u8f7d\u7b2c3\u65b9\u6570\u636e\u63a5\u53e3\u670d\u52a1\u65f6 \u670d\u52a1\u540d\u79f0\u6ca1\u6709\u8bbe\u7f6e \u5c06\u8df3\u8fc7\u6b64\u52a0\u8f7d," + s.getClass().getName()));
                continue;
            }
            if (result.containsKey(info.getIdentity())) {
                LOGGER.warn((Object)("\u52a0\u8f7d\u7b2c3\u65b9\u6570\u636e\u63a5\u53e3\u670d\u52a1\u65f6 \u670d\u52a1\u540d\u79f0" + name + "\u5df2\u7ecf\u88ab\u8bbe\u7f6e\u8bbe\u7f6e \u5c06\u8df3\u8fc7\u6b64\u52a0\u8f7d," + s.getClass().getName()));
                continue;
            }
            result.put(info.getIdentity(), s);
        }
        return result;
    }

    public static IMagicBusinessBindService getBindService(String type) {
        return magicBindServiceManager.get(type);
    }

    public static OutService getOutServiceByType(String type) {
        if (type == null) {
            return null;
        }
        return CAP4MagicCacheInitializer.loadAllMagicOutService().get(type);
    }

    public IMagicProviderDao getMagicProviderDao() {
        return this.magicProviderDao;
    }

    public void setMagicProviderDao(IMagicProviderDao magicProviderDao) {
        this.magicProviderDao = magicProviderDao;
    }
}

