/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.magic.management.manager.impl;

import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormTriggerBean;
import com.seeyon.cap4.form.modules.business.BizConfigBean;
import com.seeyon.cap4.form.modules.business.BusinessManager;
import com.seeyon.cap4.form.po.CAPFormDefinition;
import com.seeyon.cap4.form.po.CapBizConfig;
import com.seeyon.cap4.form.service.CAP4FormCacheManager;
import com.seeyon.cap4.magic.dao.IMagicInterfaceDefineDao;
import com.seeyon.cap4.magic.dao.IMagicProviderDao;
import com.seeyon.cap4.magic.dao.IMagicReflectionRelationDao;
import com.seeyon.cap4.magic.initializer.CAP4MagicCacheInitializer;
import com.seeyon.cap4.magic.management.manager.IMagicManagement;
import com.seeyon.cap4.magic.po.MagicInterfaceDefineEntity;
import com.seeyon.cap4.magic.po.MagicReflectionRelationPO;
import com.seeyon.cap4.magic.po.MagicServiceProviderPO;
import com.seeyon.cap4.magic.utils.JSONUtils;
import com.seeyon.cap4.magic.utils.MagicPrivateUtils;
import com.seeyon.cap4.magic.vo.MagicEnums;
import com.seeyon.cap4.magic.vo.MagicFormBean;
import com.seeyon.cap4.magic.vo.MagicFormFieldBean;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.form.service.FormCacheManager;
import com.seeyon.ctp.organization.bo.V3xOrgAccount;
import com.seeyon.ctp.organization.bo.V3xOrgMember;
import com.seeyon.ctp.organization.manager.OrgManager;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.FlipInfo;
import com.seeyon.ctp.util.ParamUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.annotation.AjaxAccess;
import com.seeyon.ctp.util.json.JSONUtil;
import com.seeyon.datamagic.engine.domain.mapping.MethodMappingConfig;
import com.seeyon.datamagic.engine.out.service.OutService;
import com.seeyon.datamagic.engine.out.service.entry.OutServiceInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;

public class MagicManagementImpl
implements IMagicManagement {
    private IMagicInterfaceDefineDao magicInterfaceDefineDao;
    private OrgManager orgManager;
    private BusinessManager businessManager4;
    private IMagicProviderDao magicProviderDao;
    private IMagicReflectionRelationDao magicReflectionRelationDao;
    private CAP4FormCacheManager cap4FormCacheManager;
    private FormCacheManager formCacheManager;
    private static Log LOGGER = CtpLogFactory.getLog(MagicManagementImpl.class);
    private static final String OTHER_CATEGORY = "123456";

    @Override
    @AjaxAccess
    public List<Map<String, Object>> loadEntryCategory(Map<String, Object> params) throws BusinessException {
        List<OutService> allOutService = CAP4MagicCacheInitializer.getAllMagicOutService();
        HashMap category = new HashMap();
        ArrayList<OutServiceInfo> allServiceInfo = new ArrayList<OutServiceInfo>();
        for (OutService os : allOutService) {
            ArrayList list = new ArrayList();
            OutServiceInfo si = os.getServiceInfo();
            if (si == null) continue;
            allServiceInfo.add(si);
            category.put(si.getIdentity(), list);
        }
        OutServiceInfo form = new OutServiceInfo();
        form.setIdentity(MagicEnums.ProviderType.DEFAULT_FORM.getType());
        form.setName("\u5e94\u7528\u5b9a\u5236\u5e73\u53f0");
        form.setSort(1);
        allServiceInfo.add(form);
        category.put(form.getIdentity(), new ArrayList());
        Collections.sort(allServiceInfo, new Comparator<OutServiceInfo>(){

            @Override
            public int compare(OutServiceInfo o1, OutServiceInfo o2) {
                return o1.getSort() - o2.getSort();
            }
        });
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        HashMap<String, String> item1 = new HashMap<String, String>();
        item1.put("name", "\u672c\u673a\u81ea\u5b9a\u4e49");
        item1.put("id", "-1");
        item1.put("parentId", "1111");
        result.add(item1);
        List<MagicInterfaceDefineEntity> allEntry = this.magicInterfaceDefineDao.loadAllEntitys();
        HashMap<Long, MagicInterfaceDefineEntity> otherEntity = new HashMap<Long, MagicInterfaceDefineEntity>();
        HashSet<Long> existsServiceBiz = new HashSet<Long>();
        for (MagicInterfaceDefineEntity e : allEntry) {
            List list = (List)category.get(e.getSubType());
            if (list != null) {
                list.add(e);
            }
            if (!MagicEnums.ProviderType.DEFAULT_FORM.getType().equals(e.getSubType())) continue;
            BizConfigBean bizConfig = this.businessManager4.findBizConfigByFormId(e.getFormId());
            if (bizConfig != null) {
                existsServiceBiz.add(bizConfig.getId());
                continue;
            }
            otherEntity.put(e.getId(), e);
        }
        HashMap<String, String> item2 = null;
        for (OutServiceInfo osi : allServiceInfo) {
            String identity = osi.getIdentity();
            List services = (List)category.get(identity);
            if (MagicEnums.ProviderType.DEFAULT_FORM.getType().equals(identity)) {
                if (services == null || services.isEmpty()) continue;
                item2 = new HashMap();
                item2.put("id", identity);
                item2.put("parentId", "-1");
                item2.put("serviceType", identity);
                item2.put("name", osi.getName());
                result.add(item2);
                List<CapBizConfig> allBizConfig = this.businessManager4.findAllBizConfig();
                for (CapBizConfig cc : allBizConfig) {
                    if (!existsServiceBiz.contains(cc.getId())) continue;
                    item2 = new HashMap();
                    V3xOrgAccount account = this.orgManager.getAccountById(cc.getOrgAccountId());
                    if (account != null) {
                        item2.put("name", cc.getName() + "(" + account.getShortName() + ")");
                    } else {
                        item2.put("name", cc.getName());
                    }
                    item2.put("id", String.valueOf(cc.getId()));
                    item2.put("parentId", identity);
                    item2.put("serviceType", identity);
                    result.add(item2);
                }
                if (otherEntity.isEmpty()) continue;
                item2 = new HashMap();
                item2.put("id", OTHER_CATEGORY);
                item2.put("parentId", identity);
                item2.put("serviceType", identity);
                item2.put("name", "\u5176\u4ed6");
                result.add(item2);
                continue;
            }
            if (services == null) continue;
            item2 = new HashMap<String, String>();
            item2.put("id", osi.getIdentity());
            item2.put("parentId", "-1");
            item2.put("serviceType", identity);
            item2.put("name", osi.getName());
            result.add(item2);
        }
        return result;
    }

    @Override
    @AjaxAccess
    public FlipInfo loadEntrysByCondition(FlipInfo infp, Map<String, Object> params) throws BusinessException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        if (infp == null) {
            infp = new FlipInfo(1, 20);
        }
        if (params == null) {
            params = new HashMap<String, Object>();
        }
        String categoryId = ParamUtil.getString(params, (String)"categoryId", (String)"0");
        String serviceType = ParamUtil.getString(params, (String)"serviceType", (String)"");
        String category = ParamUtil.getString(params, (String)"parentId", (String)"");
        HashMap<String, Object> condition = new HashMap<String, Object>();
        if (!params.isEmpty()) {
            String queryValue;
            if (Strings.isNotBlank((String)serviceType)) {
                condition.put("serviceType", serviceType);
            }
            if (MagicEnums.ProviderType.DEFAULT_FORM.getType().equals(category)) {
                List<CAPFormDefinition> formBeans = this.businessManager4.getCAP4FormByBizId(Long.parseLong(categoryId));
                ArrayList<Long> formIds = new ArrayList<Long>();
                if (!formBeans.isEmpty()) {
                    for (CAPFormDefinition f : formBeans) {
                        formIds.add(f.getId());
                    }
                    condition.put("category", -1);
                    condition.put("formId", formIds);
                }
            }
            params.remove("parentId");
            params.remove("categoryId");
            String queryType = ParamUtil.getString(params, (String)"queryType");
            if ("entryName".equals(queryType) && Strings.isNotBlank((String)(queryValue = ParamUtil.getString(params, (String)"queryValue")))) {
                condition.put("name", queryValue);
            }
        }
        List<MagicServiceProviderPO> providers = this.magicProviderDao.loadAllProviders(MagicEnums.ProviderStatus.ON);
        HashMap<String, MagicServiceProviderPO> tempMapper = new HashMap<String, MagicServiceProviderPO>();
        for (MagicServiceProviderPO p : providers) {
            tempMapper.put(p.getBusinessId() + "_" + p.getVersionId() + "_" + p.getMethodName(), p);
        }
        List<Object> entitys = Collections.emptyList();
        entitys = OTHER_CATEGORY.equals(categoryId) ? this.loadOthers(infp, condition) : this.magicInterfaceDefineDao.loadAllEntitys(infp, condition);
        HashSet<String> businessIds = new HashSet<String>();
        for (MagicInterfaceDefineEntity magicInterfaceDefineEntity : entitys) {
            businessIds.add(magicInterfaceDefineEntity.getBusinessId());
            HashMap d = new HashMap();
            d.put("id", String.valueOf(magicInterfaceDefineEntity.getId()));
            d.put("name", magicInterfaceDefineEntity.getName(AppContext.getLocale()));
            String tempkey = magicInterfaceDefineEntity.getBusinessId() + "_" + magicInterfaceDefineEntity.getVersionId() + "_" + magicInterfaceDefineEntity.getMethodName();
            MagicServiceProviderPO provider = (MagicServiceProviderPO)tempMapper.get(tempkey);
            if (provider != null) {
                FormBean fb;
                if (MagicEnums.ProviderType.DEFAULT_FORM.getType().equals(provider.getSourceType())) {
                    fb = this.cap4FormCacheManager.getForm(Long.parseLong(provider.getSource()));
                    if (fb != null) {
                        d.put("provider", "CAP." + fb.getFormName());
                        BizConfigBean fcb = this.businessManager4.findBizConfigByFormId(fb.getId());
                        if (fcb != null) {
                            d.put("businessType", fcb.getName());
                        } else {
                            d.put("businessType", "-");
                        }
                    } else {
                        d.put("provider", "-");
                        d.put("businessType", "-");
                    }
                } else if (MagicEnums.ProviderType.DEFAULT_FORM_CAP3.getType().equals(provider.getSourceType())) {
                    fb = this.formCacheManager.getForm(Long.parseLong(provider.getSource()));
                    if (fb != null) {
                        d.put("provider", "CAP." + fb.getFormName());
                    } else {
                        d.put("provider", "-");
                    }
                    d.put("businessType", "\u4e1a\u52a1\u751f\u6210\u5668");
                }
            } else {
                d.put("businessType", "-");
                d.put("provider", "-");
            }
            if (MagicEnums.BusinessMethodType.RELATION_SYS.getType() == magicInterfaceDefineEntity.getServiceType() || MagicEnums.BusinessMethodType.RELATION_USER.getType() == magicInterfaceDefineEntity.getServiceType()) {
                d.put("serviceType", "\u67e5\u8be2");
            } else {
                d.put("serviceType", "\u5199\u5165");
            }
            d.put("range", "\u79c1\u6709");
            d.put("status", "\u672a\u53d1\u5e03");
            V3xOrgMember member = this.getEntityCreater(magicInterfaceDefineEntity);
            if (member != null) {
                d.put("creater", member.getName());
            } else {
                d.put("creater", "-");
            }
            d.put("createDate", DateUtil.format((Date)magicInterfaceDefineEntity.getCreateDate(), (String)"yyyy-MM-dd HH:mm"));
            d.put("remark", "");
            data.put(tempkey, d);
        }
        List<MagicReflectionRelationPO> reflactions = this.magicReflectionRelationDao.getReflectionByBids(businessIds);
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (MagicReflectionRelationPO r : reflactions) {
            ArrayList<MethodMappingConfig> mmcList;
            String cbversion;
            String cbid;
            block31: {
                cbid = r.getCalleeBusinessId();
                cbversion = r.getCalleeVersionId();
                mmcList = new ArrayList<MethodMappingConfig>();
                try {
                    JSONUtils.parseJSonListObj_Class(r.getMappingConfig(), mmcList, MethodMappingConfig.class);
                }
                catch (ClassCastException e) {
                    MethodMappingConfig mmc = JSONUtils.parseJSonStr_Class(r.getMappingConfig(), MethodMappingConfig.class);
                    if (mmc == null) break block31;
                    mmcList.add(mmc);
                }
            }
            for (MethodMappingConfig mmc : mmcList) {
                String methodName = mmc.getMethodName();
                String tempKey = cbid + "_" + cbversion + "_" + methodName;
                Integer count = (Integer)hashMap.get(tempKey);
                if (count == null) {
                    count = 0;
                }
                count = count + 1;
                hashMap.put(tempKey, count);
            }
        }
        ArrayList<Map> datas = new ArrayList<Map>();
        for (Map.Entry entry : data.entrySet()) {
            Map entryValue = (Map)entry.getValue();
            String entryKey = (String)entry.getKey();
            Integer count = (Integer)hashMap.get(entryKey);
            entryValue.put("invokeCount", count != null ? String.valueOf(count) : "0");
            datas.add(entryValue);
        }
        infp.setData(datas);
        return infp;
    }

    private List<MagicInterfaceDefineEntity> loadOthers(FlipInfo info, Map<String, Object> condition) throws BusinessException {
        int size;
        FlipInfo infp = new FlipInfo(1, Integer.MAX_VALUE);
        List<Object> data = this.magicInterfaceDefineDao.loadAllEntitys(infp, condition);
        int page = info.getPage();
        if (page < 1) {
            page = 1;
        }
        if ((size = info.getSize()) < 1) {
            size = 20;
        }
        ArrayList<MagicInterfaceDefineEntity> result = new ArrayList<MagicInterfaceDefineEntity>();
        for (MagicInterfaceDefineEntity e : data) {
            BizConfigBean bizConfig = this.businessManager4.findBizConfigByFormId(e.getFormId());
            if (bizConfig != null) continue;
            result.add(e);
        }
        int resultSize = result.size();
        data.clear();
        int startIndex = (page - 1) * size;
        int endIndex = page * size - 1;
        if (startIndex < resultSize) {
            if (endIndex >= resultSize) {
                endIndex = resultSize;
            }
            data = result.subList(startIndex, endIndex);
        }
        info.setData(data);
        info.setTotal(resultSize);
        return data;
    }

    @Override
    @AjaxAccess
    public Map<String, Object> getAllProvider(Map<String, Object> params) throws BusinessException {
        long id = ParamUtil.getLong(params, (String)"id", (Long)0L);
        MagicInterfaceDefineEntity entity = this.magicInterfaceDefineDao.loadDefineById(id);
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (entity != null) {
            result.put("serviceId", String.valueOf(id));
            result.put("serviceName", entity.getName(AppContext.getLocale()));
            List<MagicServiceProviderPO> allProviders = this.magicProviderDao.loadProviders(entity.getBusinessId(), entity.getVersionId());
            if (allProviders != null && !allProviders.isEmpty()) {
                ArrayList providers = new ArrayList();
                for (MagicServiceProviderPO p : allProviders) {
                    FormBean fb;
                    HashMap<String, String> item = new HashMap<String, String>();
                    item.put("id", String.valueOf(p.getId()));
                    if (MagicEnums.ProviderType.DEFAULT_FORM.getType().equals(p.getSourceType())) {
                        fb = this.cap4FormCacheManager.getForm(Long.parseLong(p.getSource()));
                        if (fb != null) {
                            item.put("provider", "CAP." + fb.getFormName());
                        } else {
                            item.put("provider", "-");
                        }
                    } else if (MagicEnums.ProviderType.DEFAULT_FORM_CAP3.getType().equals(p.getSourceType())) {
                        fb = this.formCacheManager.getForm(Long.parseLong(p.getSource()));
                        if (fb != null) {
                            item.put("provider", "CAP." + fb.getFormName());
                        } else {
                            item.put("provider", "-");
                        }
                    }
                    item.put("status", String.valueOf(p.getStatus()));
                    providers.add(item);
                }
                result.put("providers", providers);
            }
        }
        return result;
    }

    @Override
    @AjaxAccess
    public Map<String, Object> switchProvider(Map<String, Object> params) throws BusinessException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", "0");
        long id = ParamUtil.getLong(params, (String)"serviceId", (Long)0L);
        long providerId = ParamUtil.getLong(params, (String)"providerId", (Long)0L);
        MagicInterfaceDefineEntity entity = this.magicInterfaceDefineDao.loadDefineById(id);
        if (entity != null) {
            MagicServiceProviderPO providers;
            if (entity.getServiceType() == MagicEnums.BusinessMethodType.TRIGGER_UPDATE.getType()) {
                List<MagicInterfaceDefineEntity> queryServices = this.magicInterfaceDefineDao.loadAllEntitys(entity.getBusinessId(), entity.getVersionId(), MagicEnums.BusinessMethodType.QUERY);
                MagicServiceProviderPO providers2 = this.magicProviderDao.getById(providerId);
                if (providers2 != null) {
                    for (MagicInterfaceDefineEntity mde : queryServices) {
                        this.magicProviderDao.deleteProvides(mde.getBusinessId(), mde.getVersionId());
                        MagicServiceProviderPO provider = new MagicServiceProviderPO();
                        provider.setBusinessId(mde.getBusinessId());
                        provider.setCreateDate(new Date());
                        provider.setCreater(Long.valueOf(AppContext.currentUserId()));
                        provider.setIdIfNew();
                        provider.setVersionId(mde.getVersionId());
                        provider.setMethodName(mde.getMethodName());
                        provider.setSource(providers2.getSource());
                        provider.setStatus(MagicEnums.ProviderStatus.ON.getType());
                        provider.setSourceType(providers2.getSourceType());
                        this.magicProviderDao.saveProvider(provider);
                    }
                }
            } else if (entity.getServiceType() == MagicEnums.BusinessMethodType.TRIGGER_DISTRIBUTE.getType() && (providers = this.magicProviderDao.getById(providerId)) != null && MagicPrivateUtils.isNumeric(providers.getSource())) {
                ArrayList<String> bid = new ArrayList<String>(1);
                bid.add(providers.getBusinessId());
                Long newTragetId = Long.parseLong(providers.getSource());
                FormBean newFormBean = this.cap4FormCacheManager.getForm(newTragetId);
                if (newFormBean != null) {
                    for (MagicReflectionRelationPO p : this.magicReflectionRelationDao.getReflectionByBids(bid)) {
                        Long oldTargetFormId;
                        FormTriggerBean triggerBean;
                        String triggerId = p.getCallingPoint().split("[_]")[0];
                        if (!MagicPrivateUtils.isNumeric(triggerId) || (triggerBean = this.cap4FormCacheManager.getFormTriggerBean(Long.parseLong(triggerId))) == null || newTragetId.equals(oldTargetFormId = Long.valueOf(triggerBean.getTargetFormId()))) continue;
                        triggerBean.setTargetFormId(newTragetId.longValue());
                        FormBean oldTargetForm = this.cap4FormCacheManager.getForm(oldTargetFormId);
                        if (oldTargetForm == null) continue;
                        oldTargetForm.removeFormTriggerSet(triggerBean.getId());
                    }
                }
                Map ext1 = (Map)JSONUtil.parseJSONString((String)entity.getExt1(), Map.class);
                String feedBackMethod = ParamUtil.getString((Map)ext1, (String)"feedback_id");
                this.magicProviderDao.deleteProvides(entity.getBusinessId(), entity.getVersionId());
                MagicServiceProviderPO provider = new MagicServiceProviderPO();
                provider.setBusinessId(entity.getBusinessId());
                provider.setCreateDate(new Date());
                provider.setCreater(Long.valueOf(AppContext.currentUserId()));
                provider.setIdIfNew();
                provider.setVersionId(entity.getVersionId());
                provider.setMethodName(feedBackMethod);
                provider.setSource(providers.getSource());
                provider.setStatus(MagicEnums.ProviderStatus.ON.getType());
                provider.setSourceType(providers.getSourceType());
                this.magicProviderDao.saveProvider(provider);
            }
            this.magicProviderDao.switchProvider(entity.getBusinessId(), entity.getVersionId(), providerId);
            result.put("success", "1");
            result.put("msg", "\u7ed1\u5b9a\u6210\u529f!");
        } else {
            result.put("msg", "\u672a\u627e\u5230\u63a5\u53e3\u5b9a\u4e49!");
        }
        return result;
    }

    @Override
    @AjaxAccess
    public Map<String, Object> handleUpdateServices(List<String> params) throws BusinessException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashSet<Long> ids = new HashSet<Long>();
        if (params != null && !params.isEmpty()) {
            for (String k : params) {
                ids.add(Long.parseLong(k));
            }
        }
        List<MagicInterfaceDefineEntity> entitys = this.getMagicInterfaceDefineDao().findByIds(ids);
        ArrayList<MagicInterfaceDefineEntity> needUpdateServices = new ArrayList<MagicInterfaceDefineEntity>();
        ArrayList<String> updateServiceNames = new ArrayList<String>();
        for (MagicInterfaceDefineEntity e : entitys) {
            MagicInterfaceDefineEntity checkAndUpdateService;
            Long formId = 0L;
            MagicEnums.ServiceOwnerType type = null;
            if (MagicEnums.ProviderType.DEFAULT_FORM_CAP3.getType().equals(e.getSubType())) {
                formId = e.getFormId();
                type = MagicEnums.ServiceOwnerType.DEFAULT_FORM_CAP3;
            } else if (MagicEnums.ProviderType.DEFAULT_FORM.getType().equals(e.getSubType())) {
                MagicServiceProviderPO provider = this.magicProviderDao.loadProviders(e.getBusinessId(), e.getVersionId(), MagicEnums.ProviderStatus.ON);
                if (provider != null && MagicPrivateUtils.isNumeric(provider.getSource())) {
                    formId = Long.parseLong(provider.getSource());
                }
                type = MagicEnums.ServiceOwnerType.DEFAULT_FORM;
            }
            if (type == null || (checkAndUpdateService = this.checkAndUpdateService(e, formId, type)) == null) continue;
            updateServiceNames.add(checkAndUpdateService.getName());
            needUpdateServices.add(checkAndUpdateService);
        }
        if (!needUpdateServices.isEmpty()) {
            this.getMagicInterfaceDefineDao().updateList(needUpdateServices);
            result.put("msg", Strings.join(updateServiceNames, (String)",") + "\u66f4\u65b0\u6210\u529f");
        } else {
            result.put("msg", "\u6240\u9009\u670d\u52a1\u6ca1\u6709\u8c03\u6574\uff0c\u4e0d\u9700\u8981\u66f4\u65b0!");
        }
        result.put("success", "1");
        return result;
    }

    private MagicInterfaceDefineEntity checkAndUpdateService(MagicInterfaceDefineEntity e, Long formId, MagicEnums.ServiceOwnerType type) {
        String ext1 = e.getExt1();
        Map ext = (Map)JSONUtil.parseJSONString((String)ext1, Map.class);
        Map fieldLimits = (Map)ext.get("fieldLimit");
        MagicFormBean mfb = new MagicFormBean(type, formId);
        if (mfb.isNull()) {
            return null;
        }
        boolean needUpdate = false;
        HashMap<String, String> newFieldLimit = new HashMap<String, String>();
        for (Map.Entry entry : fieldLimits.entrySet()) {
            String key = (String)entry.getKey();
            MagicFormFieldBean ffb = mfb.getFieldBeanByName(key);
            if (ffb == null || ffb.isNull()) {
                needUpdate = true;
                continue;
            }
            Map itemLists = (Map)JSONUtil.parseJSONString((String)entry.getValue().toString(), Map.class);
            needUpdate = this.checkFieldChange(itemLists, ffb);
            if (needUpdate) {
                Map<String, Object> limit = mfb.getFormFieldInfo(ffb, MagicEnums.BusinessMethodType.valueOfType((int)e.getServiceType()));
                limit.put("ownerTableName", ParamUtil.getString((Map)itemLists, (String)"ownerTableName"));
                newFieldLimit.put(key, JSONUtil.toJSONString(limit));
                continue;
            }
            newFieldLimit.put(key, JSONUtil.toJSONString((Object)itemLists));
        }
        if (needUpdate) {
            ext.put("fieldLimit", newFieldLimit);
            String ext11 = JSONUtil.toJSONString((Object)ext);
            e.setExt1(ext11);
            return e;
        }
        return null;
    }

    private boolean checkFieldChange(Map<String, Object> itemLists, MagicFormFieldBean ffb) {
        String inputType = ParamUtil.getString(itemLists, (String)"inputType", (String)"");
        String fieldType = ParamUtil.getString(itemLists, (String)"fieldType", (String)"");
        String ownerTableName = ParamUtil.getString(itemLists, (String)"ownerTableName", (String)"");
        String enumLevel = ParamUtil.getString(itemLists, (String)"enumLevel", (String)"");
        String isFinalChild = ParamUtil.getString(itemLists, (String)"isFinalChild", (String)"");
        String fieldLength = ParamUtil.getString(itemLists, (String)"fieldLength", (String)"");
        String digitNum = ParamUtil.getString(itemLists, (String)"digitNum", (String)"");
        String enumId = ParamUtil.getString(itemLists, (String)"value", (String)"");
        if (!(inputType.equalsIgnoreCase(ffb.getInputType()) && fieldType.equalsIgnoreCase(ffb.getFieldType()) && fieldLength.equalsIgnoreCase(ffb.getFieldLength()) && ownerTableName.equals(ffb.getOwnerTableName()))) {
            return true;
        }
        return "select".equalsIgnoreCase(inputType) || "imageselect".equalsIgnoreCase(inputType) || "radio".equalsIgnoreCase(inputType) || "imageradio".equalsIgnoreCase(inputType) ? !enumId.equals(ffb.getEnumId() + "") || !enumLevel.equals(ffb.getEnumLevel() + "") || !isFinalChild.equals(ffb.getIsFinalChild() ? "1" : "0") : "DECIMAL".equalsIgnoreCase(fieldType) && !digitNum.equals(ffb.getDigitNum());
    }

    private V3xOrgMember getEntityCreater(MagicInterfaceDefineEntity entity) {
        String ext2 = entity.getExt2();
        if (Strings.isNotBlank((String)ext2)) {
            try {
                Map extM = (Map)JSONUtil.parseJSONString((String)ext2, Map.class);
                Long id = ParamUtil.getLong((Map)extM, (String)"creater", (Long)0L);
                return this.orgManager.getMemberById(id);
            }
            catch (Exception e) {
                LOGGER.info((Object)e.getLocalizedMessage());
            }
        }
        return null;
    }

    @Override
    @AjaxAccess
    public FlipInfo showProvider(FlipInfo infp, Map<String, Object> params) throws BusinessException {
        List<MagicServiceProviderPO> providers;
        Long id = ParamUtil.getLong(params, (String)"id", (Long)0L);
        MagicInterfaceDefineEntity entity = this.magicInterfaceDefineDao.loadDefineById(id);
        if (entity != null && (providers = this.magicProviderDao.loadProviders(entity.getBusinessId(), entity.getVersionId())) != null && !providers.isEmpty()) {
            ArrayList result = new ArrayList(providers.size());
            for (MagicServiceProviderPO p : providers) {
                FormBean fb;
                String sourceType = p.getSourceType();
                HashMap<String, String> data = new HashMap<String, String>();
                if (MagicEnums.ProviderType.DEFAULT_FORM.getType().equals(sourceType)) {
                    data.put("type", "\u8868\u5355");
                    fb = this.cap4FormCacheManager.getForm(Long.parseLong(p.getSource()));
                    if (fb != null) {
                        data.put("provider", "CAP." + fb.getFormName());
                    } else {
                        data.put("provider", "-");
                    }
                } else if (MagicEnums.ProviderType.DEFAULT_DEE.getType().equals(sourceType)) {
                    data.put("type", "DEE\u4efb\u52a1");
                    data.put("provider", "-");
                } else if (MagicEnums.ProviderType.DEFAULT_FORM_CAP3.getType().equals(sourceType)) {
                    fb = this.formCacheManager.getForm(Long.parseLong(p.getSource()));
                    if (fb != null) {
                        data.put("provider", "CAP." + fb.getFormName());
                    } else {
                        data.put("provider", "-");
                    }
                    data.put("type", "\u8868\u5355");
                }
                V3xOrgMember member = this.orgManager.getMemberById(p.getCreater());
                if (member != null) {
                    data.put("creater", member.getName());
                } else {
                    data.put("creater", "-");
                }
                data.put("createDate", DateUtil.format((Date)p.getCreateDate(), (String)"yyyy-MM-dd HH:mm"));
                data.put("remark", p.getComment() == null ? "" : p.getComment());
                result.add(data);
            }
            infp.setData(result);
            infp.setTotal(result.size());
        }
        return infp;
    }

    @Override
    @AjaxAccess
    public Map<String, Object> deleteEntrys(List<String> ids) throws BusinessException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (ids != null && !ids.isEmpty()) {
            ArrayList<MagicInterfaceDefineEntity> allEntity = new ArrayList<MagicInterfaceDefineEntity>();
            ArrayList<String> businessIds = new ArrayList<String>();
            for (String id : ids) {
                try {
                    long i = Long.parseLong(id);
                    MagicInterfaceDefineEntity entity = this.magicInterfaceDefineDao.loadDefineById(i);
                    if (entity == null) continue;
                    businessIds.add(entity.getBusinessId());
                    allEntity.add(entity);
                }
                catch (Exception e) {
                    LOGGER.info((Object)e.getMessage());
                }
            }
            List<MagicReflectionRelationPO> reflactions = this.magicReflectionRelationDao.getReflectionByBids(businessIds);
            HashMap<String, Integer> invokeCount = new HashMap<String, Integer>();
            for (MagicReflectionRelationPO r : reflactions) {
                ArrayList<MethodMappingConfig> mmcList;
                String cbversion;
                String cbid;
                block14: {
                    cbid = r.getCalleeBusinessId();
                    cbversion = r.getCalleeVersionId();
                    mmcList = new ArrayList<MethodMappingConfig>();
                    try {
                        JSONUtils.parseJSonListObj_Class(r.getMappingConfig(), mmcList, MethodMappingConfig.class);
                    }
                    catch (ClassCastException e) {
                        MethodMappingConfig mmc = JSONUtils.parseJSonStr_Class(r.getMappingConfig(), MethodMappingConfig.class);
                        if (mmc == null) break block14;
                        mmcList.add(mmc);
                    }
                }
                for (MethodMappingConfig mmc : mmcList) {
                    String methodName = mmc.getMethodName();
                    String tempKey = (String)cbid + "_" + cbversion + "_" + methodName;
                    Integer count = (Integer)invokeCount.get(tempKey);
                    if (count == null) {
                        count = 0;
                    }
                    count = count + 1;
                    invokeCount.put(tempKey, count);
                }
            }
            ArrayList<MagicInterfaceDefineEntity> canDelelte = new ArrayList<MagicInterfaceDefineEntity>();
            ArrayList<MagicInterfaceDefineEntity> notDelelte = new ArrayList<MagicInterfaceDefineEntity>();
            for (MagicInterfaceDefineEntity e : allEntity) {
                Integer count = (Integer)invokeCount.get(e.getBusinessId() + "_" + e.getVersionId() + "_" + e.getMethodName());
                if (count == null || count == 0) {
                    canDelelte.add(e);
                    this.magicProviderDao.deleteProvides(e.getBusinessId(), e.getVersionId());
                    continue;
                }
                notDelelte.add(e);
            }
            this.magicInterfaceDefineDao.delete(canDelelte);
            if (!notDelelte.isEmpty()) {
                ArrayList<String> names = new ArrayList<String>(notDelelte.size());
                for (MagicInterfaceDefineEntity es : notDelelte) {
                    names.add(es.getName(AppContext.getLocale()));
                }
                result.put("msg", Strings.join(names, (String)",") + "\u5df2\u88ab\u4f7f\u7528,\u4e0d\u80fd\u5220\u9664\uff01");
            } else {
                result.put("msg", "\u5220\u9664\u6210\u529f!");
                result.put("success", "1");
            }
        }
        return result;
    }

    public IMagicInterfaceDefineDao getMagicInterfaceDefineDao() {
        return this.magicInterfaceDefineDao;
    }

    public void setMagicInterfaceDefineDao(IMagicInterfaceDefineDao magicInterfaceDefineDao) {
        this.magicInterfaceDefineDao = magicInterfaceDefineDao;
    }

    public OrgManager getOrgManager() {
        return this.orgManager;
    }

    public void setOrgManager(OrgManager orgManager) {
        this.orgManager = orgManager;
    }

    public BusinessManager getBusinessManager4() {
        return this.businessManager4;
    }

    public void setBusinessManager4(BusinessManager businessManager4) {
        this.businessManager4 = businessManager4;
    }

    public IMagicProviderDao getMagicProviderDao() {
        return this.magicProviderDao;
    }

    public void setMagicProviderDao(IMagicProviderDao magicProviderDao) {
        this.magicProviderDao = magicProviderDao;
    }

    public IMagicReflectionRelationDao getMagicReflectionRelationDao() {
        return this.magicReflectionRelationDao;
    }

    public void setMagicReflectionRelationDao(IMagicReflectionRelationDao magicReflectionRelationDao) {
        this.magicReflectionRelationDao = magicReflectionRelationDao;
    }

    public CAP4FormCacheManager getCap4FormCacheManager() {
        return this.cap4FormCacheManager;
    }

    public void setCap4FormCacheManager(CAP4FormCacheManager cap4FormCacheManager) {
        this.cap4FormCacheManager = cap4FormCacheManager;
    }

    public FormCacheManager getFormCacheManager() {
        return this.formCacheManager;
    }

    public void setFormCacheManager(FormCacheManager formCacheManager) {
        this.formCacheManager = formCacheManager;
    }
}

