/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.magic.manager.impl;

import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormFieldComEnum;
import com.seeyon.cap4.form.bean.FormRelationshipBean;
import com.seeyon.cap4.form.bean.FormRelationshipMapBean;
import com.seeyon.cap4.form.bean.FormTableBean;
import com.seeyon.cap4.form.bean.FormTriggerActionBean;
import com.seeyon.cap4.form.bean.FormTriggerBean;
import com.seeyon.cap4.form.modules.business.BizConfigBean;
import com.seeyon.cap4.form.modules.business.BusinessManager;
import com.seeyon.cap4.form.modules.engin.relation.FormRelationEnums;
import com.seeyon.cap4.form.modules.importandexport.BusinessDataBean;
import com.seeyon.cap4.form.service.CAP4FormCacheManager;
import com.seeyon.cap4.magic.business.create.utils.MagicCreateServiceUtils;
import com.seeyon.cap4.magic.business.update.IMagicServiceUpdate;
import com.seeyon.cap4.magic.business.update.MagicUpdateServiceUtils;
import com.seeyon.cap4.magic.dao.IMagicInterfaceDefineDao;
import com.seeyon.cap4.magic.dao.IMagicProviderDao;
import com.seeyon.cap4.magic.dao.IMagicReflectionRelationDao;
import com.seeyon.cap4.magic.dao.IMagicServiceSummaryDao;
import com.seeyon.cap4.magic.initializer.CAP4MagicCacheInitializer;
import com.seeyon.cap4.magic.manager.ICAP4MagicManager;
import com.seeyon.cap4.magic.po.MagicInterfaceDefineEntity;
import com.seeyon.cap4.magic.po.MagicReflectionRelationPO;
import com.seeyon.cap4.magic.po.MagicServiceProviderPO;
import com.seeyon.cap4.magic.po.MagicServiceSummary;
import com.seeyon.cap4.magic.utils.JSONUtils;
import com.seeyon.cap4.magic.utils.MagicPrivateUtils;
import com.seeyon.cap4.magic.vo.DataRightEntity;
import com.seeyon.cap4.magic.vo.MagicEnums;
import com.seeyon.cap4.magic.vo.MagicFormBean;
import com.seeyon.cap4.magic.vo.MagicImportResult;
import com.seeyon.cap4.magic.vo.MagicServiceDetail;
import com.seeyon.cap4.magic.vo.RightAnnotationEntity;
import com.seeyon.ctp.cap.api.manager.CAPFormManager;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.constants.ApplicationCategoryEnum;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.report.engine.api.manager.ReportApi;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.ParamUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.UUIDLong;
import com.seeyon.ctp.util.json.JSONUtil;
import com.seeyon.datamagic.engine.domain.base.MagicDisplay;
import com.seeyon.datamagic.engine.domain.config.ResultConfigGuide;
import com.seeyon.datamagic.engine.domain.mapping.MethodMappingConfig;
import com.seeyon.datamagic.engine.domain.metadata.MetadataConfig;
import com.seeyon.datamagic.engine.domain.service.ServiceConfig;
import com.seeyon.datamagic.engine.domain.service.ServiceMethodConfig;
import com.seeyon.datamagic.engine.utils.PrivateUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.jgroups.util.UUID;

public class CAP4MagicManagerImpl
implements ICAP4MagicManager {
    private IMagicInterfaceDefineDao magicInterfaceDefineDao;
    private IMagicReflectionRelationDao magicReflectionRelationDao;
    private CAP4FormCacheManager cap4FormCacheManager;
    private BusinessManager businessManager4;
    private IMagicProviderDao magicProviderDao;
    private IMagicServiceSummaryDao magicServiceSummaryDao;
    private CAPFormManager capFormManager;
    private ReportApi reportApi;
    private static final Log LOGGER = CtpLogFactory.getLog(CAP4MagicManagerImpl.class);

    @Override
    public MagicServiceDetail getServiceDetailById(String id) throws BusinessException {
        MagicInterfaceDefineEntity data = this.magicInterfaceDefineDao.loadDefineById(Long.valueOf(id));
        if (data == null) {
            return null;
        }
        return MagicPrivateUtils.convert(this.magicServiceSummaryDao.loadServiceInfo(data.getBusinessId(), data.getVersionId()), data);
    }

    @Override
    public List<MagicReflectionRelationPO> importMagicMappings(List<Map<String, Object>> list, BusinessDataBean businessDataBean) throws BusinessException {
        if (list != null && !list.isEmpty()) {
            Map old2NewIdMap = businessDataBean.getOld2NewIdMap();
            ArrayList<MagicReflectionRelationPO> entrys = new ArrayList<MagicReflectionRelationPO>(list.size());
            for (Map<String, Object> sm : list) {
                MagicReflectionRelationPO po = new MagicReflectionRelationPO();
                po.setIdIfNew();
                Long oldFormId = ParamUtil.getLong(sm, (String)"formId", (Long)0L);
                Long newFomrId = (Long)old2NewIdMap.get(oldFormId);
                po.setFormId(newFomrId == null ? 0L : newFomrId);
                String callingPoint = ParamUtil.getString(sm, (String)"callingPoint", (String)"0_0");
                String[] pointArray = callingPoint.split("[_]");
                po.setCallingType(ParamUtil.getInt(sm, (String)"callingType", (int)0).intValue());
                FormBean sourceForm = null;
                if (pointArray.length < 2) {
                    po.setCallingPoint(callingPoint);
                } else {
                    Long newShipId;
                    Long oldShipId;
                    ArrayList<String> pointList = new ArrayList<String>(Arrays.asList(pointArray));
                    pointList.remove(1);
                    pointList.remove(0);
                    if (!MagicPrivateUtils.isNumeric(pointArray[1])) {
                        oldShipId = Long.parseLong(pointArray[0]);
                        newShipId = (Long)old2NewIdMap.get(oldShipId);
                        po.setCallingPoint(callingPoint.replace(String.valueOf(oldShipId), String.valueOf(newShipId)));
                    } else {
                        oldShipId = Long.parseLong(pointArray[0]);
                        newShipId = (Long)old2NewIdMap.get(oldShipId);
                        oldShipId = Long.parseLong(pointArray[1]);
                        Long newActionId = (Long)old2NewIdMap.get(oldShipId);
                        sourceForm = this.getNewSourceFormByRelationId(newShipId, businessDataBean);
                        po.setCallingPoint(newShipId + "_" + newActionId + Strings.join(pointList, (String)"_"));
                    }
                }
                po.setStatus(ParamUtil.getInt(sm, (String)"status", (int)0).intValue());
                po.setDynamicInvokeToken(ParamUtil.getString(sm, (String)"dynamicInvokeToken"));
                po.setBusinessId(ParamUtil.getString(sm, (String)"businessId"));
                po.setVersionId(ParamUtil.getString(sm, (String)"versionId"));
                po.setCalleeBusinessId(ParamUtil.getString(sm, (String)"calleeBusinessId"));
                po.setCalleeVersionId(ParamUtil.getString(sm, (String)"calleeVersionId"));
                String mappingConfig = ParamUtil.getString(sm, (String)"mappingConfig");
                if (sourceForm != null) {
                    po.setFormId(sourceForm.getId().longValue());
                    List subTables = sourceForm.getSubTableBean();
                    for (FormTableBean t : subTables) {
                        String oldTableName = null;
                        String newTableName = t.getTableName();
                        Map oldAndNewStringMap = businessDataBean.getOldAndNewStringMap();
                        for (Map.Entry k : oldAndNewStringMap.entrySet()) {
                            if (!newTableName.equals(k.getValue())) continue;
                            oldTableName = (String)k.getKey();
                            break;
                        }
                        if (!Strings.isNotBlank(oldTableName) || !mappingConfig.contains(oldTableName)) continue;
                        mappingConfig = mappingConfig.replaceAll(oldTableName, newTableName);
                    }
                }
                po.setMappingConfig(mappingConfig);
                po.setInvokeSort(ParamUtil.getInt(sm, (String)"invokeSort", (int)0).intValue());
                po.setCreateDate(new Date());
                po.setIdentifier(PrivateUtils.generateMD5((String)UUID.randomUUID().toString()));
                entrys.add(po);
            }
            return entrys;
        }
        return Collections.emptyList();
    }

    public FormBean getNewSourceFormByRelationId(Long shipOrTriggerId, BusinessDataBean businessDataBean) {
        long formId = 0L;
        List ships = businessDataBean.getRelationshipBeanList();
        for (FormRelationshipBean s : ships) {
            if (!s.getId().equals(shipOrTriggerId)) continue;
            formId = s.getSourceFormId();
            break;
        }
        List triggers = businessDataBean.getTriggerBeanList();
        for (FormTriggerBean ft : triggers) {
            if (!ft.getId().equals(shipOrTriggerId)) continue;
            formId = ft.getSourceFormId();
            break;
        }
        return this.cap4FormCacheManager.getForm(formId);
    }

    @Override
    public Map<String, List<MagicInterfaceDefineEntity>> getServicesEntryByMapping(List<MagicReflectionRelationPO> relations) throws BusinessException {
        List<MagicInterfaceDefineEntity> list = this.getMagicInterfaceDefineDao().loadAllEntitys();
        HashMap<String, MagicInterfaceDefineEntity> mapper = new HashMap<String, MagicInterfaceDefineEntity>();
        for (MagicInterfaceDefineEntity e : list) {
            mapper.put(e.getBusinessId() + "_" + e.getVersionId() + "_" + e.getMethodName(), e);
        }
        HashMap<String, List<MagicInterfaceDefineEntity>> usedEntry = new HashMap<String, List<MagicInterfaceDefineEntity>>();
        for (MagicReflectionRelationPO po : relations) {
            ArrayList mmcList = new ArrayList();
            JSONUtils.parseJSonListObj_Class(po.getMappingConfig(), mmcList, MethodMappingConfig.class);
            for (MethodMappingConfig mmc : mmcList) {
                MagicInterfaceDefineEntity temp = (MagicInterfaceDefineEntity)mapper.get(po.getCalleeBusinessId() + "_" + po.getCalleeVersionId() + "_" + mmc.getMethodName());
                if (temp == null) continue;
                ArrayList<MagicInterfaceDefineEntity> temp1 = (ArrayList<MagicInterfaceDefineEntity>)usedEntry.get(temp.getBusinessId() + "_" + temp.getVersionId());
                if (temp1 == null) {
                    temp1 = new ArrayList<MagicInterfaceDefineEntity>();
                    usedEntry.put(temp.getBusinessId() + "_" + temp.getVersionId(), temp1);
                }
                temp1.add(temp);
            }
        }
        return usedEntry;
    }

    @Override
    public MagicInterfaceDefineEntity getServiceEntryByCallPoint(String point, MagicEnums.BusinessMethodType st) throws BusinessException {
        List<MagicReflectionRelationPO> pos = this.magicReflectionRelationDao.getReflectionRelationByCallPoint(point);
        if (pos != null && !pos.isEmpty()) {
            MagicReflectionRelationPO po = pos.get(0);
            ArrayList mmcList = new ArrayList();
            JSONUtils.parseJSonListObj_Class(po.getMappingConfig(), mmcList, MethodMappingConfig.class);
            for (MethodMappingConfig m : mmcList) {
                MagicInterfaceDefineEntity entity = this.magicInterfaceDefineDao.loadDefineById(po.getCalleeBusinessId(), po.getCalleeVersionId(), m.getMethodName());
                if (entity == null) continue;
                return entity;
            }
        }
        return null;
    }

    @Override
    public List<ServiceConfig> getAllServicesByBizId(Long bizId, Map<String, Object> otherParams) throws BusinessException {
        if (bizId == null) {
            return Collections.emptyList();
        }
        ArrayList<ServiceConfig> result = new ArrayList<ServiceConfig>();
        List<FormBean> allFormBean = this.businessManager4.getFormBeanListByBizId(bizId);
        ArrayList<String> ownerId = new ArrayList<String>(allFormBean.size());
        for (FormBean fb : allFormBean) {
            ownerId.add(String.valueOf(fb.getId()));
        }
        HashMap<String, String> parms = new HashMap<String, String>();
        parms.put("categoryId", String.valueOf(bizId));
        parms.put("category", ApplicationCategoryEnum.cap4biz.name());
        List designData = this.reportApi.findDesignWithoutAuth(parms);
        for (Map d : designData) {
            String id = ParamUtil.getString((Map)d, (String)"designId", (String)"");
            ownerId.add(id);
        }
        ownerId.add(String.valueOf(bizId));
        HashMap<String, Object> condition = new HashMap<String, Object>();
        condition.put("ownerId", ownerId);
        List<MagicServiceSummary> serviceSummaries = this.magicServiceSummaryDao.findServices(condition, null);
        for (MagicServiceSummary mss : serviceSummaries) {
            List<MagicInterfaceDefineEntity> data = this.magicInterfaceDefineDao.loadAllEntitys(mss.getBusinessId(), mss.getBusinessVersion());
            ServiceConfig scc = MagicPrivateUtils.mergeInterface2Configs(mss, data, null);
            result.add(scc);
        }
        return result;
    }

    @Override
    public List<ServiceConfig> convertEntrys(Map<String, List<MagicInterfaceDefineEntity>> relations) throws BusinessException {
        if (relations == null || relations.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ServiceConfig> result = new ArrayList<ServiceConfig>();
        for (Map.Entry<String, List<MagicInterfaceDefineEntity>> resultEntry : relations.entrySet()) {
            String[] key = resultEntry.getKey().split("[_]");
            List<MagicInterfaceDefineEntity> data = resultEntry.getValue();
            if (data == null || data.isEmpty()) continue;
            MagicServiceSummary serviceSummary = this.magicServiceSummaryDao.loadServiceInfo(key[0], key[1]);
            ServiceConfig scc = MagicPrivateUtils.mergeInterface2Configs(serviceSummary, data, null);
            result.add(scc);
        }
        return result;
    }

    @Deprecated
    private void importProviderService(List<ServiceConfig> providerList, Map<String, Object> providerEntryFormRelation, BusinessDataBean businessDataBean, Map<String, Object> providerEntryLimit, MagicImportResult result, Map<String, String> allMethodName) throws BusinessException {
        MagicInterfaceDefineEntity e = null;
        for (ServiceConfig sc : providerList) {
            String bid = sc.getBusinessId();
            String version = sc.getVersion();
            Long exportFormId = ParamUtil.getLong(providerEntryFormRelation, (String)bid, (Long)0L);
            Long formId = businessDataBean.getNewIdByOldId(exportFormId);
            if (formId == null) {
                formId = 0L;
            }
            MagicFormBean targetFormBean = new MagicFormBean(MagicEnums.ServiceOwnerType.DEFAULT_FORM, formId);
            String name = "";
            List methodConfigs = sc.getMethodConfig();
            HashMap<String, MetadataConfig> allMedataDataConfig = new HashMap<String, MetadataConfig>();
            HashMap<String, Map<String, Object>> providerMapping = new HashMap<String, Map<String, Object>>();
            for (ServiceMethodConfig mc : methodConfigs) {
                String ext1;
                Object subType;
                FormBean fb;
                MagicInterfaceDefineEntity checkExist = this.magicInterfaceDefineDao.loadDefineById(bid, version, mc.getMethodName());
                Long id = UUIDLong.longUUID();
                if (checkExist != null) {
                    id = checkExist.getId();
                    result.addProviderExists(checkExist);
                }
                e = new MagicInterfaceDefineEntity();
                e.setId(id);
                e.setBusinessId(sc.getBusinessId());
                e.setVersionId(version);
                e.setCategory(-1);
                e.setCreateDate(new Date());
                if (sc.getDes() != null && !sc.getDes().isEmpty()) {
                    e.setDescription(((MagicDisplay)sc.getDes().get(0)).getText());
                }
                name = (fb = this.cap4FormCacheManager.getForm(formId)) != null ? fb.getFormName() + bid.substring(4, 9) : bid;
                e.setMethodName(mc.getMethodName());
                e.setName(allMethodName.get(bid + "_" + version + "_" + mc.getMethodName()));
                String serviceType = mc.getServiceType();
                if (MagicPrivateUtils.isNumeric(serviceType)) {
                    e.setServiceType(Integer.valueOf(serviceType).intValue());
                }
                if ((subType = mc.getOtherAttr("serviceSubType")) != null) {
                    e.setSubType(subType.toString());
                }
                e.setArgsConfig(JSONUtils.getJSonString(mc.getArgsConfig()));
                e.setMetadataConfig(JSONUtils.getJSonString(sc.getMetadata().getMetadatas()));
                e.setResultConfig(JSONUtils.getJSonString(mc.getReturnConfig()));
                if (Strings.isBlank((String)e.getSubType()) || MagicEnums.ProviderType.DEFAULT_FORM.getType().equals(e.getSubType())) {
                    if (checkExist != null) {
                        Long oldFormId = checkExist.getFormId();
                        FormBean formb = this.cap4FormCacheManager.getForm(oldFormId);
                        if (formb == null) {
                            String ext12;
                            e.setFormId(formId.longValue());
                            if (providerEntryLimit != null && Strings.isNotBlank((String)(ext12 = ParamUtil.getString(providerEntryLimit, (String)mc.getMethodName())))) {
                                e.setExt1(MagicCreateServiceUtils.updateFieldLimit(ext12, fb));
                            }
                        } else {
                            e.setFormId(oldFormId.longValue());
                            e.setExt1(checkExist.getExt1());
                        }
                    } else if (providerEntryLimit != null && Strings.isNotBlank((String)(ext1 = ParamUtil.getString(providerEntryLimit, (String)mc.getMethodName())))) {
                        e.setExt1(MagicCreateServiceUtils.updateFieldLimit(ext1, fb));
                    }
                }
                e.setFormId(formId.longValue());
                if (providerEntryLimit != null && Strings.isNotBlank((String)(ext1 = ParamUtil.getString(providerEntryLimit, (String)mc.getMethodName())))) {
                    e.setExt1(ext1);
                }
                if (checkExist != null) {
                    e.setExt3(checkExist.getExt3());
                }
                e.setExt2(MagicPrivateUtils.setExt2Info());
                MagicUpdateServiceUtils.updateEntity(e, CAP4MagicCacheInitializer.getLatestUpdateVersion(), allMedataDataConfig);
                this.magicInterfaceDefineDao.saveEntityInCache(e);
                result.addProviderNew(e);
                Map<String, Object> methodM = this.importSetServiceProvider(e, businessDataBean, targetFormBean);
                if (methodM.isEmpty()) continue;
                providerMapping.put(e.getMethodName(), methodM);
            }
            MagicServiceSummary serviceSummary = this.magicServiceSummaryDao.loadServiceInfo(sc.getBusinessId(), sc.getVersion());
            if (serviceSummary == null) {
                serviceSummary = this.setSummary(formId, bid, name, version, allMedataDataConfig);
                result.addNewServiceSummary(serviceSummary);
            } else {
                ArrayList existsMetadata = new ArrayList();
                if (Strings.isNotBlank((String)serviceSummary.getMetadata())) {
                    JSONUtils.parseJSonListObj_Class(serviceSummary.getMetadata(), existsMetadata, MetadataConfig.class);
                }
                for (MetadataConfig mc : existsMetadata) {
                    allMedataDataConfig.put(mc.getObjName(), mc);
                }
                existsMetadata.clear();
                existsMetadata.addAll(allMedataDataConfig.values());
                serviceSummary.setMetadata(JSONUtils.getJSonString(existsMetadata));
                if (MagicEnums.ServiceOwnerType.DEFAULT_FORM_CAP3.getType().equals(serviceSummary.getOwnerType()) || MagicEnums.ServiceOwnerType.DEFAULT_FORM.getType().equals(serviceSummary.getOwnerType())) {
                    MagicEnums.ServiceOwnerType serviceOwnerType = MagicEnums.ServiceOwnerType.getEnumByType((String)serviceSummary.getOwnerType());
                    if (MagicPrivateUtils.isNumeric(serviceSummary.getOwner())) {
                        MagicFormBean magicFormBean = new MagicFormBean(serviceOwnerType, Long.parseLong(serviceSummary.getOwner()));
                        if (magicFormBean.isNull()) {
                            serviceSummary.setOwner(String.valueOf(formId));
                            serviceSummary.setNameDisplay(name);
                        }
                    } else {
                        Long newId = businessDataBean.genNewIdByOldId(Long.valueOf(Long.parseLong(MagicPrivateUtils.isNumeric(sc.getOwner()) ? sc.getOwner() : "0")));
                        if (newId != null) {
                            serviceSummary.setOwner(String.valueOf(newId));
                        }
                    }
                }
                result.addExistsServiceSummary(serviceSummary);
                result.addNewServiceSummary(serviceSummary);
            }
            if (targetFormBean.isNull()) continue;
            List<MagicServiceProviderPO> allServiceProviders = this.magicProviderDao.loadProviders(bid, version, String.valueOf(formId), MagicEnums.ServiceOwnerType.DEFAULT_FORM.getType());
            if (allServiceProviders != null && !allServiceProviders.isEmpty()) {
                for (MagicServiceProviderPO p : allServiceProviders) {
                    List extMapper = JSONUtils.parseJSonStr_Class(p.getExt1(), List.class);
                    extMapper.addAll(providerMapping.values());
                    p.setExt1(JSONUtils.getJSonString(extMapper));
                    result.addExistsProvierCache(p);
                    result.addNewProvierCache(p);
                }
                continue;
            }
            ArrayList extMapper = new ArrayList();
            extMapper.addAll(providerMapping.values());
            MagicServiceProviderPO po = new MagicServiceProviderPO();
            po.setIdIfNew();
            po.setDisplayName(targetFormBean.getFormName());
            po.setBusinessId(bid);
            po.setSourceType(targetFormBean.getType().getType());
            po.setSource(String.valueOf(targetFormBean.getId()));
            po.setStatus(MagicEnums.ProviderStatus.ON.getType());
            po.setExt1(JSONUtils.getJSonString(extMapper));
            po.setVersionId(version);
            po.setCreater(Long.valueOf(AppContext.currentUserId()));
            po.setCreateDate(DateUtil.currentDate());
            result.addNewProvierCache(po);
        }
    }

    public MagicServiceSummary setSummary(Long formId, String bid, String name, String version, Map<String, MetadataConfig> allMedataDataConfig) {
        MagicServiceSummary serviceSummary = new MagicServiceSummary();
        serviceSummary.setIdIfNew();
        serviceSummary.setCreateId(Long.valueOf(AppContext.currentUserId()));
        serviceSummary.setCreateDate(DateUtil.currentDate());
        serviceSummary.setAuthorizationType(Integer.valueOf(1));
        serviceSummary.setBusinessType(MagicEnums.BusinessType.INTERNAL_BUSINESS.getKey());
        serviceSummary.setOwnerType(MagicEnums.ServiceOwnerType.DEFAULT_FORM.getType());
        serviceSummary.setOwner(String.valueOf(formId));
        serviceSummary.setMetadata(JSONUtils.getJSonString(allMedataDataConfig.values()));
        serviceSummary.setCertificateType(Integer.valueOf(MagicEnums.CertificateType.Private_certificate.getKey()));
        serviceSummary.setBusinessId(bid);
        serviceSummary.setBusinessVersion(version);
        serviceSummary.setNameDisplay(name);
        return serviceSummary;
    }

    private void updateOldImportServices(List<MagicInterfaceDefineEntity> entitys) {
        try {
            Map allUpdateServices = AppContext.getBeansOfType(IMagicServiceUpdate.class);
            TreeMap<Integer, IMagicServiceUpdate> sortUpdate = new TreeMap<Integer, IMagicServiceUpdate>();
            int updateSort = 0;
            for (IMagicServiceUpdate su : allUpdateServices.values()) {
                if (su.updateSort() > updateSort) {
                    updateSort = su.updateSort();
                }
                sortUpdate.put(su.updateSort(), su);
            }
            List<MagicInterfaceDefineEntity> needUpdate = null;
            updateSort = 0;
            for (IMagicServiceUpdate su : sortUpdate.values()) {
                needUpdate = su.update(entitys, updateSort);
                updateSort = su.updateSort();
            }
        }
        catch (BusinessException businessException) {
            // empty catch block
        }
    }

    private String updateFieldLimit(String oldLimit, BusinessDataBean businessDataBean) {
        if (oldLimit == null) {
            return oldLimit;
        }
        Map limitMap = (Map)JSONUtil.parseJSONString((String)oldLimit, Map.class);
        Map fieldLimit = (Map)limitMap.get("fieldLimit");
        if (fieldLimit == null || fieldLimit.isEmpty()) {
            return oldLimit;
        }
        ArrayList<String> enumInputTypes = new ArrayList<String>();
        enumInputTypes.add(FormFieldComEnum.SELECT.getKey());
        enumInputTypes.add(FormFieldComEnum.IMAGE_SELECT.getKey());
        enumInputTypes.add(FormFieldComEnum.RADIO.getKey());
        enumInputTypes.add(FormFieldComEnum.IMAGE_RADIO.getKey());
        HashMap<String, Map> newFieldLimit = new HashMap<String, Map>();
        for (Map.Entry entry : fieldLimit.entrySet()) {
            String key = (String)entry.getKey();
            Map value = (Map)JSONUtil.parseJSONString((String)entry.getValue().toString(), Map.class);
            if (value != null && enumInputTypes.contains(value.get("inputType"))) {
                String newValue;
                String oldValue = ParamUtil.getString((Map)value, (String)"value", (String)"0");
                if (businessDataBean.isUpgrade()) {
                    oldValue = String.valueOf(businessDataBean.getRealId4Upgrade(Long.valueOf(Long.parseLong(oldValue))));
                }
                if ((newValue = (String)businessDataBean.getEnumMapOld2New().get(oldValue)) != null) {
                    value.put("value", newValue);
                }
            }
            newFieldLimit.put(key, value);
        }
        limitMap.put("fieldLimit", newFieldLimit);
        return JSONUtil.toJSONString((Object)limitMap);
    }

    private boolean checkProviderIsOn(List<MagicServiceProviderPO> providers) {
        boolean result = false;
        for (MagicServiceProviderPO p : providers) {
            if (p.getStatus() != MagicEnums.ProviderStatus.ON.getType()) continue;
            return true;
        }
        return result;
    }

    private List<MagicServiceProviderPO> checkProviders(List<MagicServiceProviderPO> providers) throws BusinessException {
        ArrayList<MagicServiceProviderPO> result = new ArrayList<MagicServiceProviderPO>();
        ArrayList<MagicServiceProviderPO> deleteList = new ArrayList<MagicServiceProviderPO>();
        for (MagicServiceProviderPO p : providers) {
            if (!MagicEnums.ProviderType.DEFAULT_FORM.getType().equals(p.getSourceType())) continue;
            String sourceId = p.getSource();
            if (Strings.isNotBlank((String)sourceId) && MagicPrivateUtils.isNumeric(sourceId)) {
                FormBean fb = this.cap4FormCacheManager.getForm(Long.parseLong(sourceId));
                if (fb == null) {
                    deleteList.add(p);
                    continue;
                }
                result.add(p);
                continue;
            }
            deleteList.add(p);
        }
        if (!deleteList.isEmpty()) {
            this.magicProviderDao.deleteProvides(deleteList);
        }
        return result;
    }

    private Map<String, Object> importSetServiceProvider(MagicInterfaceDefineEntity entity, BusinessDataBean businessDataBean, MagicFormBean formBean) throws BusinessException {
        HashMap ext1 = new HashMap();
        Map<String, Object> result = new HashMap<String, Object>();
        String entryExt1 = entity.getExt1();
        try {
            if (Strings.isNotBlank((String)entryExt1)) {
                String newTableName;
                HashMap<String, String> tableNameMapping;
                Map ext = (Map)JSONUtil.parseJSONString((String)entryExt1, Map.class);
                String anno = ParamUtil.getString((Map)ext, (String)"dataRight");
                if (anno != null) {
                    Long newRightId;
                    Long newViewId;
                    String rightId;
                    String viewId;
                    DataRightEntity right = JSONUtils.parseJSonStr_Class(anno, DataRightEntity.class);
                    HashMap<String, String> rightMapping = new HashMap<String, String>();
                    List<RightAnnotationEntity> rights = right.getPcRights();
                    for (RightAnnotationEntity r : rights) {
                        viewId = r.getViewId();
                        rightId = r.getRightId();
                        newViewId = businessDataBean.getNewIdByOldId(Long.valueOf(Long.parseLong(viewId)));
                        newRightId = businessDataBean.getNewIdByOldId(Long.valueOf(Long.parseLong(rightId)));
                        if (newViewId == null || newRightId == null) continue;
                        rightMapping.put(viewId + "." + rightId, newViewId + "." + newRightId);
                    }
                    rights = right.getPhoneRights();
                    for (RightAnnotationEntity r : rights) {
                        viewId = r.getViewId();
                        rightId = r.getRightId();
                        newViewId = businessDataBean.getNewIdByOldId(Long.valueOf(Long.parseLong(viewId)));
                        newRightId = businessDataBean.getNewIdByOldId(Long.valueOf(Long.parseLong(rightId)));
                        if (newViewId == null || newRightId == null) continue;
                        rightMapping.put(viewId + "." + rightId, newViewId + "." + newRightId);
                    }
                    ext1.put("dataRight", rightMapping);
                }
                if ((anno = ParamUtil.getString((Map)ext, (String)"templates")) != null) {
                    List template = (List)JSONUtil.parseJSONString((String)anno, List.class);
                    HashMap<String, String> templateMapping = new HashMap<String, String>();
                    for (Map k : template) {
                        String id = k.get("id").toString();
                        Long newTemplateId = businessDataBean.getNewIdByOldId(Long.valueOf(Long.parseLong(id)));
                        if (newTemplateId == null) continue;
                        templateMapping.put(id, String.valueOf(newTemplateId));
                    }
                    ext1.put("templates", templateMapping);
                }
                if ((anno = ParamUtil.getString((Map)ext, (String)"tableName")) != null) {
                    Map tableMapping = (Map)JSONUtil.parseJSONString((String)anno, Map.class);
                    tableNameMapping = new HashMap();
                    Set keySet = tableMapping.keySet();
                    for (String k : keySet) {
                        newTableName = businessDataBean.getOldAndNewStringMap(k);
                        if (!Strings.isNotBlank((String)newTableName)) continue;
                        tableNameMapping.put(k, newTableName);
                    }
                    ext1.put("tableName", tableNameMapping);
                } else {
                    Map oldAndNewString = businessDataBean.getOldAndNewStringMap();
                    tableNameMapping = new HashMap<String, String>();
                    List formTableName = formBean.getCap4FormBean().getTableList();
                    for (FormTableBean ftb : formTableName) {
                        newTableName = ftb.getTableName();
                        for (Map.Entry entry : oldAndNewString.entrySet()) {
                            if (!((String)entry.getValue()).equals(newTableName)) continue;
                            tableNameMapping.put((String)entry.getKey(), newTableName);
                        }
                    }
                    ext1.put("tableName", tableNameMapping);
                }
                result = MagicUpdateServiceUtils.updateProviderMappingSet(entity, formBean, ext1);
            }
        }
        catch (Exception e) {
            LOGGER.warn((Object)e);
        }
        return result;
    }

    private MagicServiceSummary initSummaryForImport(ServiceConfig sc, BusinessDataBean businessDataBean) throws BusinessException {
        MagicEnums.ServiceOwnerType sot;
        MagicServiceSummary mss = MagicCreateServiceUtils.convertServiceToPo(sc);
        mss.setIdIfNew();
        if (sc.getOtherAttrs() != null) {
            Map authInfo = (Map)sc.getOtherAttrs().get("authInfo");
            if (authInfo != null && !authInfo.isEmpty()) {
                String authType = ParamUtil.getString((Map)authInfo, (String)"authType", (String)"");
                if (MagicEnums.ServiceAuthType.USERDEFINED.getName().equals(authType)) {
                    mss.setAuthorizationType(Integer.valueOf(MagicEnums.ServiceAuthType.USERDEFINED.getKey()));
                    List oldBizInfos = (List)authInfo.get("authInfo");
                    if (oldBizInfos != null) {
                        ArrayList newBizInfos = new ArrayList();
                        for (Map s : oldBizInfos) {
                            Long id = ParamUtil.getLong((Map)s, (String)"value", (Long)0L);
                            BizConfigBean existsBiz = this.businessManager4.findBizConfigById(id);
                            if (existsBiz != null) {
                                HashMap<String, String> newAuth = new HashMap<String, String>();
                                newAuth.putAll(s);
                                newAuth.put("name", existsBiz.getName());
                                newBizInfos.add(newAuth);
                                continue;
                            }
                            Long newId = businessDataBean.getNewIdByOldId(id);
                            if (newId == null) continue;
                            HashMap<String, String> newAuth = new HashMap<String, String>();
                            newAuth.putAll(s);
                            newAuth.put("value", String.valueOf(newId));
                            newBizInfos.add(newAuth);
                        }
                        mss.setAuthorizationInfo(JSONUtils.getJSonString(newBizInfos));
                    }
                } else if (MagicEnums.ServiceAuthType.PUBLIC.getName().equals(authType)) {
                    mss.setAuthorizationType(Integer.valueOf(MagicEnums.ServiceAuthType.PUBLIC.getKey()));
                } else {
                    mss.setAuthorizationType(Integer.valueOf(MagicEnums.ServiceAuthType.PRIVATE.getKey()));
                }
            } else {
                mss.setAuthorizationType(Integer.valueOf(MagicEnums.ServiceAuthType.PUBLIC.getKey()));
            }
        }
        if ((sot = MagicEnums.ServiceOwnerType.getEnumByType((String)sc.getOwnerType())) != null && MagicPrivateUtils.isNumeric(sc.getOwner())) {
            switch (sot) {
                case DEFAULT_FORM: 
                case DEFAULT_CAP4_BIZ: {
                    Long newId;
                    Long ownerId = Long.parseLong(sc.getOwner());
                    if (businessDataBean.isUpgrade()) {
                        ownerId = businessDataBean.getRealId4Upgrade(ownerId);
                    }
                    if ((newId = businessDataBean.genNewIdByOldId(ownerId)) == null) break;
                    mss.setOwner(String.valueOf(newId));
                }
            }
        }
        return mss;
    }

    private void setExterOwnerInfo(MagicServiceSummary serviceSummary, BusinessDataBean businessDataBean) {
        BizConfigBean bizConfigBean = businessDataBean.getBizConfigBean();
        if (bizConfigBean.getBizCreateType() == 1 && bizConfigBean.getAppInfo() != null) {
            HashMap<String, String> exOwner = new HashMap<String, String>();
            String goodsId = bizConfigBean.getAppInfo().getGoodsId();
            String orderGoodsIds = bizConfigBean.getAppInfo().getOrderGoodsId();
            exOwner.put("orderGoodsIds", orderGoodsIds);
            exOwner.put("goodId", goodsId);
            serviceSummary.setExtendOwner(JSONUtil.toJSONString(exOwner));
        }
    }

    @Override
    public void importServiceSummary(String bid, String vId, ServiceConfig sc, MagicImportResult importResult, BusinessDataBean businessDataBean) throws BusinessException {
        MagicServiceSummary existsSummary = this.magicServiceSummaryDao.loadServiceInfo(bid, vId);
        if (existsSummary == null) {
            existsSummary = this.initSummaryForImport(sc, businessDataBean);
            this.setExterOwnerInfo(existsSummary, businessDataBean);
            importResult.addNewServiceSummary(existsSummary);
        } else {
            MagicServiceSummary mss = this.initSummaryForImport(sc, businessDataBean);
            this.setExterOwnerInfo(existsSummary, businessDataBean);
            mss.setId(existsSummary.getId());
            mss.setOwner(existsSummary.getOwner());
            mss.setCreateDate(existsSummary.getCreateDate());
            mss.setOwnerType(existsSummary.getOwnerType());
            if (sc.getMetadata() != null && sc.getMetadata().getMetadatas() != null && !sc.getMetadata().getMetadatas().isEmpty()) {
                HashMap<String, MetadataConfig> allMetadata = new HashMap<String, MetadataConfig>();
                for (Object mc : sc.getMetadata().getMetadatas()) {
                    allMetadata.put(mc.getObjName(), (MetadataConfig)mc);
                }
                ArrayList existsMetadata = new ArrayList();
                if (Strings.isNotBlank((String)existsSummary.getMetadata())) {
                    JSONUtils.parseJSonListObj_Class(existsSummary.getMetadata(), existsMetadata, MetadataConfig.class);
                }
                for (MetadataConfig emc : existsMetadata) {
                    allMetadata.put(emc.getObjName(), emc);
                }
                mss.setMetadata(JSONUtil.toJSONString(allMetadata.values()));
            }
            if (MagicEnums.ServiceOwnerType.DEFAULT_FORM_CAP3.getType().equals(mss.getOwnerType()) || MagicEnums.ServiceOwnerType.DEFAULT_FORM.getType().equals(mss.getOwnerType())) {
                Long newId;
                MagicEnums.ServiceOwnerType serviceOwnerType = MagicEnums.ServiceOwnerType.getEnumByType((String)mss.getOwnerType());
                if (MagicPrivateUtils.isNumeric(mss.getOwner())) {
                    Long newId2;
                    MagicFormBean magicFormBean = new MagicFormBean(serviceOwnerType, Long.parseLong(mss.getOwner()));
                    if (magicFormBean.isNull() && MagicPrivateUtils.isNumeric(sc.getOwner()) && (newId2 = businessDataBean.genNewIdByOldId(Long.valueOf(Long.parseLong(sc.getOwner())))) != null) {
                        mss.setOwner(String.valueOf(newId2));
                        mss.setCreateId(Long.valueOf(AppContext.currentUserId()));
                    }
                } else if (MagicPrivateUtils.isNumeric(sc.getOwner()) && (newId = businessDataBean.genNewIdByOldId(Long.valueOf(Long.parseLong(sc.getOwner())))) != null) {
                    mss.setOwner(String.valueOf(newId));
                    mss.setCreateId(Long.valueOf(AppContext.currentUserId()));
                }
            } else if (MagicEnums.ServiceOwnerType.DEFAULT_CAP4_BIZ.getType().equals(sc.getOwnerType())) {
                if (MagicPrivateUtils.isNumeric(existsSummary.getOwner())) {
                    BizConfigBean b = this.businessManager4.findBizConfigById(Long.parseLong(existsSummary.getOwner()));
                    if (b == null) {
                        mss.setOwner(businessDataBean.getBizConfigBean() != null ? String.valueOf(businessDataBean.getBizConfigBean().getId()) : "0");
                        mss.setCreateId(Long.valueOf(AppContext.currentUserId()));
                    }
                } else {
                    mss.setOwner(businessDataBean.getBizConfigBean() != null ? String.valueOf(businessDataBean.getBizConfigBean().getId()) : "0");
                }
            }
            importResult.addExistsServiceSummary(existsSummary);
            importResult.addUpdateServiceSummary(mss);
        }
    }

    @Override
    public void importInvokeService(List<ServiceConfig> invokeList, BusinessDataBean businessDataBean, MagicImportResult importResult) throws BusinessException {
        if (invokeList != null && !invokeList.isEmpty()) {
            for (ServiceConfig sc : invokeList) {
                String version;
                String bid = sc.getBusinessId();
                MagicServiceSummary serviceSummary = importResult.getServiceSummary(bid, version = sc.getVersion());
                if (serviceSummary == null) {
                    this.importServiceSummary(bid, version, sc, importResult, businessDataBean);
                }
                List methodConfigs = sc.getMethodConfig();
                for (ServiceMethodConfig mc : methodConfigs) {
                    MagicInterfaceDefineEntity checkExist = this.magicInterfaceDefineDao.loadDefineById(bid, version, mc.getMethodName());
                    if (checkExist == null) {
                        checkExist = importResult.getServiceEntry(bid, version, mc.getMethodName());
                    }
                    if (checkExist != null) {
                        importResult.addInvokeExistsServices(checkExist);
                        MagicServiceProviderPO providers = this.magicProviderDao.loadProviders(checkExist.getBusinessId(), checkExist.getVersionId(), MagicEnums.ProviderStatus.ON);
                        if (providers != null) {
                            importResult.addExistsProvierCache(providers);
                        }
                        this.magicInterfaceDefineDao.saveEntityInCache(checkExist);
                        continue;
                    }
                    MagicInterfaceDefineEntity e = MagicCreateServiceUtils.convertMethodToPo(sc.getOwnerType(), sc.getOwner(), bid, version, mc);
                    String ext1 = e.getExt1();
                    if (Strings.isNotBlank((String)ext1)) {
                        e.setExt1(this.updateFieldLimit(ext1, businessDataBean));
                    }
                    if (MagicEnums.CertificateType.Private_certificate.getName().equals(sc.getCertificateType())) {
                        e.setCategory(MagicEnums.CertificateType.Private_certificate.getKey());
                    } else if (MagicEnums.CertificateType.Public_certificate.getName().equals(sc.getCertificateType())) {
                        e.setCategory(MagicEnums.CertificateType.Public_certificate.getKey());
                    }
                    importResult.addInvokeNewMethod(e);
                    this.magicInterfaceDefineDao.saveEntityInCache(e);
                }
            }
        }
    }

    private Map<String, String> getOldMethodNameMapper(String invokeServices, String providerServices) {
        ArrayList all = new ArrayList();
        JSONUtils.parseJSonListObj_Class(invokeServices, all, Map.class);
        JSONUtils.parseJSonListObj_Class(providerServices, all, Map.class);
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map i : all) {
            String bid = ParamUtil.getString((Map)i, (String)"businessid", (String)"");
            String version = ParamUtil.getString((Map)i, (String)"version", (String)"");
            List methodList = (List)i.get("methodconfig");
            if (methodList == null) continue;
            for (Map m : methodList) {
                Object displayName = m.get("displayname");
                String methodName = ParamUtil.getString((Map)m, (String)"methodname", (String)"");
                if (displayName == null) continue;
                String name = MagicUpdateServiceUtils.getOldText(displayName);
                result.put(bid + "_" + version + "_" + methodName, name);
            }
        }
        return result;
    }

    @Override
    public void importMagicService(List<ServiceConfig> invokeList, List<ServiceConfig> providerList, Map<String, Object> providerEntryFormRelation, BusinessDataBean businessDataBean, Map<String, Object> providerEntryLimit, MagicImportResult result, String invokeServices, String providerServices) throws BusinessException {
        Map<String, String> allMethodName = this.getOldMethodNameMapper(invokeServices, providerServices);
        this.importProviderService(providerList, providerEntryFormRelation, businessDataBean, providerEntryLimit, result, allMethodName);
        if (invokeList != null && !invokeList.isEmpty()) {
            MagicInterfaceDefineEntity e = null;
            for (ServiceConfig sc : invokeList) {
                String bid = sc.getBusinessId();
                String version = sc.getVersion();
                List methodConfigs = sc.getMethodConfig();
                HashMap<String, MetadataConfig> allMedataDataConfig = new HashMap<String, MetadataConfig>();
                String serviceOwnerType = "";
                for (ServiceMethodConfig mc : methodConfigs) {
                    String ext1;
                    Map otherAttr;
                    ResultConfigGuide resultGuide;
                    List argsGuide;
                    Object subType;
                    String ext12;
                    String serviceType;
                    MagicInterfaceDefineEntity checkExist = this.magicInterfaceDefineDao.loadDefineById(bid, version, mc.getMethodName());
                    if (checkExist != null) {
                        result.addInvokeExistsServices(checkExist);
                        MagicServiceProviderPO providers = this.magicProviderDao.loadProviders(checkExist.getBusinessId(), checkExist.getVersionId(), MagicEnums.ProviderStatus.ON);
                        if (providers != null) {
                            result.addProvider(providers);
                        }
                        this.magicInterfaceDefineDao.saveEntityInCache(checkExist);
                        continue;
                    }
                    e = new MagicInterfaceDefineEntity();
                    e.setIdIfNew();
                    e.setBusinessId(sc.getBusinessId());
                    e.setVersionId(version);
                    e.setCategory(-1);
                    e.setCreateDate(new Date());
                    if (sc.getDes() != null && !sc.getDes().isEmpty()) {
                        e.setDescription(((MagicDisplay)sc.getDes().get(0)).getText());
                    }
                    if (MagicPrivateUtils.isNumeric(serviceType = mc.getServiceType())) {
                        e.setServiceType(Integer.valueOf(serviceType).intValue());
                    }
                    e.setMethodName(mc.getMethodName());
                    e.setName(allMethodName.get(bid + "_" + version + "_" + mc.getMethodName()));
                    if (providerEntryLimit != null && Strings.isNotBlank((String)(ext12 = ParamUtil.getString(providerEntryLimit, (String)mc.getMethodName())))) {
                        e.setExt1(ext12);
                    }
                    if ((subType = mc.getOtherAttr("serviceSubType")) != null) {
                        serviceOwnerType = subType.toString();
                        e.setSubType(subType.toString());
                    }
                    if ((argsGuide = mc.getArgsConfigGuide()) != null) {
                        e.setArgsConfigGuide(JSONUtils.getJSonString(argsGuide));
                    }
                    if ((resultGuide = mc.getResultConfigGuide()) != null) {
                        e.setResultConfigGuide(JSONUtils.getJSonString(resultGuide));
                    }
                    if ((otherAttr = mc.getOtherAttr()) != null) {
                        e.setOtherAttr(JSONUtils.getJSonString(otherAttr));
                    }
                    if (providerEntryLimit != null && Strings.isNotBlank((String)(ext1 = ParamUtil.getString(providerEntryLimit, (String)mc.getMethodName())))) {
                        e.setExt1(this.updateFieldLimit(ext1, businessDataBean));
                    }
                    e.setExt2(MagicPrivateUtils.setExt2Info());
                    e.setArgsConfig(JSONUtils.getJSonString(mc.getArgsConfig()));
                    e.setMetadataConfig(JSONUtils.getJSonString(sc.getMetadata().getMetadatas()));
                    e.setResultConfig(JSONUtils.getJSonString(mc.getReturnConfig()));
                    result.addInvokeNewMethod(e);
                    MagicUpdateServiceUtils.updateEntity(e, CAP4MagicCacheInitializer.getLatestUpdateVersion(), allMedataDataConfig);
                    this.magicInterfaceDefineDao.saveEntityInCache(e);
                }
                MagicServiceSummary serviceSummary = this.magicServiceSummaryDao.loadServiceInfo(sc.getBusinessId(), sc.getVersion());
                if (serviceSummary == null) {
                    serviceSummary = this.setSummary(0L, bid, "\u5176\u4ed6" + bid.substring(4, 9), version, allMedataDataConfig);
                    serviceSummary.setOwnerType(serviceOwnerType);
                    result.addNewServiceSummary(serviceSummary);
                    continue;
                }
                ArrayList existsMetadata = new ArrayList();
                if (Strings.isNotBlank((String)serviceSummary.getMetadata())) {
                    JSONUtils.parseJSonListObj_Class(serviceSummary.getMetadata(), existsMetadata, MetadataConfig.class);
                }
                for (MetadataConfig mc : existsMetadata) {
                    allMedataDataConfig.put(mc.getObjName(), mc);
                }
                existsMetadata.clear();
                existsMetadata.addAll(allMedataDataConfig.values());
                serviceSummary.setMetadata(JSONUtils.getJSonString(existsMetadata));
                result.addExistsServiceSummary(serviceSummary);
                result.addNewServiceSummary(serviceSummary);
            }
        }
    }

    @Override
    public void updateMagic() throws BusinessException {
        try {
            Map allUpdateServices = AppContext.getBeansOfType(IMagicServiceUpdate.class);
            TreeMap<Integer, IMagicServiceUpdate> sortUpdate = new TreeMap<Integer, IMagicServiceUpdate>();
            int updateSort = 0;
            for (IMagicServiceUpdate su : allUpdateServices.values()) {
                if (su.updateSort() > updateSort) {
                    updateSort = su.updateSort();
                }
                sortUpdate.put(su.updateSort(), su);
            }
            IMagicInterfaceDefineDao magicInterfaceDefineDao = (IMagicInterfaceDefineDao)AppContext.getBean((String)"magicInterfaceDefineDao");
            List<MagicInterfaceDefineEntity> allEntitys = magicInterfaceDefineDao.loadAllNeedUpdateEntitys(updateSort);
            LOGGER.info((Object)("start update size = " + allEntitys.size()));
            List<MagicInterfaceDefineEntity> needUpdate = null;
            updateSort = 0;
            for (IMagicServiceUpdate su : sortUpdate.values()) {
                needUpdate = su.update(allEntitys, updateSort);
                updateSort = su.updateSort();
            }
            if (needUpdate != null && !needUpdate.isEmpty()) {
                magicInterfaceDefineDao.delete(needUpdate);
                magicInterfaceDefineDao.saveDefine(needUpdate);
            }
        }
        catch (Exception e) {
            throw new BusinessException((Throwable)e);
        }
    }

    @Override
    public DataRightEntity getMethodAnnoEntityById(String id) throws BusinessException {
        MagicInterfaceDefineEntity data = this.magicInterfaceDefineDao.loadDefineById(Long.valueOf(id));
        if (data != null && Strings.isNotBlank((String)data.getExt1())) {
            DataRightEntity result = new DataRightEntity();
            Map ext = (Map)JSONUtil.parseJSONString((String)data.getExt1(), Map.class);
            if (ext == null || ext.isEmpty()) {
                return result;
            }
            String anno = ParamUtil.getString((Map)ext, (String)"dataRight");
            if (Strings.isBlank((String)anno)) {
                return result;
            }
            return JSONUtils.parseJSonStr_Class(anno, DataRightEntity.class);
        }
        return null;
    }

    @Override
    public String getRelationRealRightId(FormRelationshipMapBean shipMap, String viewType) throws BusinessException {
        FormRelationshipBean shipBean = shipMap.getRelationshipBean();
        String bId = ParamUtil.getString((Map)shipMap.getParams(), (String)"businessId");
        String vId = ParamUtil.getString((Map)shipMap.getParams(), (String)"versionId");
        String methodName = ParamUtil.getString((Map)shipMap.getParams(), (String)"methodName");
        MagicInterfaceDefineEntity entity = this.magicInterfaceDefineDao.loadDefineById(bId, vId, methodName);
        if (shipBean.getRelationType() == 1) {
            String oldView = "";
            oldView = "pcView".equals(viewType) ? shipMap.getPcView() : (entity != null && MagicEnums.ProviderType.DEFAULT_FORM_CAP3.getType().equals(entity.getSubType()) ? shipMap.getPcView() : shipMap.getPhoneView());
            String newRightId = "";
            if (Strings.isNotBlank((String)oldView) && entity != null) {
                MagicServiceProviderPO provider = this.magicProviderDao.loadProviders(entity.getBusinessId(), entity.getVersionId(), MagicEnums.ProviderStatus.ON);
                if (provider == null) {
                    return "";
                }
                newRightId = MagicPrivateUtils.convertRight(MagicPrivateUtils.convert(entity), provider, oldView);
                this.capFormManager.addRight(newRightId);
            }
            return newRightId;
        }
        return "";
    }

    @Override
    public void deleteReflectionByShip(FormRelationshipBean relationBean) throws BusinessException {
        if (relationBean != null && FormRelationEnums.relationApplicationType.inner.getKey().equals(relationBean.getApplicationType())) {
            List ships = relationBean.getRelationMapList();
            long id = relationBean.getId();
            if (ships != null && !ships.isEmpty()) {
                ArrayList<String> point = new ArrayList<String>(ships.size());
                if (FormRelationEnums.ViewSelectType.user.getKey() == relationBean.getRelationType()) {
                    for (FormRelationshipMapBean s : ships) {
                        point.add(id + "_" + s.getSelectedField());
                    }
                } else {
                    for (FormRelationshipMapBean s : ships) {
                        point.add(id + "_" + s.getConditionFormulaId());
                    }
                }
                this.magicReflectionRelationDao.deleteByPoints(point);
            }
        }
    }

    @Override
    public void deleteReflectionsByTrigger(FormTriggerBean triggerBean) throws BusinessException {
        if (triggerBean != null && (FormTriggerBean.TriggerBusinessType.DataInterface.getKey().equals(triggerBean.getType()) || FormTriggerBean.TriggerBusinessType.OuterForm.getKey().equals(triggerBean.getType()))) {
            long id = triggerBean.getId();
            List actions = triggerBean.getActionList();
            if (actions != null && !actions.isEmpty()) {
                ArrayList<String> point = new ArrayList<String>(actions.size());
                for (FormTriggerActionBean a : actions) {
                    point.add(id + "_" + a.getId());
                }
                this.magicReflectionRelationDao.deleteByPoints(point);
            }
        }
    }

    @Override
    public List<Long> getServiceProviderSource(FormTriggerBean triggerBean) throws BusinessException {
        ArrayList<Long> result = new ArrayList<Long>();
        for (FormTriggerActionBean action : triggerBean.getActionList()) {
            List<MagicServiceProviderPO> providers;
            Long magicId = ParamUtil.getLong((Map)action.getParam(), (String)"dataMagicId", (Long)0L);
            MagicInterfaceDefineEntity entity = this.magicInterfaceDefineDao.loadDefineById(magicId);
            if (entity == null || (providers = this.magicProviderDao.loadProviders(entity.getBusinessId(), entity.getVersionId())) == null || providers.isEmpty()) continue;
            for (MagicServiceProviderPO p : providers) {
                if (p.getStatus() != MagicEnums.ProviderStatus.ON.getType() || !MagicEnums.ProviderType.DEFAULT_FORM.getType().equals(p.getSourceType())) continue;
                String source = p.getSource();
                try {
                    result.add(Long.parseLong(source));
                }
                catch (Exception e) {
                    LOGGER.info((Object)e.getLocalizedMessage());
                }
            }
        }
        return result;
    }

    @Override
    public Long getServiceProviderSource(FormTriggerActionBean actionBean) throws BusinessException {
        Long magicId = ParamUtil.getLong((Map)actionBean.getParam(), (String)"dataMagicId", (Long)0L);
        MagicInterfaceDefineEntity entity = this.magicInterfaceDefineDao.loadDefineById(magicId);
        if (entity != null) {
            List<MagicServiceProviderPO> providers = this.magicProviderDao.loadProviders(entity.getBusinessId(), entity.getVersionId());
            if (providers == null || providers.isEmpty()) {
                return 0L;
            }
            for (MagicServiceProviderPO p : providers) {
                if (p.getStatus() != MagicEnums.ProviderStatus.ON.getType() || !MagicEnums.ProviderType.DEFAULT_FORM.getType().equals(p.getSourceType())) continue;
                String source = p.getSource();
                try {
                    return Long.parseLong(source);
                }
                catch (Exception e) {
                    LOGGER.info((Object)e.getLocalizedMessage());
                }
            }
        }
        return 0L;
    }

    @Override
    public List<Long> getServiceProviderSource(FormRelationshipBean shipBean) throws BusinessException {
        HashSet<Long> result = new HashSet<Long>();
        if (shipBean != null && FormRelationEnums.relationApplicationType.inner.getKey().equals(shipBean.getApplicationType())) {
            List ships = shipBean.getRelationMapList();
            long id = shipBean.getId();
            if (ships != null && !ships.isEmpty()) {
                List<MagicReflectionRelationPO> allReflections;
                ArrayList<String> point = new ArrayList<String>(ships.size());
                if (FormRelationEnums.ViewSelectType.user.getKey() == shipBean.getRelationType()) {
                    for (FormRelationshipMapBean s : ships) {
                        point.add(id + "_" + s.getSelectedField());
                    }
                } else {
                    for (FormRelationshipMapBean s : ships) {
                        point.add(id + "_" + s.getConditionFormulaId());
                    }
                }
                if ((allReflections = this.magicReflectionRelationDao.getReflectionByBids(point)) != null && !allReflections.isEmpty()) {
                    for (MagicReflectionRelationPO rr : allReflections) {
                        List<MagicServiceProviderPO> providers = this.magicProviderDao.loadProviders(rr.getCalleeBusinessId(), rr.getVersionId());
                        for (MagicServiceProviderPO p : providers) {
                            if (!MagicEnums.ProviderType.DEFAULT_FORM.getType().equals(p.getSourceType())) continue;
                            try {
                                result.add(Long.parseLong(p.getSource()));
                            }
                            catch (Exception e) {
                                LOGGER.warn((Object)(p.getSource() + " \u65e0\u6cd5\u8f6c\u6210Long"));
                            }
                        }
                    }
                }
            }
        }
        return new ArrayList<Long>(result);
    }

    @Override
    public Long getServiceProviderSource(FormRelationshipMapBean shipMapBean) throws BusinessException {
        FormRelationshipBean shipBean = shipMapBean.getRelationshipBean();
        List ships = shipBean.getRelationMapList();
        long id = shipBean.getId();
        if (ships != null && !ships.isEmpty()) {
            String point = "";
            point = FormRelationEnums.ViewSelectType.user.getKey() == shipBean.getRelationType() ? id + "_" + shipMapBean.getSelectedField() : id + "_" + shipMapBean.getConditionFormulaId();
            List<MagicReflectionRelationPO> allReflections = this.magicReflectionRelationDao.getReflectionRelationByCallPoint(point);
            if (allReflections != null && !allReflections.isEmpty()) {
                MagicReflectionRelationPO rr = allReflections.get(0);
                List<MagicServiceProviderPO> providers = this.magicProviderDao.loadProviders(rr.getCalleeBusinessId(), rr.getVersionId());
                for (MagicServiceProviderPO p : providers) {
                    if (!MagicEnums.ProviderType.DEFAULT_FORM.getType().equals(p.getSourceType()) || MagicEnums.ProviderStatus.ON.getType() != p.getStatus()) continue;
                    try {
                        return Long.parseLong(p.getSource());
                    }
                    catch (Exception e) {
                        LOGGER.warn((Object)(p.getSource() + " \u65e0\u6cd5\u8f6c\u6210Long"));
                    }
                }
            }
        }
        return 0L;
    }

    @Override
    public List<MagicInterfaceDefineEntity> getServiceByProvider(long formId) throws BusinessException {
        List<MagicServiceProviderPO> providers = this.magicProviderDao.getProvidersBySource(String.valueOf(formId), MagicEnums.ProviderStatus.ON, MagicEnums.ProviderType.DEFAULT_FORM);
        if (providers != null && !providers.isEmpty()) {
            ArrayList<MagicInterfaceDefineEntity> result = new ArrayList<MagicInterfaceDefineEntity>();
            for (MagicServiceProviderPO p : providers) {
                MagicInterfaceDefineEntity entity = this.magicInterfaceDefineDao.loadDefineById(p.getBusinessId(), p.getVersionId(), p.getMethodName());
                if (entity == null) continue;
                result.add(entity);
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public Map<Long, String> getServiceNameByProvider(long formId) throws BusinessException {
        List<MagicServiceProviderPO> providers = this.magicProviderDao.getProvidersBySource(String.valueOf(formId), MagicEnums.ProviderStatus.ON, MagicEnums.ProviderType.DEFAULT_FORM);
        HashMap<Long, String> result = new HashMap<Long, String>();
        if (providers != null && !providers.isEmpty()) {
            for (MagicServiceProviderPO p : providers) {
                String name;
                MagicInterfaceDefineEntity entity;
                if (result.containsKey(p.getId()) || (entity = this.magicInterfaceDefineDao.loadDefineById(p.getBusinessId(), p.getVersionId(), p.getMethodName())) == null || (name = entity.getName(AppContext.getLocale())) == null) continue;
                result.put(p.getId(), name);
            }
        }
        return result;
    }

    @Override
    public void deleteMagicByFormBean(FormBean fb) throws BusinessException {
        List triggerIds = fb.getFormTriggerIdList();
        ArrayList<Long> all = new ArrayList<Long>();
        all.addAll(triggerIds);
        List relationIds = fb.getFormRelationshipIdList();
        all.addAll(relationIds);
        this.magicReflectionRelationDao.deleteByTriggerOrRelationIds(all);
        this.magicProviderDao.deleteProvidesBySource(String.valueOf(fb.getId()), MagicEnums.ProviderType.DEFAULT_FORM);
    }

    @Override
    public List<FormRelationshipMapBean> getRelationBeansByFormId(long formId) throws BusinessException {
        List<MagicServiceProviderPO> providers = this.magicProviderDao.getProvidersBySource(String.valueOf(formId), MagicEnums.ProviderStatus.ON, MagicEnums.ProviderType.DEFAULT_FORM);
        ArrayList<FormRelationshipMapBean> result = new ArrayList<FormRelationshipMapBean>();
        if (providers != null && !providers.isEmpty()) {
            HashSet<String> bids = new HashSet<String>();
            for (MagicServiceProviderPO p : providers) {
                bids.add(p.getBusinessId());
            }
            List<MagicReflectionRelationPO> allRelcations = this.magicReflectionRelationDao.getReflectionByBids(bids);
            for (MagicReflectionRelationPO p : allRelcations) {
                String callingPoint = p.getCallingPoint();
                String[] array = callingPoint.split("_");
                Long relationId = Long.parseLong(array[0]);
                FormRelationshipBean tempShip = this.cap4FormCacheManager.getFormRelationshipBean(relationId);
                if (tempShip == null || FormRelationEnums.ViewSelectType.system.getKey() == tempShip.getRelationType() || array.length <= 1) continue;
                for (FormRelationshipMapBean ship : tempShip.getRelationMapList()) {
                    if (!array[1].equals(ship.getSelectedField())) continue;
                    result.add(ship);
                }
            }
        }
        return result;
    }

    @Override
    public List<FormTriggerActionBean> getTriggerBeanByFormId(long formId) throws BusinessException {
        List<MagicServiceProviderPO> providers = this.magicProviderDao.getProvidersBySource(String.valueOf(formId), MagicEnums.ProviderStatus.ON, MagicEnums.ProviderType.DEFAULT_FORM);
        ArrayList<FormTriggerActionBean> result = new ArrayList<FormTriggerActionBean>();
        if (providers != null && !providers.isEmpty()) {
            HashSet<String> bids = new HashSet<String>();
            for (MagicServiceProviderPO p : providers) {
                bids.add(p.getBusinessId());
            }
            List<MagicReflectionRelationPO> allRelcations = this.magicReflectionRelationDao.getReflectionByBids(bids);
            for (MagicReflectionRelationPO p : allRelcations) {
                String callingPoint = p.getCallingPoint();
                String[] array = callingPoint.split("_");
                Long triggerId = Long.parseLong(array[0]);
                FormTriggerBean tempShip = this.cap4FormCacheManager.getFormTriggerBean(triggerId);
                if (tempShip == null || array.length <= 1) continue;
                for (FormTriggerActionBean action : tempShip.getActionList()) {
                    if (!array[1].equals(action.getId().toString())) continue;
                    result.add(action);
                }
            }
        }
        return result;
    }

    @Override
    public List<MagicReflectionRelationPO> getMappingByPoints(List<String> points) throws BusinessException {
        return this.getMagicReflectionRelationDao().getReflectionByCallPoints(points);
    }

    public IMagicInterfaceDefineDao getMagicInterfaceDefineDao() {
        return this.magicInterfaceDefineDao;
    }

    public void setMagicInterfaceDefineDao(IMagicInterfaceDefineDao magicInterfaceDefineDao) {
        this.magicInterfaceDefineDao = magicInterfaceDefineDao;
    }

    public CAP4FormCacheManager getCap4FormCacheManager() {
        return this.cap4FormCacheManager;
    }

    public void setCap4FormCacheManager(CAP4FormCacheManager cap4FormCacheManager) {
        this.cap4FormCacheManager = cap4FormCacheManager;
    }

    public BusinessManager getBusinessManager4() {
        return this.businessManager4;
    }

    public void setBusinessManager4(BusinessManager businessManager4) {
        this.businessManager4 = businessManager4;
    }

    public IMagicReflectionRelationDao getMagicReflectionRelationDao() {
        return this.magicReflectionRelationDao;
    }

    public void setMagicReflectionRelationDao(IMagicReflectionRelationDao magicReflectionRelationDao) {
        this.magicReflectionRelationDao = magicReflectionRelationDao;
    }

    public IMagicProviderDao getMagicProviderDao() {
        return this.magicProviderDao;
    }

    public void setMagicProviderDao(IMagicProviderDao magicProviderDao) {
        this.magicProviderDao = magicProviderDao;
    }

    public IMagicServiceSummaryDao getMagicServiceSummaryDao() {
        return this.magicServiceSummaryDao;
    }

    public void setMagicServiceSummaryDao(IMagicServiceSummaryDao magicServiceSummaryDao) {
        this.magicServiceSummaryDao = magicServiceSummaryDao;
    }

    @Override
    public void updateEntity() throws BusinessException {
        LinkedList<MagicInterfaceDefineEntity> needUpdate = new LinkedList<MagicInterfaceDefineEntity>();
        for (MagicInterfaceDefineEntity e : this.magicInterfaceDefineDao.loadAllEntitys()) {
            if (!Strings.isBlank((String)e.getResultConfigGuide()) && !Strings.isBlank((String)e.getArgsConfigGuide())) continue;
            try {
                MagicUpdateServiceUtils.updateGuide(e);
                needUpdate.add(e);
            }
            catch (Exception ex) {}
        }
        this.magicInterfaceDefineDao.delete(needUpdate);
        this.magicInterfaceDefineDao.saveDefine(needUpdate);
        List<MagicServiceProviderPO> po = this.magicProviderDao.loadAllProviders();
        LinkedList needUpdatePo = new LinkedList();
        for (MagicServiceProviderPO p : po) {
            if (Strings.isNotBlank((String)p.getExt1()) && !p.getExt1().startsWith("{")) continue;
        }
    }

    @Override
    public List<String> checkHandlePermission(MagicServiceSummary summary) throws BusinessException {
        ArrayList<String> list = new ArrayList<String>();
        list.add("addMethod");
        list.add("addImpl");
        list.add("modifyImpl");
        list.add("modifyMethod");
        list.add("modifyAuth");
        list.add("modifySummary");
        list.add("deleteImpl");
        list.add("deleteMethod");
        if (MagicEnums.ServiceOwnerType.DEFAULT_FORM.getType().equals(summary.getOwnerType()) || MagicEnums.ServiceOwnerType.DEFAULT_CAP4_BIZ.getType().equals(summary.getOwnerType())) {
            if (MagicPrivateUtils.isNumeric(summary.getOwner())) {
                BizConfigBean bizConfigBean = MagicEnums.ServiceOwnerType.DEFAULT_FORM.getType().equals(summary.getOwnerType()) ? this.businessManager4.findBizConfigByFormId(Long.parseLong(summary.getOwner())) : this.businessManager4.findBizConfigById(Long.parseLong(summary.getOwner()));
                if (bizConfigBean == null) {
                    list.clear();
                } else if (AppContext.currentUserId() == bizConfigBean.getOwnerId() && bizConfigBean.getBizCreateType() != null && bizConfigBean.getBizCreateType() == 1 && Strings.isNotBlank((String)summary.getExtendOwner())) {
                    list.clear();
                    list.add("modifyAuth");
                } else if (AppContext.currentUserId() != bizConfigBean.getOwnerId()) {
                    list.clear();
                }
            } else {
                list.clear();
            }
        } else if (MagicEnums.ServiceOwnerType.DEFAULT_EXTERNAL.getType().equals(summary.getOwnerType())) {
            if (Strings.isNotBlank((String)summary.getExtendOwner())) {
                list.clear();
                list.add("modifyAuth");
            }
        } else {
            list.clear();
        }
        return list;
    }

    public CAPFormManager getCapFormManager() {
        return this.capFormManager;
    }

    public void setCapFormManager(CAPFormManager capFormManager) {
        this.capFormManager = capFormManager;
    }

    public ReportApi getReportApi() {
        return this.reportApi;
    }

    public void setReportApi(ReportApi reportApi) {
        this.reportApi = reportApi;
    }
}

