/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.magic.manager.impl;

import com.seeyon.cap4.bizportal.BizPortalConstants;
import com.seeyon.cap4.bizportal.datasource.DefaultDataSourceProvider;
import com.seeyon.cap4.bizportal.datasource.bean.Command;
import com.seeyon.cap4.bizportal.datasource.bean.DataSetMetadata;
import com.seeyon.cap4.bizportal.datasource.bean.DataSetResult;
import com.seeyon.cap4.bizportal.datasource.bean.DefaultDataSetList;
import com.seeyon.cap4.bizportal.datasource.bean.PaginationParam;
import com.seeyon.cap4.bizportal.datasource.list.ListDataSetResult;
import com.seeyon.cap4.bizportal.param.ContextParam;
import com.seeyon.cap4.form.bean.FormRelationshipBean;
import com.seeyon.cap4.form.bean.FormRelationshipMapBean;
import com.seeyon.cap4.form.bean.SimpleObjectBean;
import com.seeyon.cap4.form.modules.engin.relation.FormRelationEnums;
import com.seeyon.cap4.magic.business.IMagicAjaxHandleService;
import com.seeyon.cap4.magic.business.bind.IMagicBusinessBindService;
import com.seeyon.cap4.magic.dao.IMagicInterfaceDefineDao;
import com.seeyon.cap4.magic.dao.IMagicProviderDao;
import com.seeyon.cap4.magic.dao.IMagicReflectionRelationDao;
import com.seeyon.cap4.magic.dao.IMagicServiceSummaryDao;
import com.seeyon.cap4.magic.execute.MagicProviderExecuteManager;
import com.seeyon.cap4.magic.initializer.CAP4MagicCacheInitializer;
import com.seeyon.cap4.magic.po.MagicInterfaceDefineEntity;
import com.seeyon.cap4.magic.po.MagicReflectionRelationPO;
import com.seeyon.cap4.magic.po.MagicServiceProviderPO;
import com.seeyon.cap4.magic.po.MagicServiceSummary;
import com.seeyon.cap4.magic.utils.JSONUtils;
import com.seeyon.cap4.magic.vo.MagicEnums;
import com.seeyon.ctp.common.constants.ApplicationCategoryEnum;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.report.bizportal.api.ReportFacadeManagerApi;
import com.seeyon.ctp.report.bizportal.bean.ListDataResult;
import com.seeyon.ctp.report.bizportal.bean.ListField;
import com.seeyon.ctp.report.bizportal.bean.ListRowData;
import com.seeyon.ctp.report.engine.bean.UserConditions;
import com.seeyon.ctp.util.FlipInfo;
import com.seeyon.ctp.util.ParamUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.UUIDGenerator;
import com.seeyon.datamagic.engine.domain.base.MagicDisplay;
import com.seeyon.datamagic.engine.domain.config.EntryConfigItem;
import com.seeyon.datamagic.engine.domain.config.ResultConfigGuide;
import com.seeyon.datamagic.engine.out.service.OutService;
import com.seeyon.datamagic.engine.out.service.entry.OutServiceInfo;
import com.seeyon.datamagic.engine.out.service.entry.ServiceSummary;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MagicPortalQueryProvider
extends DefaultDataSourceProvider {
    private IMagicServiceSummaryDao magicServiceSummaryDao;
    private IMagicInterfaceDefineDao magicInterfaceDefineDao;
    private IMagicReflectionRelationDao magicReflectionRelationDao;
    private IMagicProviderDao magicProviderDao;
    private IMagicAjaxHandleService magicAjaxHandleService;
    private static final String OWNER_TYPE = "ownerType";
    private ReportFacadeManagerApi reportFacadeManagerApi;

    @Override
    protected String getId(Command command, DataSetMetadata metadata) throws BusinessException {
        return metadata.getUuid();
    }

    @Override
    public DefaultDataSetList.Node getStepNode(DataSetMetadata dataSetMetadata) throws BusinessException {
        String ownerType = ParamUtil.getString(dataSetMetadata.getAttributes(), (String)OWNER_TYPE, (String)"");
        DefaultDataSetList.Node node = new DefaultDataSetList.Node();
        node.setId(ownerType);
        return node;
    }

    @Override
    public BizPortalConstants.DataFormat dataFormat() {
        return BizPortalConstants.DataFormat.LIST;
    }

    @Override
    public String uuid() {
        return "magic";
    }

    @Override
    public String name() {
        return ResourceUtil.getString((String)"cap.magic.outer.interface.label");
    }

    @Override
    public boolean isAllow(ContextParam contextParam, DataSetMetadata metadata, Command command) throws BusinessException {
        return true;
    }

    @Override
    public DataSetMetadata beforeDataSetMetaBind(String dataId, DataSetMetadata metadata) throws BusinessException {
        Map<String, Object> attr = metadata.getAttributes();
        String ownerType = ParamUtil.getString(attr, (String)OWNER_TYPE, (String)"");
        if (!MagicEnums.ServiceOwnerType.DEFAULT_REPORT.getType().equals(ownerType)) {
            MagicInterfaceDefineEntity entity;
            ServiceSummary serviceSummary;
            String businessId = ParamUtil.getString(attr, (String)"businessId", (String)"");
            String version = ParamUtil.getString(attr, (String)"versionId", (String)"");
            String methodName = ParamUtil.getString(attr, (String)"methodName", (String)"");
            OutService outService = CAP4MagicCacheInitializer.getOutServiceByType(ownerType);
            if (outService != null && !MagicEnums.ServiceOwnerType.DEFAULT_FORM_CAP3.getType().equals(ownerType)) {
                serviceSummary = new ServiceSummary();
                serviceSummary.setId(dataId);
                if (attr.containsKey("otherAttr")) {
                    serviceSummary.setOtherAttr((Map)attr.get("otherAttr"));
                }
                serviceSummary = this.magicAjaxHandleService.convertOutService(MagicEnums.BusinessMethodType.RELATION_USER.getName(), ownerType, serviceSummary);
                entity = this.magicInterfaceDefineDao.loadDefineById(Long.parseLong(serviceSummary.getId()));
                businessId = entity.getBusinessId();
                version = entity.getVersionId();
                methodName = entity.getMethodName();
                metadata.attr("businessId", businessId);
                metadata.attr("versionId", version);
                metadata.attr("methodName", methodName);
            } else {
                entity = this.magicInterfaceDefineDao.loadDefineById(businessId, version, methodName);
            }
            serviceSummary = this.magicServiceSummaryDao.loadServiceInfo(businessId, version);
            String callingPoint = businessId + "_methodName" + UUIDGenerator.getUUID();
            metadata.attr("callingPoint", callingPoint);
            IMagicBusinessBindService bindServices = CAP4MagicCacheInitializer.getBindService(serviceSummary.getBusinessType());
            FormRelationshipBean shipBean = new FormRelationshipBean();
            FormRelationshipMapBean shipMapBean = this.newShipMapBean(entity);
            MagicReflectionRelationPO mmc = bindServices.bindRelation((MagicServiceSummary)serviceSummary, shipBean, shipMapBean, entity, true);
            mmc.setCallingPoint(callingPoint);
            this.magicReflectionRelationDao.deleteByPoint(callingPoint);
            this.magicReflectionRelationDao.save(mmc);
        }
        return metadata;
    }

    private FormRelationshipMapBean newShipMapBean(MagicInterfaceDefineEntity entity) {
        ResultConfigGuide resultConfigGuide;
        ArrayList<SimpleObjectBean> resultKey = new ArrayList<SimpleObjectBean>();
        FormRelationshipBean shipBean = new FormRelationshipBean();
        shipBean.setRelationType(FormRelationEnums.ViewSelectType.user.getKey());
        FormRelationshipMapBean relationshipMapBean = new FormRelationshipMapBean();
        relationshipMapBean.setRelationshipBean(shipBean);
        if (Strings.isNotBlank((String)entity.getResultConfigGuide()) && (resultConfigGuide = JSONUtils.parseJSonStr_Class(entity.getResultConfigGuide(), ResultConfigGuide.class)).getConfigList() != null) {
            for (EntryConfigItem e : resultConfigGuide.getConfigList()) {
                SimpleObjectBean simpleObjectBean = new SimpleObjectBean();
                simpleObjectBean.setName(e.getName());
                resultKey.add(simpleObjectBean);
            }
        }
        relationshipMapBean.setShowFieldList(resultKey);
        relationshipMapBean.putParams("outServiceParams", Collections.emptyList());
        return relationshipMapBean;
    }

    @Override
    public DataSetResult executeQuery(ContextParam contextParam, DataSetMetadata metadata, String[] versions, Command command) throws BusinessException {
        Map<String, Object> attr = metadata.getAttributes();
        ListDataSetResult resultData = new ListDataSetResult();
        String ownerType = ParamUtil.getString(attr, (String)OWNER_TYPE, (String)"");
        PaginationParam paginationParam = PaginationParam.of(command);
        if (MagicEnums.ServiceOwnerType.DEFAULT_REPORT.getType().equals(ownerType)) {
            Long id = ParamUtil.getLong(attr, (String)"id", (Long)0L);
            UserConditions userConditions = new UserConditions();
            FlipInfo fi = new FlipInfo();
            fi.setPage(paginationParam.getPage().intValue());
            fi.setSize(paginationParam.getPageSize().intValue());
            ListDataResult reportResult = this.reportFacadeManagerApi.findQueryDataResult(id, userConditions, fi);
            for (ListRowData d : reportResult.getData()) {
                d.setActions(Collections.emptyList());
            }
            resultData.setListDataResult(reportResult);
        } else {
            String businessId = ParamUtil.getString(attr, (String)"businessId", (String)"");
            String version = ParamUtil.getString(attr, (String)"versionId", (String)"");
            String methodName = ParamUtil.getString(attr, (String)"methodName", (String)"");
            String callingPoint = ParamUtil.getString(attr, (String)"callingPoint", (String)"");
            MagicServiceSummary serviceSummary = this.magicServiceSummaryDao.loadServiceInfo(businessId, version);
            List<MagicReflectionRelationPO> reflections = this.magicReflectionRelationDao.getReflectionRelationByCallPoint(callingPoint);
            MagicProviderExecuteManager providerExecute = CAP4MagicCacheInitializer.getExecuteByProviderManager(serviceSummary.getOwnerType());
            MagicServiceProviderPO provider = this.magicProviderDao.loadProviders(businessId, version, MagicEnums.ProviderStatus.ON);
            MagicInterfaceDefineEntity entry = this.magicInterfaceDefineDao.loadDefineById(businessId, version, methodName);
            if (entry != null && providerExecute != null && !reflections.isEmpty() && provider != null) {
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("isMainSelecter", "1");
                params.put("isInit", "0");
                FormRelationshipMapBean shipMapBean = this.newShipMapBean(entry);
                params.put("page", paginationParam.getPage());
                params.put("pageSize", paginationParam.getPageSize());
                Map<String, Object> result = providerExecute.relation(params, shipMapBean, reflections.get(0), entry, provider, null);
                resultData.setListDataResult(this.convertData(result, entry));
            } else {
                HashMap<String, Object> result = new HashMap<String, Object>();
                result.put("data", Collections.emptyList());
                resultData.setListDataResult(this.convertData(result, entry));
            }
        }
        return resultData;
    }

    private ListDataResult convertData(Map<String, Object> relationData, MagicInterfaceDefineEntity entity) {
        ResultConfigGuide resultConfigGuide;
        List data = (List)relationData.get("data");
        ListDataResult result = new ListDataResult();
        int total = ParamUtil.getInt(relationData, (String)"total", (int)0);
        int pageSize = ParamUtil.getInt(relationData, (String)"pageSize", (int)50);
        int page = ParamUtil.getInt(relationData, (String)"page", (int)1);
        result.setTotal(total);
        result.setPage(page);
        result.setSize(pageSize);
        ArrayList<ListField> fields = new ArrayList<ListField>(data.size());
        if (entity != null && Strings.isNotBlank((String)entity.getResultConfigGuide()) && (resultConfigGuide = JSONUtils.parseJSonStr_Class(entity.getResultConfigGuide(), ResultConfigGuide.class)).getConfigList() != null) {
            for (EntryConfigItem e : resultConfigGuide.getConfigList()) {
                Map otherConfig = e.getOtherConfig();
                if (e.getOtherConfig() == null) {
                    otherConfig = Collections.emptyMap();
                }
                String fieldType = ParamUtil.getString(otherConfig, (String)"fieldType", (String)"");
                String inputType = ParamUtil.getString(otherConfig, (String)"inputType", (String)"");
                String displayName = ParamUtil.getString(otherConfig, (String)"displayName", (String)"");
                if (Strings.isBlank((String)displayName) && e.getDisplayName() != null && !e.getDisplayName().isEmpty()) {
                    displayName = ((MagicDisplay)e.getDisplayName().get(0)).getText();
                }
                String fieldLength = ParamUtil.getString(otherConfig, (String)"fieldLength", (String)"20");
                String digitNum = ParamUtil.getString(otherConfig, (String)"digitNum", (String)"20");
                Long enumId = ParamUtil.getLong(otherConfig, (String)"value", (Long)0L);
                Integer enumLevel = ParamUtil.getInt(otherConfig, (String)"enumLevel", (int)0);
                String name = ParamUtil.getString(otherConfig, (String)"name", (String)"");
                if (Strings.isBlank((String)name) && Strings.isNotBlank((String)e.getName())) {
                    name = e.getName();
                }
                ListField lf = new ListField();
                lf.setFieldType(fieldType);
                lf.setInputType(inputType);
                lf.setKey(name);
                lf.setName(displayName);
                lf.setLength(fieldLength);
                lf.setDigitNum(digitNum);
                lf.setEnumId(enumId);
                lf.setEnumLevel(enumLevel);
                fields.add(lf);
            }
        }
        ArrayList<ListRowData> listRowData = new ArrayList<ListRowData>(data.size());
        for (Map item : data) {
            Map showData = (Map)item.get("showData");
            ListRowData rowDataItem = new ListRowData();
            HashMap<String, ListRowData.Data> resultData = new HashMap<String, ListRowData.Data>();
            for (int x = 0; x < fields.size(); ++x) {
                ListField lf = (ListField)fields.get(x);
                Map value = (Map)showData.get(lf.getKey());
                if (value == null) continue;
                Object realValue = value.get("value");
                Object showValue = value.get("showValue");
                resultData.put(String.valueOf(x), new ListRowData.Data(realValue, showValue));
            }
            rowDataItem.setData(resultData);
            listRowData.add(rowDataItem);
        }
        result.setFields(fields);
        result.setData(listRowData);
        return result;
    }

    @Override
    public DefaultDataSetList getDataSetList(ContextParam contextParam, DataSetMetadata dataSetMetadata, String[] versions) throws BusinessException {
        HashMap<String, Object> condition = new HashMap<String, Object>();
        String parentID = ParamUtil.getString(dataSetMetadata.getAttributes(), (String)OWNER_TYPE, (String)"");
        condition.put("serviceType", parentID);
        condition.put("subType", MagicEnums.BusinessMethodType.RELATION.getName());
        if (MagicEnums.ServiceOwnerType.DEFAULT_REPORT.getType().equals(parentID)) {
            condition.put("category", ApplicationCategoryEnum.global.name());
        }
        List<ServiceSummary> serviceSummaries = this.magicAjaxHandleService.loadAllAvailableService(condition);
        DefaultDataSetList result = new DefaultDataSetList();
        if (serviceSummaries.size() > 1) {
            for (int x = 1; x < serviceSummaries.size(); ++x) {
                ServiceSummary o = serviceSummaries.get(x);
                if (o.isCategory()) continue;
                DefaultDataSetList.Node node = new DefaultDataSetList.Node();
                node.setId(o.getId());
                node.setName(o.getName());
                node.setParentId(parentID);
                DataSetMetadata metadata = new DataSetMetadata();
                if (MagicEnums.ServiceOwnerType.DEFAULT_REPORT.getType().equals(parentID)) {
                    metadata.attr("id", o.getId());
                } else {
                    metadata.attr("businessId", o.getBusinessId());
                    metadata.attr("versionId", o.getVersion());
                    metadata.attr("methodName", o.getServiceName());
                }
                node.setFullName(o.getName());
                metadata.attr("otherAttr", o.getOtherAttr());
                metadata.attr(OWNER_TYPE, parentID);
                metadata.setUuid(this.uuid());
                node.setMetadata(metadata);
                result.addNode(node);
            }
        }
        return result;
    }

    public int getSortOrder() {
        return 3;
    }

    @Override
    public DefaultDataSetList getDataSetList(ContextParam contextParam, String[] versions) throws BusinessException {
        DefaultDataSetList result = new DefaultDataSetList();
        HashMap<String, Object> condition = new HashMap<String, Object>();
        condition.put("handleType", MagicEnums.BusinessMethodType.RELATION_SYS.getName() + "," + MagicEnums.BusinessMethodType.RELATION.getName() + "," + MagicEnums.BusinessMethodType.RELATION_USER.getName());
        List<OutServiceInfo> infoList = this.magicAjaxHandleService.loadOutServices(condition);
        for (OutServiceInfo o : infoList) {
            if (MagicEnums.ServiceOwnerType.DEFAULT_FORM.getType().equals(o.getIdentity())) continue;
            DefaultDataSetList.Node node = new DefaultDataSetList.Node();
            node.setId(o.getIdentity());
            DataSetMetadata metadata = new DataSetMetadata();
            metadata.setUuid(this.uuid());
            metadata.attr(OWNER_TYPE, o.getIdentity());
            node.setMetadata(metadata);
            if (MagicEnums.ServiceOwnerType.DEFAULT_REPORT.getType().equals(o.getIdentity())) {
                node.setName(ResourceUtil.getString((String)"cap.magic.globalreport.lebel"));
            } else {
                node.setName(o.getName());
            }
            result.addNode(node);
        }
        return result;
    }

    public IMagicServiceSummaryDao getMagicServiceSummaryDao() {
        return this.magicServiceSummaryDao;
    }

    public void setMagicServiceSummaryDao(IMagicServiceSummaryDao magicServiceSummaryDao) {
        this.magicServiceSummaryDao = magicServiceSummaryDao;
    }

    public IMagicInterfaceDefineDao getMagicInterfaceDefineDao() {
        return this.magicInterfaceDefineDao;
    }

    public void setMagicInterfaceDefineDao(IMagicInterfaceDefineDao magicInterfaceDefineDao) {
        this.magicInterfaceDefineDao = magicInterfaceDefineDao;
    }

    public IMagicReflectionRelationDao getMagicReflectionRelationDao() {
        return this.magicReflectionRelationDao;
    }

    public void setMagicReflectionRelationDao(IMagicReflectionRelationDao magicReflectionRelationDao) {
        this.magicReflectionRelationDao = magicReflectionRelationDao;
    }

    public IMagicAjaxHandleService getMagicAjaxHandleService() {
        return this.magicAjaxHandleService;
    }

    public void setMagicAjaxHandleService(IMagicAjaxHandleService magicAjaxHandleService) {
        this.magicAjaxHandleService = magicAjaxHandleService;
    }

    public IMagicProviderDao getMagicProviderDao() {
        return this.magicProviderDao;
    }

    public void setMagicProviderDao(IMagicProviderDao magicProviderDao) {
        this.magicProviderDao = magicProviderDao;
    }

    public ReportFacadeManagerApi getReportFacadeManagerApi() {
        return this.reportFacadeManagerApi;
    }

    public void setReportFacadeManagerApi(ReportFacadeManagerApi reportFacadeManagerApi) {
        this.reportFacadeManagerApi = reportFacadeManagerApi;
    }
}

