/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.magic.utils;

import com.seeyon.apps.collaboration.api.CollaborationApi;
import com.seeyon.apps.collaboration.constants.ColConstant;
import com.seeyon.apps.collaboration.po.ColSummary;
import com.seeyon.cap4.form.bean.FormAuthViewBean;
import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormDataBean;
import com.seeyon.cap4.form.bean.FormDataMasterBean;
import com.seeyon.cap4.form.bean.FormDataSubBean;
import com.seeyon.cap4.form.bean.FormFieldBean;
import com.seeyon.cap4.form.bean.FormFieldComEnum;
import com.seeyon.cap4.form.bean.FormFormulaBean;
import com.seeyon.cap4.form.bean.FormQueryWhereClause;
import com.seeyon.cap4.form.bean.FormRelationshipMapBean;
import com.seeyon.cap4.form.bean.FormTableBean;
import com.seeyon.cap4.form.bean.FormTriggerActionBean;
import com.seeyon.cap4.form.bean.FormTriggerBean;
import com.seeyon.cap4.form.bean.SimpleObjectBean;
import com.seeyon.cap4.form.bean.fieldCtrl.FormFieldMapMarked;
import com.seeyon.cap4.form.bean.fieldCtrl.FormFieldUtil;
import com.seeyon.cap4.form.modules.engin.base.formData.CAP4FormDataDAO;
import com.seeyon.cap4.form.modules.engin.base.formData.CAP4FormDataManager;
import com.seeyon.cap4.form.modules.engin.relation.CAP4FormRelationActionManager;
import com.seeyon.cap4.form.modules.engin.relation.FormRelationEnums;
import com.seeyon.cap4.form.modules.engin.relation.bo.CAP4RelationQueryParamsBO;
import com.seeyon.cap4.form.modules.engin.trigger.CAP4FormTriggerManager;
import com.seeyon.cap4.form.modules.engin.trigger.FormTriggerActionContext;
import com.seeyon.cap4.form.modules.engin.trigger.FormTriggerUtil;
import com.seeyon.cap4.form.service.CAP4FormCacheManager;
import com.seeyon.cap4.form.service.CAP4FormManager;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.cap4.form.util.FormSearchUtil;
import com.seeyon.cap4.form.util.FormUtil;
import com.seeyon.cap4.form.vo.FormTriggerFillBackResultVo;
import com.seeyon.cap4.magic.dao.IMagicInterfaceDefineDao;
import com.seeyon.cap4.magic.dao.IMagicProviderDao;
import com.seeyon.cap4.magic.po.MagicInterfaceDefineEntity;
import com.seeyon.cap4.magic.po.MagicServiceProviderPO;
import com.seeyon.cap4.magic.utils.MagicPrivateUtils;
import com.seeyon.cap4.magic.utils.UpdateArgsEntity;
import com.seeyon.cap4.magic.vo.MagicEnums;
import com.seeyon.cap4.magic.vo.MethodProviderInfo;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.ModuleType;
import com.seeyon.ctp.common.constants.ApplicationCategoryEnum;
import com.seeyon.ctp.common.ctpenumnew.manager.EnumManager;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.filemanager.manager.AttachmentManager;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.po.ctpenumnew.CtpEnumItem;
import com.seeyon.ctp.common.po.template.CtpTemplate;
import com.seeyon.ctp.common.usermessage.MessageContent;
import com.seeyon.ctp.common.usermessage.MessageReceiver;
import com.seeyon.ctp.common.usermessage.UserMessageManager;
import com.seeyon.ctp.form.modules.serialNumber.SerialCalRecordManager;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.FlipInfo;
import com.seeyon.ctp.util.ParamUtil;
import com.seeyon.ctp.util.StringUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.UUIDLong;
import com.seeyon.ctp.util.json.JSONUtil;
import com.seeyon.datamagic.engine.domain.base.DataMagicContext;
import com.seeyon.datamagic.engine.domain.config.EntryConfigItem;
import com.seeyon.datamagic.engine.domain.config.ResultConfigGuide;
import com.seeyon.datamagic.engine.domain.service.ServiceMethodConfig;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.songjian.utils.json.JSONObject;

public class MagicHandleFormUtils {
    private static final Log LOGGER = CtpLogFactory.getLog(MagicHandleFormUtils.class);
    private static EnumManager enumManagerNew = (EnumManager)AppContext.getBean((String)"enumManagerNew");
    private static CAP4FormDataManager cap4FormDataManager = (CAP4FormDataManager)AppContext.getBean((String)"cap4FormDataManager");
    private static CAP4FormCacheManager cap4FormCacheManager = (CAP4FormCacheManager)AppContext.getBean((String)"cap4FormCacheManager");
    private static CAP4FormManager cap4FormManager = (CAP4FormManager)AppContext.getBean((String)"cap4FormManager");
    private static CAP4FormDataDAO cap4FormDataDAO = (CAP4FormDataDAO)AppContext.getBean((String)"cap4FormDataDAO");
    private static UserMessageManager messageManager = (UserMessageManager)AppContext.getBean((String)"userMessageManager");
    private static IMagicProviderDao magicProviderDao = (IMagicProviderDao)AppContext.getBean((String)"magicProviderDao");

    private static Object getEnumValue(long enumId, Object value) throws BusinessException {
        CtpEnumItem item;
        if (enumId != 0L && !StringUtil.checkNull((String)String.valueOf(value)) && (item = enumManagerNew.getCtpEnumItem(Long.valueOf(value.toString()))) != null) {
            return item.getEnumvalue();
        }
        return value;
    }

    public static Map<String, Object> checkUpdateScope(FormTableBean targetSubTableBean, List<Object> param, FormBean formBean) throws BusinessException {
        Object formulaStr = AppContext.getThreadContext((String)"scopeSet");
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (formulaStr == null || Strings.isBlank((String)formulaStr.toString())) {
            return result;
        }
        FormFormulaBean formulaBean = new FormFormulaBean(formBean);
        formulaBean.setIdIfNew();
        formulaBean.loadFromFormula(formulaStr.toString());
        FormQueryWhereClause whereClause = formulaBean.getExecuteFormulaForWhereClauseSQL(formBean, true, true);
        param.addAll(whereClause.getQueryParams());
        String sql = whereClause.getAllSqlClause();
        ArrayList<FormTableBean> containsSubTables = new ArrayList<FormTableBean>();
        String masterShortName = formBean.getMasterTableBean().getTableName().replace(Enums.TableType.MASTER.getTableSufName() + "_", "b");
        for (FormTableBean tableBean : formBean.getTableList()) {
            String shortName;
            if (tableBean.isMainTable()) {
                shortName = tableBean.getTableName().replace(Enums.TableType.MASTER.getTableSufName() + "_", "b");
            } else {
                if (sql.contains(tableBean.getTableName())) {
                    containsSubTables.add(tableBean);
                }
                shortName = tableBean.getTableName().replace(Enums.TableType.SLAVE.getTableSufName() + "_", "b");
            }
            sql = sql.replaceAll(tableBean.getTableName(), shortName);
        }
        if (!containsSubTables.isEmpty()) {
            String subSql = MagicHandleFormUtils.appendSqlIncludeSubTable((FormTableBean)containsSubTables.get(0), formBean.getMasterTableBean().getTableName(), sql);
            sql = masterShortName + ".id in(" + subSql + ")";
        } else {
            sql = " (" + sql + ")";
        }
        result.put("sql", sql);
        return result;
    }

    private static String appendSqlIncludeSubTable(FormTableBean slaveFormTableBean, String masterTableName, String whereStr) {
        String mainShortName = masterTableName.replace(Enums.TableType.MASTER.getTableSufName() + "_", "b");
        String fieldNames = mainShortName + ".id";
        String slaveShortName = slaveFormTableBean.getTableName().replace(Enums.TableType.SLAVE.getTableSufName() + "_", "b");
        StringBuilder sb = new StringBuilder("select ");
        sb.append(fieldNames).append(" from ").append(masterTableName).append(" ").append(mainShortName);
        sb.append(",").append(slaveFormTableBean.getTableName()).append(" ").append(slaveShortName);
        whereStr = mainShortName + ".id=" + slaveShortName + ".formmain_id and " + whereStr;
        sb.append(" where " + whereStr);
        return sb.toString();
    }

    public static String getCorrectData(String businessId, String version, String methodName, String argsName, String data) {
        if (Strings.isBlank((String)data) || Strings.isBlank((String)argsName)) {
            return data;
        }
        try {
            MagicServiceProviderPO currentProvider = magicProviderDao.loadProviders(businessId, version, MagicEnums.ProviderStatus.ON);
            if (currentProvider != null && Strings.isNotBlank((String)currentProvider.getExt1())) {
                Map ext1 = (Map)JSONUtil.parseJSONString((String)currentProvider.getExt1(), Map.class);
                Map datas = (Map)ext1.get(argsName);
                return (String)datas.get(data);
            }
        }
        catch (Exception e) {
            LOGGER.warn((Object)e);
        }
        return data;
    }

    public static List<String> getCorrectDatas(String businessId, String version, String methodName, String argsName, List<String> data) {
        if (data == null || data.isEmpty() || Strings.isBlank((String)argsName)) {
            return Collections.emptyList();
        }
        try {
            MagicServiceProviderPO currentProvider = magicProviderDao.loadProviders(businessId, version, MagicEnums.ProviderStatus.ON);
            ArrayList<String> result = new ArrayList<String>();
            if (currentProvider != null && Strings.isNotBlank((String)currentProvider.getExt1())) {
                Map ext1 = (Map)JSONUtil.parseJSONString((String)currentProvider.getExt1(), Map.class);
                Map datas = (Map)ext1.get(argsName);
                for (String i : data) {
                    String correct = (String)datas.get(i);
                    if (!Strings.isNotBlank((String)correct)) continue;
                    result.add(correct);
                }
            } else {
                result.addAll(data);
            }
            return result;
        }
        catch (Exception e) {
            LOGGER.warn((Object)e);
            return data;
        }
    }

    private MagicHandleFormUtils() {
    }

    public static Map<String, Object> getFeedBackData(Long formId, List<String> maserdataId, String dataRight, Map<String, List<FormFieldBean>> fieldMapper) {
        FormBean fb = cap4FormCacheManager.getForm(formId);
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (fb == null || maserdataId == null || maserdataId.isEmpty() || fieldMapper == null || fieldMapper.isEmpty()) {
            return result;
        }
        try {
            String master = maserdataId.get(0);
            long targetDataId = Long.parseLong(master);
            FormDataMasterBean toMasterBean = cap4FormManager.getDataMasterBeanById(targetDataId, fb, null);
            if (toMasterBean == null) {
                return result;
            }
            List<FormFieldBean> masterBeans = fieldMapper.remove(fb.getMasterTableBean().getTableName());
            for (FormFieldBean formFieldBean : masterBeans) {
                Object value = toMasterBean.getFieldValue(formFieldBean.getName());
                result.put(formFieldBean.getName(), value);
            }
            for (Map.Entry entry : fieldMapper.entrySet()) {
                String subTableName = (String)entry.getKey();
                List subDatas = toMasterBean.getSubData(subTableName);
                List subFields = (List)entry.getValue();
                if (subDatas == null || subDatas.isEmpty() || subFields == null || subFields.isEmpty()) continue;
                ArrayList returnSubData = new ArrayList(subDatas.size());
                for (FormDataSubBean s : subDatas) {
                    HashMap<String, Object> temp = new HashMap<String, Object>();
                    temp.put("id", s.getId());
                    for (FormFieldBean t : subFields) {
                        temp.put(t.getName(), s.getFieldValue(t.getName()));
                    }
                    returnSubData.add(temp);
                }
                result.put(subTableName, returnSubData);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public static List<Map<String, Object>> triggerDistribute(DataMagicContext context, FormBean toFormBean) {
        return Collections.emptyList();
    }

    public static List<Map<String, Object>> updateUnflowData(DataMagicContext context, FormBean toFormBean, boolean newline, boolean remindUser, UpdateArgsEntity fillBack, FormAuthViewBean authViewBean) {
        ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>();
        try {
            FormTableBean toTableBean;
            List<Map<String, Object>> subData;
            String subName;
            HashMap<String, Map<Long, Set<Long>>> attachmentMap = new HashMap<String, Map<Long, Set<Long>>>();
            FormTriggerActionContext actionContext = (FormTriggerActionContext)context.getExtAttrs().get("triggerContext");
            String prewrite = (String)context.getExtAttrs().get("prewrite");
            Map<String, Object> filbackMaster = fillBack.getMasterData();
            Set<String> fillBackFieldList = MagicHandleFormUtils.getFillBackFieldList(actionContext, "1".equals(prewrite));
            Long sourceDataId = fillBack.getSourceDataId();
            FormDataMasterBean tempMasterD = cap4FormDataDAO.selectDataByMasterId(sourceDataId, toFormBean, null);
            if (tempMasterD == null) {
                return results;
            }
            for (Map.Entry<String, Object> entry : filbackMaster.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                if (!key.startsWith("field") || !fillBackFieldList.contains(key)) continue;
                FormFieldBean fieldBean = toFormBean.getFieldBeanByName(key);
                if (fieldBean != null && fieldBean.isAttachment() && !(FormFieldUtil.getFormFieldCtrl((String)fieldBean.getInputType()) instanceof FormFieldMapMarked)) {
                    Long newId = MagicHandleFormUtils.getAttchSubReference(true, attachmentMap, fieldBean, null, null, value);
                    tempMasterD.addFieldValue(key, (Object)newId);
                    continue;
                }
                tempMasterD.addFieldValue(key, value);
            }
            Map<String, List<Map<String, Object>>> fillbackSubData = fillBack.getSubData();
            if (newline) {
                if (fillbackSubData != null && !fillbackSubData.isEmpty()) {
                    for (Map.Entry<String, List<Map<String, Object>>> sub : fillbackSubData.entrySet()) {
                        subName = sub.getKey();
                        subData = sub.getValue();
                        if (subData == null || subData.isEmpty() || (toTableBean = toFormBean.getTableByTableName(subName)) == null) continue;
                        FormTriggerUtil.deleteNullSubData(subName, tempMasterD, false);
                        for (Map<String, Object> item : subData) {
                            try {
                                Long recordId = UUIDLong.longUUID();
                                FormDataSubBean subDataBean = MagicHandleFormUtils.addNewSubBean(tempMasterD, toTableBean, recordId);
                                for (Map.Entry<String, Object> temp1 : item.entrySet()) {
                                    String key = temp1.getKey();
                                    Object value = temp1.getValue();
                                    if (!key.startsWith("field") || !fillBackFieldList.contains(key)) continue;
                                    FormFieldBean fieldBean = toFormBean.getFieldBeanByName(key);
                                    if (fieldBean != null && fieldBean.isAttachment()) {
                                        Long newId = MagicHandleFormUtils.getAttchSubReference(true, attachmentMap, fieldBean, null, null, value);
                                        subDataBean.addFieldValue(key, (Object)newId);
                                        continue;
                                    }
                                    subDataBean.addFieldValue(key, value);
                                }
                                tempMasterD.addSubData(subName, subDataBean);
                            }
                            catch (NumberFormatException e) {
                                LOGGER.warn((Object)"sourceDataId \u4e0d\u80fd\u8f6c\u6362long \u81ea\u52a8\u751f\u6210\u91cd\u590d\u8868ID");
                            }
                        }
                    }
                }
            } else if (fillbackSubData != null && !fillbackSubData.isEmpty()) {
                for (Map.Entry<String, List<Map<String, Object>>> sub : fillbackSubData.entrySet()) {
                    subName = sub.getKey();
                    subData = sub.getValue();
                    if (subData == null || subData.isEmpty() || (toTableBean = toFormBean.getTableByTableName(subName)) == null) continue;
                    for (Map<String, Object> item : subData) {
                        try {
                            Long recordId = ParamUtil.getLong(item, (String)"sourceDataId", (Long)UUIDLong.longUUID());
                            FormDataSubBean subDataBean = tempMasterD.getFormDataSubBeanById(subName, recordId);
                            if (subDataBean == null) {
                                LOGGER.warn((Object)("\u65e0\u6cd5\u627e\u5230\u91cd\u8868\u8bb0\u5f55\u4e3a " + recordId + "\u7684\u6570\u636e  \u65e0\u6cd5\u66f4\u65b0"));
                                continue;
                            }
                            for (Map.Entry<String, Object> temp1 : item.entrySet()) {
                                String key = temp1.getKey();
                                Object value = temp1.getValue();
                                if (!key.startsWith("field") || !fillBackFieldList.contains(key)) continue;
                                FormFieldBean fieldBean = toFormBean.getFieldBeanByName(key);
                                if (fieldBean != null && fieldBean.isAttachment()) {
                                    Long newId = MagicHandleFormUtils.getAttchSubReference(true, attachmentMap, fieldBean, null, null, value);
                                    subDataBean.addFieldValue(key, (Object)newId);
                                    continue;
                                }
                                subDataBean.addFieldValue(key, value);
                            }
                        }
                        catch (NumberFormatException e) {
                            LOGGER.warn((Object)"sourceDataId \u4e0d\u80fd\u8f6c\u6362long \u81ea\u52a8\u751f\u6210\u91cd\u590d\u8868ID");
                        }
                    }
                }
            }
            String string = MagicHandleFormUtils.dealOtherInfoAndValidate(actionContext, toFormBean, authViewBean, null, tempMasterD, "1".equals(prewrite));
            HashMap<String, String> resultData = new HashMap<String, String>();
            if (string == null) {
                MagicHandleFormUtils.dealOtherInfoAfterValidate(context, toFormBean, tempMasterD, actionContext.getModuleId(), attachmentMap);
                FormTriggerUtil.saveDataAndContent(toFormBean, tempMasterD, AppContext.currentUserId(), "");
                resultData.put("success", "1");
                resultData.put("msg", "\u66f4\u65b0\u300a" + toFormBean.getFormName() + "\u300b\u6210\u529f\uff01");
            } else {
                resultData.put("success", "0");
                resultData.put("msg", string);
            }
            results.add(resultData);
        }
        catch (Exception e) {
            HashMap<String, String> resultData = new HashMap<String, String>();
            resultData.put("success", "0");
            resultData.put("msg", e.getLocalizedMessage());
            results.add(resultData);
            LOGGER.warn((Object)"\u66f4\u65b0\u5931\u8d25");
        }
        return results;
    }

    private static Set<String> getFillBackFieldList(FormTriggerActionContext actionContext, boolean prewrite) {
        List holdingFields;
        HashSet<String> result = new HashSet<String>();
        FormTriggerActionBean actionBean = actionContext.getActionBean();
        List fillBackList = (List)actionBean.getParam(FormTriggerBean.ActionParam.FillBack.getKey());
        for (SimpleObjectBean sob : fillBackList) {
            String[] valueArray = sob.getName().split("[.]");
            result.add(valueArray[1]);
        }
        if (prewrite && (holdingFields = actionBean.getWithHoldingFields()) != null) {
            for (SimpleObjectBean s : holdingFields) {
                String[] nameArray = s.getName().split("[.]");
                String[] valueArray = s.getValue().split("[.]");
                result.remove(valueArray[1]);
                result.add(nameArray[1]);
            }
        }
        return result;
    }

    private static FormDataSubBean addNewSubBean(FormDataMasterBean toMasterBean, FormTableBean toTableBean, Long recordId) {
        HashMap<String, Long> valueMap = new HashMap<String, Long>();
        valueMap.put(Enums.SubTableField.id.getKey(), recordId);
        valueMap.put(Enums.SubTableField.formmain_id.getKey(), toMasterBean.getId());
        return new FormDataSubBean(valueMap, toTableBean, toMasterBean, new boolean[]{true});
    }

    @Deprecated
    public static List<FormDataMasterBean> query(DataMagicContext context, FormBean toFormBean, Map<String, Object> condition) {
        LinkedList<FormDataMasterBean> result = new LinkedList<FormDataMasterBean>();
        ArrayList<Object> paramSQL = new ArrayList<Object>();
        ArrayList<Object> paramSQL4enum = new ArrayList<Object>();
        StringBuilder whereSb = new StringBuilder();
        FormTableBean targetSubTableBean = null;
        String sql = null;
        for (Map.Entry<String, Object> entity : condition.entrySet()) {
            String key = entity.getKey();
            FormFieldBean ffb = toFormBean.getFieldBeanByName(key);
            if (ffb == null) continue;
            try {
                whereSb.append(key).append(" = ").append("? ");
                whereSb.append(" and ");
                paramSQL.add(entity.getValue());
                paramSQL4enum.add(MagicHandleFormUtils.getEnumValue(toFormBean.getFieldBeanByName(key).getEnumId(), entity.getValue()));
                if (ffb.isMasterField()) continue;
                String subTableName = ffb.getOwnerTableName();
                targetSubTableBean = toFormBean.getTableByTableName(subTableName);
            }
            catch (BusinessException e) {
                LOGGER.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            catch (NumberFormatException e) {
                LOGGER.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        sql = whereSb.toString();
        sql = sql.substring(0, sql.length() - 4);
        List<Map> queryResult = null;
        try {
            queryResult = cap4FormDataDAO.selectTargetDataId(toFormBean.getMasterTableBean(), targetSubTableBean, sql, paramSQL);
            if (Strings.isEmpty(queryResult)) {
                queryResult = cap4FormDataDAO.selectTargetDataId(toFormBean.getMasterTableBean(), targetSubTableBean, sql, paramSQL4enum);
            }
            if (queryResult != null) {
                for (Map s : queryResult) {
                    FormDataMasterBean targetMasterBean = cap4FormManager.getDataMasterBeanById(Long.valueOf(String.valueOf(s.get("id"))), toFormBean, null);
                    if (targetMasterBean == null) continue;
                    result.add(targetMasterBean);
                }
            }
        }
        catch (BusinessException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (NumberFormatException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public static Map<FormDataMasterBean, List<Long>> queryForUpdate(DataMagicContext context, FormBean toFormBean, Map<String, Object> condition) {
        HashMap<FormDataMasterBean, List<Long>> result = new HashMap<FormDataMasterBean, List<Long>>();
        ArrayList<Object> paramSQL = new ArrayList<Object>();
        ArrayList<Object> paramSQL4enum = new ArrayList<Object>();
        StringBuilder whereSb = new StringBuilder();
        FormTableBean targetSubTableBean = null;
        String sql = null;
        for (Map.Entry<String, Object> entity : condition.entrySet()) {
            String key = entity.getKey();
            FormFieldBean ffb = toFormBean.getFieldBeanByName(key);
            if (ffb == null) continue;
            try {
                whereSb.append(key).append(" = ").append("? ");
                whereSb.append(" and ");
                paramSQL.add(entity.getValue());
                paramSQL4enum.add(MagicHandleFormUtils.getEnumValue(toFormBean.getFieldBeanByName(key).getEnumId(), entity.getValue()));
                if (ffb.isMasterField()) continue;
                String subTableName = ffb.getOwnerTableName();
                targetSubTableBean = toFormBean.getTableByTableName(subTableName);
            }
            catch (BusinessException e) {
                LOGGER.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            catch (NumberFormatException e) {
                LOGGER.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        sql = whereSb.toString();
        sql = sql.substring(0, sql.length() - 4);
        List<Map> queryResult = null;
        try {
            LOGGER.info((Object)("\u6570\u636e\u9b54\u65b9\u89e6\u53d1\u66f4\u65b0   \u6761\u4ef6sql param " + paramSQL));
            queryResult = cap4FormDataDAO.selectTargetDataId(toFormBean.getMasterTableBean(), targetSubTableBean, sql, paramSQL);
            if (Strings.isEmpty(queryResult)) {
                queryResult = cap4FormDataDAO.selectTargetDataId(toFormBean.getMasterTableBean(), targetSubTableBean, sql, paramSQL4enum);
            }
            if (queryResult != null) {
                for (Map s : queryResult) {
                    FormDataMasterBean targetMasterBean = cap4FormManager.getDataMasterBeanById(Long.valueOf(String.valueOf(s.get("id"))), toFormBean, null);
                    if (targetMasterBean == null) continue;
                    if (s.containsKey("slave_id")) {
                        Long subId = Long.valueOf(String.valueOf(s.get("slave_id")));
                        ArrayList<Long> subIds = (ArrayList<Long>)result.get(targetMasterBean);
                        if (subIds == null) {
                            subIds = new ArrayList<Long>();
                            result.put(targetMasterBean, subIds);
                        }
                        if (subIds.contains(subId)) continue;
                        subIds.add(subId);
                        continue;
                    }
                    result.put(targetMasterBean, new ArrayList());
                }
            }
        }
        catch (BusinessException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (NumberFormatException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public static List<Map<String, Object>> saveFlowDataBean(DataMagicContext context, List<FormDataMasterBean> masterBeans, FormBean toFormBean, CtpTemplate template, Long sourceDataId, Map<String, Map<Long, Set<Long>>> attachmentMap) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        CollaborationApi service = (CollaborationApi)AppContext.getBean((String)"collaborationApi");
        String templateName = template.getSubject();
        CAP4FormDataManager cap4FormDataManager = (CAP4FormDataManager)AppContext.getBean((String)"cap4FormDataManager");
        HashSet<Long> senders = new HashSet<Long>();
        try {
            cap4FormDataManager.insertMasterData(masterBeans);
            for (FormDataMasterBean targetMasterBean : masterBeans) {
                Object startMember = targetMasterBean.getFieldValue(Enums.MasterTableField.start_member_id.getKey());
                Long sender = Long.parseLong(startMember.toString());
                senders.add(sender);
                MagicHandleFormUtils.dealOtherInfoAfterValidate(context, toFormBean, targetMasterBean, sourceDataId, attachmentMap);
                service.transSendColl(ColConstant.SendType.auto, template.getId(), sender, targetMasterBean.getId(), null, targetMasterBean.getId());
                MagicHandleFormUtils.saveUnflowLog(context, toFormBean, true, templateName, null);
                HashMap<String, Object> resultData = new HashMap<String, Object>();
                resultData.put("dataId", targetMasterBean.getId());
                resultData.put("success", "1");
                result.add(resultData);
            }
        }
        catch (BusinessException e1) {
            HashMap<String, String> resultData = new HashMap<String, String>();
            resultData.put("success", "0");
            resultData.put("msg", e1.getLocalizedMessage());
            result.add(resultData);
            LOGGER.error((Object)e1.getMessage(), (Throwable)e1);
            MagicHandleFormUtils.sendFlowErrorMsg((Exception)((Object)e1), context, toFormBean, templateName, senders);
        }
        catch (SQLException e1) {
            HashMap<String, String> resultData = new HashMap<String, String>();
            resultData.put("success", "0");
            resultData.put("msg", e1.getLocalizedMessage());
            result.add(resultData);
            LOGGER.error((Object)e1.getMessage(), (Throwable)e1);
            MagicHandleFormUtils.sendFlowErrorMsg(e1, context, toFormBean, templateName, senders);
        }
        return result;
    }

    public static List<Map<String, Object>> saveUnflowDataBeans(DataMagicContext context, List<FormDataMasterBean> masterBeans, FormBean toFormBean, FormAuthViewBean authViewBean, Long sourceDataId, Map<String, Map<Long, Set<Long>>> attachmentMap) {
        CAP4FormTriggerManager cap4FormTriggerManager = (CAP4FormTriggerManager)AppContext.getBean((String)"cap4FormTriggerManager");
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        if (masterBeans == null) {
            return result;
        }
        try {
            String flag = FormTriggerUtil.validateCheckRule(toFormBean, masterBeans);
            if (Strings.isEmpty((String)flag)) {
                cap4FormDataManager.insertMasterData(masterBeans);
                flag = MagicHandleFormUtils.validateUnique(toFormBean, masterBeans, null, true);
            }
            if (Strings.isNotBlank((String)flag)) {
                MagicHandleFormUtils.sendUnflowErrorMsg(context, toFormBean, flag, true);
                return result;
            }
            for (FormDataMasterBean targetMasterBean : masterBeans) {
                MagicHandleFormUtils.dealOtherInfoAfterValidate(context, toFormBean, targetMasterBean, sourceDataId, attachmentMap);
                FormTriggerUtil.saveDataAndContent(toFormBean, targetMasterBean, AppContext.currentUserId(), "");
                MagicHandleFormUtils.saveUnflowLog(context, toFormBean, true, null, true);
                FormTriggerActionContext actionContext = (FormTriggerActionContext)context.getExtAttrs().get("triggerContext");
                if (actionContext == null) {
                    cap4FormTriggerManager.doTrigger(ModuleType.cap4UnflowForm.getKey(), (long)targetMasterBean.getId(), (long)toFormBean.getId(), authViewBean.getId().toString(), null, false, "magic");
                } else if (actionContext.getFormBean().isFlowForm()) {
                    cap4FormTriggerManager.doTrigger(ModuleType.cap4UnflowForm.getKey(), (long)targetMasterBean.getId(), (long)toFormBean.getId(), authViewBean.getId().toString(), null, false, "magic");
                } else if (actionContext.isTime()) {
                    actionContext.addQuartzDataVo(ModuleType.cap4UnflowForm.getKey(), targetMasterBean.getId(), toFormBean.getId(), authViewBean.getId().toString(), null, false, AppContext.currentUserId(), AppContext.getCurrentUser().getLocale());
                } else if (FormTriggerBean.TriggerType.Distribution.getKey().equals(actionContext.getActionBean().getParam("triggerType"))) {
                    cap4FormTriggerManager.doTrigger(ModuleType.cap4UnflowForm.getKey(), (long)targetMasterBean.getId(), (long)toFormBean.getId(), actionContext.getTriggerBean().getId(), actionContext.getActionBean().getId(), null);
                } else {
                    cap4FormTriggerManager.doTrigger(ModuleType.cap4UnflowForm.getKey(), (long)targetMasterBean.getId(), (long)toFormBean.getId(), authViewBean.getId().toString(), null, false, "magic");
                }
                HashMap<String, Object> resultData = new HashMap<String, Object>();
                resultData.put("dataId", targetMasterBean.getId());
                resultData.put("success", "1");
                result.add(resultData);
            }
        }
        catch (Exception e) {
            HashMap<String, String> resultData = new HashMap<String, String>();
            resultData.put("success", "0");
            resultData.put("msg", e.getLocalizedMessage());
            result.add(resultData);
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            MagicHandleFormUtils.sendUnflowErrorMsg(context, toFormBean, e.getLocalizedMessage(), true);
        }
        return result;
    }

    private static void sendUnflowErrorMsg(DataMagicContext context, FormBean toFormBean, String reason, boolean needSend) {
        Map ext = context.getExtAttrs();
        List errorReceivers = (List)ext.get("errorReceivers");
        String sourceFormName = ParamUtil.getString((Map)ext, (String)"sourceFormName");
        String error = "checkRule".equals(reason) ? "form.baseinfo.checkRule.label" : ("uniqueMarked".equals(reason) ? "form.unique.marked.label" : null);
        String errorMsg = "\u300a" + sourceFormName + "\u300b\u65b0\u5efa\u300a" + toFormBean.getFormName() + "\u300b\u5931\u8d25\uff01\u539f\u56e0\uff1a" + error;
        LOGGER.info((Object)errorMsg);
        if (needSend) {
            if (Strings.isNotBlank((String)error)) {
                errorMsg = "\u300a" + sourceFormName + "\u300b\u65b0\u5efa\u300a" + toFormBean.getFormName() + "\u300b\u5931\u8d25\uff0c\u65b0\u5efa\u7684\u6570\u636e\u4e0d\u7b26\u5408\u8868\u5355" + ResourceUtil.getString((String)error) + "\u7684\u89c4\u5219\u5b9a\u4e49\uff0c\u65b0\u5efa\u8bb0\u5f55\u5931\u8d25\uff01";
            }
            try {
                messageManager.sendSystemMessage(MessageContent.get((String)errorMsg, (Object[])new Object[0]), ApplicationCategoryEnum.cap4Form, 2L, MessageReceiver.get((Long)-1L, (Collection)errorReceivers), new Object[0]);
            }
            catch (Exception e) {
                LOGGER.error((Object)"\u6dfb\u52a0\u65e5\u5fd7\u5f02\u5e38", (Throwable)e);
            }
        }
    }

    public static Long getAttchSubReference(boolean isUpdate, Map<String, Map<Long, Set<Long>>> attachmentMap, FormFieldBean tempField, Object oldSub, Object sourceSub, Object value) throws BusinessException {
        Long newSub = MagicHandleFormUtils.getSubReference(isUpdate, tempField, oldSub, value);
        if (newSub != null && !StringUtil.checkNull((String)String.valueOf(value))) {
            Long subReference;
            Set<Long> tempList;
            Map<Long, Set<Long>> temp = attachmentMap.get(tempField.getName());
            if (temp == null) {
                temp = new HashMap<Long, Set<Long>>();
            }
            if ((tempList = temp.get(subReference = Long.valueOf(Long.parseLong(value.toString())))) == null) {
                tempList = new HashSet<Long>();
            }
            tempList.add(newSub);
            temp.put(subReference, tempList);
            attachmentMap.put(tempField.getName(), temp);
        }
        return newSub;
    }

    private static Long getSubReference(boolean isUpdate, FormFieldBean toFieldBean, Object oldSub, Object sourceSub) {
        Long sub = null;
        if (!StringUtil.checkNull((String)String.valueOf(sourceSub))) {
            sub = UUIDLong.longUUID();
        }
        return sub;
    }

    private static String validateUnique(FormBean toFormBean, List<FormDataMasterBean> masterBeans, FormDataMasterBean oldMasterBean, boolean needUpdateDataState) throws BusinessException, SQLException {
        LOGGER.info((Object)("\u6821\u9a8c\u552f\u4e00\u6807\u8bc6\u524d\u6267\u884c\u6570\u636e\u4fdd\u5b58\uff1a\u8868\u5355id " + toFormBean.getId() + "; \u4eba\u5458id " + AppContext.currentUserId()));
        CAP4FormDataDAO cap4FormDataDAO = (CAP4FormDataDAO)AppContext.getBean((String)"cap4FormDataDAO");
        String result = FormTriggerUtil.validateDataUnique(toFormBean, masterBeans);
        if (Strings.isNotBlank((String)result)) {
            LOGGER.error((Object)"\u552f\u4e00\u6807\u8bc6\u6821\u9a8c\u4e0d\u901a\u8fc7\uff0c\u5220\u9664/\u56de\u6eda\u6570\u636e");
            if (needUpdateDataState) {
                cap4FormDataManager.deleteMasterData(masterBeans);
            } else {
                cap4FormDataManager.insertOrUpdateMasterData(oldMasterBean);
            }
        } else if (needUpdateDataState) {
            for (FormDataMasterBean dataBean : masterBeans) {
                dataBean.setState(Enums.FormDataStateEnum.UNFLOW_UNLOCK.getKey());
            }
            LOGGER.info((Object)"\u552f\u4e00\u6807\u8bc6\u6821\u9a8c\u901a\u8fc7\uff0c\u4fee\u6539\u6570\u636e\u72b6\u6001");
            cap4FormDataDAO.updateDataState2Unlock(masterBeans);
        }
        return result;
    }

    private static void saveUnflowLog(DataMagicContext context, FormBean toFormBean, boolean isSuccess, Object templateName, boolean b) {
    }

    private static void sendFlowErrorMsg(Exception e, DataMagicContext context, FormBean toFormBean, String templateName, Collection<Long> errorReceivers) {
        LOGGER.error((Object)e.getMessage(), (Throwable)e);
        try {
            String msg = "\u53d1\u751f\u5f02\u5e38__" + e.getMessage();
            String formName = ParamUtil.getString((Map)context.getExtAttrs(), (String)"fromName");
            MessageContent messageContent = MessageContent.get((String)(ResourceUtil.getString((String)"form.trigger.triggerSet.actions.error.flow.rule", (Object)formName, (Object)toFormBean.getFormName()) + msg), (Object[])new Object[0]);
            Collection receiver = MessageReceiver.get((Long)-1L, errorReceivers);
            messageManager.sendSystemMessage(messageContent, ApplicationCategoryEnum.cap4Form, 2L, receiver, new Object[0]);
            msg = "\u65b0\u5efa\u6d41\u7a0b\u300a" + templateName + "\u300b\u5931\u8d25\uff01\u539f\u56e0\uff1a" + msg;
            LOGGER.error((Object)msg);
        }
        catch (BusinessException e1) {
            LOGGER.error((Object)e1.getMessage(), (Throwable)e1);
        }
    }

    private static String sendUpdateErrorMsg(FormTriggerActionContext context, FormBean toFormBean, String reason, boolean needSend, boolean withholding) throws BusinessException {
        FormBean formBean = context.getFormBean();
        Set<Long> errorReceivers = context.getErrorReceivers();
        String msg = "\u8868\u5355 " + formBean.getFormName() + " \u540d\u79f0\u4e3a\u3010" + context.getTriggerBean().getName() + "\u3011\u7684\u66f4\u65b0\u5931\u8d25\uff01\uff01 \u539f\u56e0\uff1a";
        if (toFormBean != null) {
            msg = "\u6e90\u8868\u5355 " + formBean.getFormName() + " \u76ee\u6807\u8868 " + toFormBean.getFormName() + "\uff0c\u66f4\u65b0\u8bb0\u5f55\u540d\u79f0\u3010" + context.getTriggerBean().getName() + "\u3011\u672a\u6267\u884c\uff01\uff01 \u539f\u56e0\uff1a";
        }
        String error = "";
        error = reason.contains("checkRule") ? "form.baseinfo.checkRule.label" : "form.unique.marked.label";
        String errorMsg = msg + "\u5931\u8d25\uff0c\u65b0\u5efa\u7684\u6570\u636e\u4e0d\u7b26\u5408\u8868\u5355" + ResourceUtil.getString((String)error) + "\u7684\u89c4\u5219\u5b9a\u4e49\uff0c\u66f4\u65b0\u8bb0\u5f55\u5931\u8d25\uff01";
        LOGGER.error((Object)errorMsg);
        if (needSend) {
            errorMsg = errorMsg.replaceAll("noDataWarn", "");
            if (reason.contains("noDataWarn") || reason.contains("uniqueMarked")) {
                if (context.getActionBean().needNoDataWarn()) {
                    messageManager.sendSystemMessage(MessageContent.get((String)errorMsg, (Object[])new Object[0]), ApplicationCategoryEnum.cap4Form, 2L, MessageReceiver.get((Long)-1L, errorReceivers), new Object[0]);
                }
            } else {
                messageManager.sendSystemMessage(MessageContent.get((String)errorMsg, (Object[])new Object[0]), ApplicationCategoryEnum.cap4Form, 2L, MessageReceiver.get((Long)-1L, errorReceivers), new Object[0]);
            }
        }
        return errorMsg;
    }

    public static FlipInfo getReletionList2Magic(Map<String, Object> params, List<Map<String, Object>> conditions, int page, int pageSize, String selectedToMasterDataId) throws BusinessException {
        FormFieldBean ffb;
        FlipInfo info = new FlipInfo(page, pageSize);
        CAP4FormCacheManager cap4FormCacheManager = (CAP4FormCacheManager)AppContext.getBean((String)"cap4FormCacheManager");
        CAP4FormRelationActionManager cap4FormRelationActionManager = (CAP4FormRelationActionManager)AppContext.getBean((String)"cap4FormRelationActionManager");
        CollaborationApi collaborationApi = (CollaborationApi)AppContext.getBean((String)"collaborationApi");
        long targetFormId = ParamUtil.getLong(params, (String)"targetFormId");
        FormBean toFormBean = cap4FormCacheManager.getForm(targetFormId);
        if (toFormBean == null) {
            info.setData(Collections.emptyList());
            info.setTotal(0);
            return info;
        }
        MethodProviderInfo providerInfo = (MethodProviderInfo)params.get("providerInfo");
        long fromFormId = ParamUtil.getLong(params, (String)"fromFormId", (Long)0L);
        ArrayList<String> customShowFields = new ArrayList<String>();
        String fromRelationAttr = ParamUtil.getString(params, (String)"fromRelationAttr");
        Long fromDataId = ParamUtil.getLong(params, (String)"fromDataId");
        Long fromRecordId = ParamUtil.getLong(params, (String)"fromRecordId");
        CAP4RelationQueryParamsBO cap4RelationQueryParamsBO = new CAP4RelationQueryParamsBO();
        Object fromRelationShip = params.get("formRelationshipMapBean");
        FormRelationshipMapBean formRelationshipMapBean = null;
        if (fromRelationShip != null) {
            formRelationshipMapBean = (FormRelationshipMapBean)fromRelationShip;
            formRelationshipMapBean.getRelationshipBean().setTargetFormId(targetFormId);
            Map<String, Object> resultMapping = providerInfo.getResultMapping();
            FormFormulaBean formFormulaBean = formRelationshipMapBean.getConditionFormula();
            String subTableName = null;
            if (formFormulaBean != null && formRelationshipMapBean.getRelationshipBean().getRelationType() == 2) {
                Map contionFieldMap = FormUtil.getRelationFormulaFieldMap((FormFormulaBean)formFormulaBean);
                for (Map.Entry entry : contionFieldMap.entrySet()) {
                    String fieldName = (String)entry.getValue();
                    FormFieldBean formFieldBean = toFormBean.getFieldBeanByName(fieldName);
                    if (formFieldBean == null || !formFieldBean.isSubField()) continue;
                    subTableName = formFieldBean.getOwnerTableName();
                    break;
                }
                try {
                    List customShowFieldsTemp = (List)params.get("customShowFields");
                    for (String k : customShowFieldsTemp) {
                        ffb = toFormBean.getFieldBeanByName(k);
                        if (ffb == null) continue;
                        if (ffb.isMasterField()) {
                            customShowFields.add(k);
                            continue;
                        }
                        if (subTableName != null && !subTableName.equals(ffb.getOwnerTableName())) continue;
                        customShowFields.add(k);
                    }
                }
                catch (Exception e) {
                    LOGGER.info((Object)e.getLocalizedMessage());
                }
            }
        }
        List relationFieldMap = formRelationshipMapBean == null ? null : formRelationshipMapBean.getRelationFieldMap();
        boolean isRelMasterTable = true;
        if (relationFieldMap != null && !relationFieldMap.isEmpty() && Strings.isNotBlank((String)formRelationshipMapBean.getSelectedField())) {
            String toRelationAttr = (String)((Map)relationFieldMap.get(0)).get(formRelationshipMapBean.getSelectedField());
            FormFieldBean toRelationFieldBean = toFormBean.getFieldBeanByName(toRelationAttr);
            boolean bl = isRelMasterTable = toRelationFieldBean == null ? true : toRelationFieldBean.isMasterField();
        }
        if (conditions != null && !conditions.isEmpty()) {
            ArrayList<Map<String, Object>> checkedCondition = new ArrayList<Map<String, Object>>();
            for (Map<String, Object> c : conditions) {
                Map resultMapping;
                String tempFieldName = ParamUtil.getString(c, (String)"fieldName");
                if (Enums.MasterTableField.getEnumByKey((String)tempFieldName) != null) {
                    checkedCondition.add(c);
                    continue;
                }
                if (!Strings.isNotBlank((String)tempFieldName)) continue;
                if (formRelationshipMapBean.getRelationshipBean().getRelationType() == FormRelationEnums.ViewSelectType.system.getKey()) {
                    resultMapping = (Map)providerInfo.convertMapping().get("condition");
                    if (resultMapping == null || !resultMapping.containsKey(tempFieldName) || resultMapping.get(tempFieldName) == null || (ffb = toFormBean.getFieldBeanByName(tempFieldName = resultMapping.get(tempFieldName).toString())) == null) continue;
                    c.put("fieldName", tempFieldName);
                    c.put("aliasTableName", ffb.getOwnerTableName());
                    checkedCondition.add(c);
                    continue;
                }
                resultMapping = providerInfo.getResultMapping();
                if (!resultMapping.containsKey(tempFieldName) || resultMapping.get(tempFieldName) == null || (ffb = toFormBean.getFieldBeanByName(tempFieldName = resultMapping.get(tempFieldName).toString())) == null) continue;
                c.put("fieldName", tempFieldName);
                c.put("aliasTableName", ffb.getOwnerTableName());
                checkedCondition.add(c);
            }
            conditions = checkedCondition;
        }
        List<Map<String, Object>> queryConditions = FormSearchUtil.getUserConditions(toFormBean, conditions);
        cap4RelationQueryParamsBO.setFromFormId(fromFormId);
        cap4RelationQueryParamsBO.setFromDataId(fromDataId);
        cap4RelationQueryParamsBO.setFromRecordId(fromRecordId);
        cap4RelationQueryParamsBO.setCustomShowFields(customShowFields);
        cap4RelationQueryParamsBO.setFromRelationAttr(fromRelationAttr);
        cap4RelationQueryParamsBO.setFormRelationshipMapBean(formRelationshipMapBean);
        if (MagicPrivateUtils.isNumeric(selectedToMasterDataId)) {
            if (Enums.FormType.processesForm.getKey() == toFormBean.getFormType()) {
                ColSummary colSummary = collaborationApi.getColSummary(Long.valueOf(Long.parseLong(selectedToMasterDataId)));
                cap4RelationQueryParamsBO.setSelectedToMasterDataId(colSummary.getFormRecordid());
            } else {
                cap4RelationQueryParamsBO.setSelectedToMasterDataId(Long.parseLong(selectedToMasterDataId));
            }
        }
        if (isRelMasterTable) {
            cap4FormRelationActionManager.getFormRelationDataList(info, cap4RelationQueryParamsBO, queryConditions);
        } else {
            cap4FormRelationActionManager.getFormRelationSubDataList(info, cap4RelationQueryParamsBO, queryConditions);
        }
        if (info.getData() == null || info.getData().isEmpty()) {
            return info;
        }
        Map<String, Object> relationMapping = providerInfo.getResultMapping();
        ArrayList convertData = new ArrayList(info.getData().size());
        for (int i = 0; i < info.getData().size(); ++i) {
            Map relationData = (Map)info.getData().get(i);
            HashMap newMap = new HashMap();
            newMap.putAll(relationData);
            if (relationMapping != null) {
                for (Map.Entry<String, Object> r : relationMapping.entrySet()) {
                    String key = r.getKey();
                    if (r.getValue() == null) continue;
                    newMap.put(key, relationData.get(r.getValue()));
                }
            }
            convertData.add(newMap);
        }
        info.setData(convertData);
        return info;
    }

    private static void dealOtherInfoAfterValidate(DataMagicContext context, FormBean toFormBean, FormDataMasterBean targetMasterBean, Long sourceDataId, Map<String, Map<Long, Set<Long>>> attachmentMap) throws BusinessException {
        EnumManager enumManagerNew = (EnumManager)AppContext.getBean((String)"enumManagerNew");
        AttachmentManager attachmentManager = (AttachmentManager)AppContext.getBean((String)"attachmentManager");
        for (FormFieldBean field : toFormBean.getAllFieldBeans()) {
            List attValues;
            if (!field.isEnumField() || (attValues = targetMasterBean.getDataList(field.getName())).isEmpty()) continue;
            try {
                for (Object object : attValues) {
                    String objStrVal = String.valueOf(object);
                    if (StringUtil.checkNull((String)objStrVal) || "0".equals(objStrVal)) continue;
                    enumManagerNew.updateEnumItemRef(Long.valueOf(Long.parseLong(objStrVal)));
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)"\u66f4\u65b0\u679a\u4e3e\u72b6\u6001\u5f02\u5e38\u2026\u2026", (Throwable)e);
            }
        }
        List serialRecordList = (List)targetMasterBean.getExtraAttr("serialCalRecords");
        if (Strings.isNotEmpty((Collection)serialRecordList)) {
            SerialCalRecordManager serialCalRecordManager = (SerialCalRecordManager)AppContext.getBean((String)"serialCalRecordManager");
            serialCalRecordManager.save(serialRecordList);
        }
        if (!attachmentMap.isEmpty()) {
            Long oldModuleId = sourceDataId;
            Long newModuleId = targetMasterBean.getId();
            for (Map.Entry entry : attachmentMap.entrySet()) {
                for (Map.Entry en : ((Map)entry.getValue()).entrySet()) {
                    Set set = (Set)en.getValue();
                    for (Long value : set) {
                        attachmentManager.copy(oldModuleId, (Long)en.getKey(), newModuleId, value, Integer.valueOf(ApplicationCategoryEnum.cap4Form.getKey()));
                    }
                }
            }
        }
    }

    private static String dealOtherInfoAndValidate(FormTriggerActionContext context, FormBean toFormBean, FormAuthViewBean authViewBean, FormTriggerFillBackResultVo resultVo, FormDataMasterBean targetMasterBean, boolean withholding) throws BusinessException, SQLException {
        targetMasterBean.setModifyDate((Date)DateUtil.currentTimestamp());
        cap4FormManager.putSessioMasterDataBean(toFormBean, targetMasterBean, false, false);
        SerialCalRecordManager serialCalRecordManager = (SerialCalRecordManager)AppContext.getBean((String)"serialCalRecordManager");
        List serialRecordList = serialCalRecordManager.selectAllByFormData(toFormBean.getId(), targetMasterBean.getId());
        if (Strings.isNotEmpty((Collection)serialRecordList)) {
            targetMasterBean.putExtraAttr("serialCalRecords", serialRecordList);
        }
        cap4FormDataManager.calcAll(toFormBean, targetMasterBean, authViewBean, false, true, true, true);
        if (!withholding && resultVo != null) {
            FormTriggerUtil.dealMapMarked(toFormBean, targetMasterBean, resultVo);
        }
        FormDataMasterBean oldMasterBean = cap4FormManager.getDataMasterBeanById(targetMasterBean.getId(), toFormBean, null);
        String logs = "";
        ArrayList<String> changeFieldList = new ArrayList<String>();
        ArrayList<FormDataMasterBean> masterBeans = new ArrayList<FormDataMasterBean>();
        masterBeans.add(targetMasterBean);
        String flag = FormTriggerUtil.validateCheckRule(toFormBean, masterBeans);
        if (Strings.isEmpty((String)flag) && !withholding) {
            changeFieldList.addAll(targetMasterBean.getModifiedFields((FormDataBean)oldMasterBean));
            cap4FormDataManager.insertOrUpdateMasterData(targetMasterBean);
            flag = MagicHandleFormUtils.validateUnique(toFormBean, masterBeans, changeFieldList, oldMasterBean, false);
        }
        if (Strings.isNotBlank((String)flag)) {
            return MagicHandleFormUtils.sendUpdateErrorMsg(context, toFormBean, flag, true, withholding);
        }
        if (withholding) {
            changeFieldList.addAll(targetMasterBean.getModifiedFields((FormDataBean)oldMasterBean));
            cap4FormDataManager.insertOrUpdateMasterData(targetMasterBean);
        }
        AppContext.putThreadContext((String)("fill_back_logs_" + targetMasterBean.getId()), (Object)logs);
        AppContext.putThreadContext((String)("fill_back_modifyFields_" + targetMasterBean.getId()), changeFieldList);
        return null;
    }

    private static final String validateUnique(FormBean toFormBean, List<FormDataMasterBean> masterBeans, List<String> changeFieldList, FormDataMasterBean oldMasterBean, boolean needUpdateDataState) throws BusinessException, SQLException {
        LOGGER.info((Object)("\u6821\u9a8c\u552f\u4e00\u6807\u8bc6\u524d\u6267\u884c\u6570\u636e\u4fdd\u5b58\uff1a\u8868\u5355id " + toFormBean.getId() + "; \u4eba\u5458id " + AppContext.currentUserId()));
        String result = FormTriggerUtil.validateDataUnique(toFormBean, masterBeans);
        if (Strings.isNotBlank((String)result)) {
            LOGGER.error((Object)"\u552f\u4e00\u6807\u8bc6\u6821\u9a8c\u4e0d\u901a\u8fc7\uff0c\u5220\u9664/\u56de\u6eda\u6570\u636e");
            if (needUpdateDataState) {
                cap4FormDataManager.deleteMasterData(masterBeans);
            } else {
                cap4FormDataManager.insertOrUpdateMasterData(oldMasterBean);
            }
        } else if (needUpdateDataState) {
            for (FormDataMasterBean dataBean : masterBeans) {
                dataBean.setState(Enums.FormDataStateEnum.UNFLOW_UNLOCK.getKey());
            }
            LOGGER.info((Object)"\u552f\u4e00\u6807\u8bc6\u6821\u9a8c\u901a\u8fc7\uff0c\u4fee\u6539\u6570\u636e\u72b6\u6001");
            cap4FormDataDAO.updateDataState2Unlock(masterBeans);
        }
        return result;
    }

    public static final void dealOtherInfoBeforeValidate(FormBean toFormBean, FormDataMasterBean toMasterBean, FormAuthViewBean authViewBean, FormTriggerFillBackResultVo resultVo, boolean isNew) throws BusinessException {
        toMasterBean.setModifyDate((Date)DateUtil.currentTimestamp());
        toMasterBean.putExtraAttr("moduleId", (Object)toMasterBean.getId());
        cap4FormManager.putSessioMasterDataBean(toFormBean, toMasterBean, false, false);
        if (isNew) {
            toMasterBean.putExtraAttr("needProduceValue", "true");
        } else {
            MagicHandleFormUtils.addSerialRecord(toFormBean, toMasterBean);
        }
        if (resultVo == null) {
            resultVo = new FormTriggerFillBackResultVo();
            Map<String, Map<Long, Set<String>>> mapMarkedMap = resultVo.getMapMarkedMap();
            List markeds = toFormBean.getFieldsByType(FormFieldComEnum.MAP_MARKED);
            List locates = toFormBean.getFieldsByType(FormFieldComEnum.MAP_LOCATE);
            markeds.addAll(locates);
            for (FormFieldBean ffb : markeds) {
                Object value = toMasterBean.getFieldValue(ffb.getName());
                if (value == null) continue;
                MagicHandleFormUtils.fillMapMarkedMap(value, mapMarkedMap, ffb, null);
            }
        }
        FormTriggerUtil.dealMapMarked(toFormBean, toMasterBean, resultVo);
        cap4FormDataManager.calcAll(toFormBean, toMasterBean, authViewBean, false, true, true, true);
    }

    private static void fillMapMarkedMap(Object value, Map<String, Map<Long, Set<String>>> mapMarkedMap, FormFieldBean toFieldBean, FormDataSubBean newSubBean) {
        Long subReference;
        Set<String> set;
        if (value == null || Strings.isEmpty((String)String.valueOf(value))) {
            return;
        }
        Map<Long, Set<String>> temp = mapMarkedMap.get(toFieldBean.getName());
        if (temp == null) {
            temp = new HashMap<Long, Set<String>>();
        }
        if ((set = temp.get(subReference = Long.valueOf(Long.parseLong(value.toString())))) == null) {
            set = new HashSet<String>();
        }
        Long newSub = UUIDLong.longUUID();
        String valueStr = newSubBean != null ? newSub + "_" + newSubBean.getId() : newSub + "_0";
        set.add(valueStr);
        temp.put(subReference, set);
        mapMarkedMap.put(toFieldBean.getName(), temp);
    }

    private static void addSerialRecord(FormBean toFormBean, FormDataMasterBean toMasterBean) throws BusinessException {
        SerialCalRecordManager serialCalRecordManager = (SerialCalRecordManager)AppContext.getBean((String)"serialCalRecordManager");
        List serialRecordList = serialCalRecordManager.selectAllByFormData(toFormBean.getId(), toMasterBean.getId());
        if (Strings.isNotEmpty((Collection)serialRecordList)) {
            toMasterBean.putExtraAttr("serialCalRecords", serialRecordList);
        }
    }

    private static void saveUnflowLog(DataMagicContext context, FormBean toFormBean, boolean isSuccess, String templateName, String reason) {
        String msg = reason;
        if (Strings.isBlank((String)templateName)) {
            templateName = toFormBean.getFormName();
        }
        msg = isSuccess ? "\u65b0\u5efa\u6d41\u7a0b\u300a" + templateName + "\u300b\u6210\u529f\uff01" : "\u65b0\u5efa\u6d41\u7a0b\u300a" + templateName + "\u300b\u5931\u8d25\uff01\u539f\u56e0\uff1a" + msg;
        LOGGER.error((Object)msg);
    }

    public static Long getRealityTempalte(String businessId, String versionId, String methodName, Long key) {
        try {
            MagicServiceProviderPO entity = magicProviderDao.loadProviders(businessId, versionId, MagicEnums.ProviderStatus.ON);
            String entryExt1 = entity.getExt1();
            if (entryExt1 != null) {
                Map mapper = (Map)JSONUtil.parseJSONString((String)entryExt1, Map.class);
                JSONObject rightMapper = (JSONObject)mapper.get("templates");
                String keyStr = key.toString();
                if (rightMapper != null && rightMapper.containsKey((Object)keyStr)) {
                    return Long.parseLong(rightMapper.get((Object)keyStr).toString());
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn((Object)("[" + businessId + " " + versionId + " " + methodName + "]\u83b7\u53d6\u6a21\u7248\u6620\u5c04\u5931\u8d25 tempalteId = " + key));
            LOGGER.error((Object)e);
        }
        return key;
    }

    public static Map<String, String> getTempalteMapper(MagicServiceProviderPO entity) {
        Map mapper;
        JSONObject templateMapper;
        HashMap<String, String> result = new HashMap<String, String>();
        if (entity != null && entity.getExt1() != null && (templateMapper = (JSONObject)(mapper = (Map)JSONUtil.parseJSONString((String)entity.getExt1(), Map.class)).get("templates")) != null && !templateMapper.isEmpty()) {
            for (Map.Entry k : templateMapper.entrySet()) {
                result.put((String)k.getKey(), k.getValue().toString());
            }
        }
        return result;
    }

    public static String getRealityRightId(String businessId, String versionId, String methodName, String rightId) {
        try {
            Map mapper;
            JSONObject rightMapper;
            MagicServiceProviderPO entity = magicProviderDao.loadProviders(businessId, versionId, MagicEnums.ProviderStatus.ON);
            String entryExt1 = entity.getExt1();
            if (entryExt1 != null && (rightMapper = (JSONObject)(mapper = (Map)JSONUtil.parseJSONString((String)entryExt1, Map.class)).get("dataRight")) != null && rightMapper.containsKey((Object)rightId)) {
                return rightMapper.get((Object)rightId).toString();
            }
        }
        catch (Exception e) {
            LOGGER.warn((Object)("[" + businessId + " " + versionId + " " + methodName + "]\u83b7\u53d6\u6743\u9650\u6620\u5c04\u5931\u8d25 rightId = " + rightId));
            LOGGER.error((Object)e);
        }
        return rightId;
    }

    public static Map<String, String> getRightIdMapper(MagicServiceProviderPO entity) {
        Map mapper;
        JSONObject rightMapper;
        HashMap<String, String> result = new HashMap<String, String>();
        String entryExt1 = entity.getExt1();
        if (entryExt1 != null && (rightMapper = (JSONObject)(mapper = (Map)JSONUtil.parseJSONString((String)entryExt1, Map.class)).get("dataRight")) != null && !rightMapper.isEmpty()) {
            for (Map.Entry k : rightMapper.entrySet()) {
                result.put((String)k.getKey(), k.getValue().toString());
            }
        }
        return result;
    }

    public static long getProviderFormId(String businessId, String versionId, String methodName) {
        try {
            MagicServiceProviderPO entity = magicProviderDao.loadProviders(businessId, versionId, MagicEnums.ProviderStatus.ON);
            if (entity != null && MagicPrivateUtils.isNumeric(entity.getSource())) {
                return Long.parseLong(entity.getSource());
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getLocalizedMessage());
        }
        return 0L;
    }

    public static Map<String, String> getFormTableMapping(String businessId, String versionId, String methodName, boolean reverse) {
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            MagicServiceProviderPO entity = magicProviderDao.loadProviders(businessId, versionId, MagicEnums.ProviderStatus.ON);
            if (entity != null) {
                return MagicHandleFormUtils.getFormTableMapping(methodName, reverse, entity);
            }
        }
        catch (Exception e) {
            LOGGER.warn((Object)("[" + businessId + " " + versionId + " " + methodName + "]\u83b7\u53d6\u8868\u5355table\u6620\u5c04\u5931\u8d25"));
            LOGGER.error((Object)e);
        }
        return result;
    }

    public static String replaceFilterConditionFormRelation(String businessId, String versionId, String methodName, String relationSql) {
        try {
            IMagicInterfaceDefineDao magicInterfaceDefineDao = (IMagicInterfaceDefineDao)AppContext.getBean((String)"magicInterfaceDefineDao");
            MagicServiceProviderPO entity = magicProviderDao.loadProviders(businessId, versionId, MagicEnums.ProviderStatus.ON);
            MethodProviderInfo providerInfo = new MethodProviderInfo(entity, methodName);
            MagicInterfaceDefineEntity serviceEntity = magicInterfaceDefineDao.loadDefineById(businessId, versionId, methodName);
            ServiceMethodConfig ms = MagicPrivateUtils.convertToMethod(serviceEntity);
            ResultConfigGuide resultConfigGuide = ms.getResultConfigGuide();
            FormBean fb = cap4FormCacheManager.getForm(Long.parseLong(entity.getSource()));
            if (fb == null) {
                return relationSql;
            }
            if (resultConfigGuide != null && resultConfigGuide.getConfigList() != null) {
                Map<String, Object> resultMapping = providerInfo.getResultMapping();
                if (resultMapping == null) {
                    resultMapping = new HashMap<String, Object>();
                }
                for (EntryConfigItem rci : resultConfigGuide.getConfigList()) {
                    Map setInfo = rci.getOtherConfig();
                    String fieldName = ParamUtil.getString((Map)setInfo, (String)"name", (String)"");
                    String formFieldName = ParamUtil.getString(resultMapping, (String)fieldName, (String)"");
                    FormFieldBean ffb = fb.getFieldBeanByName(formFieldName);
                    if (ffb == null) continue;
                    String ownerTableName = ParamUtil.getString((Map)setInfo, (String)"ownerTableName", (String)"");
                    relationSql = relationSql.replace(ownerTableName + "." + fieldName, ffb.getOwnerTableName() + "." + ffb.getName());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return relationSql;
    }

    public static Map<String, String> getFormTableMapping(String methodName, boolean reverse, MagicServiceProviderPO entity) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (entity != null && Strings.isNotBlank((String)entity.getExt1())) {
            MethodProviderInfo methodProviderInfo = new MethodProviderInfo(entity, methodName);
            if (!methodProviderInfo.isExists()) {
                return Collections.emptyMap();
            }
            Map<String, Object> methodMapper = methodProviderInfo.convertMapping();
            Map rightMapper = (Map)methodMapper.get("tableName");
            if (rightMapper != null) {
                if (reverse) {
                    for (Map.Entry e : rightMapper.entrySet()) {
                        Object value = e.getValue();
                        if (value == null) continue;
                        result.put(value.toString(), (String)e.getKey());
                    }
                } else {
                    for (Map.Entry e : rightMapper.entrySet()) {
                        result.put((String)e.getKey(), e.getValue() == null ? null : e.getValue().toString());
                    }
                }
            }
        }
        if (result.isEmpty() && entity != null) {
            FormBean fb = cap4FormCacheManager.getForm(Long.parseLong(entity.getSource()));
            result.putAll(MagicPrivateUtils.getFormTableDefaultMapping(fb));
        }
        return result;
    }
}

