/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.magic.utils;

import com.seeyon.cap4.magic.manager.MagicProviderInfo;
import com.seeyon.cap4.magic.manager.MagicProviderRegisterServices;
import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.FileUtil;
import com.seeyon.datamagic.engine.loader.PrivateClassLoader;
import com.seeyon.datamagic.engine.utils.GenerateUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.commons.logging.Log;
import org.songjian.utils.StreamUtils;

public class PrivateFileUtils {
    public static final String MAGIC_COMPILER_DIRECTORY = "magic/compiler";
    public static final String MAGIC_EXECUTE_DIRECTORY = "magic/execute";
    public static final String MAGIC_SOURCE_CODE_DIRECTORY = "magic/source";
    public static final String MAGIC_TEMPLATE_DIRECTORY = "magic/template";
    public static final String MAGIC_CONFIG_DIRECTORY = "magic/config";
    public static final String MAGIC_IMPORT_DIRECTORY = "magic/import";
    private static final Log LOGGER = CtpLogFactory.getLog(PrivateFileUtils.class);

    public static PrivateClassLoader getClassLoader(String sBid, String sVid, String tBid, String tVid, List<String> extFiles, Long serviceConfigId) {
        PrivateClassLoader temp = new PrivateClassLoader(PrivateFileUtils.class.getClassLoader());
        File compilerPath = new File(SystemEnvironment.getClassCacheFolder(), MAGIC_EXECUTE_DIRECTORY + File.separator + serviceConfigId);
        temp.addClassPath(compilerPath.getPath());
        try {
            PrivateFileUtils.copyClass2ExecutePath(sBid, sVid, tBid, tVid, extFiles, serviceConfigId);
        }
        catch (Exception e) {
            LOGGER.error((Object)("copy class error :" + e));
        }
        return temp;
    }

    private PrivateFileUtils() {
    }

    public static List<MagicProviderInfo> invokeInitForExternal(File executePath, String initClassName) throws BusinessException {
        try {
            PrivateClassLoader pc = new PrivateClassLoader(PrivateFileUtils.class.getClassLoader());
            pc.addClassPath(executePath.getPath());
            Class classz = pc.loadClass(initClassName);
            MagicProviderRegisterServices mps = (MagicProviderRegisterServices)classz.newInstance();
            List providerInfos = mps.registerProviders("", "");
            return providerInfos;
        }
        catch (Exception e) {
            throw new BusinessException((Throwable)e);
        }
    }

    public static void copyCode(File source, File compilerPath, File executePath) {
        File[] listFiles = source.listFiles();
        if (listFiles != null && listFiles.length > 0) {
            for (File f : listFiles) {
                File targetExePath;
                if (f.isFile()) {
                    FileUtil.copyFile((File)f, (File)new File(compilerPath, f.getName()));
                    FileUtil.copyFile((File)f, (File)new File(executePath, f.getName()));
                    continue;
                }
                File targetCompPath = new File(compilerPath, f.getName());
                if (!targetCompPath.exists()) {
                    targetCompPath.mkdirs();
                }
                if (!(targetExePath = new File(executePath, f.getName())).exists()) {
                    targetExePath.mkdirs();
                }
                PrivateFileUtils.copyCode(f, targetCompPath, targetExePath);
            }
        }
    }

    public static boolean copyClass2ExecutePath(String sBid, String sVid, String tBid, String tVid, List<String> extFiles, Long serviceConfigId) {
        boolean result = false;
        File compilerFile = new File(SystemEnvironment.getClassCacheFolder(), MAGIC_COMPILER_DIRECTORY + File.separator + serviceConfigId);
        File executeFile = new File(SystemEnvironment.getClassCacheFolder(), MAGIC_EXECUTE_DIRECTORY + File.separator + serviceConfigId);
        String seeyonObjPath = GenerateUtils.generateEntityPackage((String)sBid, (String)sVid);
        String seeyonImplPath = GenerateUtils.generateServiceImplPath((String)sBid);
        String thirdObjPath = GenerateUtils.generateEntityPackage((String)tBid, (String)tVid);
        String thirdImplPath = GenerateUtils.generateServiceImplPath((String)tBid);
        try {
            File executeFile4Impl;
            File executeFile4Obj;
            File[] objs;
            LOGGER.info((Object)"\u5f00\u59cbcopy class\u6587\u4ef6  .... ");
            File compilerFile4Obj = new File(compilerFile, seeyonObjPath.replaceAll("[.]", "\\" + File.separator));
            if (compilerFile4Obj.exists() && compilerFile4Obj.isDirectory()) {
                objs = compilerFile4Obj.listFiles();
                executeFile4Obj = new File(executeFile, seeyonObjPath.replaceAll("[.]", "\\" + File.separator));
                LOGGER.info((Object)("\u6587\u4ef6\u5939\u540d :" + compilerFile4Obj.getName()));
                PrivateFileUtils.copyFiles(objs, executeFile4Obj);
            }
            if ((compilerFile4Obj = new File(compilerFile, thirdObjPath.replaceAll("[.]", "\\" + File.separator))).exists() && compilerFile4Obj.isDirectory()) {
                objs = compilerFile4Obj.listFiles();
                LOGGER.info((Object)("\u6587\u4ef6\u5939\u540d :" + compilerFile4Obj.getName()));
                executeFile4Obj = new File(executeFile, thirdObjPath.replaceAll("[.]", "\\" + File.separator));
                PrivateFileUtils.copyFiles(objs, executeFile4Obj);
            }
            if ((compilerFile4Obj = new File(compilerFile, seeyonImplPath.replaceAll("[.]", "\\" + File.separator))).exists() && compilerFile4Obj.isDirectory()) {
                objs = compilerFile4Obj.listFiles();
                LOGGER.info((Object)("\u6587\u4ef6\u5939\u540d :" + compilerFile4Obj.getName()));
                executeFile4Impl = new File(executeFile, seeyonImplPath.replaceAll("[.]", "\\" + File.separator));
                PrivateFileUtils.copyFiles(objs, executeFile4Impl);
            }
            if ((compilerFile4Obj = new File(compilerFile, thirdImplPath.replaceAll("[.]", "\\" + File.separator))).exists() && compilerFile4Obj.isDirectory()) {
                objs = compilerFile4Obj.listFiles();
                LOGGER.info((Object)("\u6587\u4ef6\u5939\u540d :" + compilerFile4Obj.getName()));
                executeFile4Impl = new File(executeFile, thirdImplPath.replaceAll("[.]", "\\" + File.separator));
                PrivateFileUtils.copyFiles(objs, executeFile4Impl);
            }
            if (extFiles != null) {
                for (String ext : extFiles) {
                    String extName = ext.replaceAll("[.]", "\\" + File.separator) + ".class";
                    compilerFile4Obj = new File(compilerFile, extName);
                    if (!compilerFile4Obj.exists() || !compilerFile4Obj.isFile()) continue;
                    File executeFile4Impl2 = new File(executeFile, extName);
                    PrivateFileUtils.copyFile(compilerFile4Obj, executeFile4Impl2);
                }
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private static boolean copyFiles(File[] files, File targetD) throws IOException {
        if (!targetD.exists()) {
            targetD.mkdirs();
        }
        if (files != null && files.length > 0) {
            for (File f : files) {
                if (f.isDirectory()) {
                    File targs = new File(targetD, f.getName());
                    PrivateFileUtils.copyFiles(f.listFiles(), targs);
                    continue;
                }
                File newPath = new File(targetD, f.getName());
                PrivateFileUtils.copyFile(f, newPath);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File oldFile, File file) {
        FileInputStream in = null;
        OutputStream out = null;
        try {
            in = new FileInputStream(oldFile);
            out = new FileOutputStream(file);
            StreamUtils.inputToOutput((InputStream)in, (OutputStream)out);
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            if (out != null) {
                try {
                    out.flush();
                    ((FileOutputStream)out).close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }
}

