/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.magic.vo;

import com.seeyon.cap4.form.bean.FormAuthViewBean;
import com.seeyon.cap4.form.bean.FormFieldComEnum;
import com.seeyon.cap4.form.bean.FormViewBean;
import com.seeyon.cap4.form.modules.engin.trigger.FormTriggerUtil;
import com.seeyon.cap4.form.service.CAP4FormCacheManager;
import com.seeyon.cap4.form.service.CAP4FormManager;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.cap4.interflow.utils.CapInterFlowRelationUtils;
import com.seeyon.cap4.magic.utils.JSONUtils;
import com.seeyon.cap4.magic.vo.DataRightEntity;
import com.seeyon.cap4.magic.vo.MagicEnums;
import com.seeyon.cap4.magic.vo.MagicFormFieldBean;
import com.seeyon.cap4.magic.vo.MagicFormTableBean;
import com.seeyon.cap4.magic.vo.RightAnnotationEntity;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.po.template.CtpTemplate;
import com.seeyon.ctp.common.template.enums.TemplateEnum;
import com.seeyon.ctp.common.template.manager.TemplateManager;
import com.seeyon.ctp.form.bean.FormBean;
import com.seeyon.ctp.form.bean.FormBindAuthBean;
import com.seeyon.ctp.form.bean.FormBindBean;
import com.seeyon.ctp.form.bean.FormFieldBean;
import com.seeyon.ctp.form.bean.FormFieldComBean;
import com.seeyon.ctp.form.bean.FormTableBean;
import com.seeyon.ctp.form.service.FormCacheManager;
import com.seeyon.ctp.form.util.Enums;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;

public class MagicFormBean {
    private MagicEnums.ServiceOwnerType type;
    private com.seeyon.cap4.form.bean.FormBean cap4FormBean;
    private FormBean cap3FormBean;
    private CAP4FormCacheManager cap4FormCacheManager;
    private FormCacheManager formCacheManager;
    private static final Log LOGGER = CtpLogFactory.getLog(MagicFormBean.class);

    public MagicFormBean(MagicEnums.ServiceOwnerType type, long sourceId) {
        this.type = type;
        switch (type) {
            case DEFAULT_FORM: {
                this.cap4FormCacheManager = (CAP4FormCacheManager)AppContext.getBean((String)"cap4FormCacheManager");
                this.cap4FormBean = this.cap4FormCacheManager.getForm(sourceId);
                break;
            }
            case DEFAULT_FORM_CAP3: {
                this.formCacheManager = (FormCacheManager)AppContext.getBean((String)"formCacheManager");
                this.cap3FormBean = this.formCacheManager.getForm(sourceId);
            }
        }
    }

    public Long getOwnerId() {
        switch (this.type) {
            case DEFAULT_FORM: {
                if (this.cap4FormBean != null) {
                    return this.cap4FormBean.getOwnerId();
                }
            }
            case DEFAULT_FORM_CAP3: {
                if (this.cap3FormBean == null) break;
                return this.cap3FormBean.getOwnerId();
            }
        }
        return 0L;
    }

    public boolean isNull() {
        if (this.type == null) {
            return true;
        }
        if (MagicEnums.ServiceOwnerType.DEFAULT_FORM.equals((Object)this.type)) {
            return this.cap4FormBean == null;
        }
        if (MagicEnums.ServiceOwnerType.DEFAULT_FORM_CAP3.equals((Object)this.type)) {
            return this.cap3FormBean == null;
        }
        return true;
    }

    public MagicEnums.ServiceOwnerType getType() {
        return this.type;
    }

    public void setType(MagicEnums.ServiceOwnerType type) {
        this.type = type;
    }

    public com.seeyon.cap4.form.bean.FormBean getCap4FormBean() {
        return this.cap4FormBean;
    }

    public FormBean getCap3FormBean() {
        return this.cap3FormBean;
    }

    public long getId() {
        long id = 0L;
        switch (this.type) {
            case DEFAULT_FORM_CAP3: {
                id = this.cap3FormBean.getId();
                break;
            }
            case DEFAULT_FORM: {
                id = this.cap4FormBean.getId();
                break;
            }
        }
        return id;
    }

    public boolean isFlowForm() {
        switch (this.type) {
            case DEFAULT_FORM_CAP3: {
                return this.cap3FormBean.getFormType() == Enums.FormType.processesForm.getKey();
            }
            case DEFAULT_FORM: {
                return this.cap4FormBean.isFlowForm();
            }
        }
        return false;
    }

    public boolean triggerNeedTemplate() {
        switch (this.type) {
            case DEFAULT_FORM_CAP3: {
                return true;
            }
            case DEFAULT_FORM: {
                return this.cap4FormBean.isFlowForm();
            }
        }
        return false;
    }

    public String getFormName() {
        String name = "";
        switch (this.type) {
            case DEFAULT_FORM_CAP3: {
                name = this.cap3FormBean.getFormName();
                break;
            }
            case DEFAULT_FORM: {
                name = this.cap4FormBean.getFormName();
                break;
            }
        }
        return name;
    }

    public List<MagicFormFieldBean> getAllFieldBeans() {
        List<MagicFormFieldBean> result = null;
        switch (this.type) {
            case DEFAULT_FORM_CAP3: {
                List allFieldBeans = this.cap3FormBean.getAllFieldBeans();
                result = new ArrayList<MagicFormFieldBean>(allFieldBeans.size());
                for (FormFieldBean ffb : allFieldBeans) {
                    MagicFormFieldBean e = new MagicFormFieldBean(this.getType());
                    e.setCap3FormFieldBean(ffb);
                    result.add(e);
                }
                break;
            }
            case DEFAULT_FORM: {
                List all = this.cap4FormBean.getAllFieldBeans();
                result = new ArrayList<MagicFormFieldBean>(all.size());
                for (com.seeyon.cap4.form.bean.FormFieldBean ffb : all) {
                    MagicFormFieldBean e = new MagicFormFieldBean(this.getType());
                    e.setCap4FormFieldBean(ffb);
                    result.add(e);
                }
                break;
            }
            default: {
                result = Collections.emptyList();
            }
        }
        return result;
    }

    private FormFieldBean createFlowTitleNameBean() {
        FormFieldBean fieldBean = new FormFieldBean();
        fieldBean.setName("flowTitleName");
        fieldBean.setDisplay(ResourceUtil.getString((String)"form.relation.member.attr.flowname.label"));
        fieldBean.setFieldType(Enums.FieldType.VARCHAR.getKey());
        fieldBean.setInputType(FormFieldComEnum.TEXT.getKey());
        fieldBean.setInputType(FormFieldComBean.FormFieldComEnum.TEXT.getKey());
        fieldBean.setFieldTypeEnum(FormFieldComBean.FormFieldComEnum.TEXT);
        fieldBean.setFieldLength("255");
        fieldBean.setDigitNum("0");
        fieldBean.setOwnerTableName(this.cap3FormBean.getMasterTableBean().getTableName());
        return fieldBean;
    }

    public List<Map<String, Object>> getAllFieldBeans(int handleType) throws BusinessException {
        LinkedList<Map<String, Object>> result = new LinkedList();
        switch (this.type) {
            case DEFAULT_FORM_CAP3: {
                if (this.cap3FormBean.getFormType() == Enums.FormType.processesForm.getKey() && 1 == handleType) {
                    FormFieldBean fieldBean = this.createFlowTitleNameBean();
                    result.add(this.convertCap3FieldBean(fieldBean));
                }
                ArrayList<FormFieldBean> allFieldBeans = new ArrayList<FormFieldBean>();
                CapInterFlowRelationUtils.filterCAP3MappingFields(this.cap3FormBean, allFieldBeans, null, 1 == handleType ? "relation" : "trigger");
                for (FormFieldBean f : allFieldBeans) {
                    Map<String, Object> json = this.convertCap3FieldBean(f);
                    result.add(json);
                }
                break;
            }
            case DEFAULT_FORM: {
                List all = this.cap4FormBean.getAllFieldBeans();
                if (this.cap4FormBean.isFlowForm() && 1 == handleType) {
                    com.seeyon.cap4.form.bean.FormFieldBean flowTitle = FormTriggerUtil.getSourceFieldBean(this.cap4FormBean, "flowTitleName");
                    flowTitle.setOwnerTableDisplay(this.cap4FormBean.getMasterTableBean().getDisplay());
                    result.add(this.convertCap4FieldBean(flowTitle));
                }
                for (com.seeyon.cap4.form.bean.FormFieldBean f : all) {
                    Map<String, Object> json;
                    if (handleType == 1 && !f.isCustomerCtrl()) {
                        json = this.convertCap4FieldBean(f);
                        result.add(json);
                        continue;
                    }
                    if (handleType == 1) continue;
                    json = this.convertCap4FieldBean(f);
                    result.add(json);
                }
                break;
            }
            default: {
                result = Collections.emptyList();
            }
        }
        return result;
    }

    public List<Map<String, Object>> getAllFieldBeans4JSON() throws BusinessException {
        LinkedList<Map<String, Object>> result = new LinkedList();
        switch (this.type) {
            case DEFAULT_FORM_CAP3: {
                List<MagicFormFieldBean> allFieldBeans = this.getAllFieldBeans();
                for (MagicFormFieldBean f : allFieldBeans) {
                    Map<String, Object> json = this.getFormFieldInfo(f, null);
                    result.add(json);
                }
                break;
            }
            case DEFAULT_FORM: {
                List<MagicFormFieldBean> all = this.getAllFieldBeans();
                for (MagicFormFieldBean f : all) {
                    if (f.getCap4FormFieldBean().isCustomerCtrl()) continue;
                    Map<String, Object> json = this.getFormFieldInfo(f, null);
                    result.add(json);
                }
                break;
            }
            default: {
                result = Collections.emptyList();
            }
        }
        return result;
    }

    private Map<String, Object> convertCap4FieldBean(com.seeyon.cap4.form.bean.FormFieldBean f) {
        HashMap<String, Object> json = new HashMap<String, Object>();
        json.put("ownerTableDisplay", f.getOwnerTableDisplay());
        json.put("digitNum", f.getDigitNum());
        json.put("enumId", f.getEnumId());
        json.put("enumLevel", f.getEnumLevel());
        json.put("fieldLength", f.getFieldLength());
        json.put("fieldType", f.getFieldType());
        json.put("fieldTypeText", f.getFieldType());
        json.put("inputType", f.getInputType());
        json.put("isFinalChild", f.getIsFinalChild());
        json.put("name", f.getName());
        json.put("display", f.getDisplay());
        json.put("externalType", f.getExternalType());
        json.put("ownerTableIndex", f.getOwnerTableIndex());
        json.put("ownerTableName", f.getOwnerTableName());
        if (f.isMasterField()) {
            json.put("ownerTableDisplay", ResourceUtil.getString((String)"form.main.table.label"));
        } else {
            json.put("ownerTableDisplay", ResourceUtil.getString((String)"form.detail.table.label") + f.getOwnerTableIndex());
        }
        HashMap<String, String> extraMap = new HashMap<String, String>();
        extraMap.put("inputTypeText", f.getInputTypeEnum().getText());
        json.put("extraMap", extraMap);
        return json;
    }

    private Map<String, Object> convertCap3FieldBean(FormFieldBean formFieldBean) throws BusinessException {
        HashMap<String, Object> json = new HashMap<String, Object>();
        if (formFieldBean.isMasterField()) {
            json.put("ownerTableDisplay", ResourceUtil.getString((String)"form.main.table.label"));
        } else {
            json.put("ownerTableDisplay", ResourceUtil.getString((String)"cap.magic.cap3.detail.table.label") + formFieldBean.getOwnerTableIndex());
        }
        json.put("digitNum", formFieldBean.getDigitNum());
        json.put("enumId", formFieldBean.getEnumId());
        json.put("enumLevel", formFieldBean.getEnumLevel());
        json.put("fieldLength", formFieldBean.getFieldLength());
        json.put("fieldType", formFieldBean.getFieldType());
        json.put("inputType", formFieldBean.getFinalInputType(true));
        json.put("isFinalChild", formFieldBean.getIsFinalChild());
        json.put("name", formFieldBean.getName());
        json.put("display", formFieldBean.getDisplay());
        json.put("ownerTableIndex", formFieldBean.getOwnerTableIndex());
        json.put("ownerTableName", formFieldBean.getOwnerTableName());
        json.put("externalType", formFieldBean.getExternalType());
        HashMap<String, String> extraMap = new HashMap<String, String>();
        extraMap.put("inputTypeText", formFieldBean.getOutwriteFieldInputType().getText(formFieldBean));
        json.put("extraMap", extraMap);
        return json;
    }

    public MagicFormFieldBean getFieldBeanByName(String fieldName) {
        MagicFormFieldBean result = new MagicFormFieldBean(this.type);
        switch (this.type) {
            case DEFAULT_FORM_CAP3: {
                if ("flowTitleName".equals(fieldName)) {
                    result.setCap3FormFieldBean(this.createFlowTitleNameBean());
                    break;
                }
                result.setCap3FormFieldBean(this.cap3FormBean.getFieldBeanByName(fieldName));
                break;
            }
            case DEFAULT_FORM: {
                if ("flowTitleName".equals(fieldName)) {
                    com.seeyon.cap4.form.bean.FormFieldBean flowTitle = FormTriggerUtil.getSourceFieldBean(this.cap4FormBean, "flowTitleName");
                    flowTitle.setOwnerTableDisplay(this.cap4FormBean.getMasterTableBean().getDisplay());
                    result.setCap4FormFieldBean(flowTitle);
                    break;
                }
                result.setCap4FormFieldBean(this.cap4FormBean.getFieldBeanByName(fieldName));
                break;
            }
        }
        return result;
    }

    public MagicFormTableBean getTableByTableName(String subTableName) {
        MagicFormTableBean result = new MagicFormTableBean(this.type);
        switch (this.type) {
            case DEFAULT_FORM_CAP3: {
                result.setCap3FormTableBean(this.cap3FormBean.getTableByTableName(subTableName));
                break;
            }
            case DEFAULT_FORM: {
                result.setCap4FormTableBean(this.cap4FormBean.getTableByTableName(subTableName));
                break;
            }
        }
        return result;
    }

    public MagicFormTableBean getMasterTableBean() {
        MagicFormTableBean result = new MagicFormTableBean(this.type);
        switch (this.type) {
            case DEFAULT_FORM_CAP3: {
                result.setCap3FormTableBean(this.cap3FormBean.getMasterTableBean());
                break;
            }
            case DEFAULT_FORM: {
                result.setCap4FormTableBean(this.cap4FormBean.getMasterTableBean());
                break;
            }
        }
        return result;
    }

    public List<MagicFormTableBean> getSubTableBean() {
        ArrayList<MagicFormTableBean> result = new ArrayList<MagicFormTableBean>();
        switch (this.type) {
            case DEFAULT_FORM_CAP3: {
                for (FormTableBean ffb : this.cap3FormBean.getSubTableBean()) {
                    MagicFormTableBean mftb = new MagicFormTableBean(this.type);
                    mftb.setCap3FormTableBean(ffb);
                    result.add(mftb);
                }
                break;
            }
            case DEFAULT_FORM: {
                for (com.seeyon.cap4.form.bean.FormTableBean ffb : this.cap4FormBean.getSubTableBean()) {
                    MagicFormTableBean mftb = new MagicFormTableBean(this.type);
                    mftb.setCap4FormTableBean(ffb);
                    result.add(mftb);
                }
                break;
            }
        }
        return result;
    }

    public MagicFormTableBean getFormTableBeanByFieldName(String name) {
        MagicFormTableBean result = new MagicFormTableBean(this.type);
        switch (this.type) {
            case DEFAULT_FORM_CAP3: {
                result.setCap3FormTableBean(this.cap3FormBean.getFormTableBeanByFieldName(name));
                break;
            }
            case DEFAULT_FORM: {
                result.setCap4FormTableBean(this.cap4FormBean.getFormTableBeanByFieldName(name));
                break;
            }
        }
        return result;
    }

    public String getDataRight() {
        switch (this.type) {
            case DEFAULT_FORM_CAP3: {
                return this.getDataRightForCAP3();
            }
            case DEFAULT_FORM: {
                return this.getDataRightForCAP4();
            }
        }
        return "";
    }

    public Map<String, String> getFormTableMapping() {
        HashMap<String, String> result = new HashMap<String, String>();
        switch (this.type) {
            case DEFAULT_FORM_CAP3: {
                if (this.cap3FormBean == null) break;
                for (FormTableBean ftb : this.cap3FormBean.getTableList()) {
                    result.put(ftb.getTableName(), ftb.getTableName());
                }
                break;
            }
            case DEFAULT_FORM: {
                if (this.cap4FormBean == null) break;
                for (com.seeyon.cap4.form.bean.FormTableBean ftb : this.cap4FormBean.getTableList()) {
                    result.put(ftb.getTableName(), ftb.getTableName());
                }
                break;
            }
        }
        return result;
    }

    public List<Map<String, Object>> getDataRight(List<String> viewType) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        if (viewType == null) {
            return result;
        }
        switch (this.type) {
            case DEFAULT_FORM_CAP3: {
                List cap3pcViewList = this.cap3FormBean.getFormViewList(Enums.ViewType.SeeyonForm);
                List cap3phoneViewList = this.cap3FormBean.getFormViewList(Enums.ViewType.Phone);
                cap3pcViewList.addAll(cap3phoneViewList);
                for (com.seeyon.ctp.form.bean.FormViewBean b : cap3pcViewList) {
                    Long viewId = b.getId();
                    String viewShowName = Enums.ViewType.SeeyonForm.getText().equals(b.getFormViewType()) ? ResourceUtil.getString((String)"cap.template.portal.computerEnd") + "." + b.getFormViewName() : ResourceUtil.getString((String)"cap.template.portal.mobileEnd") + "." + b.getFormViewName();
                    for (com.seeyon.ctp.form.bean.FormAuthViewBean t : b.getAllOperations()) {
                        if (t.isDelete() || !viewType.contains(t.getType())) continue;
                        Map<String, Object> i = this.convertRightGuide(viewId + "." + t.getId(), b.getFormViewType(), viewShowName + "." + t.getName());
                        result.add(i);
                    }
                }
                break;
            }
            case DEFAULT_FORM: {
                List pcViewList = this.cap4FormBean.getFormViewList(Enums.ViewType.SeeyonForm);
                List phoneViewList = this.cap4FormBean.getFormViewList(Enums.ViewType.Phone);
                pcViewList.addAll(phoneViewList);
                for (FormViewBean b : pcViewList) {
                    Long viewId = b.getId();
                    String viewShowName = Enums.ViewType.SeeyonForm.getText().equals(b.getFormViewType()) ? ResourceUtil.getString((String)"cap.template.portal.computerEnd") + "." + b.getFormViewName() : ResourceUtil.getString((String)"cap.template.portal.mobileEnd") + "." + b.getFormViewName();
                    for (FormAuthViewBean t : b.getAllOperations()) {
                        if (t.isDelete() || !viewType.contains(t.getType())) continue;
                        Map<String, Object> i = this.convertRightGuide(viewId + "." + t.getId(), b.getFormViewType(), viewShowName + "." + t.getName());
                        result.add(i);
                    }
                }
                break;
            }
        }
        return result;
    }

    private Map<String, Object> convertRightGuide(String id, String viewType, String displayName) {
        HashMap<String, Object> i = new HashMap<String, Object>();
        i.put("id", id);
        i.put("name", id);
        i.put("viewType", viewType);
        i.put("displayName", displayName);
        return i;
    }

    private String getDataRightForCAP4() {
        if (this.cap4FormBean != null) {
            RightAnnotationEntity rae;
            String viewName;
            String viewId;
            List pcViewList = this.cap4FormBean.getFormViewList(Enums.ViewType.SeeyonForm);
            List phoneViewList = this.cap4FormBean.getFormViewList(Enums.ViewType.Phone);
            DataRightEntity ae = new DataRightEntity();
            for (FormViewBean fvb : pcViewList) {
                viewId = String.valueOf(fvb.getId());
                viewName = fvb.getFormViewName();
                for (FormAuthViewBean t : fvb.getAllOperations()) {
                    if (t.isDelete()) continue;
                    rae = this.convertRight(t.getId(), t.getName(), t.getType(), viewId, viewName);
                    ae.addPCRight(rae);
                }
            }
            for (FormViewBean fvb : phoneViewList) {
                viewId = String.valueOf(fvb.getId());
                viewName = fvb.getFormViewName();
                for (FormAuthViewBean t : fvb.getAllOperations()) {
                    if (t.isDelete()) continue;
                    rae = this.convertRight(t.getId(), t.getName(), t.getType(), viewId, viewName);
                    ae.addPhoneRight(rae);
                }
            }
            return JSONUtils.getJSonString(ae);
        }
        return "";
    }

    private RightAnnotationEntity convertRight(Long id, String rightName, String type, String viewId, String viewName) {
        RightAnnotationEntity rae = new RightAnnotationEntity();
        rae.setRightId(String.valueOf(id));
        rae.setViewId(viewId);
        rae.setViewName(viewName);
        rae.setRightName(rightName);
        rae.setType(type);
        return rae;
    }

    private String getDataRightForCAP3() {
        if (this.cap3FormBean != null) {
            RightAnnotationEntity rae;
            String viewName;
            String viewId;
            List pcViewList = this.cap3FormBean.getFormViewList(Enums.ViewType.SeeyonForm);
            List phoneViewList = this.cap3FormBean.getFormViewList(Enums.ViewType.Phone);
            DataRightEntity ae = new DataRightEntity();
            for (com.seeyon.ctp.form.bean.FormViewBean fvb : pcViewList) {
                viewId = String.valueOf(fvb.getId());
                viewName = fvb.getFormViewName();
                for (com.seeyon.ctp.form.bean.FormAuthViewBean t : fvb.getAllOperations()) {
                    if (t.isDelete()) continue;
                    rae = this.convertRight(t.getId(), t.getName(), t.getType(), viewId, viewName);
                    ae.addPCRight(rae);
                }
            }
            for (com.seeyon.ctp.form.bean.FormViewBean fvb : phoneViewList) {
                viewId = String.valueOf(fvb.getId());
                viewName = fvb.getFormViewName();
                for (com.seeyon.ctp.form.bean.FormAuthViewBean t : fvb.getAllOperations()) {
                    if (t.isDelete()) continue;
                    rae = this.convertRight(t.getId(), t.getName(), t.getType(), viewId, viewName);
                    ae.addPhoneRight(rae);
                }
            }
            return JSONUtils.getJSonString(ae);
        }
        return "";
    }

    public List<MagicFormTableBean> getTableList() {
        ArrayList<MagicFormTableBean> result = new ArrayList<MagicFormTableBean>();
        switch (this.type) {
            case DEFAULT_FORM_CAP3: {
                for (FormTableBean ffb : this.cap3FormBean.getTableList()) {
                    MagicFormTableBean mftb = new MagicFormTableBean(this.type);
                    mftb.setCap3FormTableBean(ffb);
                    result.add(mftb);
                }
                break;
            }
            case DEFAULT_FORM: {
                for (com.seeyon.cap4.form.bean.FormTableBean ffb : this.cap4FormBean.getTableList()) {
                    MagicFormTableBean mftb = new MagicFormTableBean(this.type);
                    mftb.setCap4FormTableBean(ffb);
                    result.add(mftb);
                }
                break;
            }
        }
        return result;
    }

    public Map<String, String> getTemplateMapping() {
        HashMap<String, String> temp = new HashMap<String, String>();
        try {
            switch (this.type) {
                case DEFAULT_FORM_CAP3: {
                    FormBindBean bindBean = this.cap3FormBean.getBind();
                    if (this.cap3FormBean.getFormType() == Enums.FormType.processesForm.getKey()) {
                        TemplateManager templateManager = (TemplateManager)AppContext.getBean((String)"templateManager");
                        List allTemplate = templateManager.getCtpTemplates(this.cap3FormBean.getId().longValue(), false);
                        for (CtpTemplate t : allTemplate) {
                            String key = String.valueOf(t.getId());
                            temp.put(key, key);
                        }
                    } else {
                        Map templates = bindBean.getUnFlowTemplateMap();
                        for (Map.Entry entry : templates.entrySet()) {
                            String key = String.valueOf(((FormBindAuthBean)entry.getValue()).getId());
                            temp.put(key, key);
                        }
                    }
                    break;
                }
                case DEFAULT_FORM: {
                    CAP4FormManager cap4FormManager = (CAP4FormManager)AppContext.getBean((String)"cap4FormManager");
                    List<CtpTemplate> templateList = cap4FormManager.getFormSystemTemplate(this.cap4FormBean.getId());
                    for (CtpTemplate template : templateList) {
                        String key = String.valueOf(template.getId());
                        temp.put(key, key);
                    }
                    break;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return temp;
    }

    public Map<String, String> getRightMapping() {
        HashMap<String, String> right = new HashMap<String, String>();
        switch (this.type) {
            case DEFAULT_FORM_CAP3: {
                for (com.seeyon.ctp.form.bean.FormViewBean fvb : this.cap3FormBean.getFormViewList()) {
                    String viewId = String.valueOf(fvb.getId());
                    for (com.seeyon.ctp.form.bean.FormAuthViewBean t : fvb.getAllOperations()) {
                        if (t.isDelete()) continue;
                        String rightId = String.valueOf(t.getId());
                        right.put(viewId + "." + rightId, viewId + "." + rightId);
                    }
                }
                break;
            }
            case DEFAULT_FORM: {
                for (FormViewBean fvb : this.cap4FormBean.getFormViewList()) {
                    String viewId = String.valueOf(fvb.getId());
                    for (FormAuthViewBean t : fvb.getAllOperations()) {
                        if (t.isDelete()) continue;
                        String rightId = String.valueOf(t.getId());
                        right.put(viewId + "." + rightId, viewId + "." + rightId);
                    }
                }
                break;
            }
        }
        return right;
    }

    public Map<String, Object> getFormFieldInfo(MagicFormFieldBean field, MagicEnums.BusinessMethodType methodType) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String chName = "";
        String type = "";
        switch (field.getType()) {
            case DEFAULT_FORM: {
                FormFieldComEnum cap4FieldInputEnum = field.getCap4FormFieldBean().getInputTypeEnum();
                result.put("inputType", cap4FieldInputEnum.getKey());
                result.put("inputTypeText", cap4FieldInputEnum.getText());
                result.put("fieldType", field.getFieldType());
                Enums.FieldType cap4ft = Enums.FieldType.getEnumByKey((String)field.getCap4FormFieldBean().getFieldType());
                if (cap4ft != null) {
                    result.put("fieldTypeText", cap4ft.getText());
                }
                result.put("displayName", field.getDisplay());
                result.put("ownerTableName", field.getOwnerTableName());
                result.put("ownerTableDisplay", field.getCap4FormFieldBean().getOwnerTableDisplay());
                result.put("masterField", field.isMasterField() ? "1" : "0");
                result.put("enumLevel", field.getEnumLevel());
                result.put("value", field.getEnumId());
                result.put("isFinalChild", field.getIsFinalChild() ? "1" : "0");
                result.put("name", field.getName());
                result.put("id", field.getName());
                result.put("fieldLength", field.getFieldLength());
                result.put("digitNum", field.getDigitNum());
                chName = "";
                if (field.isMasterField()) {
                    chName = chName + "[" + ResourceUtil.getString((String)"cap.form.batchOperation.excelDatas.masterTable") + "]" + field.getDisplay();
                } else {
                    MagicFormTableBean subTableBean = this.getFormTableBeanByFieldName(field.getName());
                    chName = chName + "[" + subTableBean.getDisplay() + "]" + field.getDisplay();
                }
                chName = chName + "[" + cap4FieldInputEnum.getText() + "]";
                result.put("displayName", chName);
                break;
            }
            case DEFAULT_FORM_CAP3: {
                FormFieldBean cap3FieldBean = field.getCap3FormFieldBean();
                try {
                    cap3FieldBean = cap3FieldBean.findRealFieldBean();
                }
                catch (BusinessException e) {
                    LOGGER.warn((Object)(cap3FieldBean.getName() + "findRealFieldBean error" + e.getLocalizedMessage()));
                }
                FormFieldComBean.FormFieldComEnum cap3FieldInputEnum = cap3FieldBean.getInputTypeEnum();
                result.put("inputType", cap3FieldBean.getInputTypeEnum().getKey());
                result.put("fieldType", cap3FieldBean.getFieldType());
                result.put("ownerTableName", cap3FieldBean.getOwnerTableName());
                result.put("masterField", cap3FieldBean.isMasterField() ? "1" : "0");
                result.put("inputTypeText", cap3FieldBean.getInputTypeEnum().getText());
                result.put("enumLevel", cap3FieldBean.getEnumLevel());
                result.put("isFinalChild", cap3FieldBean.getIsFinalChild() ? "1" : "0");
                result.put("fieldLength", cap3FieldBean.getFieldLength());
                result.put("ownerTableDisplay", this.getTableByTableName(field.getOwnerTableName()).getDisplay());
                result.put("digitNum", cap3FieldBean.getDigitNum());
                result.put("name", field.getName());
                result.put("id", field.getName());
                result.put("value", field.getEnumId());
                Enums.FieldType cap3ft = Enums.FieldType.getEnumByKey((String)cap3FieldBean.getFieldType());
                if (cap3ft != null) {
                    result.put("fieldTypeText", cap3ft.getText());
                }
                switch (cap3FieldInputEnum) {
                    case RADIO: 
                    case SELECT: {
                        if (FormFieldComBean.FormFieldComEnum.OUTWRITE.equals((Object)cap3FieldInputEnum)) {
                            result.put("value", String.valueOf(field.getCap3FormFieldBean().getFormatEnumId()));
                            result.put("enumLevel", field.getCap3FormFieldBean().getFormatEnumLevel());
                            result.put("isFinalChild", field.getCap3FormFieldBean().isFormatEnumIsFinalChild() ? "1" : "0");
                            break;
                        }
                        result.put("value", String.valueOf(field.getEnumId()));
                        break;
                    }
                }
                type = FormFieldComBean.FormFieldComEnum.PREPAREWRITE.equals((Object)cap3FieldInputEnum) ? FormFieldComBean.FormFieldComEnum.TEXT.getText() : cap3FieldInputEnum.getText();
                if (MagicEnums.BusinessMethodType.TRIGGER_UPDATE.equals((Object)methodType) && FormFieldComBean.FormFieldComEnum.OUTWRITE.getKey().equals(field.getCap3FormFieldBean().getInputType()) && "multiattachment".equals(field.getCap3FormFieldBean().getFormatType())) {
                    result.put("inputTypeText", cap3FieldInputEnum.getText() + "(" + ResourceUtil.getString((String)"cap.template.common.text.append0") + ")");
                    type = cap3FieldInputEnum.getText() + "(" + ResourceUtil.getString((String)"cap.template.common.text.append0") + ")";
                }
                chName = "";
                if (field.isMasterField()) {
                    chName = chName + "[" + ResourceUtil.getString((String)"cap.form.batchOperation.excelDatas.masterTable") + "]" + field.getDisplay();
                } else {
                    MagicFormTableBean subTableBean = this.getFormTableBeanByFieldName(field.getName());
                    chName = chName + "[" + subTableBean.getDisplay() + "]" + field.getDisplay();
                }
                chName = chName + "[" + type + "]";
                result.put("displayName", chName);
                break;
            }
        }
        return result;
    }

    public List<List<Map<String, Object>>> getUniqueFieldList() throws BusinessException {
        ArrayList<List<Map<String, Object>>> uniqueList = new ArrayList<List<Map<String, Object>>>();
        List uniques = null;
        switch (this.type) {
            case DEFAULT_FORM_CAP3: {
                List<List<FormFieldBean>> fieldBeans = CapInterFlowRelationUtils.filterAndConvertUniqueFields(this.cap3FormBean);
                for (List<FormFieldBean> list : fieldBeans) {
                    ArrayList<Map<String, Object>> fieldBeanList = new ArrayList<Map<String, Object>>();
                    for (FormFieldBean f : list) {
                        Map<String, Object> json = this.convertCap3FieldBean(f);
                        fieldBeanList.add(json);
                    }
                    uniqueList.add(fieldBeanList);
                }
                break;
            }
            case DEFAULT_FORM: {
                uniques = this.cap4FormBean.getUniqueFieldList();
                for (List list : uniques) {
                    ArrayList<Map<String, Object>> fieldBeanList = new ArrayList<Map<String, Object>>();
                    for (String fieldName : list) {
                        com.seeyon.cap4.form.bean.FormFieldBean f = this.cap4FormBean.getFieldBeanByName(fieldName);
                        Map<String, Object> json = this.convertCap4FieldBean(f);
                        fieldBeanList.add(json);
                    }
                    uniqueList.add(fieldBeanList);
                }
                break;
            }
        }
        return uniqueList;
    }

    public List<Map<String, Object>> getTemplates() throws BusinessException {
        ArrayList<Map<String, Object>> templates = new ArrayList<Map<String, Object>>();
        switch (this.type) {
            case DEFAULT_FORM: {
                if (!this.cap4FormBean.isFlowForm()) break;
                CAP4FormManager cap4FormManager = (CAP4FormManager)AppContext.getBean((String)"cap4FormManager");
                List<CtpTemplate> templateList = cap4FormManager.getFormSystemTemplate(this.cap4FormBean.getId());
                for (CtpTemplate template : templateList) {
                    if (template.getState().intValue() != TemplateEnum.State.normal.ordinal()) continue;
                    Map<String, Object> object = this.setTemplate(template.getId(), template.getSubject());
                    templates.add(object);
                }
                break;
            }
            case DEFAULT_FORM_CAP3: {
                if (this.cap3FormBean.getFormType() == Enums.FormType.processesForm.getKey()) {
                    TemplateManager templateManager = (TemplateManager)AppContext.getBean((String)"templateManager");
                    List allTemplate = templateManager.getCtpTemplates(this.cap3FormBean.getId().longValue(), false);
                    for (CtpTemplate t : allTemplate) {
                        Map<String, Object> object = this.setTemplate(t.getId(), t.getSubject());
                        templates.add(object);
                    }
                } else {
                    Map formAuthBeans = this.cap3FormBean.getBind().getUnFlowTemplateMap();
                    for (Map.Entry entry : formAuthBeans.entrySet()) {
                        FormBindAuthBean authBean = (FormBindAuthBean)entry.getValue();
                        Map<String, Object> object = this.setTemplate(authBean.getId(), authBean.getName());
                        templates.add(object);
                    }
                }
                break;
            }
        }
        return templates;
    }

    private Map<String, Object> setTemplate(Long id, String displayName) {
        HashMap<String, Object> object = new HashMap<String, Object>();
        object.put("id", id);
        object.put("name", id);
        object.put("displayName", displayName);
        return object;
    }
}

