/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.magic.vo;

import com.seeyon.cap4.form.bean.FormFieldComEnum;
import com.seeyon.cap4.form.bean.FormTableBean;
import com.seeyon.cap4.form.bean.fieldCtrl.FormFieldCtrl;
import com.seeyon.cap4.form.bean.fieldCtrl.FormFieldCustomCtrl;
import com.seeyon.cap4.form.bean.fieldCtrl.FormFieldExtendCtrl;
import com.seeyon.cap4.form.bean.fieldCtrl.FormFieldLineNumber;
import com.seeyon.cap4.form.bean.fieldCtrl.FormFieldMapCtrl;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.cap4.magic.vo.MagicEnums;
import com.seeyon.cap4.magic.vo.MagicFormFieldBean;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.form.bean.FormFieldBean;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

public class MagicFormTableBean {
    private MagicEnums.ServiceOwnerType type;
    private FormTableBean cap4FormTableBean;
    private com.seeyon.ctp.form.bean.FormTableBean cap3FormTableBean;

    public MagicFormTableBean(MagicEnums.ServiceOwnerType type) {
        this.type = type;
    }

    public MagicEnums.ServiceOwnerType getType() {
        return this.type;
    }

    public void setType(MagicEnums.ServiceOwnerType type) {
        this.type = type;
    }

    public FormTableBean getCap4FormTableBean() {
        return this.cap4FormTableBean;
    }

    public void setCap4FormTableBean(FormTableBean cap4FormTableBean) {
        this.cap4FormTableBean = cap4FormTableBean;
    }

    public com.seeyon.ctp.form.bean.FormTableBean getCap3FormTableBean() {
        return this.cap3FormTableBean;
    }

    public void setCap3FormTableBean(com.seeyon.ctp.form.bean.FormTableBean cap3FormTableBean) {
        this.cap3FormTableBean = cap3FormTableBean;
    }

    public String getTableName() {
        switch (this.type) {
            case DEFAULT_FORM_CAP3: {
                return this.cap3FormTableBean.getTableName();
            }
            case DEFAULT_FORM: {
                return this.cap4FormTableBean.getTableName();
            }
        }
        return null;
    }

    public String getDisplay() {
        switch (this.type) {
            case DEFAULT_FORM_CAP3: {
                if (this.cap3FormTableBean.isMainTable()) {
                    return this.cap3FormTableBean.getDisplay();
                }
                return ResourceUtil.getString((String)"form.detail.table.label") + this.cap3FormTableBean.getTableIndex();
            }
            case DEFAULT_FORM: {
                return this.cap4FormTableBean.getDisplay();
            }
        }
        return null;
    }

    public List<MagicFormFieldBean> getFieldsByName() {
        LinkedList<MagicFormFieldBean> list = new LinkedList<MagicFormFieldBean>();
        switch (this.type) {
            case DEFAULT_FORM_CAP3: {
                for (FormFieldBean ffb : this.cap3FormTableBean.getFieldsByName()) {
                    MagicFormFieldBean mffb = new MagicFormFieldBean(this.type);
                    mffb.setCap3FormFieldBean(ffb);
                    list.add(mffb);
                }
                break;
            }
            case DEFAULT_FORM: {
                for (com.seeyon.cap4.form.bean.FormFieldBean ffb : this.cap4FormTableBean.getFieldsByName()) {
                    MagicFormFieldBean mffb = new MagicFormFieldBean(this.type);
                    mffb.setCap4FormFieldBean(ffb);
                    list.add(mffb);
                }
                break;
            }
        }
        return list;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<MagicFormFieldBean> getFieldsByName(String methodType, String filterType) {
        LinkedList<MagicFormFieldBean> list;
        block20: {
            list = new LinkedList<MagicFormFieldBean>();
            switch (this.type) {
                case DEFAULT_FORM_CAP3: {
                    for (FormFieldBean ffb : this.cap3FormTableBean.getFieldsByName()) {
                        MagicFormFieldBean mffb = new MagicFormFieldBean(this.type);
                        mffb.setCap3FormFieldBean(ffb);
                        list.add(mffb);
                    }
                    return list;
                }
                case DEFAULT_FORM: {
                    MagicEnums.BusinessMethodType businessMethodType = MagicEnums.BusinessMethodType.valueOfName((String)methodType);
                    List allFieldBeans = this.cap4FormTableBean.getFieldsByName();
                    if (businessMethodType == null) {
                        for (com.seeyon.cap4.form.bean.FormFieldBean ffb : allFieldBeans) {
                            MagicFormFieldBean mffb = new MagicFormFieldBean(this.type);
                            mffb.setCap4FormFieldBean(ffb);
                            list.add(mffb);
                        }
                        return list;
                    }
                    switch (businessMethodType) {
                        case RELATION: 
                        case RELATION_SYS: 
                        case RELATION_USER: {
                            if ("condition".equals(filterType)) {
                                for (com.seeyon.cap4.form.bean.FormFieldBean ffb : allFieldBeans) {
                                    if (!this.checkFieldCanUseForCondition(ffb)) continue;
                                    MagicFormFieldBean mffb = new MagicFormFieldBean(this.type);
                                    mffb.setCap4FormFieldBean(ffb);
                                    list.add(mffb);
                                }
                            } else {
                                if (!"result".equals(filterType)) return list;
                                for (com.seeyon.cap4.form.bean.FormFieldBean ffb : allFieldBeans) {
                                    if (!this.checkFieldCanUseForRelationFillBack(ffb)) continue;
                                    MagicFormFieldBean mffb = new MagicFormFieldBean(this.type);
                                    mffb.setCap4FormFieldBean(ffb);
                                    list.add(mffb);
                                }
                            }
                            break block20;
                        }
                        case TRIGGER_CREATE: 
                        case TRIGGER_DISTRIBUTE: 
                        case TRIGGER_UPDATE: 
                        case TRIGGER_FEEDBACK: 
                        case QUERY: {
                            if ("condition".equals(filterType)) {
                                for (com.seeyon.cap4.form.bean.FormFieldBean ffb : allFieldBeans) {
                                    if (!this.checkFieldCanUseFormTriggerCondition(ffb)) continue;
                                    MagicFormFieldBean mffb = new MagicFormFieldBean(this.type);
                                    mffb.setCap4FormFieldBean(ffb);
                                    list.add(mffb);
                                }
                            } else {
                                if (!"formData".equals(filterType)) return list;
                                for (com.seeyon.cap4.form.bean.FormFieldBean ffb : allFieldBeans) {
                                    if (!this.checkFieldCanUseForTriggerFillBack(ffb)) continue;
                                    MagicFormFieldBean mffb = new MagicFormFieldBean(this.type);
                                    mffb.setCap4FormFieldBean(ffb);
                                    list.add(mffb);
                                }
                            }
                        }
                    }
                }
            }
        }
        return list;
    }

    private boolean checkFieldCanUseForCondition(com.seeyon.cap4.form.bean.FormFieldBean field) {
        FormFieldCtrl ctrl = field.getFieldCtrl();
        return !(ctrl instanceof FormFieldExtendCtrl) && !(ctrl instanceof FormFieldMapCtrl) && !(ctrl instanceof FormFieldCustomCtrl) && !(ctrl instanceof FormFieldLineNumber);
    }

    private boolean checkFieldCanUseForRelationFillBack(com.seeyon.cap4.form.bean.FormFieldBean field) {
        return !field.isCustomerCtrl();
    }

    private boolean checkFieldCanUseForTriggerFillBack(com.seeyon.cap4.form.bean.FormFieldBean field) {
        if (field.isCustomerCtrl()) {
            return false;
        }
        FormFieldComEnum[] filters = new FormFieldComEnum[]{FormFieldComEnum.MAP_LOCATE, FormFieldComEnum.MAP_PHOTO, FormFieldComEnum.LINE_NUMBER, FormFieldComEnum.CUSTOM_CONTROL};
        HashSet<FormFieldComEnum> filterStr = new HashSet<FormFieldComEnum>(Arrays.asList(filters));
        return !filterStr.contains(field.getInputTypeEnum());
    }

    private boolean checkFieldCanUseFormTriggerCondition(com.seeyon.cap4.form.bean.FormFieldBean field) {
        if (field.isCustomerCtrl()) {
            return false;
        }
        FormFieldComEnum[] filters = new FormFieldComEnum[]{FormFieldComEnum.MAP_LOCATE, FormFieldComEnum.MAP_PHOTO, FormFieldComEnum.LINE_NUMBER, FormFieldComEnum.CUSTOM_CONTROL};
        HashSet<FormFieldComEnum> filterStr = new HashSet<FormFieldComEnum>(Arrays.asList(filters));
        return filterStr.contains(field.getInputTypeEnum()) || !field.getFieldType().equals(Enums.FieldType.LONGTEXT.getKey()) && !field.isAttachment() && !field.isLbs() && !field.isCustomerCtrl() && !field.isMultiOrg();
    }
}

