/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.monitor.cacheMonitor.manager;

import com.seeyon.cap4.cache.CacheEngine;
import com.seeyon.cap4.cache.impl.CAP4DataCacheManager;
import com.seeyon.cap4.cache.impl.CAP4DataCacheMonitor;
import com.seeyon.cap4.cache.inf.ICacheManager;
import com.seeyon.cap4.form.modules.engin.base.formData.CAPFormDataLoaderContext;
import com.seeyon.cap4.form.modules.engin.base.formData.CAPFormDataPojo;
import com.seeyon.cap4.monitor.cacheMonitor.manager.CacheMonitorManager;
import com.seeyon.cap4.monitor.cacheMonitor.vo.CacheLogVo;
import com.seeyon.cap4.monitor.cacheMonitor.vo.DataAsyncVo;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.Datetimes;
import com.seeyon.ctp.util.FlipInfo;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.geode.management.internal.cli.util.JsonUtil;
import org.sqlite.JDBC;

public class CacheMonitorManagerImpl
implements CacheMonitorManager {
    private static final Log LOGGER = CtpLogFactory.getLog(CacheMonitorManagerImpl.class);
    private CAP4DataCacheManager<CAPFormDataPojo, CAPFormDataLoaderContext> fCAP4DataCacheManager;
    public static String dataPath = "";

    private void initCacheManager() {
        ICacheManager<CAPFormDataPojo, CAPFormDataLoaderContext> fManager = CacheEngine.getInstance().getCacheManager(CAPFormDataPojo.class, CAPFormDataLoaderContext.class);
        if (fManager instanceof CAP4DataCacheManager) {
            this.fCAP4DataCacheManager = (CAP4DataCacheManager)fManager;
        }
    }

    @Override
    public Map<String, Object> getCacheMonitorInfo(Map<String, Object> params) throws BusinessException {
        if (this.fCAP4DataCacheManager == null) {
            this.initCacheManager();
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.fCAP4DataCacheManager != null) {
            CAP4DataCacheMonitor fCAP4DataCacheMonitor = this.fCAP4DataCacheManager.getCAP4DataCacheMonitor();
            result.put("name", fCAP4DataCacheMonitor.getCacheType());
            result.put("state", fCAP4DataCacheMonitor.getState());
            result.put("host", "");
            result.put("port", "");
            result.put("connecTime", "");
            result.put("dataAsync", "0");
            String config = fCAP4DataCacheMonitor.getConfig();
            if (config != null && config.length() > 1) {
                String startId;
                Object serverid;
                String ttl;
                Map configMap = JsonUtil.jsonToMap((String)config);
                String logfile = (String)configMap.get("logfile");
                if (logfile != null && logfile.length() != 0) {
                    result.put("logFile", logfile);
                    dataPath = logfile;
                }
                if ((ttl = (String)configMap.get("ttl")) != null && ttl.length() != 0) {
                    result.put("ttl", ttl);
                }
                if ((serverid = (String)configMap.get("serverid")) != null && ((String)serverid).length() != 0) {
                    result.put("serverid", serverid);
                }
                if ((startId = (String)configMap.get("StartId")) != null && startId.length() != 0) {
                    result.put("startId", startId);
                }
                for (String configMapKey : configMap.keySet()) {
                    String connectime;
                    if (configMapKey.indexOf("host") != -1) {
                        String host = (String)configMap.get(configMapKey);
                        if (host == null || host.length() == 0) continue;
                        result.put("host", host);
                        continue;
                    }
                    if (configMapKey.indexOf("port") != -1) {
                        String port = (String)configMap.get(configMapKey);
                        if (port == null || port.length() == 0) continue;
                        result.put("port", port);
                        continue;
                    }
                    if (configMapKey.indexOf("connectime") == -1 || (connectime = (String)configMap.get(configMapKey)) == null || connectime.length() == 0) continue;
                    result.put("connectime", connectime);
                }
            }
            result.put("heartBeatTime", "");
            ArrayList serverList = new ArrayList();
            result.put("serverList", serverList);
            String runInfo = fCAP4DataCacheMonitor.getRunInfo();
            if (runInfo != null && runInfo.length() > 1) {
                Map runInfoMap = JsonUtil.jsonToMap((String)runInfo);
                for (String runInfoMapKey : runInfoMap.keySet()) {
                    if (runInfoMapKey.indexOf("heartbeat") != -1) {
                        String heartBeatTime = (String)runInfoMap.get(runInfoMapKey);
                        if (heartBeatTime == null || heartBeatTime.length() <= 0) continue;
                        result.put("heartBeatTime", heartBeatTime);
                        continue;
                    }
                    if (runInfoMapKey.indexOf("master_info") == -1) continue;
                }
            }
            Connection connection = this.getCacheSqliteConnection();
            ResultSet resultSetTotal = null;
            Statement preparedStatement = null;
            try {
                if (connection != null && !connection.isClosed()) {
                    preparedStatement = connection.prepareStatement("select count(*) from dataasync");
                    resultSetTotal = preparedStatement.executeQuery();
                    int total = 0;
                    if (resultSetTotal.next()) {
                        total = resultSetTotal.getInt(1);
                    }
                    result.put("dataAsync", total);
                }
            }
            catch (SQLException e) {
                throw new BusinessException(e.getMessage());
            }
            finally {
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                    if (resultSetTotal != null) {
                        resultSetTotal.close();
                    }
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (SQLException e1) {
                    throw new BusinessException(e1.getMessage());
                }
            }
            return result;
        }
        return null;
    }

    @Override
    public FlipInfo getLogInfo(FlipInfo info, Map<String, Object> params) throws BusinessException {
        ArrayList<CacheLogVo> cacheLogVoList = new ArrayList<CacheLogVo>();
        Connection connection = null;
        ResultSet resultSet = null;
        Statement preparedStatement = null;
        Statement pStatementTotal = null;
        ResultSet resultSetTotal = null;
        String tableName = "";
        try {
            int limitNumber = info.getSize();
            int offsetNumber = (info.getPage() - 1) * limitNumber;
            connection = this.getCacheSqliteConnection();
            if (connection == null || connection.isClosed()) {
                info.setTotal(0);
                info.setData(cacheLogVoList);
                FlipInfo flipInfo = info;
                return flipInfo;
            }
            String time = (String)params.get("time");
            String selectSql = "";
            String totalSql = "";
            if (time != null) {
                tableName = "connectlog_" + time.replace("-", "_");
                selectSql = "select *from connectlog_" + time.replace("-", "_");
                totalSql = "select count(*) from connectlog_" + time.replace("-", "_");
            } else {
                tableName = "connectlog_" + Datetimes.format((Date)new Date(), (String)"yyyy_MM_dd");
                selectSql = "select *from connectlog_" + Datetimes.format((Date)new Date(), (String)"yyyy_MM_dd");
                totalSql = "select count(*) from connectlog_" + Datetimes.format((Date)new Date(), (String)"yyyy_MM_dd");
            }
            pStatementTotal = connection.prepareStatement(totalSql);
            resultSetTotal = pStatementTotal.executeQuery();
            int total = 0;
            if (resultSetTotal.next()) {
                total = resultSetTotal.getInt(1);
            }
            info.setTotal(total);
            if (offsetNumber > total) {
                info.setPage(1);
                offsetNumber = 0;
            }
            selectSql = selectSql + " order by dtime desc limit " + limitNumber + " offset " + offsetNumber;
            preparedStatement = connection.prepareStatement(selectSql);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                CacheLogVo cacheLogVo = new CacheLogVo();
                cacheLogVo.setConnectId(resultSet.getString("connectid"));
                cacheLogVo.setData(resultSet.getString("ddata"));
                cacheLogVo.setState(resultSet.getString("dstate"));
                cacheLogVo.setTime(resultSet.getString("dtime"));
                cacheLogVoList.add(cacheLogVo);
            }
        }
        catch (SQLException e) {
            String message = e.getMessage();
            if (message.indexOf("no such table") != -1) {
                String error = ResourceUtil.getString((String)"cap.monitor.tips.error1", (Object)tableName.replace("_", "-").replace("connectlog-", ""));
                throw new BusinessException(error);
            }
            LOGGER.error((Object)e);
            throw new BusinessException(e.getMessage());
        }
        finally {
            try {
                if (resultSetTotal != null) {
                    resultSetTotal.close();
                }
                if (resultSet != null) {
                    resultSet.close();
                }
                if (pStatementTotal != null) {
                    pStatementTotal.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                throw new BusinessException(e.getMessage());
            }
        }
        info.setData(cacheLogVoList);
        return info;
    }

    @Override
    public List<DataAsyncVo> getDataAsyncInfo(Map<String, Object> params) throws BusinessException {
        Connection connection = this.getCacheSqliteConnection();
        ResultSet resultSet = null;
        PreparedStatement preparedStatement = null;
        ArrayList<DataAsyncVo> dataAsyncVoList = new ArrayList<DataAsyncVo>();
        if (connection != null) {
            try {
                preparedStatement = connection.prepareStatement("SELECT sid,dtime,pos from dataasync order by dtime desc");
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    DataAsyncVo dataAsyncVo = new DataAsyncVo();
                    dataAsyncVo.setId(resultSet.getString("sid"));
                    dataAsyncVo.setTime(resultSet.getString("dtime"));
                    dataAsyncVo.setPos(resultSet.getString("pos"));
                    dataAsyncVoList.add(dataAsyncVo);
                }
            }
            catch (Exception e) {
                throw new BusinessException(e.getMessage());
            }
            finally {
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception e) {
                    throw new BusinessException(e.getMessage());
                }
            }
        }
        return dataAsyncVoList;
    }

    @Override
    public boolean deleteDataAsyncInfoById(String id) throws BusinessException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        boolean deleteResult = false;
        try {
            connection = this.getCacheSqliteConnection();
            preparedStatement = connection.prepareStatement("delete from dataasync where sid=?");
            preparedStatement.setObject(1, id);
            int t = preparedStatement.executeUpdate();
            connection.commit();
            if (t >= 1) {
                deleteResult = true;
            }
        }
        catch (SQLException sqlException) {
            throw new BusinessException(sqlException.getMessage());
        }
        finally {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                throw new BusinessException(e.getMessage());
            }
        }
        return deleteResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteAllLog(Map<String, Object> params) throws BusinessException {
        Connection connection = null;
        Statement preparedStatement = null;
        ResultSet resultSet = null;
        Statement statement = null;
        try {
            connection = this.getCacheSqliteConnection();
            if (connection != null && !connection.isClosed()) {
                preparedStatement = connection.prepareStatement("SELECT name FROM sqlite_master WHERE type='table' order by name");
                resultSet = preparedStatement.executeQuery();
                String today = Datetimes.format((Date)new Date(), (String)"yyyy_MM_dd");
                ArrayList<String> dropTableSqlList = new ArrayList<String>();
                while (resultSet.next()) {
                    String dropTable;
                    String tableName = resultSet.getString(1);
                    if (tableName.indexOf("connectlog") == -1) continue;
                    if (tableName.indexOf(today) != -1) {
                        dropTable = "delete from  " + tableName;
                        dropTableSqlList.add(dropTable);
                        continue;
                    }
                    dropTable = "DROP TABLE  " + tableName;
                    dropTableSqlList.add(dropTable);
                }
                resultSet.close();
                preparedStatement.close();
                connection.commit();
                statement = connection.createStatement();
                for (String dropSql : dropTableSqlList) {
                    statement.execute(dropSql);
                }
                connection.commit();
            }
            boolean today = true;
            return today;
        }
        catch (SQLException sqlException) {
            LOGGER.error((Object)sqlException);
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                throw new BusinessException(e.getMessage());
            }
        }
        return false;
    }

    private Connection getCacheSqliteConnection() {
        try {
            JDBC sqlite = new JDBC();
            Properties info = new Properties();
            Connection connection = sqlite.connect("jdbc:sqlite:" + dataPath, info);
            connection.setAutoCommit(false);
            return connection;
        }
        catch (SQLException e) {
            LOGGER.error((Object)e);
            return null;
        }
    }
}

