/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.monitor.controller;

import com.seeyon.cap4.form.control.ControlManager;
import com.seeyon.cap4.monitor.po.CapConfigLog;
import com.seeyon.cap4.monitor.po.CapDataLog;
import com.seeyon.cap4.monitor.service.CapLogService;
import com.seeyon.cap4.monitor.service.MonitorConfigService;
import com.seeyon.cap4.monitor.service.SlowSqlService;
import com.seeyon.cap4.monitor.utils.CAP4MonitorUtil;
import com.seeyon.cap4.task.TaskExecuteManager;
import com.seeyon.cap4.validity.service.CloudResourceManager;
import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.common.controller.BaseController;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.monitor.perf.jdbcmonitor.proxyobj.JMProxyDriver;
import com.seeyon.ctp.monitor.perf.jdbcmonitor.proxyobj.JMTrackUtils;
import com.seeyon.ctp.organization.OrgConstants;
import com.seeyon.ctp.util.PropertiesUtil;
import com.seeyon.ctp.util.ReqUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.annotation.CheckRoleAccess;
import java.io.File;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.ModelAndView;

@CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner})
public class MonitorController
extends BaseController {
    private SlowSqlService slowSqlService;
    private TaskExecuteManager taskExecuteManager;
    private MonitorConfigService monitorConfigService;
    private CapLogService capLogService;
    private CloudResourceManager cloudResourceManager;
    private ControlManager controlManager;

    public void setControlManager(ControlManager controlManager) {
        this.controlManager = controlManager;
    }

    public void setCloudResourceManager(CloudResourceManager cloudResourceManager) {
        this.cloudResourceManager = cloudResourceManager;
    }

    public void setCapLogService(CapLogService capLogService) {
        this.capLogService = capLogService;
    }

    public ModelAndView index(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return new ModelAndView("cap4/monitor/main");
    }

    public ModelAndView cloud(HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.controlManager.getAllControls();
        return null;
    }

    public ModelAndView log(HttpServletRequest request, HttpServletResponse response) throws Exception {
        CapConfigLog capConfigLog = new CapConfigLog();
        capConfigLog.setNewId();
        capConfigLog.setOperType(CapConfigLog.OperTypeEnum.createApp.getKey());
        capConfigLog.setOperTypeName(CapConfigLog.OperTypeEnum.createApp.getName());
        capConfigLog.setObjectType(CapConfigLog.ObjectTypeEnum.App.getKey());
        capConfigLog.setObjectId(1L);
        this.capLogService.saveCapConfigLog(capConfigLog);
        CapDataLog capDataLog = new CapDataLog();
        capDataLog.setNewId();
        this.capLogService.saveCapDataLog(capDataLog);
        return null;
    }

    public ModelAndView nav(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModelAndView mav = new ModelAndView("cap4/monitor/nav");
        mav.addObject("taskCount", (Object)this.taskExecuteManager.getTaskEventCount());
        mav.addObject("slowSqlCount", (Object)this.slowSqlService.getSlowSqlLastWeekNumber());
        return mav;
    }

    public ModelAndView slowSQL(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModelAndView mav = new ModelAndView("cap4/monitor/slowSQL");
        return mav;
    }

    public ModelAndView setting(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModelAndView mav = new ModelAndView("cap4/monitor/setting");
        return mav;
    }

    public ModelAndView running(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModelAndView mav = new ModelAndView("cap4/monitor/running");
        return mav;
    }

    public ModelAndView app(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModelAndView mav = new ModelAndView("cap4/monitor/app");
        return mav;
    }

    public ModelAndView form(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModelAndView mav = new ModelAndView("cap4/monitor/form");
        return mav;
    }

    public ModelAndView config(HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.monitorConfigService.loadConfigs();
        return null;
    }

    public ModelAndView showSqlSum(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModelAndView mav = new ModelAndView("cap4/monitor/showSqlSum");
        mav.addObject("sqlSum", (Object)JMTrackUtils.outTrackSQLInfo());
        mav.addObject("timeSum", (Object)JMTrackUtils.outTrackTimeInfo());
        return mav;
    }

    public ModelAndView capTrackBusiness(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String folder;
        File dbConfig;
        Properties properties;
        Object driverClassName;
        ModelAndView mav = new ModelAndView("cap4/monitor/capTrack/capTrackBusiness");
        int historyobjFileLength = CAP4MonitorUtil.getTrackFiles("historyobj").length;
        int trackSaveFileLength = CAP4MonitorUtil.getTrackFiles("tracksave").length;
        mav.addObject("formDataLength", (Object)historyobjFileLength);
        mav.addObject("businessLength", (Object)trackSaveFileLength);
        boolean status = CAP4MonitorUtil.checkTrackStatus();
        mav.addObject("status", (Object)status);
        if (!(status || (driverClassName = (properties = PropertiesUtil.getFromFile((File)(dbConfig = new File(folder = SystemEnvironment.getBaseFolder(), "conf/datasourceCtp.properties")))).get("ctpDataSource.driverClassName")) != null && JMProxyDriver.class.getName().equals(driverClassName.toString()))) {
            String msg = ResourceUtil.getString((String)"cap.monitor.track.error1", (Object)JMProxyDriver.class.getName());
            mav.addObject("errorMsg", (Object)msg);
        }
        return mav;
    }

    public ModelAndView showSql(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String tags = ReqUtil.getString((HttpServletRequest)request, (String)"tags", (String)"");
        String sqls = "";
        if (Strings.isNotEmpty((String)tags)) {
            sqls = JMTrackUtils.printTrackSQLInfo((String[])tags.split(","));
        }
        ModelAndView mav = new ModelAndView("cap4/monitor/showSql");
        mav.addObject("sqlInfo", (Object)sqls);
        return mav;
    }

    public void setSlowSqlService(SlowSqlService slowSqlService) {
        this.slowSqlService = slowSqlService;
    }

    public void setTaskExecuteManager(TaskExecuteManager taskExecuteManager) {
        this.taskExecuteManager = taskExecuteManager;
    }

    public void setMonitorConfigService(MonitorConfigService monitorConfigService) {
        this.monitorConfigService = monitorConfigService;
    }
}

