/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.monitor.dao;

import com.seeyon.cap4.monitor.dao.BaseDaoImpl;
import com.seeyon.cap4.monitor.dao.CapLogDao;
import com.seeyon.cap4.monitor.po.CapConfigLog;
import com.seeyon.cap4.monitor.po.CapDataLog;
import com.seeyon.cap4.monitor.po.CapLog;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.util.DBAgent;
import com.seeyon.ctp.util.FlipInfo;
import com.seeyon.ctp.util.ParamUtil;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class CapLogDaoImpl
extends BaseDaoImpl
implements CapLogDao {
    @Override
    public void insertCapDataLog(CapDataLog capDataLog) throws BusinessException {
        this.loadProps(capDataLog);
        DBAgent.save((Object)((Object)capDataLog));
    }

    @Override
    public void insertCapDataLogs(List<CapDataLog> capDataLogs) throws BusinessException {
        for (CapDataLog capDataLog : capDataLogs) {
            this.loadProps(capDataLog);
        }
        DBAgent.saveAll(capDataLogs);
    }

    @Override
    public void insertCapConfigLog(CapConfigLog capConfigLog) throws BusinessException {
        this.loadProps(capConfigLog);
        DBAgent.save((Object)((Object)capConfigLog));
    }

    @Override
    public void insertCapConfigLogs(List<CapConfigLog> capConfigLogs) throws BusinessException {
        for (CapConfigLog capConfigLog : capConfigLogs) {
            this.loadProps(capConfigLog);
        }
        DBAgent.saveAll(capConfigLogs);
    }

    @Override
    public List<CapDataLog> getDataLogs(FlipInfo fi, Map<String, Object> params) throws BusinessException {
        StringBuilder hql = new StringBuilder("FROM CapDataLog ss WHERE 1=1");
        if (params != null && params.size() != 0) {
            this.jointHql(params, hql);
        }
        hql.append(" order by ss.operTime desc");
        return DBAgent.find((String)hql.toString(), params, (FlipInfo)fi);
    }

    @Override
    public List<CapConfigLog> getConfigLogs(FlipInfo fi, Map<String, Object> params) throws BusinessException {
        StringBuilder hql = new StringBuilder("FROM CapConfigLog ss WHERE 1=1");
        if (params != null && params.size() != 0) {
            this.jointHql(params, hql);
        }
        hql.append(" order by ss.operTime desc");
        return DBAgent.find((String)hql.toString(), params, (FlipInfo)fi);
    }

    private void jointHql(Map<String, Object> params, StringBuilder hql) {
        if (params.containsKey("operDescription")) {
            hql.append(" AND ss.operDescription like :operDescription");
            params.put("operDescription", "%" + params.get("operDescription") + "%");
        }
        if (params.containsKey("objectName")) {
            hql.append(" AND ss.objectName like :objectName");
            params.put("objectName", "%" + params.get("objectName") + "%");
        }
        if (params.containsKey("operTypeName")) {
            hql.append(" AND ss.operTypeName like :operTypeName");
            params.put("operTypeName", "%" + params.get("operTypeName") + "%");
        }
        if (params.containsKey("userName")) {
            hql.append(" AND ss.userName like :userName");
            params.put("userName", "%" + params.get("userName") + "%");
        }
        if (params.containsKey("appId")) {
            params.put("appId", ParamUtil.getLong(params, (String)"appId"));
            hql.append(" AND ss.appId = :appId");
        }
        this.handleCreateTime(hql, params, "ss", "operTime");
    }

    private void loadProps(CapLog capLog) {
        if (null == capLog.getUserId()) {
            capLog.setUserId(AppContext.currentUserId());
        }
        if (null == capLog.getUserName()) {
            capLog.setUserName(AppContext.currentUserName());
        }
        if (null == capLog.getUnitId()) {
            capLog.setUnitId(AppContext.currentAccountId());
        }
        if (null == capLog.getUnitName()) {
            capLog.setUnitName(AppContext.currentAccountName());
        }
        if (null == capLog.getOperIp()) {
            capLog.setOperIp(AppContext.getRemoteAddr());
        }
        if (null == capLog.getOperTime()) {
            capLog.setOperTime(new Date());
        }
    }
}

