/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.monitor.perf.dao;

import com.seeyon.cap4.monitor.perf.dao.ConnectionUtil;
import com.seeyon.cap4.monitor.perf.dao.MySQLExplainDao;
import com.seeyon.cap4.monitor.perf.po.MySQLExplain;
import com.seeyon.cap4.monitor.perf.po.SQLExplain;
import com.seeyon.ctp.common.log.CtpLogFactory;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;

public class MySQLExplainDaoImpl
implements MySQLExplainDao {
    private static final Log LOGGER = CtpLogFactory.getLog(MySQLExplainDaoImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SQLExplain> getSQLExplain(String sql) {
        Connection conn = ConnectionUtil.getConn();
        Statement ps = null;
        ResultSet rs = null;
        try {
            ps = conn.prepareStatement("explain " + sql);
            rs = ps.executeQuery();
            ArrayList<SQLExplain> ses = new ArrayList<SQLExplain>();
            while (rs.next()) {
                MySQLExplain se = new MySQLExplain();
                if (rs.getObject("id") != null) {
                    se.setId(rs.getInt("id"));
                }
                se.setSelectType(rs.getString("select_type"));
                se.setTable(rs.getString("table"));
                se.setPartitions(rs.getString("partitions"));
                se.setType(rs.getString("type"));
                se.setPossibleKeys(rs.getString("possible_keys"));
                se.setKey(rs.getString("key"));
                if (rs.getObject("key_len") != null) {
                    se.setKeyLen(rs.getInt("key_len"));
                }
                se.setRef(rs.getString("ref"));
                if (rs.getObject("rows") != null) {
                    se.setRows(rs.getLong("rows"));
                }
                if (rs.getObject("filtered") != null) {
                    se.setFiltered(rs.getInt("filtered"));
                }
                se.setExtra(rs.getString("Extra"));
                ses.add(se);
            }
            ArrayList<SQLExplain> arrayList = ses;
            return arrayList;
        }
        catch (SQLException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    LOGGER.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    LOGGER.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            ConnectionUtil.close(conn);
        }
        return null;
    }
}

