/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.monitor.perf.dao;

import com.seeyon.cap4.monitor.perf.dao.ConnectionUtil;
import com.seeyon.cap4.monitor.perf.dao.MySQLIndexDao;
import com.seeyon.cap4.monitor.perf.po.IndexInfo;
import com.seeyon.ctp.common.log.CtpLogFactory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;

public class MySQLIndexDaoImpl
implements MySQLIndexDao {
    private static final Log LOGGER = CtpLogFactory.getLog(MySQLIndexDaoImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IndexInfo> getIndexs(String table) {
        Connection conn = ConnectionUtil.getConn();
        String sql = "show index from " + table;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = conn.prepareStatement(sql);
            rs = ps.executeQuery();
            ArrayList<IndexInfo> iis = new ArrayList<IndexInfo>();
            while (rs.next()) {
                IndexInfo ii = new IndexInfo();
                ii.setTable(rs.getString("Table"));
                ii.setUnique(!rs.getBoolean("Non_unique"));
                ii.setIndexName(rs.getString("Key_name"));
                ii.setSeqInIndex(rs.getInt("Seq_in_index"));
                ii.setColumnName(rs.getString("Column_name"));
                iis.add(ii);
            }
            ArrayList<IndexInfo> arrayList = iis;
            return arrayList;
        }
        catch (SQLException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    LOGGER.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    LOGGER.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            ConnectionUtil.close(conn);
        }
        return null;
    }
}

