/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.monitor.perf.service;

import com.seeyon.cap4.monitor.perf.dao.MySQLExplainDao;
import com.seeyon.cap4.monitor.perf.dao.MySQLExplainDaoImpl;
import com.seeyon.cap4.monitor.perf.dao.MySQLIndexDao;
import com.seeyon.cap4.monitor.perf.dao.MySQLIndexDaoImpl;
import com.seeyon.cap4.monitor.perf.po.ColumnIndexSuggest;
import com.seeyon.cap4.monitor.perf.po.IndexInfo;
import com.seeyon.cap4.monitor.perf.po.MySQLExplain;
import com.seeyon.cap4.monitor.perf.po.SQLExplain;
import com.seeyon.cap4.monitor.perf.po.SQLExplainResult;
import com.seeyon.cap4.monitor.perf.service.SQLExplainService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MySQLExplainServiceImpl
implements SQLExplainService {
    private MySQLExplainDao explainDao = new MySQLExplainDaoImpl();
    private MySQLIndexDao indexDao = new MySQLIndexDaoImpl();
    private Pattern fieldsPattern = Pattern.compile("([a-zA-Z0-9]+)\\s?(?:=|!=|>|<|in|not|is|>=|<=|><|<>)");

    @Override
    public SQLExplainResult analyze(String sql) {
        List<SQLExplain> ses = this.explainDao.getSQLExplain(sql);
        if (ses != null) {
            SQLExplainResult ser = new SQLExplainResult();
            ser.setSql(sql);
            ser.setExplains(ses);
            ser.setNest(ses.size());
            HashSet<String> tables = new HashSet<String>();
            HashSet<String> indexs = new HashSet<String>();
            long rows = 0L;
            for (SQLExplain tse : ses) {
                boolean indexScene;
                MySQLExplain se = (MySQLExplain)tse;
                if (se.getRows() != null) {
                    rows += se.getRows().longValue();
                }
                if (se.getKey() != null) {
                    ser.setUseIndex(true);
                    indexs.add(se.getKey());
                }
                if (se.getId() == null || se.getTable() == null || se.getTable().contains("<")) continue;
                tables.add(se.getTable());
                boolean bl = indexScene = sql.contains("where") || sql.contains("order") || sql.contains("group");
                if (!"ALL".equals(se.getType()) || se.getKey() != null || !indexScene) continue;
                ser.setNeedIndex(true);
            }
            ser.setRows(rows);
            this.analyzeIndex(sql, ser, tables, indexs);
            if (ser.isUseIndex()) {
                ser.setNeedTime((30L + 500L * ser.getRows() / 10000L) * (long)ser.getNest());
            } else {
                ser.setNeedTime((30L + 500L * ser.getRows() / 10000L) * (long)ser.getNest() * 10L);
            }
            return ser;
        }
        return null;
    }

    private void analyzeIndex(String sql, SQLExplainResult ser, Set<String> tables, Set<String> indexs) {
        int i = 1;
        int size = tables.size();
        for (String table : tables) {
            String tempSql = sql;
            tempSql = i < size ? sql.substring(sql.indexOf(table), sql.indexOf("select", sql.indexOf(table))) : sql.substring(sql.indexOf(table), sql.length());
            ++i;
            Set<String> fields = this.getAllFields(tempSql);
            List<IndexInfo> iis = this.indexDao.getIndexs(table);
            if (fields.isEmpty() || iis.isEmpty()) continue;
            ser.setTableIndexSuggests(new HashMap<String, List<ColumnIndexSuggest>>());
            ser.getTableIndexSuggests().put(table, new ArrayList());
            for (String field : fields) {
                ColumnIndexSuggest cis = new ColumnIndexSuggest();
                cis.setTable(table);
                cis.setColumn(field);
                cis.setIndexs(new ArrayList<String>());
                cis.setUseIndexs(new ArrayList<String>());
                for (IndexInfo ii : iis) {
                    if (!ii.getColumnName().equals(field)) continue;
                    cis.setHasIndex(true);
                    cis.getIndexs().add(ii.getIndexName());
                    if (!indexs.contains(ii.getIndexName())) continue;
                    cis.getUseIndexs().add(ii.getIndexName());
                    cis.setUseIndex(true);
                }
                ser.getTableIndexSuggests().get(table).add(cis);
            }
        }
    }

    private Set<String> getAllFields(String sql) {
        HashSet<String> fields = new HashSet<String>();
        Matcher matcher = this.fieldsPattern.matcher(sql);
        while (matcher.find()) {
            String field = matcher.group(1);
            fields.add(field);
        }
        if (sql.contains("group by")) {
            int index = 0;
            index = sql.contains("having") ? sql.indexOf("having") : (sql.contains("order by") ? sql.indexOf("order by") : sql.length());
            String tempSql = sql.substring(sql.indexOf("group by") + 8, index).replace("asc", "").replace("desc", "").replace(" ", "");
            String[] arr = tempSql.split(",");
            fields.addAll(Arrays.asList(arr));
        }
        if (sql.contains("order by")) {
            String tempSql = sql.substring(sql.indexOf("order by") + 8, sql.length()).replace(" ", "");
            String[] arr = tempSql.split(",");
            fields.addAll(Arrays.asList(arr));
        }
        return fields;
    }
}

