/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.monitor.performance.manager;

import com.seeyon.cap4.form.modules.business.BusinessManager;
import com.seeyon.cap4.form.po.CapBizConfig;
import com.seeyon.cap4.form.service.CAP4FormCacheManager;
import com.seeyon.cap4.monitor.vo.JMMonitorVO;
import com.seeyon.cap4.template.constant.CAPBusinessEnum;
import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.po.template.CtpTemplateCategory;
import com.seeyon.ctp.common.template.manager.TemplateManager;
import com.seeyon.ctp.form.bean.FormBean;
import com.seeyon.ctp.form.service.FormCacheManager;
import com.seeyon.ctp.monitor.perf.jdbcmonitor.JMCallingObj;
import com.seeyon.ctp.monitor.perf.jdbcmonitor.JMObject;
import com.seeyon.ctp.monitor.perf.jdbcmonitor.JMSumObject;
import com.seeyon.ctp.monitor.perf.jdbcmonitor.JMTimeGroup;
import com.seeyon.ctp.monitor.perf.jdbcmonitor.JMTimeObject;
import com.seeyon.ctp.monitor.perf.jdbcmonitor.OutSumInfo;
import com.seeyon.ctp.monitor.perf.jdbcmonitor.proxyobj.JMTrackUtils;
import com.seeyon.ctp.monitor.performance.FormRunTypeEnum;
import com.seeyon.ctp.monitor.performance.JMMonitorService;
import com.seeyon.ctp.monitor.utils.MoJSONObject;
import com.seeyon.ctp.monitor.utils.MoJSONUtils;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.json.JSONUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.logging.Log;

public class JMMonitorServiceImpl
implements JMMonitorService {
    private static final Log LOGGER = CtpLogFactory.getLog(JMMonitorServiceImpl.class);
    private FormCacheManager formCacheManager;
    private CAP4FormCacheManager cap4FormCacheManager;
    private BusinessManager businessManager4;
    private TemplateManager templateManager;
    private static JMTimeGroup fTimeGroup = JMMonitorServiceImpl.getTrackTimeGroup();

    private static JMTimeGroup getTrackTimeGroup() {
        MoJSONObject fLoadObj = null;
        try {
            String path = JMMonitorServiceImpl.getBasePath();
            path = path + File.separator + "JMmonitorData" + File.separator + DateUtil.format((Date)new Date()) + ".json";
            File file = new File(path);
            if (file.exists()) {
                fLoadObj = MoJSONUtils.parseJSonFile((String)path, (String)"UTF-8");
            }
        }
        catch (Throwable e) {
            LOGGER.error((Object)e);
        }
        fTimeGroup = new JMTimeGroup();
        fTimeGroup.newTimeObj(JMTrackUtils.TimeObj.d1.getName(), JMTrackUtils.TimeObj.d1.getStep(), JMTrackUtils.TimeObj.d1.getCount());
        fTimeGroup.newTimeObj(JMTrackUtils.TimeObj.h1.getName(), JMTrackUtils.TimeObj.h1.getStep(), JMTrackUtils.TimeObj.h1.getCount());
        fTimeGroup.newTimeObj(JMTrackUtils.TimeObj.m1.getName(), JMTrackUtils.TimeObj.m1.getStep(), JMTrackUtils.TimeObj.m1.getCount());
        if (fLoadObj != null) {
            fTimeGroup.getTimeObj(JMTrackUtils.TimeObj.d1.getName()).getRoot().importFromJSon(fLoadObj);
        }
        return fTimeGroup;
    }

    public JMMonitorServiceImpl() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 5);
        Date time = calendar.getTime();
        Timer timer = new Timer();
        timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                try {
                    JMMonitorServiceImpl.this.saveDataToFile();
                }
                catch (IOException e) {
                    LOGGER.error((Object)e.getMessage(), (Throwable)e);
                }
                catch (BusinessException e) {
                    LOGGER.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }, time, 100000L);
    }

    public JMCallingObj putJMCall(long formId, Object formRunType, String methodName, String userName, com.seeyon.cap4.form.bean.FormBean formBean, CapBizConfig capBizConfig) throws BusinessException {
        Object f;
        String[] aTags = new String[7];
        aTags[0] = "root";
        if (null != formRunType && formRunType instanceof FormRunTypeEnum) {
            f = (FormRunTypeEnum)formRunType;
            aTags[4] = f.getI18n();
        } else if (formRunType instanceof CAPBusinessEnum.BatchOperationEnum) {
            f = (CAPBusinessEnum.BatchOperationEnum)((Object)formRunType);
            aTags[4] = ((CAPBusinessEnum.BatchOperationEnum)((Object)f)).getRealExplain();
        } else {
            aTags[4] = formRunType != null && !formRunType.equals("null") ? String.valueOf(formRunType) : "-";
        }
        String tag4 = aTags[4];
        aTags[4] = tag4.replace("null", "\u66f4\u65b0");
        aTags[5] = methodName;
        aTags[6] = Strings.isNotEmpty((String)userName) ? userName : "-";
        return this.putJMCall(formId, aTags, formBean, capBizConfig);
    }

    private JMCallingObj putJMCall(long formId, String[] aTags, Object formBean, CapBizConfig capBizConfig) throws BusinessException {
        FormBean fb;
        long categoryId = 0L;
        String formName = "-";
        if (null != formBean) {
            if (formBean instanceof FormBean) {
                fb = (FormBean)formBean;
                categoryId = fb.getCategoryId();
                formId = fb.getId();
                formName = fb.getFormName();
            } else {
                com.seeyon.cap4.form.bean.FormBean fbCap4 = (com.seeyon.cap4.form.bean.FormBean)formBean;
                categoryId = fbCap4.getCategoryId();
                formId = fbCap4.getId();
                formName = fbCap4.getFormName();
            }
        } else {
            fb = this.formCacheManager.getForm(formId);
            if (fb != null) {
                categoryId = fb.getCategoryId();
                formId = fb.getId();
                formName = fb.getFormName();
            } else {
                com.seeyon.cap4.form.bean.FormBean fbCap4 = this.cap4FormCacheManager.getForm(formId);
                if (fbCap4 != null) {
                    categoryId = fbCap4.getCategoryId();
                    formId = fbCap4.getId();
                    formName = fbCap4.getFormName();
                }
            }
        }
        aTags[1] = "-";
        aTags[2] = "-";
        if (categoryId != 0L) {
            CtpTemplateCategory category = this.templateManager.getCtpTemplateCategory(Long.valueOf(categoryId));
            if (null != category && Strings.isNotEmpty((String)category.getName())) {
                aTags[2] = category.getName();
            }
            if (null == capBizConfig) {
                capBizConfig = this.businessManager4.findBizConfigByFormId(formId);
            }
            if (null != capBizConfig && Strings.isNotEmpty((String)capBizConfig.getName())) {
                aTags[1] = capBizConfig.getName();
            }
        }
        aTags[3] = formName;
        JMCallingObj fCallObj = fTimeGroup.startCallInfo(aTags);
        fCallObj.setEndTime(fCallObj.getStartTime());
        return fCallObj;
    }

    public JMCallingObj putJMCall(long formId, Object formRunType, String methodName, String userName) throws BusinessException {
        return this.putJMCall(formId, formRunType, methodName, userName, null, null);
    }

    public void endJMCall(JMCallingObj fCallObj) throws BusinessException {
        try {
            fTimeGroup.endCallInfo(fCallObj);
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public String getJMMonitor(String runType, int level, long tiemSetp, JMTimeObject jmTimeObject, String loadTime) {
        JMTrackUtils.TimeObj timeObj = null;
        if (Strings.isNotBlank((String)runType)) {
            for (JMTrackUtils.TimeObj t : JMTrackUtils.TimeObj.values()) {
                if (!runType.equals(t.getName())) continue;
                timeObj = t;
            }
        } else {
            timeObj = JMTrackUtils.TimeObj.d1;
        }
        boolean isHistorData = null != jmTimeObject;
        JMTimeObject jmcallingObj = jmTimeObject;
        long stepNum = 0L;
        String dateFomat = null;
        switch (timeObj) {
            case h1: {
                jmcallingObj = fTimeGroup.getTimeObj(JMTrackUtils.TimeObj.h1.getName());
                stepNum = JMTrackUtils.TimeObj.h1.getStep();
                dateFomat = "mm";
                break;
            }
            case m1: {
                jmcallingObj = fTimeGroup.getTimeObj(JMTrackUtils.TimeObj.m1.getName());
                stepNum = JMTrackUtils.TimeObj.m1.getStep();
                dateFomat = "ss";
                break;
            }
            case d1: {
                jmcallingObj = fTimeGroup.getTimeObj(JMTrackUtils.TimeObj.d1.getName());
                stepNum = JMTrackUtils.TimeObj.d1.getStep();
                dateFomat = "HH";
            }
        }
        if (jmTimeObject != null) {
            jmcallingObj = jmTimeObject;
        }
        if (null == jmcallingObj) {
            return "";
        }
        ArrayList<JMMonitorVO> jmMonitorVOS = new ArrayList<JMMonitorVO>();
        List datas = JMTrackUtils.getSumOutList((JMObject)jmcallingObj.getRoot(), (int)1, (int)8);
        int beginTime = 60;
        for (JMSumObject jmSumObject : ((OutSumInfo)datas.get(level)).getLevelData()) {
            JMMonitorVO jmMonitorVO = new JMMonitorVO();
            long time = Long.parseLong((String)jmSumObject.getTags().get(0));
            long stepFormat = time * stepNum;
            Calendar beginDate = Calendar.getInstance();
            Calendar endDate = Calendar.getInstance();
            if (isHistorData) {
                beginDate.setTime(new Date(stepFormat));
                endDate.setTime(new Date(stepFormat));
            } else {
                beginDate.setTime(new Date());
                endDate.setTime(new Date());
            }
            beginDate.set(11, 0);
            beginDate.set(12, 0);
            beginDate.set(13, 0);
            beginDate.set(14, 1);
            endDate.set(11, 23);
            endDate.set(12, 59);
            endDate.set(13, 59);
            endDate.set(14, 999);
            if (beginDate.getTimeInMillis() >= stepFormat && stepFormat <= endDate.getTimeInMillis()) continue;
            String stpFormat = DateUtil.format((Date)new Date(stepFormat), (String)dateFomat);
            if (timeObj.getName().equals(JMTrackUtils.TimeObj.h1.getName()) && beginTime > Integer.parseInt(stpFormat) && jmSumObject.getSumCount() != 0L) {
                beginTime = Integer.parseInt(stpFormat);
            }
            if (tiemSetp != 0L && tiemSetp != time) continue;
            jmMonitorVO.setStepNum(Integer.parseInt(stpFormat));
            if (jmSumObject.getSumTime() <= 0L) {
                jmMonitorVO.setRuntime(jmSumObject.getSumCount());
            } else {
                jmMonitorVO.setRuntime(jmSumObject.getSumTime());
            }
            jmMonitorVO.setCount(jmSumObject.getSumCount());
            jmMonitorVO.setRunType(timeObj.getName());
            jmMonitorVO.setLevel(level);
            jmMonitorVO.setTag(this.getTags(jmSumObject.getTags()));
            jmMonitorVO.setTimeNum(time);
            jmMonitorVO.setLoadTime(String.valueOf(loadTime));
            jmMonitorVOS.add(jmMonitorVO);
        }
        Collections.sort(jmMonitorVOS, new Comparator<JMMonitorVO>(){

            @Override
            public int compare(JMMonitorVO o1, JMMonitorVO o2) {
                if (o1.getRuntime() < o2.getRuntime()) {
                    return 1;
                }
                if (o1.getRuntime() == o2.getRuntime()) {
                    return 0;
                }
                return -1;
            }
        });
        return JSONUtil.toJSONString(jmMonitorVOS) + "_M#@SEEYON@#_" + beginTime;
    }

    private List<String> getTags(List<String> tag) {
        if (tag == null || tag.isEmpty()) {
            return tag;
        }
        if (tag.size() > 6) {
            String i18n = tag.get(5);
            tag.set(5, ResourceUtil.getString((String)i18n));
        }
        return tag;
    }

    public void saveDataToFile() throws IOException, BusinessException {
        String path = JMMonitorServiceImpl.getBasePath();
        File f = new File(path = path + File.separator + "JMmonitorData" + File.separator + DateUtil.format((Date)new Date()) + ".json");
        if (!f.exists()) {
            if (!f.getParentFile().exists()) {
                f.getParentFile().mkdirs();
            }
            f.createNewFile();
        }
        String folder = SystemEnvironment.getLogsFolder();
        JMTimeObject jmTimeObject = fTimeGroup.getTimeObj(JMTrackUtils.TimeObj.d1.getName());
        MoJSONObject fSaveObj = jmTimeObject.copyToReport().exportToJSon(null);
        MoJSONUtils.saveJSonFile((String)f.getAbsolutePath(), (MoJSONObject)fSaveObj, (String)"UTF-8");
    }

    private static JMTimeObject loadFromFile(String aFileName) {
        MoJSONObject fLoadObj = MoJSONUtils.parseJSonFile((String)aFileName, (String)"UTF-8");
        if (fLoadObj == null) {
            return null;
        }
        JMTimeGroup jm = new JMTimeGroup();
        jm.newTimeObj(JMTrackUtils.TimeObj.d1.getName(), JMTrackUtils.TimeObj.d1.getStep(), JMTrackUtils.TimeObj.d1.getCount());
        jm.newTimeObj(JMTrackUtils.TimeObj.h1.getName(), JMTrackUtils.TimeObj.h1.getStep(), JMTrackUtils.TimeObj.h1.getCount());
        jm.newTimeObj(JMTrackUtils.TimeObj.m1.getName(), JMTrackUtils.TimeObj.m1.getStep(), JMTrackUtils.TimeObj.m1.getCount());
        jm.getTimeObj(JMTrackUtils.TimeObj.d1.getName()).getRoot().importFromJSon(fLoadObj);
        return jm.getTimeObj(JMTrackUtils.TimeObj.d1.getName());
    }

    private static String getBasePath() throws BusinessException {
        return SystemEnvironment.getBaseFolder() + File.separator + "monitor";
    }

    public String getHistoryData(String fielName, String runType, int level, long timeStep) throws BusinessException {
        String basePath = JMMonitorServiceImpl.getBasePath();
        JMTimeObject jmTimeObject = JMMonitorServiceImpl.loadFromFile(basePath + File.separator + "JMmonitorData" + File.separator + fielName + ".json");
        if (jmTimeObject == null) {
            ArrayList jmMonitorVOS = new ArrayList();
            return JSONUtil.toJSONString(jmMonitorVOS) + "_M#@SEEYON@#_" + 0;
        }
        return this.getJMMonitor(runType, level, timeStep, jmTimeObject, fielName);
    }

    public static void main(String[] a) {
    }

    public FormCacheManager getFormCacheManager() {
        return this.formCacheManager;
    }

    public void setFormCacheManager(FormCacheManager formCacheManager) {
        this.formCacheManager = formCacheManager;
    }

    public CAP4FormCacheManager getCap4FormCacheManager() {
        return this.cap4FormCacheManager;
    }

    public void setCap4FormCacheManager(CAP4FormCacheManager cap4FormCacheManager) {
        this.cap4FormCacheManager = cap4FormCacheManager;
    }

    public BusinessManager getBusinessManager4() {
        return this.businessManager4;
    }

    public void setBusinessManager4(BusinessManager businessManager4) {
        this.businessManager4 = businessManager4;
    }

    public TemplateManager getTemplateManager() {
        return this.templateManager;
    }

    public void setTemplateManager(TemplateManager templateManager) {
        this.templateManager = templateManager;
    }
}

