/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.monitor.service;

import com.seeyon.cap4.monitor.dao.CapLogDao;
import com.seeyon.cap4.monitor.po.CapConfigLog;
import com.seeyon.cap4.monitor.po.CapDataLog;
import com.seeyon.cap4.monitor.service.CapLogService;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.organization.OrgConstants;
import com.seeyon.ctp.util.FlipInfo;
import com.seeyon.ctp.util.annotation.AjaxAccess;
import com.seeyon.ctp.util.annotation.CheckRoleAccess;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CapLogServiceImpl
implements CapLogService {
    private static final Log log = LogFactory.getLog(CapLogServiceImpl.class);
    private CapLogDao capLogDao;

    public void setCapLogDao(CapLogDao capLogDao) {
        this.capLogDao = capLogDao;
    }

    @Override
    public void saveCapDataLog(CapDataLog capDataLog) throws BusinessException {
        this.capLogDao.insertCapDataLog(capDataLog);
    }

    @Override
    public void saveCapDataLogs(List<CapDataLog> capDataLogs) throws BusinessException {
        this.capLogDao.insertCapDataLogs(capDataLogs);
    }

    @Override
    public void saveCapConfigLog(CapConfigLog capConfigLog) throws BusinessException {
        this.capLogDao.insertCapConfigLog(capConfigLog);
    }

    @Override
    public void saveCapConfigLogs(List<CapConfigLog> capConfigLogs) throws BusinessException {
        this.capLogDao.insertCapConfigLogs(capConfigLogs);
    }

    @Override
    @AjaxAccess
    @CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner})
    public FlipInfo getDataLogs(FlipInfo fi, Map<String, Object> params) throws BusinessException {
        List<CapDataLog> capDataLogs = this.capLogDao.getDataLogs(fi, params);
        fi.setData(capDataLogs);
        return fi;
    }

    @Override
    @AjaxAccess
    @CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner})
    public FlipInfo getConfigLogs(FlipInfo fi, Map<String, Object> params) throws BusinessException {
        List<CapConfigLog> capConfigLogs = this.capLogDao.getConfigLogs(fi, params);
        fi.setData(capConfigLogs);
        return fi;
    }
}

