/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.monitor.service;

import com.seeyon.cap4.monitor.dao.MonitorConfigDao;
import com.seeyon.cap4.monitor.enums.ConfigEnum;
import com.seeyon.cap4.monitor.po.MonitorConfig;
import com.seeyon.cap4.monitor.service.MonitorConfigService;
import com.seeyon.cap4.task.Constants;
import com.seeyon.ctp.common.AbstractSystemInitializer;
import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.monitor.histories.HistoryObjManager;
import com.seeyon.ctp.monitor.perf.jdbcmonitor.JMManager;
import com.seeyon.ctp.monitor.perf.jdbcmonitor.proxyobj.JMTrackTableCfg;
import com.seeyon.ctp.monitor.perf.jdbcmonitor.proxyobj.JMTrackUtils;
import com.seeyon.ctp.monitor.utils.MoBackgroundExecutor;
import com.seeyon.ctp.monitor.utils.MonitorUtil;
import com.seeyon.ctp.report.utils.ReportDBUtils;
import com.seeyon.ctp.util.Strings;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.songjian.utils.StreamUtils;

public class MonitorConfigServiceImpl
extends AbstractSystemInitializer
implements MonitorConfigService {
    private static final Log log = LogFactory.getLog(MonitorConfigServiceImpl.class);
    private Map<String, MonitorConfig> configs = new ConcurrentHashMap<String, MonitorConfig>();
    private MonitorConfigDao monitorConfigDao;

    public void setMonitorConfigDao(MonitorConfigDao monitorConfigDao) {
        this.monitorConfigDao = monitorConfigDao;
    }

    @Override
    public MonitorConfig getMonitorConfig(String key) throws BusinessException {
        return this.configs.get(key);
    }

    public void initialize() {
        MonitorConfig slowSqlSection = new MonitorConfig();
        slowSqlSection.setValue("2000,5000,8000");
        this.configs.put(ConfigEnum.SlowSqlSection.getKey(), slowSqlSection);
        try {
            this.loadConfigs();
        }
        catch (BusinessException e) {
            log.error((Object)"\u76d1\u63a7\u914d\u7f6e\u521d\u59cb\u5316\u5931\u8d25\uff01", (Throwable)e);
        }
    }

    private void initDevelopTrackCfg(JMTrackTableCfg fCfg) {
        String fName = StreamUtils.getPackageResourceName(MonitorConfigServiceImpl.class, (String)"developtrackcfg.properties");
        Properties fPps = StreamUtils.readResourceProperties_UTF8((String)fName);
        if (fPps == null) {
            return;
        }
        fCfg.setMatchTableNames(this.getBooleanPts(fPps, "matchtablename"));
        fCfg.setNullTableName(this.getBooleanPts(fPps, "nulltablename"));
    }

    private final boolean getBooleanPts(Properties aPps, String aKey) {
        String ftemp = aPps.getProperty(aKey);
        if (Strings.isBlank((String)ftemp)) {
            return false;
        }
        boolean result = Boolean.parseBoolean(ftemp);
        return result;
    }

    @Override
    public void loadConfigs() throws BusinessException {
        for (ConfigEnum configEnum : ConfigEnum.values()) {
            try {
                MonitorConfig monitorConfig = this.monitorConfigDao.getConfigByKey(configEnum.getKey());
                if (monitorConfig == null) continue;
                this.configs.put(configEnum.getKey(), monitorConfig);
            }
            catch (BusinessException e) {
                log.error((Object)("\u76d1\u63a7\u5c5e\u6027\u52a0\u8f7d\u9519\u8bef" + configEnum.getKey()), (Throwable)e);
            }
        }
        if (this.configs.containsKey(ConfigEnum.TriggerQueueFull.getKey())) {
            MonitorConfig monitorConfig = this.configs.get(ConfigEnum.TriggerQueueFull.getKey());
            Constants.getTaskAndEventFullCount().getAndSet(Integer.valueOf(monitorConfig.getValue()));
        }
        if (!JMTrackUtils.isProxyDriverOk()) {
            return;
        }
        MoBackgroundExecutor.getBackgroundExecutor().start();
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                MoBackgroundExecutor.getBackgroundExecutor().stop(true);
            }
        }));
        HistoryObjManager fManager = HistoryObjManager.getInstance();
        fManager.setConUrl("jdbc:sqlite:" + SystemEnvironment.getBaseFolder() + "/monitor/historyobj.db");
        fManager.start();
        JMTrackTableCfg fCfg = JMTrackUtils.getTrackTableCfg();
        fCfg.setConUrl("jdbc:sqlite:" + SystemEnvironment.getBaseFolder() + "/monitor/tracksave.db");
        fCfg.setDbType(1);
        if (ReportDBUtils.isMySQLRuntime()) {
            fCfg.setDbType(1);
        } else if (ReportDBUtils.isOracleRuntime()) {
            fCfg.setDbType(0);
        } else if (ReportDBUtils.isPostgreSQLRuntime()) {
            fCfg.setDbType(3);
        } else if (ReportDBUtils.isSQLServerRuntime()) {
            fCfg.setDbType(2);
        } else {
            log.info((Object)"SQL\u76d1\u63a7\u521d\u59cb\u5316\uff0c\u8bbe\u5b9a\u8ddf\u8e2a\u7684\u6570\u636e\u5e93\u7c7b\u578b\u5931\u8d25\uff01");
        }
        this.initDevelopTrackCfg(fCfg);
        MonitorUtil.loadTrackTables((JMTrackTableCfg)fCfg);
        JMManager.regTrackCallback();
        fCfg.enableTrackTable();
        if (this.configs.containsKey(ConfigEnum.SlowSqlTime.getKey())) {
            MonitorConfig monitorConfig = this.configs.get(ConfigEnum.SlowSqlTime.getKey());
            JMManager.setSQLTimeOut((long)Long.valueOf(monitorConfig.getValue()));
        }
        if (this.configs.containsKey(ConfigEnum.NeedSqlSum.getKey())) {
            MonitorConfig monitorConfig = this.configs.get(ConfigEnum.NeedSqlSum.getKey());
            JMTrackUtils.setNeedSqlMonitor((boolean)Boolean.valueOf(monitorConfig.getValue()));
        }
    }

    @Override
    public void init() throws BusinessException {
    }

    @Override
    public void destroy() {
        MoBackgroundExecutor.getBackgroundExecutor().stop(true);
    }
}

