/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.monitor.service;

import com.seeyon.cap4.form.modules.formlist.CAP4FormListManager;
import com.seeyon.cap4.monitor.dao.SlowSqlDao;
import com.seeyon.cap4.monitor.enums.AlarmLevelEnum;
import com.seeyon.cap4.monitor.enums.ConfigEnum;
import com.seeyon.cap4.monitor.enums.IndicatorEnum;
import com.seeyon.cap4.monitor.po.SlowSql;
import com.seeyon.cap4.monitor.service.MonitorConfigService;
import com.seeyon.cap4.monitor.service.SlowSqlService;
import com.seeyon.cap4.monitor.utils.CAP4MonitorUtil;
import com.seeyon.cap4.monitor.vo.SlowSqlVO;
import com.seeyon.ctp.common.AbstractSystemInitializer;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.monitor.perf.jdbcmonitor.IOnSQLTimeOutTrack;
import com.seeyon.ctp.monitor.perf.jdbcmonitor.JMManager;
import com.seeyon.ctp.monitor.perf.jdbcmonitor.proxyobj.JMTrackObjcet_SQLStatementItem;
import com.seeyon.ctp.monitor.perf.jdbcmonitor.proxyobj.JMTrackUtils;
import com.seeyon.ctp.organization.OrgConstants;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.FlipInfo;
import com.seeyon.ctp.util.annotation.AjaxAccess;
import com.seeyon.ctp.util.annotation.CheckRoleAccess;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SlowSqlServiceImpl
extends AbstractSystemInitializer
implements SlowSqlService {
    private static final Log log = LogFactory.getLog(SlowSqlServiceImpl.class);
    private SlowSqlDao slowSqlDao;
    private MonitorConfigService monitorConfigService;
    private CAP4FormListManager cap4FormListManager;

    public void setSlowSqlDao(SlowSqlDao slowSqlDao) {
        this.slowSqlDao = slowSqlDao;
    }

    public void setMonitorConfigService(MonitorConfigService monitorConfigService) {
        this.monitorConfigService = monitorConfigService;
    }

    public void setCap4FormListManager(CAP4FormListManager cap4FormListManager) {
        this.cap4FormListManager = cap4FormListManager;
    }

    @Override
    public void init() throws BusinessException {
        if (!JMTrackUtils.isProxyDriverOk()) {
            return;
        }
        JMTrackUtils.get();
        JMManager.regTrackCallback();
        JMManager.setSQLTimeOutEvent((IOnSQLTimeOutTrack)new IOnSQLTimeOutTrack(){

            public void onTrack(String[] aTags, JMTrackObjcet_SQLStatementItem aSQLItem) {
                try {
                    log.info((Object)(aTags + "-" + aSQLItem));
                    SlowSql slowSql = new SlowSql();
                    slowSql.setNewId();
                    String alarmLevel = SlowSqlServiceImpl.this.monitorConfigService.getMonitorConfig(ConfigEnum.SlowSqlSection.getKey()).getValue();
                    slowSql.setAlarmLevel(CAP4MonitorUtil.getAlarmLevel(alarmLevel, aSQLItem.getUseTime()));
                    slowSql.setSqlText(aSQLItem.getSQL() + " params:" + aSQLItem.getParams());
                    slowSql.setCreateTime(new Date(aSQLItem.getStartTime()));
                    slowSql.setTimeUsed(aSQLItem.getUseTime());
                    slowSql.setIndicatorId(IndicatorEnum.SlowSql.getId());
                    slowSql.setIndicatorName(IndicatorEnum.SlowSql.getName());
                    CAP4MonitorUtil.splitTags(aTags, slowSql);
                    SlowSqlServiceImpl.this.insertSlowSql(slowSql);
                }
                catch (BusinessException e) {
                    log.error((Object)"\u6162\u901fsql\u4fdd\u5b58\u9519\u8bef", (Throwable)e);
                }
            }
        });
        JMManager.startTimeOutThread();
    }

    public void destroy() {
        if (!JMTrackUtils.isProxyDriverOk()) {
            return;
        }
        JMManager.waitSQLTimeOutEventEnd();
    }

    @Override
    public void insertSlowSql(SlowSql slowSql) throws BusinessException {
        this.slowSqlDao.insertSlowSql(slowSql);
    }

    @Override
    public void insertSlowSqls(List<SlowSql> slowSqls) throws BusinessException {
        this.slowSqlDao.insertSlowSqls(slowSqls);
    }

    @Override
    @AjaxAccess
    @CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner})
    public FlipInfo getAppSlowSqls(FlipInfo fi, Map<String, Object> params) throws BusinessException {
        List<SlowSql> slowSqls = this.slowSqlDao.getAppSlowSqls(fi, params);
        fi.setData(this.transfer2VO(slowSqls));
        return fi;
    }

    @Override
    @AjaxAccess
    @CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner})
    public FlipInfo getFormSlowSqls(FlipInfo fi, Map<String, Object> params) throws BusinessException {
        FlipInfo fiTemp = new FlipInfo(-1);
        fiTemp = this.cap4FormListManager.showFormList(fiTemp, null);
        ArrayList formIds = new ArrayList();
        List forms = fiTemp.getData();
        if (CollectionUtils.isNotEmpty((Collection)forms)) {
            for (Map formMap : forms) {
                formIds.add(formMap.get("id"));
            }
            params.put("formIds", formIds);
        } else {
            params.put("formIds", -1L);
        }
        List<SlowSql> slowSqls = this.slowSqlDao.getFormSlowSqls(fi, params);
        fi.setData(this.transfer2VO(slowSqls));
        return fi;
    }

    @Override
    @AjaxAccess
    @CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner})
    public int getSlowSqlLastWeekNumber() throws BusinessException {
        FlipInfo flipInfo = new FlipInfo(-1);
        HashMap<String, Object> params = new HashMap<String, Object>();
        ArrayList<Date> createTimes = new ArrayList<Date>();
        createTimes.add(CAP4MonitorUtil.getWeekStartDate());
        createTimes.add(new Date());
        params.put("createTime", createTimes);
        this.getAppSlowSqls(flipInfo, params);
        return flipInfo.getData().size();
    }

    private List<SlowSqlVO> transfer2VO(List<SlowSql> slowSqls) {
        ArrayList<SlowSqlVO> slowSqlVOS = new ArrayList<SlowSqlVO>();
        if (CollectionUtils.isNotEmpty(slowSqls)) {
            for (SlowSql slowSql : slowSqls) {
                SlowSqlVO slowSqlVO = new SlowSqlVO(slowSql);
                slowSqlVO.setAlarmLevelName(AlarmLevelEnum.getEnumByKey(slowSql.getAlarmLevel()).getName());
                slowSqlVO.setCreateTimeStr(DateUtil.format((Date)slowSql.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                slowSqlVO.setFormOrEntityStr((slowSql.getEntityName() != null ? slowSql.getEntityName() : "") + (slowSql.getFormName() != null ? slowSql.getFormName() : ""));
                slowSqlVOS.add(slowSqlVO);
            }
        }
        return slowSqlVOS;
    }
}

