/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.monitor.taskQueue.manager;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.seeyon.cap4.form.bean.FormTriggerActionBean;
import com.seeyon.cap4.form.bean.FormTriggerBean;
import com.seeyon.cap4.form.modules.business.BizConfigBean;
import com.seeyon.cap4.form.modules.business.BusinessManager;
import com.seeyon.cap4.form.modules.engin.trigger.CAP4FormTriggerManager;
import com.seeyon.cap4.form.po.CAPFormTriggerEvent;
import com.seeyon.cap4.form.po.CAPFormTriggerTask;
import com.seeyon.cap4.form.service.CAP4FormCacheManager;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.cap4.monitor.taskQueue.manager.TaskQueueManager;
import com.seeyon.cap4.monitor.taskQueue.vo.FormTrggerEventInfoView;
import com.seeyon.cap4.monitor.taskQueue.vo.InputQueueTaskView;
import com.seeyon.cap4.monitor.taskQueue.vo.QuartzTaskInfo;
import com.seeyon.cap4.monitor.taskQueue.vo.RunningTaskInfoView;
import com.seeyon.cap4.task.RunningTaskInfo;
import com.seeyon.cap4.task.Task;
import com.seeyon.cap4.task.TaskEventManager;
import com.seeyon.cap4.task.taskring.TaskRingMonitor;
import com.seeyon.cap4.task.taskring.TaskRingSnapshot;
import com.seeyon.ctp.common.content.mainbody.MainbodyService;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.po.content.CtpContentAll;
import com.seeyon.ctp.common.template.manager.TemplateManager;
import com.seeyon.ctp.form.bean.FormBean;
import com.seeyon.ctp.form.bean.FormTriggerBean;
import com.seeyon.ctp.form.bean.FormTriggerConditionBean;
import com.seeyon.ctp.form.modules.trigger.FormTriggerManager;
import com.seeyon.ctp.form.po.FormTriggerEvent;
import com.seeyon.ctp.form.service.FormCacheManager;
import com.seeyon.ctp.form.util.Enums;
import com.seeyon.ctp.organization.manager.OrgManager;
import com.seeyon.ctp.util.DBAgent;
import com.seeyon.ctp.util.Datetimes;
import com.seeyon.ctp.util.FlipInfo;
import com.seeyon.ctp.util.JDBCAgent;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.json.JSONUtil;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;

public class TaskQueueManagerImpl
implements TaskQueueManager {
    private FormCacheManager formCacheManager;
    private CAP4FormCacheManager cap4FormCacheManager;
    private BusinessManager businessManager4;
    private TemplateManager templateManager;
    private TaskEventManager taskEventManager;
    private FormTriggerManager formTriggerManager;
    private CAP4FormTriggerManager cap4FormTriggerManager;
    private OrgManager orgManager;
    private TaskRingSnapshot taskRingSnapshot;
    private static final Log log = CtpLogFactory.getLog(TaskQueueManagerImpl.class);

    @Override
    public Map<String, String> getTaskRingSnapshot(Map<String, Object> params) throws BusinessException {
        if (this.taskRingSnapshot == null) {
            this.taskRingSnapshot = TaskRingMonitor.getInstance().makeSnapshot();
        }
        HashMap<String, String> taskRingSnapshotView = new HashMap<String, String>();
        Map<Long, String> analyszdTaskMap = this.taskRingSnapshot.getAnalyzedTaskMap();
        int analyzedTaskNum = 0;
        for (Long analyszdMapKey : analyszdTaskMap.keySet()) {
            String analyszdValue = analyszdTaskMap.get(analyszdMapKey);
            Map analyszdValueMap = (Map)JSONUtil.parseJSONString((String)analyszdValue, new HashMap().getClass());
            int analyszdNume = Integer.valueOf(analyszdValueMap.get("count").toString());
            if (analyszdNume <= 0) continue;
            analyzedTaskNum += analyszdNume;
        }
        int needAddToInputQueueCount = 0;
        if (analyzedTaskNum > 10000) {
            needAddToInputQueueCount = analyzedTaskNum - 10000;
            analyzedTaskNum = 10000;
        }
        taskRingSnapshotView.put("analyzedTaskNum", String.valueOf(analyzedTaskNum));
        int inputQueueCount = this.taskRingSnapshot.getInputQueueCount();
        taskRingSnapshotView.put("inputQueueCount", String.valueOf(inputQueueCount + needAddToInputQueueCount));
        taskRingSnapshotView.put("SnapshotTime", Datetimes.format((Date)new Date(this.taskRingSnapshot.getSnapshotTime()), (String)"yyyy-MM-dd HH:mm:ss"));
        taskRingSnapshotView.put("threadCount", String.valueOf(this.taskRingSnapshot.getThreadCount()));
        taskRingSnapshotView.put("waitRunTaskNum", String.valueOf(analyzedTaskNum));
        return taskRingSnapshotView;
    }

    @Override
    public FlipInfo getInputQueueTaskInfo(FlipInfo info, Map<String, Object> params) throws BusinessException {
        ArrayList<InputQueueTaskView> inputQueueTaskViewList = new ArrayList<InputQueueTaskView>();
        if (this.taskRingSnapshot == null) {
            this.taskRingSnapshot = TaskRingMonitor.getInstance().makeSnapshot();
        }
        Map<Long, String> analyszdTaskMap = this.taskRingSnapshot.getAnalyzedTaskMap();
        HashMap<Long, Integer> resetmap = new HashMap<Long, Integer>();
        for (Long key : analyszdTaskMap.keySet()) {
            String analyszdValue = analyszdTaskMap.get(key);
            Map analyszdValueMap = (Map)JSONUtil.parseJSONString((String)analyszdValue, new HashMap().getClass());
            int analyszdNume = Integer.valueOf(analyszdValueMap.get("count").toString());
            if (analyszdNume <= 0) continue;
            resetmap.put(key, analyszdNume);
        }
        int page = info.getPage();
        int total = resetmap.keySet().size();
        int end = page * info.getSize();
        if (end > total) {
            info.setPage(1);
            end = total;
        }
        int start = (page - 1) * info.getSize();
        info.setTotal(total);
        LinkedHashMap<Long, Integer> sortMap = this.sortMapValueDescending(resetmap, start, end);
        for (long formId : sortMap.keySet()) {
            InputQueueTaskView inputQueueTaskView = new InputQueueTaskView();
            String capBizConfigName = "-";
            inputQueueTaskView.setTaskFlowName(this.getFormNameByFormID(formId));
            BizConfigBean capBizConfig = this.businessManager4.findBizConfigByFormId(formId);
            if (null != capBizConfig && Strings.isNotEmpty((String)capBizConfig.getName())) {
                capBizConfigName = capBizConfig.getName();
            }
            inputQueueTaskView.setCapBizConfigName(capBizConfigName);
            String analyszdValue = analyszdTaskMap.get(formId);
            HashMap analyszdValueMap = (HashMap)JSONUtil.parseJSONString((String)analyszdValue, new HashMap().getClass());
            inputQueueTaskView.setTaskNum(Integer.valueOf(analyszdValueMap.get("count").toString()));
            inputQueueTaskView.setNowTaskId(analyszdValueMap.get("taskid") + "(" + analyszdValueMap.get("tasknum") + ")");
            JSONArray dependsMap = (JSONArray)analyszdValueMap.get("depends");
            String depends = "";
            if (dependsMap != null && !dependsMap.isEmpty()) {
                JSONObject dependMap = (JSONObject)dependsMap.get(0);
                String formdefineid = dependMap.get((Object)"formdefineid").toString();
                String taskid = dependMap.get((Object)"taskid").toString();
                String tasknum = dependMap.get((Object)"tasknum").toString();
                depends = depends + this.getFormNameByFormID(Long.parseLong(formdefineid)) + "(" + tasknum + ")\r\n";
            }
            inputQueueTaskView.setRelevantTaskCode(depends);
            inputQueueTaskViewList.add(inputQueueTaskView);
        }
        info.setData(inputQueueTaskViewList);
        return info;
    }

    @Override
    public FlipInfo getRunningTaskInfo(FlipInfo info, Map<String, Object> params) throws BusinessException {
        RunningTaskInfo[] runningTaskInfos;
        ArrayList<RunningTaskInfoView> runningTaskInfoViewList = new ArrayList<RunningTaskInfoView>();
        if (this.taskRingSnapshot == null) {
            this.taskRingSnapshot = TaskRingMonitor.getInstance().makeSnapshot();
        }
        for (RunningTaskInfo runningTaskInfo : runningTaskInfos = this.taskRingSnapshot.getRunningTaskInfo()) {
            RunningTaskInfoView runningTaskInfoView = new RunningTaskInfoView();
            runningTaskInfoView.setRingType(runningTaskInfo.getRingType());
            long startTime = runningTaskInfo.getStartTime();
            runningTaskInfoView.setStartTime(Datetimes.format((Date)new Date(startTime), (String)"yyyy-MM-dd HH:mm:ss"));
            long useTime = runningTaskInfo.getUseTime();
            if (useTime == 0L) {
                runningTaskInfoView.setUseTime("0.01");
            } else {
                runningTaskInfoView.setUseTime(String.valueOf(useTime));
            }
            long taskId = runningTaskInfo.getTaskId();
            Task task = this.taskEventManager.getTaskById(taskId);
            if (task != null) {
                CAPFormTriggerTask capFormTriggerTask = (CAPFormTriggerTask)task;
                runningTaskInfoView.setCategoryName("");
                runningTaskInfoView.setSourceFormName(capFormTriggerTask.getSourceFormName());
                runningTaskInfoView.setSourceAppName(capFormTriggerTask.getSourceAppName());
                runningTaskInfoView.setSourceTitle(capFormTriggerTask.getSourceTitle());
                runningTaskInfoView.setActionName(capFormTriggerTask.getActionName());
                runningTaskInfoView.setRelationName(capFormTriggerTask.getTriggerName());
                runningTaskInfoView.setSourceUserName(capFormTriggerTask.getSourceUserName());
                Long formId = capFormTriggerTask.getTargetFormId();
                runningTaskInfoView.setTargetFormName(this.getFormNameByFormID(formId));
                runningTaskInfoView.setTargetContent(runningTaskInfoView.getActionName() + "-" + runningTaskInfoView.getTargetFormName());
            }
            runningTaskInfoViewList.add(runningTaskInfoView);
        }
        info.setData(runningTaskInfoViewList);
        return info;
    }

    @Override
    public Map<String, String> getQuartzInfo(Map<String, Object> params) throws BusinessException {
        HashMap<String, String> quartsInfo = new HashMap<String, String>();
        FlipInfo info = new FlipInfo();
        info.setSize(1);
        info.setPage(1);
        this.getCap3QuartzTaskList(info, params);
        quartsInfo.put("cap3TashNum", String.valueOf(info.getTotal()));
        info = new FlipInfo();
        this.getCap4QuartzTaskList(info, params);
        quartsInfo.put("cap4TaskNum", String.valueOf(info.getTotal()));
        return quartsInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FlipInfo getCap3QuartzTaskList(FlipInfo info, Map<String, Object> params) throws BusinessException {
        ArrayList<QuartzTaskInfo> quartzTaskInfoList = new ArrayList<QuartzTaskInfo>();
        ConcurrentMap triggers = this.formCacheManager.getTriggers();
        Collection formTriggerBeanSet = triggers.values();
        ArrayList<Long> triggerIDList = new ArrayList<Long>();
        block5: for (FormTriggerBean triggerBean : formTriggerBeanSet) {
            List formTriggerConditionBeans = triggerBean.getConditions();
            if (formTriggerConditionBeans == null) continue;
            Iterator iterator = formTriggerConditionBeans.iterator();
            while (iterator.hasNext()) {
                FormTriggerConditionBean triggerConditionBean = (FormTriggerConditionBean)iterator.next();
                String triggerTime = triggerConditionBean.getTriggerTime();
                if (triggerTime == null || triggerTime.length() <= 1) continue;
                triggerIDList.add(triggerBean.getId());
                continue block5;
            }
        }
        if (triggerIDList.isEmpty()) {
            info.setData(quartzTaskInfoList);
            return info;
        }
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ");
        sql.append("TRIGGER_NAME,NEXT_FIRE_TIME,PREV_FIRE_TIME,TRIGGER_TYPE,START_TIME,END_TIME,JOB_GROUP ");
        sql.append("from JK_TRIGGERS ");
        sql.append("WHERE TRIGGER_STATE='WAITING' and JOB_GROUP in(");
        JDBCAgent jdbcAgent = new JDBCAgent(false);
        try {
            for (Long id : triggerIDList) {
                sql.append("'" + id + "',");
            }
            String sqlt = sql.toString();
            sqlt = sqlt.substring(0, sqlt.length() - 1);
            sqlt = sqlt + ")  ORDER BY NEXT_FIRE_TIME ASC";
            info = jdbcAgent.findByPaging(sqlt, info);
        }
        catch (SQLException e) {
            log.error((Object)("error-sql:" + sql));
            log.error((Object)"getCap3QuartzTaskList\u6570\u636e\u67e5\u8be2\u51fa\u9519\uff0c\u5177\u4f53\u89c1\uff1a", (Throwable)e);
        }
        finally {
            jdbcAgent.close();
        }
        if (info != null) {
            List datas = info.getData();
            for (Map valueMap : datas) {
                QuartzTaskInfo quartzTaskInfo = new QuartzTaskInfo();
                String trigger_name = (String)valueMap.get("trigger_name");
                String[] formId = trigger_name.split("_");
                long next_fire_time_long = -1L;
                Object next_fire_time = valueMap.get("next_fire_time");
                if (next_fire_time instanceof Long) {
                    next_fire_time_long = (Long)next_fire_time;
                } else if (next_fire_time instanceof BigDecimal) {
                    next_fire_time_long = ((BigDecimal)next_fire_time).longValue();
                }
                if (next_fire_time_long != -1L) {
                    Date date_next = new Date(next_fire_time_long);
                    quartzTaskInfo.setExecutionTime(Datetimes.format((Date)date_next, (String)"yyyy-MM-dd HH:mm:ss"));
                } else {
                    quartzTaskInfo.setExecutionTime("-");
                }
                long prev_fire_time_long = -1L;
                Object prev_fire_time = valueMap.get("prev_fire_time");
                if (prev_fire_time instanceof Long) {
                    prev_fire_time_long = (Long)prev_fire_time;
                } else if (prev_fire_time instanceof BigDecimal) {
                    prev_fire_time_long = ((BigDecimal)prev_fire_time).longValue();
                }
                if (prev_fire_time_long != -1L) {
                    Date date_prev = new Date(prev_fire_time_long);
                    quartzTaskInfo.setLastExecutionTime(Datetimes.format((Date)date_prev, (String)"yyyy-MM-dd HH:mm:ss"));
                } else {
                    quartzTaskInfo.setLastExecutionTime("-");
                }
                String job_group = (String)valueMap.get("job_group");
                quartzTaskInfo.setTaskID(job_group);
                FormTriggerBean formTriggerBean = this.formCacheManager.getTrigger(Long.valueOf(job_group).longValue());
                FormBean formBean = formTriggerBean.getFormBean();
                quartzTaskInfo.setFormName(formBean.getFormName());
                quartzTaskInfo.setRelationName(formTriggerBean.getName());
                String capBizConfigName = "-";
                BizConfigBean capBizConfig = this.businessManager4.findBizConfigByFormId(Long.valueOf(formId[0]));
                if (null != capBizConfig && Strings.isNotEmpty((String)capBizConfig.getName())) {
                    capBizConfigName = capBizConfig.getName();
                }
                quartzTaskInfo.setCategoryName(capBizConfigName);
                quartzTaskInfo.setTaskType(1);
                List formTriggerConditionBeans = formTriggerBean.getConditions();
                if (formTriggerConditionBeans != null) {
                    for (FormTriggerConditionBean formTriggerConditionBean : formTriggerConditionBeans) {
                        String triggerTime = formTriggerConditionBean.getTriggerTime();
                        if (triggerTime == null) continue;
                        String param = formTriggerConditionBean.getParam();
                        if ("once".equals(param)) {
                            quartzTaskInfo.setTaskType(1);
                            break;
                        }
                        if ("day".equals(param)) {
                            quartzTaskInfo.setTaskType(2);
                            break;
                        }
                        if ("week".equals(param)) {
                            quartzTaskInfo.setTaskType(3);
                            break;
                        }
                        if ("season".equals(param)) {
                            quartzTaskInfo.setTaskType(4);
                            break;
                        }
                        if ("halfyear".equals(param)) {
                            quartzTaskInfo.setTaskType(5);
                            break;
                        }
                        if (!"year".equals(param)) continue;
                        quartzTaskInfo.setTaskType(6);
                        break;
                    }
                }
                List formTriggerActionBeans = formTriggerBean.getActions();
                Map<String, String> actionInfo = this.getActionInfoForCAP3(formBean, formTriggerActionBeans, formTriggerBean);
                quartzTaskInfo.setTarContent(actionInfo.get("tarContent"));
                quartzTaskInfoList.add(quartzTaskInfo);
            }
        }
        info.setData(quartzTaskInfoList);
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FlipInfo getCap4QuartzTaskList(FlipInfo info, Map<String, Object> params) throws BusinessException {
        JDBCAgent jdbcAgent = new JDBCAgent(false);
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ");
        sql.append("jk.TRIGGER_NAME,jk.NEXT_FIRE_TIME,jk.PREV_FIRE_TIME,jk.TRIGGER_TYPE,jk.START_TIME,jk.END_TIME,jk.JOB_GROUP ");
        sql.append("FROM  JK_TRIGGERS jk, CAP_FORM_BUSINESS_RELATION re  where ");
        if ("oracle".equals(JDBCAgent.getDBType())) {
            sql.append("jk.JOB_GROUP =to_char(re.ID)  AND jk.TRIGGER_STATE='WAITING' ORDER BY jk.NEXT_FIRE_TIME ASC");
        } else {
            sql.append("jk.JOB_GROUP =re.ID AND jk.TRIGGER_STATE='WAITING' ORDER BY jk.NEXT_FIRE_TIME ASC");
        }
        try {
            info = jdbcAgent.findByPaging(sql.toString(), info);
        }
        catch (SQLException e) {
            log.error((Object)"getCap4QuartzTaskList\u6570\u636e\u67e5\u8be2\u51fa\u9519\uff0c\u5177\u4f53\u89c1\uff1a", (Throwable)e);
        }
        finally {
            jdbcAgent.close();
        }
        ArrayList<QuartzTaskInfo> quartzTaskInfoList = new ArrayList<QuartzTaskInfo>();
        if (info != null) {
            List datas = info.getData();
            for (Map valueMap : datas) {
                QuartzTaskInfo quartzTaskInfo = new QuartzTaskInfo();
                String trigger_name = (String)valueMap.get("trigger_name");
                String[] formId = trigger_name.split("_");
                long next_fire_time_long = -1L;
                Object next_fire_time = valueMap.get("next_fire_time");
                if (next_fire_time instanceof Long) {
                    next_fire_time_long = (Long)next_fire_time;
                } else if (next_fire_time instanceof BigDecimal) {
                    next_fire_time_long = ((BigDecimal)next_fire_time).longValue();
                }
                if (next_fire_time_long != -1L) {
                    Date date_next = new Date(next_fire_time_long);
                    quartzTaskInfo.setExecutionTime(Datetimes.format((Date)date_next, (String)"yyyy-MM-dd HH:mm:ss"));
                } else {
                    quartzTaskInfo.setExecutionTime("-");
                }
                long prev_fire_time_long = -1L;
                Object prev_fire_time = valueMap.get("prev_fire_time");
                if (prev_fire_time instanceof Long) {
                    prev_fire_time_long = (Long)prev_fire_time;
                } else if (prev_fire_time instanceof BigDecimal) {
                    prev_fire_time_long = ((BigDecimal)prev_fire_time).longValue();
                }
                if (prev_fire_time_long != -1L) {
                    Date date_prev = new Date(prev_fire_time_long);
                    quartzTaskInfo.setLastExecutionTime(Datetimes.format((Date)date_prev, (String)"yyyy-MM-dd HH:mm:ss"));
                } else {
                    quartzTaskInfo.setLastExecutionTime("-");
                }
                String job_group = (String)valueMap.get("job_group");
                quartzTaskInfo.setTaskID(job_group);
                com.seeyon.cap4.form.bean.FormTriggerBean formTriggerBean = this.cap4FormCacheManager.getFormTriggerBean(Long.valueOf(job_group));
                com.seeyon.cap4.form.bean.FormBean formBean = this.cap4FormCacheManager.getForm(formTriggerBean.getSourceFormId());
                quartzTaskInfo.setFormName(formBean.getFormName());
                quartzTaskInfo.setRelationName(formTriggerBean.getName());
                String capBizConfigName = "-";
                BizConfigBean capBizConfig = this.businessManager4.findBizConfigByFormId(Long.valueOf(formId[0]));
                if (null != capBizConfig && Strings.isNotEmpty((String)capBizConfig.getName())) {
                    capBizConfigName = capBizConfig.getName();
                }
                quartzTaskInfo.setCategoryName(capBizConfigName);
                quartzTaskInfo.setTaskType(1);
                com.seeyon.cap4.form.bean.FormTriggerConditionBean formTriggerConditionBean = formTriggerBean.getDateCondition();
                int taskType = 1;
                if (formTriggerConditionBean != null) {
                    String param = formTriggerConditionBean.getTimeFrequency();
                    if ("once".equals(param)) {
                        taskType = 1;
                    } else if ("day".equals(param)) {
                        taskType = 2;
                    } else if ("week".equals(param)) {
                        taskType = 3;
                    } else if ("season".equals(param)) {
                        taskType = 4;
                    } else if ("halfyear".equals(param)) {
                        taskType = 5;
                    } else if ("year".equals(param)) {
                        taskType = 6;
                    }
                }
                quartzTaskInfo.setTaskType(taskType);
                List formTriggerActionBeans = formTriggerBean.getActionList();
                Map<String, String> actionInfo = this.getActionInfoForCAP4(formBean, formTriggerActionBeans, formTriggerBean);
                quartzTaskInfo.setTarContent(actionInfo.get("tarContent"));
                quartzTaskInfoList.add(quartzTaskInfo);
            }
        }
        info.setData(quartzTaskInfoList);
        return info;
    }

    @Override
    public Map<String, String> getEventInfo(Map<String, Object> params) throws BusinessException {
        HashMap<String, String> eventInfo = new HashMap<String, String>();
        String formSqlCap3All = "FROM FormTriggerEvent where (state = 0 or state = 2)";
        int cap3allCount = DBAgent.count((String)formSqlCap3All);
        String formSqlCap4All = "FROM CAPFormTriggerEvent where (state = 0 or state = 2)";
        int cap4allCount = DBAgent.count((String)formSqlCap4All);
        eventInfo.put("totalCount", String.valueOf(cap3allCount + cap4allCount));
        Date beforeOneSec = new Date(System.currentTimeMillis() - 60000L);
        params.put("beforeOneSec", beforeOneSec);
        String formSqlCap3In = "FROM FormTriggerEvent where  createTime>=:beforeOneSec";
        int cap3InCount = DBAgent.count((String)formSqlCap3In, params);
        String formSqlCap4In = "FROM CAPFormTriggerEvent where  createTime>=:beforeOneSec";
        int cap4InCount = DBAgent.count((String)formSqlCap4In, params);
        eventInfo.put("inQueueCount", String.valueOf(cap3InCount + cap4InCount));
        String formSqlCap3Out = "FROM FormTriggerEvent where state = 1 and modifyTime>=:beforeOneSec";
        int cap3OutCount = DBAgent.count((String)formSqlCap3Out, params);
        String formSqlCap4OutHistory = "FROM CapFormTriggerEventHistory where  modifyTime>=:beforeOneSec";
        int cap4OutCountHistory = DBAgent.count((String)formSqlCap4OutHistory, params);
        eventInfo.put("outQueueCount", String.valueOf(cap3OutCount + cap4OutCountHistory));
        return eventInfo;
    }

    @Override
    public FlipInfo getCap3EventListInfo(FlipInfo info, Map<String, Object> params) throws BusinessException {
        String formSql = "";
        String sourceFormName = (String)params.get("sourceFormName");
        formSql = sourceFormName != null && sourceFormName.length() > 0 ? "FROM FormTriggerEvent where (state = 0 or state = 2) AND formId IN (SELECT id FROM FormDefinition WHERE name LIKE('%" + sourceFormName + "%'))" : "FROM FormTriggerEvent where (state = 0 or state = 2) ORDER BY create_time desc";
        DBAgent.find((String)formSql, null, (FlipInfo)info);
        ArrayList<FormTrggerEventInfoView> formTrggerEventInfoViewList = new ArrayList<FormTrggerEventInfoView>();
        List formTriggerEvents = info.getData();
        if (formTriggerEvents != null) {
            for (FormTriggerEvent event : formTriggerEvents) {
                try {
                    FormTrggerEventInfoView formTrggerEventInfoView = new FormTrggerEventInfoView();
                    long formId = event.getFormId();
                    String capBizConfigName = "-";
                    FormBean formBean = this.formCacheManager.getForm(event.getFormId().longValue());
                    formTrggerEventInfoView.setCreateTime(Datetimes.format((Date)event.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                    formTrggerEventInfoView.setSourceFormName(this.getFormNameByFormID(formId));
                    BizConfigBean capBizConfig = this.businessManager4.findBizConfigByFormId(formId);
                    if (null != capBizConfig && Strings.isNotEmpty((String)capBizConfig.getName())) {
                        capBizConfigName = capBizConfig.getName();
                    }
                    formTrggerEventInfoView.setSourceAppName(capBizConfigName);
                    long userId = event.getUserId();
                    String creatorName = this.orgManager.getMemberById(Long.valueOf(userId)).getName();
                    CtpContentAll contentAll = MainbodyService.getInstance().getContent(event.getModuleType().intValue(), event.getModuleId().longValue());
                    String dataName = contentAll.getTitle();
                    if (formBean.getFormType() == Enums.FormType.manageInfo.getKey() || formBean.getFormType() == Enums.FormType.baseInfo.getKey()) {
                        dataName = creatorName + "  " + Datetimes.format((Date)contentAll.getCreateDate(), (String)"yyyy-MM-dd HH:mm:ss") + "  (ID: " + event.getMasterId() + ")";
                    }
                    formTrggerEventInfoView.setDataName(dataName);
                    List triggerList = this.formTriggerManager.getFormTriggerBeanList(formBean, event.getMasterId());
                    String triggerType = "";
                    String tarContent = "";
                    String triggerName = "";
                    String tarFormName = "";
                    if (!triggerList.isEmpty()) {
                        for (FormTriggerBean triggerBean : triggerList) {
                            List actions = triggerBean.getActions();
                            Map<String, String> actionInfo = this.getActionInfoForCAP3(formBean, actions, triggerBean);
                            triggerType = triggerType + actionInfo.get("triggerType");
                            tarContent = tarContent + actionInfo.get("tarContent");
                            triggerName = triggerName + actionInfo.get("triggerName");
                            tarFormName = tarFormName + actionInfo.get("tarFormName");
                        }
                    }
                    formTrggerEventInfoView.setTarContent(tarContent);
                    formTrggerEventInfoView.setTarFormName(tarFormName);
                    formTrggerEventInfoView.setTriggerName(triggerName);
                    formTrggerEventInfoView.setTriggerType(triggerType);
                    formTrggerEventInfoViewList.add(formTrggerEventInfoView);
                }
                catch (Exception e) {
                    log.info((Object)e.getMessage());
                }
            }
        }
        info.setData(formTrggerEventInfoViewList);
        return info;
    }

    @Override
    public FlipInfo getCap4EventListInfo(FlipInfo info, Map<String, Object> params) throws BusinessException {
        String sourceFormName = (String)params.get("sourceFormName");
        String formSql = "";
        formSql = sourceFormName != null && sourceFormName.length() > 0 ? "FROM CAPFormTriggerEvent where (state = 0 or state = 2) AND formId IN (SELECT id FROM CAPFormDefinition WHERE name LIKE('%" + sourceFormName + "%'))" : "FROM CAPFormTriggerEvent where (state = 0 or state = 2) ORDER BY create_time desc";
        DBAgent.find((String)formSql, null, (FlipInfo)info);
        ArrayList<FormTrggerEventInfoView> formTrggerEventInfoViewList = new ArrayList<FormTrggerEventInfoView>();
        List formTriggerEvents = info.getData();
        if (formTriggerEvents != null) {
            for (CAPFormTriggerEvent event : formTriggerEvents) {
                FormTrggerEventInfoView formTrggerEventInfoView = new FormTrggerEventInfoView();
                long formId = event.getFormId();
                String capBizConfigName = "-";
                com.seeyon.cap4.form.bean.FormBean formBean = this.cap4FormCacheManager.getForm(event.getFormId());
                formTrggerEventInfoView.setCreateTime(Datetimes.format((Date)event.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                formTrggerEventInfoView.setSourceFormName(this.getFormNameByFormID(formId));
                BizConfigBean capBizConfig = this.businessManager4.findBizConfigByFormId(formId);
                if (null != capBizConfig && Strings.isNotEmpty((String)capBizConfig.getName())) {
                    capBizConfigName = capBizConfig.getName();
                }
                formTrggerEventInfoView.setSourceAppName(capBizConfigName);
                long userId = event.getUserId();
                String creatorName = this.orgManager.getMemberById(Long.valueOf(userId)).getName();
                CtpContentAll contentAll = MainbodyService.getInstance().getContent(event.getModuleType().intValue(), event.getModuleId().longValue());
                String dataName = "";
                if (contentAll != null) {
                    dataName = contentAll.getTitle();
                    if (formBean.getFormType() == Enums.FormType.unFlowForm.getKey()) {
                        dataName = creatorName + "  " + Datetimes.format((Date)contentAll.getCreateDate(), (String)"yyyy-MM-dd HH:mm:ss") + "  (ID: " + event.getMasterId() + ")";
                    }
                }
                formTrggerEventInfoView.setDataName(dataName);
                List triggerListIDs = formBean.getFormTriggerIdList();
                ArrayList<com.seeyon.cap4.form.bean.FormTriggerBean> triggerList = new ArrayList<com.seeyon.cap4.form.bean.FormTriggerBean>();
                Iterator iterator = triggerListIDs.iterator();
                while (iterator.hasNext()) {
                    long triggerID = (Long)iterator.next();
                    triggerList.add(this.cap4FormCacheManager.getFormTriggerBean(triggerID));
                }
                String triggerType = "";
                String tarContent = "";
                String triggerName = "";
                String tarFormName = "";
                if (!triggerList.isEmpty()) {
                    for (com.seeyon.cap4.form.bean.FormTriggerBean triggerBean : triggerList) {
                        List actions = triggerBean.getActionList();
                        Map<String, String> actionInfo = this.getActionInfoForCAP4(formBean, actions, triggerBean);
                        triggerType = triggerType + actionInfo.get("triggerType");
                        tarContent = tarContent + actionInfo.get("tarContent");
                        triggerName = triggerName + actionInfo.get("triggerName");
                        tarFormName = tarFormName + actionInfo.get("tarFormName");
                    }
                }
                formTrggerEventInfoView.setTriggerType(triggerType);
                formTrggerEventInfoView.setTriggerName(triggerName);
                formTrggerEventInfoView.setTarFormName(tarFormName);
                formTrggerEventInfoView.setTarContent(tarContent);
                formTrggerEventInfoViewList.add(formTrggerEventInfoView);
            }
        }
        info.setData(formTrggerEventInfoViewList);
        return info;
    }

    private Map<String, String> getActionInfoForCAP3(FormBean formBean, List<com.seeyon.ctp.form.bean.FormTriggerActionBean> actions, FormTriggerBean triggerBean) throws BusinessException {
        String triggerType = "";
        String tarContent = "";
        String triggerName = "";
        String tarFormName = "";
        if (!actions.isEmpty()) {
            for (com.seeyon.ctp.form.bean.FormTriggerActionBean action : actions) {
                String actionType = action.getType();
                Enums.TriggerType triggerEnumType = Enums.TriggerType.getEnumByKey((String)actionType);
                triggerType = triggerType + triggerEnumType.getText() + "$";
                Map paramMap = action.getActionManager().getParamMap(action, formBean);
                String templateName = (String)paramMap.get("content");
                if ("taskDEE".equals(actionType)) {
                    String string = templateName = action.getParam("taskName") != null ? (String)action.getParam("taskName") : "";
                }
                if ("calculate".equals(actionType) || "bilateralback".equals(actionType)) {
                    String actionformId = action.getParam("formId") != null ? (String)action.getParam("formId") : "";
                    templateName = this.formCacheManager.getForm(Long.valueOf(actionformId).longValue()).getFormName();
                }
                if ("billInner".equals(actionType) || "billOuter".equals(actionType) || "autoInsert".equals(actionType)) {
                    templateName = formBean.getFormName();
                }
                if ("message".equals(actionType)) {
                    templateName = paramMap.get("messageMem_txt").toString();
                }
                if (null == templateName) {
                    templateName = "\u2014";
                }
                tarContent = tarContent + triggerEnumType.getText() + "-" + templateName + "$";
                triggerName = triggerName + triggerBean.getName() + "$";
                tarFormName = templateName + "$";
            }
        }
        HashMap<String, String> actionInfo = new HashMap<String, String>();
        actionInfo.put("triggerType", triggerType);
        actionInfo.put("triggerName", triggerName);
        actionInfo.put("tarFormName", tarFormName);
        actionInfo.put("tarContent", tarContent);
        return actionInfo;
    }

    private Map<String, String> getActionInfoForCAP4(com.seeyon.cap4.form.bean.FormBean formBean, List<FormTriggerActionBean> actions, com.seeyon.cap4.form.bean.FormTriggerBean triggerBean) throws BusinessException {
        String triggerType = "";
        String tarContent = "";
        String triggerName = "";
        String tarFormName = "";
        if (!actions.isEmpty()) {
            for (FormTriggerActionBean action : actions) {
                long actionformId;
                String actionType = action.getType();
                FormTriggerBean.TriggerType triggerEnumType = FormTriggerBean.TriggerType.getEnumByKey((String)actionType);
                triggerType = triggerType + triggerEnumType.getText() + "$";
                Map paramMap = action.getParam();
                String templateName = (String)paramMap.get("content");
                if ("taskDEE".equals(actionType)) {
                    templateName = action.getParam("taskName") != null ? (String)action.getParam("taskName") : "";
                }
                if (null == (templateName = (actionformId = (Long)action.getParam("formId") != null ? (Long)action.getParam("formId") : -1L) != -1L ? this.getFormNameByFormID(actionformId) : formBean.getFormName())) {
                    templateName = "\u2014";
                }
                String actionName = triggerEnumType.getText();
                tarContent = "message".equals(actionType) ? tarContent + actionName + "-" + paramMap.get("msgContent").toString() : tarContent + actionName + "-" + templateName + "$";
                triggerName = triggerName + triggerBean.getName() + "$";
                tarFormName = tarFormName + templateName + "$";
            }
        }
        HashMap<String, String> actionInfo = new HashMap<String, String>();
        actionInfo.put("triggerType", triggerType);
        actionInfo.put("triggerName", triggerName);
        actionInfo.put("tarFormName", tarFormName);
        actionInfo.put("tarContent", tarContent);
        return actionInfo;
    }

    private LinkedHashMap<Long, Integer> sortMapValueDescending(Map<Long, Integer> map, int start, int end) {
        LinkedList<Map.Entry<Long, Integer>> list = new LinkedList<Map.Entry<Long, Integer>>(map.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<Long, Integer>>(){

            @Override
            public int compare(Map.Entry<Long, Integer> o1, Map.Entry<Long, Integer> o2) {
                int compare = o1.getValue().compareTo(o2.getValue());
                return -compare;
            }
        });
        LinkedHashMap<Long, Integer> result = new LinkedHashMap<Long, Integer>();
        int counter = 0;
        for (Map.Entry entry : list) {
            if (counter >= start && counter < end) {
                result.put((Long)entry.getKey(), (Integer)entry.getValue());
            } else if (counter >= end) break;
            ++counter;
        }
        return result;
    }

    private String getFormNameByFormID(Long formId) {
        String formName = formId.toString();
        FormBean cap3FormBean = this.formCacheManager.getForm(formId.longValue());
        if (cap3FormBean != null) {
            formName = cap3FormBean.getFormName();
        } else {
            com.seeyon.cap4.form.bean.FormBean cap4FormBean = this.cap4FormCacheManager.getForm(formId);
            if (cap4FormBean != null) {
                formName = cap4FormBean.getFormName();
            }
        }
        return formName;
    }

    public FormCacheManager getFormCacheManager() {
        return this.formCacheManager;
    }

    public void setFormCacheManager(FormCacheManager formCacheManager) {
        this.formCacheManager = formCacheManager;
    }

    public CAP4FormCacheManager getCap4FormCacheManager() {
        return this.cap4FormCacheManager;
    }

    public void setCap4FormCacheManager(CAP4FormCacheManager cap4FormCacheManager) {
        this.cap4FormCacheManager = cap4FormCacheManager;
    }

    public BusinessManager getBusinessManager4() {
        return this.businessManager4;
    }

    public void setBusinessManager4(BusinessManager businessManager4) {
        this.businessManager4 = businessManager4;
    }

    public TemplateManager getTemplateManager() {
        return this.templateManager;
    }

    public void setTemplateManager(TemplateManager templateManager) {
        this.templateManager = templateManager;
    }

    public TaskEventManager getTaskEventManager() {
        return this.taskEventManager;
    }

    public void setTaskEventManager(TaskEventManager taskEventManager) {
        this.taskEventManager = taskEventManager;
    }

    public OrgManager getOrgManager() {
        return this.orgManager;
    }

    public void setOrgManager(OrgManager orgManager) {
        this.orgManager = orgManager;
    }

    public FormTriggerManager getFormTriggerManager() {
        return this.formTriggerManager;
    }

    public void setFormTriggerManager(FormTriggerManager formTriggerManager) {
        this.formTriggerManager = formTriggerManager;
    }

    public CAP4FormTriggerManager getCap4FormTriggerManager() {
        return this.cap4FormTriggerManager;
    }

    public void setCap4FormTriggerManager(CAP4FormTriggerManager cap4FormTriggerManager) {
        this.cap4FormTriggerManager = cap4FormTriggerManager;
    }
}

