/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.monitor.track.dao;

import com.seeyon.cap4.magic.dao.MagicProviderDaoImpl;
import com.seeyon.cap4.monitor.track.TrackEnums;
import com.seeyon.cap4.monitor.track.dao.ICAP4FormTrackConfigDao;
import com.seeyon.cap4.monitor.track.po.FormBusinessTrackConfig;
import com.seeyon.cap4.monitor.track.po.FormDataTrackConfig;
import com.seeyon.ctp.common.cache.CacheAccessable;
import com.seeyon.ctp.common.cache.CacheFactory;
import com.seeyon.ctp.common.cache.CacheMap;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.util.DBAgent;
import com.seeyon.ctp.util.FlipInfo;
import com.seeyon.ctp.util.JDBCAgent;
import com.seeyon.ctp.util.Strings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CAP4FormTrackConfigDaoImpl
implements ICAP4FormTrackConfigDao {
    private static final CacheAccessable cacheFactory = CacheFactory.getInstance(MagicProviderDaoImpl.class);
    private static CacheMap<Long, FormBusinessTrackConfig> monitorBusinessTrack = cacheFactory.createMap("monitorBusinessTrack");
    private static CacheMap<Long, FormDataTrackConfig> monitorFormDataTrack = cacheFactory.createMap("monitorFormDataTrack");

    public CAP4FormTrackConfigDaoImpl() {
        this.init();
    }

    @Override
    public List<FormBusinessTrackConfig> loadBusinessTrackConfig(FlipInfo info, Map<String, Object> params) throws BusinessException {
        String queryHql = "from FormBusinessTrackConfig";
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        ArrayList<String> querySql = new ArrayList<String>();
        if (params != null) {
            if (params.containsKey("formId")) {
                queryParams.put("formId", params.get("formId"));
                querySql.add("formId =:formId");
            } else if (params.containsKey("trackStatus")) {
                queryParams.put("trackStatus", params.get("trackStatus"));
                querySql.add("trackStatus =:trackStatus");
            }
        }
        if (!querySql.isEmpty()) {
            queryHql = queryHql + " where " + Strings.join(querySql, (String)" and ");
        }
        queryHql = queryHql + " order by trackDate DESC";
        DBAgent.find((String)queryHql, queryParams, (FlipInfo)info);
        return info.getData();
    }

    @Override
    public List<FormBusinessTrackConfig> loadBusinessTrackConfig(Long formId, String formVersion, TrackEnums.TrackStatus status) throws BusinessException {
        ArrayList<FormBusinessTrackConfig> all = new ArrayList<FormBusinessTrackConfig>();
        for (FormBusinessTrackConfig b : monitorBusinessTrack.values()) {
            if (formId != null && !formId.equals(b.getFormId()) || !Strings.isBlank((String)formVersion) && !formVersion.equals(b.getFormType()) || status != null && status.getKey() != b.getTrackStatus().intValue()) continue;
            all.add(b);
        }
        return all;
    }

    @Override
    public List<FormDataTrackConfig> loadDataTrackConfig(Long formId, String formVersion, TrackEnums.TrackStatus status) throws BusinessException {
        ArrayList<FormDataTrackConfig> all = new ArrayList<FormDataTrackConfig>();
        for (FormDataTrackConfig b : monitorFormDataTrack.values()) {
            if (formId != null && !formId.equals(b.getFormId()) || !Strings.isBlank((String)formVersion) && !formVersion.equals(b.getFormType()) || status != null && status.getKey() != b.getTrackStatus().intValue()) continue;
            all.add(b);
        }
        return all;
    }

    @Override
    public List<FormDataTrackConfig> loadDataTrackConfigByTableName(Long formId, String formTableName) throws BusinessException {
        ArrayList<FormDataTrackConfig> all = new ArrayList<FormDataTrackConfig>();
        for (FormDataTrackConfig b : monitorFormDataTrack.values()) {
            if (!b.getFormId().equals(formId) || !b.getFormTableName().equals(formTableName)) continue;
            all.add(b);
        }
        return all;
    }

    @Override
    public List<FormDataTrackConfig> loadDataTrackConfig(List<Long> idList) throws BusinessException {
        ArrayList<FormDataTrackConfig> all = new ArrayList<FormDataTrackConfig>();
        if (idList != null) {
            for (Long id : idList) {
                FormDataTrackConfig b = (FormDataTrackConfig)((Object)monitorFormDataTrack.get((Serializable)id));
                if (b == null) continue;
                all.add(b);
            }
        }
        return all;
    }

    private void init() {
        List allDataTrack = DBAgent.loadAll(FormDataTrackConfig.class);
        this.addFormDataTrackToCache(allDataTrack);
        List allBusinessTrack = DBAgent.loadAll(FormBusinessTrackConfig.class);
        this.addBusinessTrackToCache(allBusinessTrack);
    }

    @Override
    public List<FormDataTrackConfig> loadDataTrackConfig(FlipInfo info, Map<String, Object> params) throws BusinessException {
        String queryHql = "from FormDataTrackConfig";
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        ArrayList<String> querySql = new ArrayList<String>();
        if (params != null) {
            if (params.containsKey("formId")) {
                queryParams.put("formId", params.get("formId"));
                querySql.add("formId =:formId");
            } else if (params.containsKey("formTableName")) {
                queryParams.put("formTableName", params.get("formTableName"));
                querySql.add("formTableName =:formTableName");
            } else if (params.containsKey("trackStatus")) {
                queryParams.put("trackStatus", params.get("trackStatus"));
                querySql.add("trackStatus =:trackStatus");
            }
        }
        if (!querySql.isEmpty()) {
            queryHql = queryHql + " where " + Strings.join(querySql, (String)" and ");
        }
        queryHql = queryHql + " order by trackDate desc";
        DBAgent.find((String)queryHql, queryParams, (FlipInfo)info);
        return info.getData();
    }

    @Override
    public boolean saveBusinessTrackConfigs(List<FormBusinessTrackConfig> configList) throws BusinessException {
        if (configList != null && !configList.isEmpty()) {
            DBAgent.saveAll(configList);
            this.addBusinessTrackToCache(configList);
        }
        return true;
    }

    private void addBusinessTrackToCache(List<FormBusinessTrackConfig> configList) {
        for (FormBusinessTrackConfig t : configList) {
            monitorBusinessTrack.put((Serializable)t.getId(), (Serializable)((Object)t));
        }
    }

    @Override
    public boolean saveDataTrackConfig(List<FormDataTrackConfig> configList) throws BusinessException {
        if (configList != null && !configList.isEmpty()) {
            DBAgent.saveAll(configList);
            this.addFormDataTrackToCache(configList);
        }
        return true;
    }

    private void addFormDataTrackToCache(List<FormDataTrackConfig> configList) {
        for (FormDataTrackConfig t : configList) {
            monitorFormDataTrack.put((Serializable)t.getId(), (Serializable)((Object)t));
        }
    }

    @Override
    public boolean updateBusinessConfigsStatus(List<Long> idList, TrackEnums.TrackStatus status) throws BusinessException {
        String sql = "update FORM_TRACK_BUSINESS_CONFIG set TRACK_STATUS =" + status.getKey();
        try {
            JDBCAgent s = new JDBCAgent(true, true);
            s.execute(sql);
            this.init();
        }
        catch (Exception e) {
            throw new BusinessException(e.getLocalizedMessage(), (Throwable)e);
        }
        return true;
    }

    @Override
    public boolean updateDataConfigStatus(TrackEnums.TrackStatus status) throws BusinessException {
        String sql = "update FORM_TRACK_DATA_CONFIG set TRACK_STATUS =" + status.getKey();
        try {
            JDBCAgent s = new JDBCAgent(true, true);
            s.execute(sql);
            this.init();
        }
        catch (Exception e) {
            throw new BusinessException(e.getLocalizedMessage(), (Throwable)e);
        }
        return true;
    }

    @Override
    public boolean deleteBusinessConfigs(List<Long> idList) throws BusinessException {
        ArrayList<FormBusinessTrackConfig> configs = new ArrayList<FormBusinessTrackConfig>(idList.size());
        for (Long id : idList) {
            FormBusinessTrackConfig c = (FormBusinessTrackConfig)((Object)DBAgent.get(FormBusinessTrackConfig.class, (Serializable)id));
            if (c == null) continue;
            configs.add(c);
            monitorBusinessTrack.remove((Serializable)c.getId());
        }
        DBAgent.deleteAll(configs);
        return true;
    }

    @Override
    public boolean deleteDataConfigs(List<Long> idList) throws BusinessException {
        ArrayList<FormDataTrackConfig> configs = new ArrayList<FormDataTrackConfig>(idList.size());
        for (Long id : idList) {
            FormDataTrackConfig c = (FormDataTrackConfig)((Object)DBAgent.get(FormDataTrackConfig.class, (Serializable)id));
            if (c == null) continue;
            configs.add(c);
            monitorFormDataTrack.remove((Serializable)c.getId());
        }
        DBAgent.deleteAll(configs);
        return true;
    }
}

