/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.monitor.track.manager;

import com.seeyon.cap4.form.modules.business.BizConfigBean;
import com.seeyon.cap4.form.modules.business.BusinessManager;
import com.seeyon.cap4.form.service.CAP4FormCacheManager;
import com.seeyon.cap4.magic.vo.MagicEnums;
import com.seeyon.cap4.magic.vo.MagicFormBean;
import com.seeyon.cap4.magic.vo.MagicFormTableBean;
import com.seeyon.cap4.monitor.track.TrackEnums;
import com.seeyon.cap4.monitor.track.dao.ICAP4FormTrackConfigDao;
import com.seeyon.cap4.monitor.track.manager.ICAP4FormTrackManager;
import com.seeyon.cap4.monitor.track.po.FormBusinessTrackConfig;
import com.seeyon.cap4.monitor.track.po.FormDataTrackConfig;
import com.seeyon.cap4.monitor.track.vo.FormTableTreeItem;
import com.seeyon.cap4.monitor.utils.CAP4MonitorUtil;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.filemanager.manager.FileManager;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.po.template.CtpTemplateCategory;
import com.seeyon.ctp.common.security.SecurityHelper;
import com.seeyon.ctp.common.template.manager.TemplateManager;
import com.seeyon.ctp.form.bean.FormBean;
import com.seeyon.ctp.form.bean.FormTableBean;
import com.seeyon.ctp.form.service.FormCacheManager;
import com.seeyon.ctp.form.util.Enums;
import com.seeyon.ctp.monitor.perf.jdbcmonitor.proxyobj.JMTrackTableCfg;
import com.seeyon.ctp.monitor.perf.jdbcmonitor.proxyobj.JMTrackUtils;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.FileUtil;
import com.seeyon.ctp.util.FlipInfo;
import com.seeyon.ctp.util.ParamUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.UUIDLong;
import com.seeyon.ctp.util.ZipUtil;
import com.seeyon.ctp.util.annotation.AjaxAccess;
import java.io.File;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;

public class CAP4FormTrackManagerImpl
implements ICAP4FormTrackManager {
    private CAP4FormCacheManager cap4FormCacheManager;
    private ICAP4FormTrackConfigDao cap4FormTrackConfigDao;
    private BusinessManager businessManager4;
    private FormCacheManager formCacheManager;
    private FileManager fileManager;
    private static final Log LOGGER = CtpLogFactory.getLog(CAP4FormTrackManagerImpl.class);

    @Override
    @AjaxAccess
    public Map<String, Object> addBusinessTarcks(List<Map<String, Object>> params) throws BusinessException {
        ArrayList<FormBusinessTrackConfig> configs = new ArrayList<FormBusinessTrackConfig>();
        HashMap<String, Long> queryParams = new HashMap<String, Long>();
        ArrayList<String> exists = new ArrayList<String>();
        int x = 0;
        TrackEnums.TrackStatus status = TrackEnums.TrackStatus.IN_TRACKING;
        for (Map<String, Object> entry : params) {
            Long formId = ParamUtil.getLong(entry, (String)"formId", (Long)0L);
            String formType = ParamUtil.getString(entry, (String)"formType", (String)"");
            MagicEnums.ServiceOwnerType type = MagicEnums.ServiceOwnerType.getEnumByType((String)formType);
            MagicFormBean fb = new MagicFormBean(type, formId);
            if (fb.isNull()) continue;
            queryParams.put("formId", formId);
            List<FormBusinessTrackConfig> data = this.cap4FormTrackConfigDao.loadBusinessTrackConfig(formId, formType, null);
            if (data != null && !data.isEmpty()) {
                exists.add(fb.getFormName());
                continue;
            }
            FormBusinessTrackConfig config = new FormBusinessTrackConfig();
            config.setIdIfNew();
            config.setCreateId(AppContext.currentUserId());
            config.setFormId(fb.getId());
            config.setFormType(fb.getType().getType());
            Date d = new Date(System.currentTimeMillis() + (long)x);
            x += 1000;
            config.setTrackDate(d);
            config.setCreateDate(d);
            config.setTrackStatus(status.getKey());
            configs.add(config);
        }
        this.cap4FormTrackConfigDao.saveBusinessTrackConfigs(configs);
        Map<String, Object> result = this.saveSuccessResult();
        if (!exists.isEmpty()) {
            String msg = Strings.join(exists, (String)",");
            result.put("msg", msg + " \u6ca1\u6709\u4fdd\u5b58\uff0c\u539f\u56e0:\u5df2\u5b58\u5728!");
        }
        return result;
    }

    @Override
    @AjaxAccess
    public Map<String, Object> addDataTarcks(List<Map<String, Object>> params) throws BusinessException {
        ArrayList<FormDataTrackConfig> configs = new ArrayList<FormDataTrackConfig>();
        ArrayList<String> exists = new ArrayList<String>();
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        HashMap<String, String> needUpdateCache = new HashMap<String, String>();
        int x = 0;
        List<FormDataTrackConfig> stopTrackingList = this.cap4FormTrackConfigDao.loadDataTrackConfig(null, null, TrackEnums.TrackStatus.STOP_Track);
        TrackEnums.TrackStatus status = TrackEnums.TrackStatus.IN_TRACKING;
        if (stopTrackingList != null && !stopTrackingList.isEmpty()) {
            status = TrackEnums.TrackStatus.STOP_Track;
        }
        for (Map<String, Object> item : params) {
            MagicFormTableBean tableBean;
            MagicFormBean fb;
            Long formId = ParamUtil.getLong(item, (String)"parentId", (Long)0L);
            String formType = ParamUtil.getString(item, (String)"formType", (String)"");
            String tableName = ParamUtil.getString(item, (String)"id", (String)"");
            MagicEnums.ServiceOwnerType type = MagicEnums.ServiceOwnerType.getEnumByType((String)formType);
            if (type == null || (fb = new MagicFormBean(type, formId)).isNull() || (tableBean = fb.getTableByTableName(tableName)) == null) continue;
            queryParams.put("formId", formId);
            queryParams.put("formTableName", tableName);
            List<FormDataTrackConfig> data = this.cap4FormTrackConfigDao.loadDataTrackConfigByTableName(formId, tableName);
            if (data != null && !data.isEmpty()) {
                exists.add(fb.getFormName() + "[" + tableBean.getDisplay() + "]");
                continue;
            }
            needUpdateCache.put(tableName, tableBean.getDisplay());
            FormDataTrackConfig config = new FormDataTrackConfig();
            config.setIdIfNew();
            config.setFormId(fb.getId());
            config.setFormType(type.getType());
            config.setTrackStatus(status.getKey());
            config.setCreaterId(AppContext.currentUserId());
            config.setFormTableName(tableName);
            Date d = new Date(System.currentTimeMillis() + (long)x);
            x += 1000;
            config.setTrackDate(d);
            config.setCreateDate(d);
            configs.add(config);
        }
        this.cap4FormTrackConfigDao.saveDataTrackConfig(configs);
        Map<String, Object> result = this.saveSuccessResult();
        if (!exists.isEmpty()) {
            String msg = Strings.join(exists, (String)",");
            result.put("msg", msg + " \u6ca1\u6709\u4fdd\u5b58\uff0c\u539f\u56e0:\u5df2\u5b58\u5728!");
        }
        JMTrackTableCfg fCfg = JMTrackUtils.getTrackTableCfg();
        for (Map.Entry f : needUpdateCache.entrySet()) {
            fCfg.putTrackTableName((String)f.getKey(), (String)f.getValue());
        }
        return result;
    }

    private Map<String, Object> saveSuccessResult() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("msg", "\u4fdd\u5b58\u6210\u529f");
        result.put("statusCode", "200");
        return result;
    }

    @Override
    @AjaxAccess
    public FlipInfo loadBusinessTracks(FlipInfo info, Map<String, Object> params) throws BusinessException {
        if (info == null) {
            info = new FlipInfo();
        }
        List<FormBusinessTrackConfig> configs = this.cap4FormTrackConfigDao.loadBusinessTrackConfig(info, params);
        ArrayList<Map<String, Object>> businessConfigShowList = new ArrayList<Map<String, Object>>(configs.size());
        int sort = 1;
        for (FormBusinessTrackConfig config : configs) {
            Map<String, Object> showItem = this.showBusinessConfig(config);
            showItem.put("sort", sort);
            businessConfigShowList.add(showItem);
            ++sort;
        }
        info.setData(businessConfigShowList);
        return info;
    }

    private Map<String, Object> showBusinessConfig(FormBusinessTrackConfig config) throws BusinessException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("id", String.valueOf(config.getId()));
        result.put("formId", String.valueOf(config.getFormId()));
        MagicEnums.ServiceOwnerType type = MagicEnums.ServiceOwnerType.getEnumByType((String)config.getFormType());
        result.putAll(this.getBizInfo(type, config.getFormId()));
        result.put("formType", config.getFormType());
        result.put("trackDate", config.getTrackDate());
        result.put("trackStatus", config.getTrackStatus());
        TrackEnums.TrackStatus ts = TrackEnums.TrackStatus.getStatusByKey(config.getTrackStatus());
        if (ts != null) {
            result.put("trackStatusText", ts.getI18nText());
        }
        return result;
    }

    private Map<String, Object> getBizInfo(MagicEnums.ServiceOwnerType type, long formId) throws BusinessException {
        MagicFormBean formBean;
        HashMap<String, Object> result = new HashMap<String, Object>();
        TemplateManager templateManager = (TemplateManager)AppContext.getBean((String)"templateManager");
        if (type != null && !(formBean = new MagicFormBean(type, formId)).isNull()) {
            result.put("formName", formBean.getFormName());
            if (MagicEnums.ServiceOwnerType.DEFAULT_FORM.equals((Object)type)) {
                BizConfigBean configBean = this.businessManager4.findBizConfigByFormId(formId);
                if (configBean != null) {
                    result.put("bizId", String.valueOf(configBean.getId()));
                    result.put("bizName", configBean.getName());
                } else {
                    CtpTemplateCategory category = templateManager.getCtpTemplateCategory(Long.valueOf(formBean.getCap4FormBean().getCategoryId()));
                    if (category != null) {
                        result.put("bizId", String.valueOf(category.getId()));
                        result.put("bizName", category.getName());
                    }
                }
            } else {
                CtpTemplateCategory category = templateManager.getCtpTemplateCategory(Long.valueOf(formBean.getCap3FormBean().getCategoryId()));
                if (category != null) {
                    result.put("bizId", String.valueOf(category.getId()));
                    result.put("bizName", category.getName());
                }
            }
        }
        return result;
    }

    @Override
    @AjaxAccess
    public FlipInfo loadFormDataTracks(FlipInfo info, Map<String, Object> params) throws BusinessException {
        if (info == null) {
            info = new FlipInfo();
        }
        List<FormDataTrackConfig> configs = this.cap4FormTrackConfigDao.loadDataTrackConfig(info, params);
        ArrayList<Map<String, Object>> businessConfigShowList = new ArrayList<Map<String, Object>>(configs.size());
        int sort = 1;
        for (FormDataTrackConfig config : configs) {
            Map<String, Object> showItem = this.showDataConfig(config);
            showItem.put("sort", sort);
            businessConfigShowList.add(showItem);
            ++sort;
        }
        info.setData(businessConfigShowList);
        return info;
    }

    private Map<String, Object> showDataConfig(FormDataTrackConfig config) throws BusinessException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("id", String.valueOf(config.getId()));
        result.put("formId", String.valueOf(config.getFormId()));
        result.put("formType", config.getFormType());
        result.put("trackDate", config.getTrackDate());
        result.put("trackStatus", config.getTrackStatus());
        TrackEnums.TrackStatus ts = TrackEnums.TrackStatus.getStatusByKey(config.getTrackStatus());
        if (ts != null) {
            result.put("trackStatusText", ts.getI18nText());
        }
        MagicEnums.ServiceOwnerType type = MagicEnums.ServiceOwnerType.getEnumByType((String)config.getFormType());
        result.putAll(this.getBizInfo(type, config.getFormId()));
        if (MagicEnums.ServiceOwnerType.DEFAULT_FORM_CAP3.equals((Object)type)) {
            FormTableBean table;
            FormBean fb = this.formCacheManager.getForm(config.getFormId().longValue());
            if (fb != null && (table = fb.getTableByTableName(config.getFormTableName())) != null) {
                result.put("tableName", table.getTableName());
            }
        } else {
            com.seeyon.cap4.form.bean.FormTableBean table;
            com.seeyon.cap4.form.bean.FormBean fb = this.cap4FormCacheManager.getForm(config.getFormId());
            if (fb != null && (table = fb.getTableByTableName(config.getFormTableName())) != null) {
                result.put("tableName", table.getTableName());
            }
        }
        return result;
    }

    @Override
    @AjaxAccess
    public Map<String, Object> handleBusinessTrackConfig(Map<String, Object> params) throws BusinessException {
        Long id = ParamUtil.getLong(params, (String)"id", (Long)0L);
        ArrayList<Long> idList = new ArrayList<Long>();
        idList.add(id);
        String handelType = ParamUtil.getString(params, (String)"handelType");
        TrackEnums.TrackStatus status = null;
        if ("stop".equals(handelType)) {
            status = TrackEnums.TrackStatus.STOP_Track;
        } else if ("start".equals(handelType)) {
            status = TrackEnums.TrackStatus.IN_TRACKING;
        }
        if (status != null) {
            this.cap4FormTrackConfigDao.updateBusinessConfigsStatus(idList, status);
        } else if ("delete".equals(handelType)) {
            this.cap4FormTrackConfigDao.deleteBusinessConfigs(idList);
        } else if ("clean".equals(handelType)) {
            File[] filterFiles;
            for (File f : filterFiles = CAP4MonitorUtil.getTrackFiles("historyobj")) {
                FileUtil.deleteFile((File)f);
            }
        }
        return Collections.emptyMap();
    }

    @Override
    @AjaxAccess
    public Map<String, Object> handleDataTrackConfig(Map<String, Object> params) throws BusinessException {
        block10: {
            File[] filterFiles;
            String handelType;
            block11: {
                JMTrackTableCfg fCfg;
                ArrayList<Long> idList;
                block9: {
                    Long id = ParamUtil.getLong(params, (String)"id", (Long)0L);
                    idList = new ArrayList<Long>();
                    idList.add(id);
                    handelType = ParamUtil.getString(params, (String)"handelType");
                    TrackEnums.TrackStatus status = null;
                    if ("stop".equals(handelType)) {
                        status = TrackEnums.TrackStatus.STOP_Track;
                    } else if ("start".equals(handelType)) {
                        status = TrackEnums.TrackStatus.IN_TRACKING;
                    }
                    fCfg = JMTrackUtils.getTrackTableCfg();
                    if (status == null) break block9;
                    this.cap4FormTrackConfigDao.updateDataConfigStatus(status);
                    if (TrackEnums.TrackStatus.STOP_Track.equals((Object)status)) {
                        for (FormDataTrackConfig f : this.cap4FormTrackConfigDao.loadDataTrackConfig(null, null, null)) {
                            fCfg.removeTrackTableName(f.getFormTableName());
                        }
                        fCfg.disableTrackTable();
                    } else {
                        for (FormDataTrackConfig f : this.cap4FormTrackConfigDao.loadDataTrackConfig(null, null, null)) {
                            MagicFormTableBean tableBean;
                            MagicEnums.ServiceOwnerType type = MagicEnums.ServiceOwnerType.getEnumByType((String)f.getFormType());
                            MagicFormBean formBean = new MagicFormBean(type, f.getFormId());
                            if (formBean.isNull() || (tableBean = formBean.getTableByTableName(f.getFormTableName())) == null) continue;
                            fCfg.putTrackTableName(f.getFormTableName(), tableBean.getDisplay());
                        }
                        fCfg.enableTrackTable();
                    }
                    break block10;
                }
                if (!"delete".equals(handelType)) break block11;
                List<FormDataTrackConfig> handleList = this.cap4FormTrackConfigDao.loadDataTrackConfig(idList);
                this.cap4FormTrackConfigDao.deleteDataConfigs(idList);
                for (FormDataTrackConfig f : handleList) {
                    fCfg.removeTrackTableName(f.getFormTableName());
                }
                break block10;
            }
            if (!"clean".equals(handelType)) break block10;
            for (File f : filterFiles = CAP4MonitorUtil.getTrackFiles("tracksave")) {
                FileUtil.deleteFile((File)f);
            }
        }
        return Collections.emptyMap();
    }

    @Override
    @AjaxAccess
    public List<FormTableTreeItem> loadTablesByFormList(Map<String, Object> params) throws BusinessException {
        ArrayList<FormTableTreeItem> result;
        block9: {
            ArrayList<String> formTableNames;
            String type;
            String name;
            block8: {
                List<Map<String, Object>> listMap;
                FormTableTreeItem formItem;
                List<FormTableTreeItem> tempTables;
                result = new ArrayList<FormTableTreeItem>();
                name = ParamUtil.getString(params, (String)"name", (String)"");
                type = ParamUtil.getString(params, (String)"serviceType", (String)"");
                try {
                    name = URLDecoder.decode(name, "UTF-8");
                }
                catch (Exception e) {
                    LOGGER.error((Object)e.getLocalizedMessage());
                }
                List<FormDataTrackConfig> allTrack = this.cap4FormTrackConfigDao.loadDataTrackConfig(null, null, null);
                formTableNames = new ArrayList<String>(allTrack.size());
                for (FormDataTrackConfig formDataTrackConfig : allTrack) {
                    formTableNames.add(formDataTrackConfig.getFormTableName());
                }
                if (!MagicEnums.ServiceOwnerType.DEFAULT_FORM.getType().equals(type)) break block8;
                FormTableTreeItem root = new FormTableTreeItem();
                root.setId("root");
                root.setName(ResourceUtil.getString((String)"system.menuname.BusinessApplication"));
                result.add(root);
                for (BizConfigBean bizConfigBean : this.businessManager4.getAllBizConfigInCache()) {
                    FormTableTreeItem biz = new FormTableTreeItem();
                    biz.setId(String.valueOf(bizConfigBean.getId()));
                    biz.setName(bizConfigBean.getName());
                    biz.setParentId(root.getId());
                    List<com.seeyon.cap4.form.bean.FormBean> fbList = this.businessManager4.getFormBeanListByBizId(bizConfigBean.getId());
                    ArrayList<FormTableTreeItem> tableSummary = new ArrayList<FormTableTreeItem>();
                    for (com.seeyon.cap4.form.bean.FormBean f : fbList) {
                        if (Strings.isNotBlank((String)name) && !f.getFormName().contains(name) || (tempTables = this.convertCap4Tables(type, f, formTableNames)).isEmpty()) continue;
                        formItem = new FormTableTreeItem();
                        formItem.setFormType(type);
                        formItem.setId(String.valueOf(f.getId()));
                        formItem.setParentId(biz.getId());
                        formItem.setName(f.getFormName());
                        tableSummary.add(formItem);
                        tableSummary.addAll(tempTables);
                    }
                    if (tableSummary.isEmpty()) continue;
                    result.add(biz);
                    result.addAll(tableSummary);
                }
                FormTableTreeItem formTableTreeItem = new FormTableTreeItem();
                formTableTreeItem.setId("123456");
                formTableTreeItem.setName(ResourceUtil.getString((String)"cap4.form.business.formmanagement"));
                result.add(formTableTreeItem);
                HashMap<String, Object> tempParams = new HashMap<String, Object>();
                if (Strings.isNotBlank((String)name)) {
                    tempParams.put("name", name);
                }
                if ((listMap = this.cap4FormCacheManager.getCap4FormDefinitionDAO().showFormList(null, tempParams)).isEmpty()) break block9;
                for (Map<String, Object> map : listMap) {
                    com.seeyon.cap4.form.bean.FormBean f;
                    Long formId = ParamUtil.getLong(map, (String)"id", (Long)0L);
                    f = this.cap4FormCacheManager.getForm(formId);
                    if (f == null || (tempTables = this.convertCap4Tables(type, f, formTableNames)).isEmpty()) continue;
                    formItem = new FormTableTreeItem();
                    formItem.setFormType(type);
                    formItem.setId(String.valueOf(f.getId()));
                    formItem.setParentId(formTableTreeItem.getId());
                    formItem.setName(f.getFormName());
                    result.add(formItem);
                    result.addAll(tempTables);
                }
                break block9;
            }
            for (FormBean formBean : this.formCacheManager.getFormList()) {
                List<FormTableTreeItem> tempTables;
                if (Strings.isNotBlank((String)name) && !formBean.getFormName().contains(name) || Enums.FormType.baseInfo.getKey() != formBean.getFormType() && Enums.FormType.processesForm.getKey() != formBean.getFormType() && Enums.FormType.manageInfo.getKey() != formBean.getFormType() || (tempTables = this.convertCap3Tables(type, formBean, formTableNames)).isEmpty()) continue;
                FormTableTreeItem formItem = new FormTableTreeItem();
                formItem.setFormType(type);
                formItem.setId(String.valueOf(formBean.getId()));
                formItem.setName(formBean.getFormName());
                result.add(formItem);
                result.addAll(tempTables);
            }
        }
        return result;
    }

    @Override
    @AjaxAccess
    public Map<String, Object> getTrackLogSize(Map<String, Object> params) throws BusinessException {
        File monitor = new File(SystemEnvironment.getBaseFolder(), "monitor");
        String filterName = ParamUtil.getString(params, (String)"trackType", (String)"");
        HashMap<String, Object> result = new HashMap<String, Object>();
        boolean canClear = this.checkClear(filterName);
        if (!canClear) {
            result.put("canClear", "0");
            return result;
        }
        result.put("canClear", "1");
        File[] files = CAP4MonitorUtil.getTrackFiles(filterName);
        long fileSize = 0L;
        for (File f : files) {
            fileSize += f.length();
        }
        long free = monitor.getFreeSpace();
        double freeForM = (double)free / 1024.0 / 1024.0;
        double usedForM = (double)fileSize / 1024.0 / 1024.0;
        result.put("free", String.format("%.2f", freeForM));
        result.put("used", String.format("%.2f", usedForM));
        return result;
    }

    private boolean checkClear(String filterName) throws BusinessException {
        boolean canClear = true;
        if ("historyobj".equals(filterName)) {
            List<FormBusinessTrackConfig> data = this.cap4FormTrackConfigDao.loadBusinessTrackConfig(null, null, TrackEnums.TrackStatus.IN_TRACKING);
            if (data != null && !data.isEmpty()) {
                canClear = false;
            }
        } else {
            List<FormDataTrackConfig> data = this.cap4FormTrackConfigDao.loadDataTrackConfig(null, null, TrackEnums.TrackStatus.IN_TRACKING);
            if (data != null && !data.isEmpty()) {
                canClear = false;
            }
        }
        return canClear;
    }

    @Override
    @AjaxAccess
    public Map<String, Object> downloadTrackLogs(Map<String, Object> params) throws BusinessException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String filterName = ParamUtil.getString(params, (String)"trackType", (String)"");
        File[] filterFiles = CAP4MonitorUtil.getTrackFiles(filterName);
        String fileName = String.valueOf(UUIDLong.longUUID());
        File tempMonitorFolder = new File(SystemEnvironment.getSystemTempFolder(), fileName);
        ArrayList<File> needZipFiles = new ArrayList<File>(filterFiles.length);
        for (int x = 0; x < filterFiles.length; ++x) {
            File thisFile = filterFiles[x];
            if (thisFile.getName().equals("historyobj.db") || thisFile.getName().equals("tracksave.db")) {
                File targetFile = new File(tempMonitorFolder, thisFile.getName());
                FileUtil.copyFile((File)thisFile, (File)targetFile);
                needZipFiles.add(targetFile);
                continue;
            }
            needZipFiles.add(thisFile);
        }
        try {
            String baseFolder = this.fileManager.getNowFolder(true);
            File zipFile = new File(baseFolder, fileName);
            ZipUtil.zip(needZipFiles, (File)zipFile);
            Date date = new Date();
            StringBuilder url = new StringBuilder();
            url.append("fileUpload.do?method=download&fileId=").append(fileName);
            url.append("&createDate=").append(DateUtil.format((Date)date));
            url.append("&v=").append(SecurityHelper.digest((Object[])new Object[]{fileName})).append("&filename=");
            result.put("fileUrl", url.toString());
            result.put("filename", zipFile.getName() + ".zip");
        }
        catch (Exception e) {
            throw new BusinessException(e.getLocalizedMessage(), (Throwable)e);
        }
        return result;
    }

    private List<FormTableTreeItem> convertCap4Tables(String type, com.seeyon.cap4.form.bean.FormBean formBean, Collection<String> tableName) {
        ArrayList<FormTableTreeItem> result = new ArrayList<FormTableTreeItem>();
        for (com.seeyon.cap4.form.bean.FormTableBean table : formBean.getTableList()) {
            if (tableName.contains(table.getTableName())) continue;
            FormTableTreeItem item = new FormTableTreeItem();
            item.setParentId(String.valueOf(formBean.getId()));
            item.setFormType(type);
            item.setId(table.getTableName());
            if (table.isMainTable()) {
                item.setName(ResourceUtil.getString((String)"form.main.table.label"));
            } else {
                item.setName(table.getDisplay());
            }
            item.setCategory(false);
            result.add(item);
        }
        return result;
    }

    private List<FormTableTreeItem> convertCap3Tables(String type, FormBean formBean, Collection<String> tableName) {
        ArrayList<FormTableTreeItem> result = new ArrayList<FormTableTreeItem>();
        for (FormTableBean table : formBean.getTableList()) {
            if (tableName.contains(table.getTableName())) continue;
            FormTableTreeItem item = new FormTableTreeItem();
            item.setParentId(String.valueOf(formBean.getId()));
            item.setFormType(type);
            if (table.isMainTable()) {
                item.setName(ResourceUtil.getString((String)"form.main.table.label"));
            } else {
                item.setName(ResourceUtil.getString((String)"form.detail.table.label") + table.getTableIndex());
            }
            item.setId(table.getTableName());
            item.setCategory(false);
            result.add(item);
        }
        return result;
    }

    public CAP4FormCacheManager getCap4FormCacheManager() {
        return this.cap4FormCacheManager;
    }

    public void setCap4FormCacheManager(CAP4FormCacheManager cap4FormCacheManager) {
        this.cap4FormCacheManager = cap4FormCacheManager;
    }

    public ICAP4FormTrackConfigDao getCap4FormTrackConfigDao() {
        return this.cap4FormTrackConfigDao;
    }

    public void setCap4FormTrackConfigDao(ICAP4FormTrackConfigDao cap4FormTrackConfigDao) {
        this.cap4FormTrackConfigDao = cap4FormTrackConfigDao;
    }

    public BusinessManager getBusinessManager4() {
        return this.businessManager4;
    }

    public void setBusinessManager4(BusinessManager businessManager4) {
        this.businessManager4 = businessManager4;
    }

    public FormCacheManager getFormCacheManager() {
        return this.formCacheManager;
    }

    public void setFormCacheManager(FormCacheManager formCacheManager) {
        this.formCacheManager = formCacheManager;
    }

    public FileManager getFileManager() {
        return this.fileManager;
    }

    public void setFileManager(FileManager fileManager) {
        this.fileManager = fileManager;
    }
}

