/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.monitor.uniqueIndex.controller;

import com.seeyon.ctp.common.controller.BaseController;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.monitor.po.FormUniqueIndexInfo;
import com.seeyon.ctp.monitor.unique.UniqueIndexService;
import com.seeyon.ctp.monitor.util.UniqueIndexUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.json.JSONUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

public class UniqueIndexMonitorController
extends BaseController {
    private static final Log log = CtpLogFactory.getLog(UniqueIndexMonitorController.class);
    UniqueIndexService uniqueIndexService;

    public ModelAndView index(HttpServletRequest request, HttpServletResponse response) throws BusinessException {
        ModelAndView mav = new ModelAndView("cap4/monitor/optimize/index");
        return mav;
    }

    public ModelAndView optimizationView(HttpServletRequest request, HttpServletResponse response) throws BusinessException {
        String id = request.getParameter("id");
        try {
            id = URLDecoder.decode(id, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)(id + " ," + e.getMessage()), (Throwable)e);
        }
        FormUniqueIndexInfo indexInfos = (FormUniqueIndexInfo)UniqueIndexUtil.uniqueRunInfo.get((Serializable)((Object)id));
        ModelAndView mav = new ModelAndView("cap4/monitor/optimize/better");
        if (indexInfos != null) {
            long count = indexInfos.getDataCount();
            String sql = indexInfos.getSql();
            mav.addObject("dataCount", (Object)(count == 0L ? "" : count + ""));
            mav.addObject("sql", (Object)(sql == null ? "" : sql));
        } else {
            mav.addObject("dataCount", (Object)"");
            mav.addObject("sql", (Object)"");
        }
        return mav;
    }

    @RequestMapping(value={"/optimization"})
    @ResponseBody
    public void optimization(HttpServletRequest request, HttpServletResponse response) throws BusinessException, IOException {
        String fieldName = request.getParameter("fieldName");
        String id = request.getParameter("id");
        FormUniqueIndexInfo fi = (FormUniqueIndexInfo)UniqueIndexUtil.uniqueRunInfo.get((Serializable)((Object)id));
        int i = this.uniqueIndexService.createIndexForField(id, fieldName);
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        if (i == 0) {
            map.put("result", true);
        } else {
            map.put("result", false);
        }
        fi.setOptimization(true);
        response.setCharacterEncoding("utf-8");
        PrintWriter out = null;
        try {
            out = response.getWriter();
            out.print(Strings.escapeJavascript((String)JSONUtil.toJSONString(map)));
        }
        catch (IOException e) {
            out = response.getWriter();
            out.print(Strings.escapeJavascript((String)JSONUtil.toJSONString(map)));
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @RequestMapping(value={"/cleanData"})
    @ResponseBody
    public void cleanData(HttpServletRequest request, HttpServletResponse response) throws IOException {
        PrintWriter out = null;
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        try {
            UniqueIndexUtil.uniqueRunInfo.clear();
            map.put("result", true);
            out = response.getWriter();
            out.print(Strings.escapeJavascript((String)JSONUtil.toJSONString(map)));
        }
        catch (IOException e) {
            map.put("result", false);
            out = response.getWriter();
            out.print(Strings.escapeJavascript((String)JSONUtil.toJSONString(map)));
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public UniqueIndexService getUniqueIndexService() {
        return this.uniqueIndexService;
    }

    public void setUniqueIndexService(UniqueIndexService uniqueIndexService) {
        this.uniqueIndexService = uniqueIndexService;
    }
}

