/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.monitor.uniqueIndex.service;

import com.seeyon.cap4.form.service.CAP4FormCacheManager;
import com.seeyon.cap4.form.util.PerfUtil;
import com.seeyon.cap4.form.util.sqlite.CAPSQLiteUtil;
import com.seeyon.ctp.common.cache.CacheMap;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.form.bean.FormBean;
import com.seeyon.ctp.form.bean.FormFieldBean;
import com.seeyon.ctp.form.bean.FormTableIndexBean;
import com.seeyon.ctp.form.service.FormCacheManager;
import com.seeyon.ctp.form.util.CAP3PerfUtil;
import com.seeyon.ctp.monitor.po.FormUniqueIndexInfo;
import com.seeyon.ctp.monitor.unique.UniqueIndexService;
import com.seeyon.ctp.monitor.util.UniqueIndexUtil;
import com.seeyon.ctp.util.FlipInfo;
import com.seeyon.ctp.util.JDBCAgent;
import com.seeyon.ctp.util.annotation.AjaxAccess;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;

public class UniqueIdexServiceImpl
implements UniqueIndexService {
    private static final Log LOGGER = CtpLogFactory.getLog(UniqueIdexServiceImpl.class);
    private CAP4FormCacheManager cap4FormCacheManager;
    private FormCacheManager formCacheManager;
    private static int maxShowCount = 30;

    @AjaxAccess
    public FlipInfo getIndexList(FlipInfo info, Map<String, Object> params) throws BusinessException {
        CacheMap indexInfos = UniqueIndexUtil.uniqueRunInfo;
        List infos = null;
        if (null != indexInfos) {
            ArrayList<FormUniqueIndexInfo> formUniqueIndexInfos = new ArrayList<FormUniqueIndexInfo>();
            for (FormUniqueIndexInfo f : indexInfos.values()) {
                formUniqueIndexInfos.add(f);
            }
            Collections.sort(formUniqueIndexInfos, new Comparator<FormUniqueIndexInfo>(){

                @Override
                public int compare(FormUniqueIndexInfo o1, FormUniqueIndexInfo o2) {
                    if (o1.getRunTime().get() < o2.getRunTime().get()) {
                        return 1;
                    }
                    if (o1.getRunTime().get() == o2.getRunTime().get()) {
                        return 0;
                    }
                    return -1;
                }
            });
            int showCount = maxShowCount;
            if (showCount > formUniqueIndexInfos.size()) {
                showCount = formUniqueIndexInfos.size();
            }
            infos = formUniqueIndexInfos.subList(0, showCount);
        }
        info.setData(infos);
        return info;
    }

    @AjaxAccess
    public FlipInfo getOptimization(FlipInfo info, Map<String, Object> params) throws BusinessException {
        FormUniqueIndexInfo indexInfos = (FormUniqueIndexInfo)UniqueIndexUtil.uniqueRunInfo.get((Serializable)((Object)((String)params.get("id"))));
        ArrayList results = new ArrayList();
        int maxCount = 0;
        String maxkey = null;
        Set fieldNameSet = indexInfos.getUniqueField().keySet();
        ArrayList fields = new ArrayList();
        fields.addAll(fieldNameSet);
        Collections.sort(fields, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                if (Integer.parseInt(o1.substring(5, o1.length())) > Integer.parseInt(o2.substring(5, o2.length()))) {
                    return 1;
                }
                if (Integer.parseInt(o1.substring(5, o1.length())) == Integer.parseInt(o2.substring(5, o2.length()))) {
                    return 0;
                }
                return -1;
            }
        });
        for (String string : fields) {
            HashMap<String, Object> showInfos = new HashMap<String, Object>();
            UniqueIndexUtil formUniqueIndex = new UniqueIndexUtil();
            int count = formUniqueIndex.getSqlCountForField(this.getTableNamebyFieldName(indexInfos.getFormId(), string), string);
            if (maxCount < count) {
                maxCount = count;
                maxkey = string;
            }
            showInfos.put("fieldName", string);
            showInfos.put("count", count);
            showInfos.put("isOptimization", false);
            showInfos.put("id", params.get("id"));
            showInfos.put("displayName", this.getFieldDisplay(indexInfos.getFormId(), string));
            results.add(showInfos);
        }
        for (Map map : results) {
            if (!map.get("fieldName").equals(maxkey)) continue;
            map.put("isOptimization", true);
            map.put("hasedIndexField", map.get("fieldName"));
        }
        info.setData(results);
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AjaxAccess
    public int createIndexForField(String id, String fieldName) throws BusinessException {
        FormUniqueIndexInfo f = (FormUniqueIndexInfo)UniqueIndexUtil.uniqueRunInfo.get((Serializable)((Object)id));
        int i = this.createIndex(f.getFormId(), fieldName);
        HashMap<String, String> index = new HashMap<String, String>();
        if (null != f.getHasedIndexField()) {
            f.getHasedIndexField().clear();
        }
        index.put(fieldName, this.getFieldDisplay(f.getFormId(), fieldName));
        f.setHasedIndexField(index);
        ArrayList<String> field = new ArrayList<String>();
        field.add("key");
        field.add("uniqueIndex");
        Connection connection = null;
        Statement statement = null;
        try {
            connection = CAPSQLiteUtil.getConnection((String)"uniqueIndex");
            if (!CAPSQLiteUtil.isExistTable((Connection)connection, (String)"uniqueIndex")) {
                CAPSQLiteUtil.createTable((Connection)connection, (String)CAPSQLiteUtil.getCreateTableSql((String)"uniqueIndex", field));
            }
            ArrayList<String> parm = new ArrayList<String>();
            parm.add(id);
            parm.add(fieldName);
            statement = connection.createStatement();
            statement.execute("delete from uniqueIndex where key='" + id + "'");
            String sql = CAPSQLiteUtil.getInsertDataSql((String)"uniqueIndex", field);
            CAPSQLiteUtil.execute((Connection)connection, (String)sql, parm);
        }
        catch (SQLException e) {
            LOGGER.error((Object)("\u552f\u4e00\u7d22\u5f15\u521b\u5efasqllite\u5199\u5165\u5f02\u5e38" + e.getMessage()), (Throwable)e);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            CAPSQLiteUtil.closeConnection((Connection)connection);
        }
        return i;
    }

    public void mergeUniqueCache(FormUniqueIndexInfo formUniqueIndexInfo) throws BusinessException {
        HashMap<String, String> indexFields = formUniqueIndexInfo.getHasedIndexField();
        HashMap<String, String> existsFields = formUniqueIndexInfo.getExistsIndexField();
        if (indexFields != null) {
            indexFields.clear();
        } else {
            indexFields = new HashMap<String, String>();
        }
        if (existsFields != null) {
            existsFields.clear();
        } else {
            existsFields = new HashMap<String, String>();
        }
        List<String> hasedIndexFields = this.getIndexColumInUniqueByFormId(formUniqueIndexInfo.getFormId());
        Iterator iterator = formUniqueIndexInfo.getUniqueField().keySet().iterator();
        while (iterator.hasNext()) {
            String unField;
            String fieldName = unField = (String)iterator.next();
            String display = (String)formUniqueIndexInfo.getUniqueField().get(unField);
            if (hasedIndexFields.contains(unField)) {
                formUniqueIndexInfo.setOptimization(true);
                indexFields.put(unField, display);
                formUniqueIndexInfo.setHasedIndexField(indexFields);
                continue;
            }
            existsFields.put(unField, display);
            formUniqueIndexInfo.setExistsIndexField(existsFields);
        }
    }

    private List<String> getIndexColumInUniqueByFormId(long formId) {
        if (this.formCacheManager.getForm(formId) != null) {
            FormBean fb = this.formCacheManager.getForm(formId);
            return CAP3PerfUtil.getIndexColumInUniqueByFormId((FormBean)fb);
        }
        return PerfUtil.getIndexColumInUniqueByFormId(formId);
    }

    private String getTableNamebyFieldName(long formId, String fieldName) throws BusinessException {
        String tableName;
        if (this.cap4FormCacheManager.getForm(formId) == null) {
            FormBean fb = this.formCacheManager.getForm(formId);
            FormFieldBean ffb = fb.getFieldBeanByName(fieldName);
            tableName = ffb.getOwnerTableName();
        } else {
            com.seeyon.cap4.form.bean.FormBean fb = this.cap4FormCacheManager.getForm(formId);
            com.seeyon.cap4.form.bean.FormFieldBean ffb = fb.getFieldBeanByName(fieldName);
            tableName = ffb.getOwnerTableName();
        }
        return tableName;
    }

    private String getFieldDisplay(long formId, String fieldName) throws BusinessException {
        String displayName;
        if (this.cap4FormCacheManager.getForm(formId) == null) {
            FormBean fb = this.formCacheManager.getForm(formId);
            FormFieldBean ffb = fb.getFieldBeanByName(fieldName);
            displayName = ffb.getDisplay();
        } else {
            com.seeyon.cap4.form.bean.FormBean fb = this.cap4FormCacheManager.getForm(formId);
            com.seeyon.cap4.form.bean.FormFieldBean ffb = fb.getFieldBeanByName(fieldName);
            displayName = ffb.getDisplay();
        }
        return displayName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int createIndex(long formId, String field) throws BusinessException {
        String tableName = this.getTableNamebyFieldName(formId, field);
        FormTableIndexBean formTableIndexBean = new FormTableIndexBean();
        JDBCAgent jdbc = new JDBCAgent();
        ArrayList<String> sqls = new ArrayList<String>();
        if (!formTableIndexBean.checkIndex(jdbc, tableName, field)) {
            String indexSql = formTableIndexBean.createColumnIndexSql(tableName, field);
            sqls.add(indexSql);
        }
        try {
            if (sqls.size() > 0) {
                jdbc.executeBatch(sqls);
            }
            int indexSql = 1;
            return indexSql;
        }
        catch (Exception e) {
            LOGGER.error((Object)("\u521b\u5efa\u552f\u4e00\u6807\u8bc6\u7d22\u5f15\u5f02\u5e38:" + e.getMessage()), (Throwable)e);
            int n = -1;
            return n;
        }
        finally {
            jdbc.close();
        }
    }

    public CAP4FormCacheManager getCap4FormCacheManager() {
        return this.cap4FormCacheManager;
    }

    public void setCap4FormCacheManager(CAP4FormCacheManager cap4FormCacheManager) {
        this.cap4FormCacheManager = cap4FormCacheManager;
    }

    public FormCacheManager getFormCacheManager() {
        return this.formCacheManager;
    }

    public void setFormCacheManager(FormCacheManager formCacheManager) {
        this.formCacheManager = formCacheManager;
    }
}

