/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.monitor.uniqueIndex.unit;

import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.monitor.po.FormUniqueIndexInfo;
import com.seeyon.ctp.monitor.util.UniqueIndexUtil;
import com.seeyon.ctp.util.Strings;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;

public class FormUniqueIndexForCap4 {
    private static final Log LOGGER = CtpLogFactory.getLog(FormUniqueIndexForCap4.class);

    public static void putUniqueRunInfo(FormBean formBean, List<String> uniqueGroup, long runTime, Map map) {
        try {
            if (uniqueGroup == null || uniqueGroup.size() == 0) {
                return;
            }
            String key = formBean.getId().toString() + "|" + Strings.join(uniqueGroup, (String)",").replace(",", "_");
            FormUniqueIndexInfo runInfo = (FormUniqueIndexInfo)UniqueIndexUtil.uniqueRunInfo.get((Serializable)((Object)key));
            HashMap<String, String> fields = new HashMap<String, String>();
            for (String field : uniqueGroup) {
                fields.put(field, formBean.getFieldBeanByName(field).getDisplay());
            }
            UniqueIndexUtil.putCache((long)formBean.getId(), (String)formBean.getFormName(), (FormUniqueIndexInfo)runInfo, (long)runTime, (String)key, fields, (Map)map);
        }
        catch (Exception e) {
            LOGGER.error((Object)"cap4 \u76d1\u63a7 \u552f\u4e00\u6807\u8bc6\u65f6 \u53d1\u751f\u9519\u8bef");
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static void putIsHasIndex(FormBean formBean, List<String> uniqueGroup, List<String> indexField, FormUniqueIndexInfo newInfo) {
        HashMap<String, String> uniqueFields = new HashMap<String, String>();
        HashMap<String, String> indexFields = new HashMap<String, String>();
        HashMap<String, String> existsFields = new HashMap<String, String>();
        for (String fieldName : uniqueGroup) {
            uniqueFields.put(fieldName, formBean.getFieldBeanByName(fieldName).getDisplay());
            newInfo.setUniqueField(uniqueFields);
            if (indexField.contains(fieldName)) {
                indexFields.put(fieldName, formBean.getFieldBeanByName(fieldName).getDisplay());
                newInfo.setHasedIndexField(indexFields);
                continue;
            }
            existsFields.put(fieldName, formBean.getFieldBeanByName(fieldName).getDisplay());
            newInfo.setExistsIndexField(existsFields);
        }
    }
}

