/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.monitor.utils;

import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.modules.business.BizConfigBean;
import com.seeyon.cap4.monitor.enums.AlarmLevelEnum;
import com.seeyon.cap4.monitor.po.SlowSql;
import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.monitor.perf.jdbcmonitor.proxyobj.ProxyDriverUtils;
import com.seeyon.ctp.util.JDBCAgent;
import com.seeyon.ctp.util.Strings;
import java.io.File;
import java.io.FilenameFilter;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CAP4MonitorUtil {
    public static final String MONITOR_DATA_SEPARATOR = "_M#@SEEYON@#_";
    private static final Log log = LogFactory.getLog(CAP4MonitorUtil.class);

    public static Date getWeekStartDate() {
        Calendar cal = Calendar.getInstance();
        cal.set(7, 2);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        Date date = cal.getTime();
        return date;
    }

    public static String contactTag(Object obj) {
        if (obj == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        if (obj instanceof BizConfigBean) {
            BizConfigBean bizConfigBean = (BizConfigBean)obj;
            sb.append("\u5e94\u7528@@").append(bizConfigBean.getId()).append("@@").append(bizConfigBean.getName());
        } else if (obj instanceof FormBean) {
            FormBean formBean = (FormBean)obj;
            sb.append("\u8868\u5355@@").append(formBean.getId()).append("@@").append(formBean.getFormName());
        }
        return sb.toString();
    }

    public static int getAlarmLevel(String section, long number) {
        String[] sectionArray = section.split(",");
        int len = sectionArray.length;
        for (int i = 0; i < len; ++i) {
            if (number <= Long.valueOf(sectionArray[i])) {
                if (AlarmLevelEnum.getEnumByKey(i) != null) {
                    return AlarmLevelEnum.getEnumByKey(i).getKey();
                }
                return 1;
            }
            if (i != len - 1) continue;
            if (AlarmLevelEnum.getEnumByKey(i + 1) != null) {
                return AlarmLevelEnum.getEnumByKey(i + 1).getKey();
            }
            return 1;
        }
        return 1;
    }

    public static void splitTags(String[] aTags, SlowSql slowSql) {
        for (int i = 0; i < aTags.length; ++i) {
            String[] strs = aTags[i].split("@@");
            if (aTags[i].startsWith("\u64cd\u4f5c@@")) {
                slowSql.setActionName(strs[1]);
                continue;
            }
            if (aTags[i].startsWith("\u5e94\u7528@@")) {
                slowSql.setAppId(Long.valueOf(strs[1]));
                slowSql.setAppName(strs[2]);
                continue;
            }
            if (aTags[i].startsWith("\u8868\u5355@@")) {
                slowSql.setFormId(Long.valueOf(strs[1]));
                slowSql.setFormName(strs[2]);
                continue;
            }
            if (!aTags[i].startsWith("\u5bf9\u8c61@@")) continue;
            slowSql.setEntityId(Long.valueOf(strs[1]));
            slowSql.setEntityType(Integer.valueOf(strs[2]));
            slowSql.setEntityName(strs[3]);
        }
    }

    public static File[] getTrackFiles(final String filterName) {
        File monitor = new File(SystemEnvironment.getBaseFolder(), "monitor");
        if (!monitor.exists() || monitor.isFile()) {
            return new File[0];
        }
        File[] filterFiles = monitor.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return Strings.isBlank((String)filterName) ? name.startsWith("historyobj") || name.startsWith("tracksave") : name.startsWith(filterName);
            }
        });
        if (filterFiles == null) {
            filterFiles = new File[]{};
        }
        return filterFiles;
    }

    public static boolean checkTrackStatus() {
        boolean flage;
        ProxyDriverUtils.putConTrack();
        try {
            Connection con = JDBCAgent.getRawConnection();
            CallableStatement callableStatement = con.prepareCall("select * from FORM_TRACK_BUSINESS_CONFIG where 1=0");
            callableStatement.close();
            con.close();
        }
        catch (Exception e) {
            log.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        finally {
            flage = ProxyDriverUtils.testConTrack();
        }
        log.info((Object)("track service status [" + flage + "]"));
        return flage;
    }
}

