/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.report.api;

import com.google.common.collect.Lists;
import com.seeyon.apps.vreport.api.VReportApi;
import com.seeyon.apps.vreport.bo.ReportDataSetAuthBO;
import com.seeyon.apps.vreport.enums.ReportDataSetTypeEnum;
import com.seeyon.cap4.form.bean.FormAuthViewBean;
import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormFieldBean;
import com.seeyon.cap4.form.bean.FormFieldComEnum;
import com.seeyon.cap4.form.bean.FormTableBean;
import com.seeyon.cap4.form.bean.FormViewBean;
import com.seeyon.cap4.form.bean.fieldCtrl.FormFieldCustomCtrl;
import com.seeyon.cap4.form.modules.business.BusinessManager;
import com.seeyon.cap4.form.po.CAPFormDefinition;
import com.seeyon.cap4.form.service.CAP4FormCacheManager;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.ctp.cap.api.manager.CAPFormManager;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.ModuleType;
import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.common.constants.ApplicationCategoryEnum;
import com.seeyon.ctp.common.content.mainbody.MainbodyService;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.po.content.CtpContentAll;
import com.seeyon.ctp.common.taglibs.functions.Functions;
import com.seeyon.ctp.organization.OrgConstants;
import com.seeyon.ctp.report.engine.api.ReportConstants;
import com.seeyon.ctp.report.engine.api.bean.FieldBean;
import com.seeyon.ctp.report.engine.api.bean.TableBean;
import com.seeyon.ctp.report.engine.api.bean.TablePenetrate;
import com.seeyon.ctp.report.engine.api.bo.PenetrateInfo;
import com.seeyon.ctp.report.engine.api.interfaces.AbstractTableDataSource;
import com.seeyon.ctp.util.UniqueList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.logging.Log;

public abstract class BaseCap4TableDataSource
extends AbstractTableDataSource {
    protected Log loggger = CtpLogFactory.getLog(BaseCap4TableDataSource.class);
    protected BusinessManager businessManager;
    protected CAP4FormCacheManager cap4FormCacheManager;
    protected CAPFormManager capFormManager;
    private VReportApi vreportApi;

    public void setBusinessManager4(BusinessManager businessManager4) {
        this.businessManager = businessManager4;
    }

    public void setCap4FormCacheManager(CAP4FormCacheManager cap4FormCacheManager) {
        this.cap4FormCacheManager = cap4FormCacheManager;
    }

    public void setVreportApi(VReportApi vreportApi) {
        this.vreportApi = vreportApi;
    }

    public void setCapFormManager(CAPFormManager capFormManager) {
        this.capFormManager = capFormManager;
    }

    public String getCategory() {
        return ApplicationCategoryEnum.cap4Form.name();
    }

    public abstract List<FormBean> findFormBeans(String var1, String var2) throws BusinessException;

    protected List<FormBean> findBeansByOwner(String ownerId) {
        ArrayList<FormBean> formBeans = new ArrayList<FormBean>();
        Long userId = Long.parseLong(ownerId);
        ConcurrentMap<Long, FormBean> cap4Forms = this.cap4FormCacheManager.getForms();
        if (!cap4Forms.isEmpty()) {
            for (FormBean formBean : cap4Forms.values()) {
                if (userId.longValue() != formBean.getOwnerId() || Enums.FormUseFlagEnum.enabled.getKey() != formBean.getUseFlag()) continue;
                formBeans.add(formBean);
            }
        }
        return formBeans;
    }

    protected List<FormBean> findBeansByBiz(String bizId) throws BusinessException {
        List<CAPFormDefinition> citems = this.businessManager.getCAP4FormByBizId(Long.valueOf(bizId));
        if (CollectionUtils.isEmpty(citems)) {
            return Collections.emptyList();
        }
        ArrayList<FormBean> formBeans = new ArrayList<FormBean>();
        for (CAPFormDefinition capFormDefinition : citems) {
            formBeans.add(this.cap4FormCacheManager.getForm(capFormDefinition.getId()));
        }
        return formBeans;
    }

    public List<TableBean> findTableList(String appCategory, String appCategoryId) throws BusinessException {
        List<FormBean> citems = this.findFormBeans(appCategory, appCategoryId);
        if (ApplicationCategoryEnum.global.name().equals(appCategory) && null != this.vreportApi) {
            List dataSetBos = this.vreportApi.findReportDataSetAuthByMember(ReportDataSetTypeEnum.CAP4_FORM_DATA_SET.getKey(), AppContext.getCurrentUser(), OrgConstants.Role_NAME.VReportAdmin.name());
            for (ReportDataSetAuthBO bo : dataSetBos) {
                Long formId = bo.getModuleId();
                if (null == this.cap4FormCacheManager.getForm(formId)) continue;
                citems.add(this.cap4FormCacheManager.getForm(formId));
            }
        }
        if (CollectionUtils.isEmpty(citems)) {
            return Collections.emptyList();
        }
        HashSet<Long> formIds = new HashSet<Long>();
        UniqueList tableBeans = new UniqueList(citems.size());
        for (FormBean formBean : citems) {
            if (formBean.getFormType() != Enums.FormType.processesForm.getKey() && formBean.getFormType() != Enums.FormType.unFlowForm.getKey() || formIds.contains(formBean.getId())) continue;
            formIds.add(formBean.getId());
            List list = formBean.getTableList();
            for (FormTableBean formTableBean : list) {
                TableBean table = new TableBean();
                table.setCategory(ApplicationCategoryEnum.cap4Form.name());
                table.setCategoryId(appCategoryId);
                table.setEntityId(formBean.getId());
                table.setEntityName(formBean.getFormName());
                table.setTableName(formTableBean.getTableName());
                if (formTableBean.isMainTable()) {
                    table.setDisplayName(formBean.getFormName());
                    table.setIdField("id");
                } else {
                    table.setDisplayName(formTableBean.getDisplay() + "[" + formBean.getFormName() + "]");
                    table.setOwnerTableName(formBean.getMasterTableBean().getTableName());
                    table.setIdField("id");
                    table.setForeignField("formmain_id");
                }
                table.setMaster(formTableBean.isMainTable());
                tableBeans.add(table);
            }
        }
        return tableBeans;
    }

    public List<FieldBean> findFieldList(TableBean table) throws BusinessException {
        ArrayList<FieldBean> fieldBeans = new ArrayList<FieldBean>();
        FormBean form = this.cap4FormCacheManager.getForm(table.getEntityId());
        FormTableBean tableBean = form.getTableByTableName(table.getTableName());
        List fields = tableBean.getFields();
        for (FormFieldBean formFieldBean : fields) {
            CollectionUtils.addIgnoreNull(fieldBeans, (Object)this.getDataSourceFieldBean(formFieldBean, tableBean));
        }
        if (tableBean.isMainTable()) {
            FieldBean fieldBean;
            int formType = form.getFormType();
            if (formType == 1) {
                fieldBean = null;
                fieldBean = new FieldBean();
                fieldBean.setDbType(ReportConstants.FieldType.LONG.getKey());
                fieldBean.setName(Enums.MasterTableField.id.getKey());
                fieldBean.setDisplay(ResourceUtil.getString((String)"reportengine.design.main.field") + this.getSystemFieldDisplay(Enums.MasterTableField.id.getText()));
                fieldBean.setFieldComType(ReportConstants.FieldComType.TEXT.getComName());
                fieldBean.setSystemField(true);
                fieldBeans.add(fieldBean);
                fieldBean = new FieldBean();
                fieldBean.setDbType(ReportConstants.FieldType.VARCHAR.getKey());
                fieldBean.setName(Enums.MasterTableField.start_member_id.getKey());
                fieldBean.setDisplay(this.getSystemFieldDisplay(Enums.MasterTableField.start_member_id.getText()));
                fieldBean.setFieldComType(ReportConstants.FieldComType.MEMBER.getComName());
                fieldBean.setSystemField(true);
                fieldBeans.add(fieldBean);
                fieldBean = new FieldBean();
                fieldBean.setDbType(ReportConstants.FieldType.VARCHAR.getKey());
                fieldBean.setName(Enums.MasterTableField.modify_member_id.getKey());
                fieldBean.setDisplay(this.getSystemFieldDisplay(Enums.MasterTableField.modify_member_id.getText()));
                fieldBean.setFieldComType(ReportConstants.FieldComType.MEMBER.getComName());
                fieldBean.setSystemField(true);
                fieldBeans.add(fieldBean);
                fieldBean = new FieldBean();
                fieldBean.setDbType(ReportConstants.FieldType.VARCHAR.getKey());
                fieldBean.setName(Enums.MasterTableField.approve_member_id.getKey());
                fieldBean.setDisplay(this.getSystemFieldDisplay(Enums.MasterTableField.approve_member_id.getText()));
                fieldBean.setFieldComType(ReportConstants.FieldComType.MEMBER.getComName());
                fieldBean.setSystemField(true);
                fieldBeans.add(fieldBean);
                fieldBean = new FieldBean();
                fieldBean.setDbType(ReportConstants.FieldType.VARCHAR.getKey());
                fieldBean.setName(Enums.MasterTableField.ratify_member_id.getKey());
                fieldBean.setDisplay(this.getSystemFieldDisplay(Enums.MasterTableField.ratify_member_id.getText()));
                fieldBean.setFieldComType(ReportConstants.FieldComType.MEMBER.getComName());
                fieldBean.setSystemField(true);
                fieldBeans.add(fieldBean);
                fieldBean = new FieldBean();
                fieldBean.setDbType(ReportConstants.FieldType.DATETIME.getKey());
                fieldBean.setName(Enums.MasterTableField.start_date.getKey());
                fieldBean.setDisplay(this.getSystemFieldDisplay(Enums.MasterTableField.start_date.getText()));
                fieldBean.setFieldComType(ReportConstants.FieldComType.DATETIME.getComName());
                fieldBean.setSystemField(true);
                fieldBeans.add(fieldBean);
                fieldBean = new FieldBean();
                fieldBean.setDbType(ReportConstants.FieldType.DATETIME.getKey());
                fieldBean.setName(Enums.MasterTableField.modify_date.getKey());
                fieldBean.setDisplay(this.getSystemFieldDisplay(Enums.MasterTableField.modify_date.getText()));
                fieldBean.setFieldComType(ReportConstants.FieldComType.DATETIME.getComName());
                fieldBean.setSystemField(true);
                fieldBeans.add(fieldBean);
                fieldBean = new FieldBean();
                fieldBean.setDbType(ReportConstants.FieldType.DATETIME.getKey());
                fieldBean.setName(Enums.MasterTableField.approve_date.getKey());
                fieldBean.setDisplay(this.getSystemFieldDisplay(Enums.MasterTableField.approve_date.getText()));
                fieldBean.setFieldComType(ReportConstants.FieldComType.DATETIME.getComName());
                fieldBean.setSystemField(true);
                fieldBeans.add(fieldBean);
                fieldBean = new FieldBean();
                fieldBean.setDbType(ReportConstants.FieldType.DATETIME.getKey());
                fieldBean.setName(Enums.MasterTableField.ratify_date.getKey());
                fieldBean.setDisplay(this.getSystemFieldDisplay(Enums.MasterTableField.ratify_date.getText()));
                fieldBean.setFieldComType(ReportConstants.FieldComType.DATETIME.getComName());
                fieldBean.setSystemField(true);
                fieldBeans.add(fieldBean);
                fieldBean = new FieldBean();
                fieldBean.setDbType(ReportConstants.FieldType.INTEGER.getKey());
                fieldBean.setName(Enums.MasterTableField.state.getKey());
                fieldBean.setDisplay(this.getSystemFieldDisplay(Enums.MasterTableField.state.getText()));
                fieldBean.setFieldComType(ReportConstants.FieldComType.CUSTOMENUM.getComName());
                fieldBean.setSystemField(true);
                fieldBean.addProperties("formType", (Object)form.getFormType());
                fieldBeans.add(fieldBean);
                fieldBean = new FieldBean();
                fieldBean.setDbType(ReportConstants.FieldType.INTEGER.getKey());
                fieldBean.setName(Enums.MasterTableField.ratifyflag.getKey());
                fieldBean.setDisplay(this.getSystemFieldDisplay(Enums.MasterTableField.ratifyflag.getText()));
                fieldBean.setSystemField(true);
                fieldBean.setFieldComType(ReportConstants.FieldComType.CUSTOMENUM.getComName());
                fieldBean.addProperties("formType", (Object)form.getFormType());
                fieldBeans.add(fieldBean);
                fieldBean = new FieldBean();
                fieldBean.setDbType(ReportConstants.FieldType.INTEGER.getKey());
                fieldBean.setName(Enums.MasterTableField.finishedflag.getKey());
                fieldBean.setDisplay(this.getSystemFieldDisplay(Enums.MasterTableField.finishedflag.getText()));
                fieldBean.setSystemField(true);
                fieldBean.setFieldComType(ReportConstants.FieldComType.CUSTOMENUM.getComName());
                fieldBean.addProperties("formType", (Object)form.getFormType());
                fieldBeans.add(fieldBean);
            } else {
                fieldBean = new FieldBean();
                fieldBean.setDbType(ReportConstants.FieldType.LONG.getKey());
                fieldBean.setName(Enums.MasterTableField.id.getKey());
                fieldBean.setDisplay(ResourceUtil.getString((String)"reportengine.design.main.field") + this.getSystemFieldDisplay(Enums.MasterTableField.id.getText()));
                fieldBean.setFieldComType(ReportConstants.FieldComType.TEXT.getComName());
                fieldBean.setSystemField(true);
                fieldBeans.add(fieldBean);
                fieldBean = new FieldBean();
                fieldBean.setDbType(ReportConstants.FieldType.VARCHAR.getKey());
                fieldBean.setName(Enums.MasterTableField.start_member_id.getKey());
                fieldBean.setDisplay(this.getSystemFieldDisplay(Enums.MasterTableField.start_member_id.getText()));
                fieldBean.setFieldComType(ReportConstants.FieldComType.MEMBER.getComName());
                fieldBean.setSystemField(true);
                fieldBeans.add(fieldBean);
                fieldBean = new FieldBean();
                fieldBean.setDbType(ReportConstants.FieldType.VARCHAR.getKey());
                fieldBean.setName(Enums.MasterTableField.modify_member_id.getKey());
                fieldBean.setDisplay(this.getSystemFieldDisplay(Enums.MasterTableField.modify_member_id.getText()));
                fieldBean.setFieldComType(ReportConstants.FieldComType.MEMBER.getComName());
                fieldBean.setSystemField(true);
                fieldBeans.add(fieldBean);
                fieldBean = new FieldBean();
                fieldBean.setDbType(ReportConstants.FieldType.DATETIME.getKey());
                fieldBean.setName(Enums.MasterTableField.start_date.getKey());
                fieldBean.setDisplay(this.getSystemFieldDisplay(Enums.MasterTableField.start_date.getText()));
                fieldBean.setFieldComType(ReportConstants.FieldComType.DATETIME.getComName());
                fieldBean.setSystemField(true);
                fieldBeans.add(fieldBean);
                fieldBean = new FieldBean();
                fieldBean.setDbType(ReportConstants.FieldType.DATETIME.getKey());
                fieldBean.setName(Enums.MasterTableField.modify_date.getKey());
                fieldBean.setDisplay(this.getSystemFieldDisplay(Enums.MasterTableField.modify_date.getText()));
                fieldBean.setFieldComType(ReportConstants.FieldComType.DATETIME.getComName());
                fieldBean.setSystemField(true);
                fieldBeans.add(fieldBean);
            }
        } else {
            FieldBean fieldBean = new FieldBean();
            fieldBean.setDbType(ReportConstants.FieldType.LONG.getKey());
            fieldBean.setDisplay(ResourceUtil.getString((String)"reportengine.design.detail.field") + this.getSystemFieldDisplay(Enums.SubTableField.id.getText()));
            fieldBean.setFieldComType(ReportConstants.FieldComType.TEXT.getComName());
            fieldBean.setName(Enums.SubTableField.id.getKey());
            fieldBean.setSystemField(true);
            fieldBeans.add(fieldBean);
            FieldBean field2 = new FieldBean();
            field2.setDbType(ReportConstants.FieldType.LONG.getKey());
            field2.setDisplay(this.getSystemFieldDisplay(ResourceUtil.getString((String)"reportengine.design.main.field") + Enums.SubTableField.id.getText()));
            field2.setFieldComType(ReportConstants.FieldComType.TEXT.getComName());
            field2.setName(Enums.SubTableField.formmain_id.getKey());
            fieldBean.setSystemField(true);
            fieldBeans.add(field2);
        }
        return fieldBeans;
    }

    protected String getSystemFieldDisplay(String display) {
        return display + "_" + ResourceUtil.getString((String)"reportengine.design.system.field");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected FieldBean getDataSourceFieldBean(FormFieldBean formField, FormTableBean formTableBean) {
        if (ReportConstants.FieldType.LONGTEXT.getKey().equalsIgnoreCase(formField.getFieldType())) {
            return null;
        }
        FieldBean field = new FieldBean();
        field.setDbType(formField.getFieldType());
        field.setDigitNum(formField.getDigitNum());
        field.setDisplay(formField.getDisplay());
        field.setLength(formField.getFieldLength());
        field.setName(formField.getName());
        field.setEnumId(Long.valueOf(formField.getEnumId()));
        String sourceInputType = formField.getInputType();
        String sourceFormatType = formField.getFormatType();
        String formatType = "";
        String fieldComType = "";
        if (formField.isCustomerCtrl()) {
            if (null == formField.getFieldCtrl() || !((FormFieldCustomCtrl)formField.getFieldCtrl()).canShowInReport()) return null;
            fieldComType = ReportConstants.FieldComType.CUSTOMTYPE.getComName();
        } else if (FormFieldComEnum.EXTEND_DATETIME.getKey().equals(sourceInputType)) {
            fieldComType = ReportConstants.FieldComType.DATETIME.getComName();
            formatType = "yyyy-mm-dd-hh-mm";
        } else if (FormFieldComEnum.TEXT.getKey().equals(sourceInputType) || FormFieldComEnum.LINE_NUMBER.getKey().equals(sourceInputType)) {
            if (ReportConstants.FieldType.VARCHAR.getKey().equals(formField.getFieldType())) {
                fieldComType = ReportConstants.FieldComType.TEXT.getComName();
            } else if (ReportConstants.FieldType.DECIMAL.getKey().equals(formField.getFieldType())) {
                fieldComType = ReportConstants.FieldComType.TEXT.getComName();
                if ("##,###,###0".equals(sourceFormatType)) {
                    formatType = "format_thousand";
                } else if ("%".equals(sourceFormatType)) {
                    formatType = "format_hundred";
                }
            } else {
                fieldComType = ReportConstants.FieldComType.TEXT.getComName();
            }
        } else if (FormFieldComEnum.EXTEND_IMAGE.getKey().equals(sourceInputType)) {
            fieldComType = ReportConstants.FieldComType.IMAGE.getComName();
        } else if (FormFieldComEnum.EXTEND_MEMBER.getKey().equals(sourceInputType) || FormFieldComEnum.EXTEND_MULTI_MEMBER.getKey().equals(sourceInputType) || FormFieldComEnum.EXTEND_ACCOUNT.getKey().equals(sourceInputType) || FormFieldComEnum.EXTEND_MULTI_ACCOUNT.getKey().equals(sourceInputType) || FormFieldComEnum.EXTEND_DEPARTMENT.getKey().equals(sourceInputType) || FormFieldComEnum.EXTEND_MULTI_DEPARTMENT.getKey().equals(sourceInputType) || FormFieldComEnum.EXTEND_POST.getKey().equals(sourceInputType) || FormFieldComEnum.EXTEND_MULTI_POST.getKey().equals(sourceInputType) || FormFieldComEnum.EXTEND_LEVEL.getKey().equals(sourceInputType) || FormFieldComEnum.EXTEND_MULTI_LEVEL.getKey().equals(sourceInputType)) {
            fieldComType = sourceInputType;
        } else if (FormFieldComEnum.RADIO.getKey().equals(sourceInputType) || FormFieldComEnum.SELECT.getKey().equals(sourceInputType)) {
            fieldComType = sourceInputType;
            field.addProperties(ReportConstants.AddtionProp.EnumLevel.key, (Object)formField.getEnumLevel());
            field.addProperties(ReportConstants.AddtionProp.IsFinalChild.key, (Object)formField.getIsFinalChild());
        } else if (FormFieldComEnum.IMAGE_RADIO.getKey().equals(sourceInputType) || FormFieldComEnum.IMAGE_SELECT.getKey().equals(sourceInputType)) {
            fieldComType = ReportConstants.FieldComType.IMAGEENUM.getComName();
            formatType = "showImage";
            field.addProperties(ReportConstants.AddtionProp.EnumLevel.key, (Object)formField.getEnumLevel());
            field.addProperties(ReportConstants.AddtionProp.IsFinalChild.key, (Object)formField.getIsFinalChild());
        } else if (FormFieldComEnum.TEXTAREA.getKey().equals(sourceInputType)) {
            fieldComType = sourceInputType;
        } else if (FormFieldComEnum.EXTEND_DATE.getKey().equals(sourceInputType)) {
            formatType = sourceFormatType;
            fieldComType = sourceInputType;
            if ("".equals(formatType)) {
                formatType = "yyyy-mm-dd";
            }
        } else if (FormFieldComEnum.CHECKBOX.getKey().equals(sourceInputType)) {
            formatType = sourceFormatType;
            fieldComType = sourceInputType;
        } else if (FormFieldComEnum.FLOWDEALOPITION.getKey().equals(sourceInputType) && ReportConstants.FieldType.VARCHAR.getKey().equals(field.getDbType())) {
            fieldComType = ReportConstants.FieldComType.TEXT.getComName();
            field.addProperties(ReportConstants.AddtionProp.NeedSpecialFormat.key, (Object)true);
            field.addProperties("specialFormatType", (Object)FormFieldComEnum.FLOWDEALOPITION.name());
        } else if (FormFieldComEnum.MAP_MARKED.getKey().equals(sourceInputType) || FormFieldComEnum.MAP_LOCATE.getKey().equals(sourceInputType)) {
            fieldComType = ReportConstants.FieldComType.MAP.getComName();
            formatType = "showMap";
        } else {
            if (!FormFieldComEnum.MAP_PHOTO.getKey().equals(sourceInputType)) return null;
            fieldComType = ReportConstants.FieldComType.MAP.getComName();
            formatType = "showMapAndImage";
        }
        field.setFormatType(formatType);
        field.setFieldComType(fieldComType);
        field.addProperties(ReportConstants.AddtionProp.SourceInputType.key, (Object)sourceInputType);
        return field;
    }

    public TablePenetrate getTablePenetrate(TableBean table) throws BusinessException {
        Long entityId = table.getEntityId();
        FormBean formBean = this.cap4FormCacheManager.getForm(entityId);
        ArrayList views = Lists.newArrayList();
        for (FormViewBean view : formBean.getFormViewList()) {
            ArrayList viewAuths = Lists.newArrayList();
            for (FormAuthViewBean auth : view.getOperations()) {
                if (!"readonly".equals(auth.getType())) continue;
                TablePenetrate.ViewAuthBean tableAuth = new TablePenetrate.ViewAuthBean();
                tableAuth.setId(auth.getId());
                tableAuth.setName(auth.getName());
                viewAuths.add(tableAuth);
            }
            TablePenetrate.ViewBean viewBean = new TablePenetrate.ViewBean();
            viewBean.setId(view.getId());
            viewBean.setName(view.getFormViewName());
            viewBean.setType(view.getFormViewType());
            viewBean.setViewAuthList((List)viewAuths);
            views.add(viewBean);
        }
        TablePenetrate tp = new TablePenetrate();
        tp.setCategory(table.getCategory());
        tp.setCategoryId(table.getCategoryId());
        tp.setEntityId(entityId);
        tp.setEntityName(formBean.getFormName());
        if (table.isMaster()) {
            tp.setPropValue("dataFieldName", Enums.MasterTableField.id.getKey());
        } else {
            tp.setPropValue("dataFieldName", Enums.SubTableField.formmain_id.getKey());
        }
        tp.setViewList((List)views);
        return tp;
    }

    public List<String> findPenetrateFieldNames(TablePenetrate tablePenet) {
        String dataFieldName = MapUtils.getString((Map)tablePenet.getProperties(), (Object)"dataFieldName");
        if (StringUtils.isBlank((String)dataFieldName)) {
            return Lists.newArrayList();
        }
        return Lists.newArrayList((Object[])new String[]{dataFieldName});
    }

    public List<PenetrateInfo> getTablePenetrateInfo(TablePenetrate tablePenetrate, String dataId) throws BusinessException {
        ArrayList<PenetrateInfo> ret = new ArrayList<PenetrateInfo>();
        Long formId = tablePenetrate.getEntityId();
        FormBean formBean = this.cap4FormCacheManager.getForm(formId);
        if (null != formBean) {
            PenetrateInfo info = new PenetrateInfo();
            Pair<String, Boolean> rightPair = this.getViewRight(tablePenetrate.getViewList());
            String moduleId = dataId;
            StringBuilder urlSb = new StringBuilder();
            if (Enums.FormType.processesForm.getKey() == formBean.getFormType()) {
                urlSb.append(SystemEnvironment.getContextPath() + "/collaboration/collaboration.do?method=summary&openFrom=capQuery");
                if (StringUtils.isNotBlank((String)dataId)) {
                    List contentList = MainbodyService.getInstance().getContentListByContentDataId(ModuleType.collaboration.getKey(), Long.valueOf(dataId).longValue());
                    if (CollectionUtils.isEmpty((Collection)contentList)) {
                        throw new BusinessException("\u975e\u6cd5\u6570\u636e\uff1a\u65e0\u6cd5\u67e5\u8be2\u5230\u534f\u540c\u6570\u636e\uff01\u8868\u4e2d\u6570\u636eid=" + dataId);
                    }
                    moduleId = String.valueOf(((CtpContentAll)contentList.get(0)).getModuleId());
                    urlSb.append("&summaryId=").append(moduleId);
                } else {
                    urlSb.append("&summaryId={moduleId}");
                }
                urlSb.append("&operationId=").append((String)rightPair.getLeft());
                urlSb.append("&formId=").append(formId);
            } else if (Enums.FormType.unFlowForm.getKey() == formBean.getFormType()) {
                int moduleType = ModuleType.cap4UnflowForm.getKey();
                urlSb.append(SystemEnvironment.getContextPath() + "/cap4/businessTemplateController.do?method=formContent" + Functions.csrfSuffix() + "#/browse?");
                urlSb.append("&rightId=").append((String)rightPair.getLeft());
                if (StringUtils.isNotBlank((String)dataId)) {
                    urlSb.append("&moduleId=").append(dataId);
                } else {
                    urlSb.append("&moduleId={moduleId}");
                }
                urlSb.append("&moduleType=").append(moduleType);
                urlSb.append("&fromModuleType=5");
            }
            info.put((Object)"baseUrl", (Object)urlSb.toString());
            if (!this.isLoginAgentFromPc()) {
                info.put((Object)"rightId", rightPair.getLeft());
                info.put((Object)"includeLight", rightPair.getRight());
            }
            if (StringUtils.isNotBlank((String)moduleId)) {
                info.put((Object)"moduleId", (Object)moduleId);
            }
            info.put((Object)"formType", (Object)formBean.getFormType());
            info.put((Object)"formId", (Object)formId);
            info.put((Object)"formName", (Object)tablePenetrate.getEntityName());
            info.put((Object)"category", (Object)tablePenetrate.getCategory());
            ret.add(info);
        }
        return ret;
    }

    private Pair<String, Boolean> getViewRight(List<TablePenetrate.ViewBean> viewList) {
        StringBuilder rightSb = new StringBuilder();
        boolean includeLight = false;
        ArrayList rightIds = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(viewList)) {
            if (this.isLoginAgentFromPc()) {
                for (TablePenetrate.ViewBean vr : viewList) {
                    String viewType = vr.getType();
                    if (!Enums.ViewType.SeeyonForm.getText().equals(viewType)) continue;
                    rightSb.append("_").append(vr.getId()).append(".").append(((TablePenetrate.ViewAuthBean)vr.getViewAuthList().get(0)).getId());
                    rightIds.add(((TablePenetrate.ViewAuthBean)vr.getViewAuthList().get(0)).getId());
                }
            } else {
                for (TablePenetrate.ViewBean vr : viewList) {
                    if (!Enums.ViewType.SeeyonForm.getText().equals(vr.getType())) {
                        includeLight = true;
                    }
                    rightSb.append("_").append(vr.getId()).append(".").append(((TablePenetrate.ViewAuthBean)vr.getViewAuthList().get(0)).getId());
                    rightIds.add(((TablePenetrate.ViewAuthBean)vr.getViewAuthList().get(0)).getId());
                }
            }
            if (rightSb.length() > 0) {
                rightSb.deleteCharAt(0);
            }
        }
        this.capFormManager.addRightId((List)rightIds);
        if (rightSb.length() == 0) {
            rightSb.append("-1");
        }
        return Pair.of((Object)rightSb.toString(), (Object)includeLight);
    }

    public String getDataSourceEntityName(String entityId) {
        FormBean formBean = this.cap4FormCacheManager.getForm(Long.valueOf(entityId));
        if (null != formBean) {
            return formBean.getFormName();
        }
        return "";
    }

    public Boolean hasDataSource(TableBean table) {
        FormBean formBean = this.cap4FormCacheManager.getForm(table.getEntityId());
        return null != formBean && null != formBean.getTableByTableName(table.getTableName());
    }
}

