/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.report.api;

import com.seeyon.cap4.form.modules.business.BizConfigBean;
import com.seeyon.cap4.form.modules.business.BusinessManager;
import com.seeyon.cap4.report.api.BaseCap4TableDataSource;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.appLog.AppLogAction;
import com.seeyon.ctp.common.appLog.manager.AppLogManager;
import com.seeyon.ctp.common.authenticate.domain.User;
import com.seeyon.ctp.common.constants.ApplicationCategoryEnum;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.taglibs.functions.Functions;
import com.seeyon.ctp.organization.OrgConstants;
import com.seeyon.ctp.report.engine.api.bean.DataSourceType;
import com.seeyon.ctp.report.engine.api.interfaces.AbstractReportAppCategory;
import com.seeyon.ctp.report.engine.po.ReportAuthInfo;
import com.seeyon.ctp.report.engine.po.ReportDesign;
import com.seeyon.ctp.report.engine.po.ReportIndex;
import com.seeyon.ctp.report.engine.po.ScheduleStatsLog;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;

public class Cap4BizReportAppCategoryManagerImpl
extends AbstractReportAppCategory {
    protected Log loggger = CtpLogFactory.getLog(BaseCap4TableDataSource.class);
    static DataSourceType CAP4FORM_SOURCETYPE = null;
    private BusinessManager businessManager;
    private AppLogManager appLogManager;

    public void setBusinessManager4(BusinessManager businessManager4) {
        this.businessManager = businessManager4;
    }

    public void setAppLogManager(AppLogManager appLogManager) {
        this.appLogManager = appLogManager;
    }

    public String getAppCategory() {
        return ApplicationCategoryEnum.cap4biz.name();
    }

    public List<DataSourceType> getReportAppSourceType() {
        ArrayList<DataSourceType> list = new ArrayList<DataSourceType>();
        list.add(CAP4FORM_SOURCETYPE);
        return list;
    }

    public List<String> getAppCategoryShowDataSource(DataSourceType sourceType) {
        ArrayList<String> list = new ArrayList<String>();
        if (CAP4FORM_SOURCETYPE.getKey().equals(sourceType.getKey())) {
            list.add(ApplicationCategoryEnum.cap4Form.name());
        }
        return list;
    }

    public void onCreateDesign(ReportDesign design, String auth) {
        this.appLogManager.insertLog(AppContext.getCurrentUser(), AppLogAction.valueOf((String)String.format("Cap4_%s_Create", design.getDesignType())), new String[]{AppContext.currentUserName(), design.getTitle()});
    }

    public void onDeleteDesign(ReportDesign design) {
        this.appLogManager.insertLog(AppContext.getCurrentUser(), AppLogAction.valueOf((String)String.format("Cap4_%s_Delete", design.getDesignType())), new String[]{AppContext.currentUserName(), design.getTitle()});
    }

    public void onUpdateDesign(ReportDesign design, ReportDesign oldDesign) {
        this.appLogManager.insertLog(AppContext.getCurrentUser(), AppLogAction.valueOf((String)String.format("Cap4_%s_Update", design.getDesignType())), new String[]{AppContext.currentUserName(), design.getTitle()});
    }

    public void onCreateIndex(List<ReportIndex> list, ReportDesign design) {
        this.appLogManager.insertLog(AppContext.getCurrentUser(), AppLogAction.Cap4_SUMMARY_Create, new String[]{AppContext.currentUserName(), String.format("\u3010%s\u3011", this.getIndexName(list)), design.getTitle()});
    }

    public void onDeleteIndex(List<ReportIndex> deleteIndex, ReportDesign design) {
        this.appLogManager.insertLog(AppContext.getCurrentUser(), AppLogAction.Cap4_SUMMARY_Delete, new String[]{AppContext.currentUserName(), String.format("\u3010%s\u3011", this.getIndexName(deleteIndex)), design.getTitle()});
    }

    public void onUpdateIndex(ReportIndex reportIndex, ReportDesign reportDesign) {
        this.appLogManager.insertLog(AppContext.getCurrentUser(), AppLogAction.Cap4_SUMMARY_Update, new String[]{AppContext.currentUserName(), String.format("\u3010%s\u3011", reportIndex.getTitle()), reportDesign.getTitle()});
    }

    public void onUpdateDesignAuth(ReportDesign design, List<ReportAuthInfo> authSrtring, String auth, List<ReportAuthInfo> oldAuth) {
    }

    public void onSchStatsSuccess(ReportDesign design, ScheduleStatsLog log) {
    }

    public void onUpdateReportCategory(ReportDesign design, ReportDesign oldDesign) {
    }

    private String getIndexName(List<ReportIndex> indexs) {
        StringBuilder sb = new StringBuilder();
        int size = indexs.size();
        for (int i = 0; i < size; ++i) {
            ReportIndex index = indexs.get(i);
            if (i != 0) {
                sb.append("\u3001");
            }
            sb.append(index.getTitle());
        }
        return sb.toString();
    }

    public Boolean hasReportAuth(String appCategoryId, User user) {
        Boolean ret = false;
        if (null != appCategoryId && null != user && Functions.isRole((String)OrgConstants.Role_NAME.BusinessDesigner.name(), (User)user)) {
            try {
                BizConfigBean bizConfig = this.businessManager.findBizConfigById(Long.valueOf(appCategoryId));
                ret = user.getId().equals(bizConfig.getOwnerId());
            }
            catch (BusinessException e) {
                this.loggger.info((Object)"\u67e5\u8be2\u8868\u5355\u4e1a\u52a1\u5305\u51fa\u9519\u3002");
            }
        }
        return ret;
    }

    static {
        CAP4FORM_SOURCETYPE = new DataSourceType("cap4Form", "reportengine.table.source.type.designer.form");
    }
}

