/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.report.api;

import com.google.common.collect.Maps;
import com.seeyon.cap4.form.bean.FormFieldComEnum;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.cap4.form.util.FormUtil;
import com.seeyon.ctp.common.constants.ApplicationCategoryEnum;
import com.seeyon.ctp.common.filemanager.manager.AttachmentManager;
import com.seeyon.ctp.common.lbs.manager.LbsManager;
import com.seeyon.ctp.common.lbs.vo.AttendanceListItem;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.report.engine.api.ReportConstants;
import com.seeyon.ctp.report.engine.api.bean.FieldBean;
import com.seeyon.ctp.report.engine.api.interfaces.CustomEnumHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;

public class Cap4FormCustomEnumHandler
implements CustomEnumHandler {
    private final Log logger = CtpLogFactory.getLog(this.getClass());
    private LbsManager lbsManager;
    private AttachmentManager attachmentManager;

    public void setLbsManager(LbsManager lbsManager) {
        this.lbsManager = lbsManager;
    }

    public void setAttachmentManager(AttachmentManager attachmentManager) {
        this.attachmentManager = attachmentManager;
    }

    public String getCategory() {
        return ApplicationCategoryEnum.cap4Form.name();
    }

    public Object format(String tableName, FieldBean field, Object value) {
        String fieldName = field.getName();
        Map properties = field.getProperties();
        if (ReportConstants.FieldComType.MAP.getComName().equals(field.getFieldComType())) {
            try {
                Long lbsId = Long.parseLong(value.toString());
                AttendanceListItem item = this.lbsManager.getAttendanceInfoById(lbsId.longValue());
                HashMap map = Maps.newHashMap();
                map.put("longitude", String.valueOf(item.getLbsLongitude()));
                map.put("latitude", String.valueOf(item.getLbsLatitude()));
                map.put("continent", item.getLbsContinent());
                map.put("province", item.getLbsProvince());
                map.put("country", item.getLbsCountry());
                map.put("city", item.getLbsCity());
                map.put("town", item.getLbsTown());
                map.put("street", item.getLbsStreet());
                map.put("nearAddress", item.getLbsNearAddress());
                map.put("address", item.getLbsAddr());
                if ("showMapAndImage".equals(field.getFormatType())) {
                    List atts = this.attachmentManager.getBySubReference(Arrays.asList(lbsId));
                    if (CollectionUtils.isNotEmpty((Collection)atts)) {
                        map.put("attachments", atts.subList(0, 1));
                    } else {
                        map.put("attachments", Collections.emptyList());
                    }
                }
                return map;
            }
            catch (Exception e) {
                this.logger.error((Object)"\u8f6c\u6362\u5f02\u5e38\uff1a", (Throwable)e);
            }
        } else if (FormFieldComEnum.FLOWDEALOPITION.name().equals(properties.get("specialFormatType"))) {
            if (value != null) {
                return FormUtil.dealFlowDealSignet((String)value.toString());
            }
        } else if ((tableName.matches("formmain_\\d+") || tableName.matches("formson_\\d+")) && value != null) {
            if ("state".equals(fieldName)) {
                int state = Integer.valueOf(value.toString());
                Enums.FormDataStateEnum e = null;
                Integer type = Integer.valueOf(properties.get("formType").toString());
                e = type.intValue() == Enums.FormType.processesForm.getKey() ? Enums.FormDataStateEnum.getFlowFormDataStateEnumByKey((int)state) : Enums.FormDataStateEnum.getUnFlowFormDataStateEnumByKey((int)state);
                return e.getText();
            }
            if ("ratifyflag".equals(fieldName)) {
                int state = Integer.valueOf(value.toString());
                Enums.FormDataRatifyFlagEnum e = Enums.FormDataRatifyFlagEnum.getFromLogOperateTypeByKey((int)state);
                return e.getText();
            }
            if ("finishedflag".equals(fieldName)) {
                int state = Integer.valueOf(value.toString());
                Enums.FromDataFinishedFlagEnum e = Enums.FromDataFinishedFlagEnum.getFlowStateByKey((int)state);
                return e.getText();
            }
        }
        return null;
    }

    public List<CustomEnumHandler.ReportEnum> values(String tableName, String fieldName, Map<String, Object> properties) {
        List<CustomEnumHandler.ReportEnum> enums;
        block3: {
            block5: {
                block4: {
                    enums = Collections.emptyList();
                    if (!tableName.matches("formmain_\\d+") && !tableName.matches("formson_\\d+")) break block3;
                    if (!"state".equals(fieldName)) break block4;
                    Integer type = Integer.valueOf(properties.get("formType").toString());
                    Enums.FormDataStateEnum[] vs = null;
                    vs = type.intValue() == Enums.FormType.processesForm.getKey() ? new Enums.FormDataStateEnum[]{Enums.FormDataStateEnum.FLOW_DRAFT, Enums.FormDataStateEnum.FLOW_UNAUDITED, Enums.FormDataStateEnum.FLOW_AUDITEDPASS, Enums.FormDataStateEnum.FLOW_AUDITEDUNPASS} : new Enums.FormDataStateEnum[]{Enums.FormDataStateEnum.UNFLOW_UNLOCK, Enums.FormDataStateEnum.UNFLOW_LOCKED};
                    enums = new ArrayList<CustomEnumHandler.ReportEnum>(vs.length);
                    for (Enums.FormDataStateEnum formDataStateEnum : vs) {
                        CustomEnumHandler.ReportEnum e = new CustomEnumHandler.ReportEnum(formDataStateEnum.getText(), String.valueOf(formDataStateEnum.ordinal()), (Object)formDataStateEnum.getKey());
                        enums.add(e);
                    }
                    break block3;
                }
                if (!"ratifyflag".equals(fieldName)) break block5;
                Enums.FormDataRatifyFlagEnum[] vs = Enums.FormDataRatifyFlagEnum.values();
                enums = new ArrayList<CustomEnumHandler.ReportEnum>(vs.length);
                for (Enums.FormDataRatifyFlagEnum formDataRatifyFlagEnum : vs) {
                    CustomEnumHandler.ReportEnum e = new CustomEnumHandler.ReportEnum(formDataRatifyFlagEnum.getText(), String.valueOf(formDataRatifyFlagEnum.ordinal()), (Object)formDataRatifyFlagEnum.getKey());
                    enums.add(e);
                }
                break block3;
            }
            if (!"finishedflag".equals(fieldName)) break block3;
            Enums.FromDataFinishedFlagEnum[] vs = Enums.FromDataFinishedFlagEnum.values();
            enums = new ArrayList<CustomEnumHandler.ReportEnum>(vs.length);
            for (Enums.FromDataFinishedFlagEnum fromDataFinishedFlagEnum : vs) {
                CustomEnumHandler.ReportEnum e = new CustomEnumHandler.ReportEnum(fromDataFinishedFlagEnum.getText(), String.valueOf(fromDataFinishedFlagEnum.ordinal()), (Object)fromDataFinishedFlagEnum.getKey());
                enums.add(e);
            }
        }
        return enums;
    }
}

