/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.report.api;

import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormFieldBean;
import com.seeyon.cap4.form.bean.FormTableBean;
import com.seeyon.cap4.form.modules.engin.design.CAP4FormOperationBaseManager;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.cap4.form.vo.ResultInfoVO;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.report.engine.api.ReportConstants;
import com.seeyon.ctp.report.engine.api.bo.Result;
import com.seeyon.ctp.report.engine.api.manager.ReportApi;
import com.seeyon.ctp.util.ParamUtil;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Triple;

public class Cap4FormOperationManager4Report
extends CAP4FormOperationBaseManager {
    private ReportApi reportApi;

    public void setReportApi(ReportApi reportApi) {
        this.reportApi = reportApi;
    }

    public Integer getSort() {
        return 1;
    }

    public String getId() {
        return "report";
    }

    public boolean externalBusiness() {
        return false;
    }

    public ResultInfoVO onFieldInfoChange(FormBean formBean, Map<String, Object> param) throws BusinessException {
        String fieldName = ParamUtil.getString(param, (String)"name");
        FormFieldBean fieldBean = formBean.getFieldBeanByName(fieldName);
        String from = ParamUtil.getString(param, (String)"from");
        Result rs = this.reportApi.checkFieldUse(formBean.getId(), fieldBean.getOwnerTableName(), fieldName, "maintenance".equals(from));
        if (rs.isSuccess()) {
            return new ResultInfoVO(true);
        }
        if ("maintenance".equals(from)) {
            ResultInfoVO vo = new ResultInfoVO(false);
            List tips = (List)rs.getData();
            for (Triple triple : tips) {
                ReportConstants.DesignType dtype = ReportConstants.DesignType.valueOf((String)((String)triple.getLeft()));
                if (dtype.equals((Object)ReportConstants.DesignType.MULTSTATS) || dtype.equals((Object)ReportConstants.DesignType.SCHEDULEDSTATS)) {
                    vo.addTipsInfo(this.setTipsInfoObject(formBean.getFormName(), formBean.getId().toString(), String.valueOf(formBean.getFormType()), ResourceUtil.getString((String)dtype.getI18n()), (String)triple.getRight(), ResourceUtil.getString((String)"cap.form.operation.report.tips1"), (String)triple.getMiddle(), Enums.CheckCategory.REPORT.getKey()));
                    continue;
                }
                vo.addTipsInfo(this.setTipsInfoObject(formBean.getFormName(), formBean.getId().toString(), String.valueOf(formBean.getFormType()), ResourceUtil.getString((String)dtype.getI18n()), (String)triple.getRight(), ResourceUtil.getString((String)"cap.form.operation.report.tips1"), (String)triple.getMiddle(), Enums.CheckCategory.REPORT.getKey()));
            }
            return vo;
        }
        ReportConstants.DesignType dtype = ReportConstants.DesignType.valueOf((String)rs.getData().toString());
        if (dtype.equals((Object)ReportConstants.DesignType.MULTSTATS) || dtype.equals((Object)ReportConstants.DesignType.SCHEDULEDSTATS)) {
            String errorMsg = ResourceUtil.getString((String)"cap.form.operation.report.error2", (Object)ResourceUtil.getString((String)dtype.getI18n()), (Object)rs.getExtInfo("multiStatsName"), (Object)rs.getExtInfo("statsName"), (Object)fieldBean.getDisplay());
            return new ResultInfoVO(false, errorMsg);
        }
        String errorMsg = ResourceUtil.getString((String)"cap.form.operation.report.error1", (Object)ResourceUtil.getString((String)dtype.getI18n()), (Object)rs.getExtInfo("statsName"), (Object)fieldBean.getDisplay());
        return new ResultInfoVO(false, errorMsg);
    }

    public ResultInfoVO checkTable4Delete(FormBean formBean, String tableName) throws BusinessException {
        Result rs = this.reportApi.checkTableUse(formBean.getId(), tableName);
        if (rs.isSuccess()) {
            return new ResultInfoVO(true);
        }
        ReportConstants.DesignType dtype = ReportConstants.DesignType.valueOf((String)rs.getData().toString());
        String errorMsg = ResourceUtil.getString((String)"cap.form.operation.report.error3", (Object)ResourceUtil.getString((String)dtype.getI18n()), (Object)rs.getExtInfo("statsName"), (Object)rs.getExtInfo("tableName"));
        return new ResultInfoVO(false, errorMsg);
    }

    public ResultInfoVO checkFormBean4Delete(FormBean formBean) throws BusinessException {
        String formMainTableName = "";
        for (FormTableBean table : formBean.getTableList()) {
            if (!table.isMainTable()) continue;
            formMainTableName = table.getTableName();
            break;
        }
        return this.checkTable4Delete(formBean, formMainTableName);
    }

    public ResultInfoVO checkView4Delete(FormBean formBean, Long viewId) throws BusinessException {
        Long formId = formBean.getId();
        Result result = this.reportApi.checkViewUse(formId, viewId);
        ResultInfoVO vo = new ResultInfoVO();
        vo.setMsg(result.getMsg());
        vo.setNeedConfirm(result.isSuccess());
        vo.setSuccess(!result.isSuccess());
        return vo;
    }
}

