/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.report.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.seeyon.cap4.bizportal.BizPortalConstants;
import com.seeyon.cap4.bizportal.datasource.bean.Command;
import com.seeyon.cap4.bizportal.datasource.bean.PaginationParam;
import com.seeyon.cap4.bizportal.datasource.list.MultiLinkDataSetResult;
import com.seeyon.cap4.bizportal.manager.BizPortalReportAdapterManager;
import com.seeyon.cap4.bizportal.param.ContextParam;
import com.seeyon.cap4.bizportal.utils.BizPortalUtils;
import com.seeyon.cap4.bizportal.vo.ServiceResult;
import com.seeyon.cap4.form.util.FormSearchUtil;
import com.seeyon.cap4.template.util.CAPFormUtil;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.filemanager.manager.PartitionManager;
import com.seeyon.ctp.report.bizportal.bean.ListDataResult;
import com.seeyon.ctp.report.bizportal.bean.ReportDesignConfig;
import com.seeyon.ctp.report.bizportal.bean.ReportDesignDefinition;
import com.seeyon.ctp.report.engine.api.manager.ReportApi;
import com.seeyon.ctp.report.engine.bean.UserConditions;
import com.seeyon.ctp.util.FileUtil;
import com.seeyon.ctp.util.FlipInfo;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class CAPReportService {
    private static final String COMMAND_TYPE_DEFAULT = "default";
    private static final String COMMAND_TYPE_VIEW_DETAIL = "viewDetail";
    private BizPortalReportAdapterManager bizPortalReportAdapterManager;
    private PartitionManager partitionManager;

    public ServiceResult getQueryConfig(Long designId, Long conditionId, Integer page, Integer pageSize, Integer platformCode) throws BusinessException {
        HashMap resultVO = Maps.newHashMap();
        ReportDesignDefinition definition = this.bizPortalReportAdapterManager.getReportDesignDefinition(designId);
        resultVO.put("id", definition.getDesignId());
        resultVO.put("title", definition.getTitle());
        resultVO.put("description", definition.getDataSourceNames());
        HashMap pagination = Maps.newHashMap();
        pagination.put("page", page);
        pagination.put("pageSize", pageSize);
        resultVO.put("pagination", pagination);
        HashMap defaultValueMap = Maps.newHashMap();
        ArrayList finalUserConditions = Lists.newArrayList();
        ArrayList userConditions = Lists.newArrayList();
        FormSearchUtil.getMergeConditions(String.valueOf(designId), defaultValueMap, finalUserConditions, userConditions, true);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        for (Map.Entry entry : defaultValueMap.entrySet()) {
            Map resultMap = (Map)entry.getValue();
            for (Map.Entry entry1 : resultMap.entrySet()) {
                String key = (String)entry1.getKey();
                if (!StringUtils.equalsIgnoreCase((String)key, (String)"startTime") && !StringUtils.equalsIgnoreCase((String)key, (String)"endTime") || !(entry1.getValue() instanceof Date)) continue;
                Date oldTime = (Date)entry1.getValue();
                String newTimeStr = sdf.format(oldTime);
                resultMap.put(key, newTimeStr);
            }
        }
        ReportDesignConfig designConfig = this.bizPortalReportAdapterManager.getReportDesignConfig(designId);
        resultVO.put("filterFields", CAPFormUtil.getReportFilterFields(designConfig.getFilterFields(), defaultValueMap));
        return ServiceResult.success(resultVO);
    }

    public ServiceResult getQueryDataList(Long designId, Integer platformCode, Command command) throws BusinessException {
        if (StringUtils.equals((String)command.getOp(), (String)COMMAND_TYPE_DEFAULT)) {
            FlipInfo fi = new FlipInfo();
            PaginationParam paginationParam = PaginationParam.of(command);
            fi.setPage(paginationParam.getPage().intValue());
            fi.setSize(paginationParam.getPageSize().intValue());
            UserConditions userConditions = new UserConditions();
            userConditions.setConditions(FormSearchUtil.getReportUserConditions((List)command.getAttributes().get("userConditions")));
            userConditions.setCustomOrderFields((List)command.getAttributes().get("customOrderFields"));
            ListDataResult dataResult = this.bizPortalReportAdapterManager.findQueryDataResult(designId, userConditions, fi);
            if (dataResult.getPage() > dataResult.getPages()) {
                fi.setPage(dataResult.getPages());
                dataResult = this.bizPortalReportAdapterManager.findQueryDataResult(designId, userConditions, fi);
            }
            return ServiceResult.success(dataResult);
        }
        if (StringUtils.equals((String)command.getOp(), (String)COMMAND_TYPE_VIEW_DETAIL)) {
            BizPortalConstants.Platform platform = BizPortalUtils.getEnumByCode(BizPortalConstants.Platform.class, platformCode);
            ContextParam contextParam = ContextParam.of(AppContext.getCurrentUser(), null, platform);
            String identifier = MapUtils.getString(command.getAttributes(), (Object)"identifier");
            MultiLinkDataSetResult dataSetResult = this.bizPortalReportAdapterManager.getQueryPenetrateInfo(contextParam, designId, identifier);
            return ServiceResult.success(dataSetResult);
        }
        return ServiceResult.internalError("\u4e0d\u652f\u6301\u8be5\u64cd\u4f5c:op=" + command.getOp());
    }

    public Pair<String, File> exportDataList(Long designId, Long userId, Map<String, Object> params) throws BusinessException {
        List userConditions = (List)params.get("userConditions");
        ReportApi.ExportExcelInfo exportExcelInfo = this.bizPortalReportAdapterManager.exportReportExcel(designId, userId, userConditions);
        String path = this.partitionManager.getFolder(exportExcelInfo.getDataPath(), true);
        File excelFile = new File(path + File.separator + exportExcelInfo.getFileName());
        String excelName = FileUtil.getDownloadFileName((HttpServletRequest)AppContext.getRawRequest(), (String)(exportExcelInfo.getExcelName() + ".xlsx"));
        return Pair.of((Object)excelName, (Object)excelFile);
    }

    public void setBizPortalReportAdapterManager(BizPortalReportAdapterManager bizPortalReportAdapterManager) {
        this.bizPortalReportAdapterManager = bizPortalReportAdapterManager;
    }

    public void setPartitionManager(PartitionManager partitionManager) {
        this.partitionManager = partitionManager;
    }
}

