/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.task;

import com.seeyon.cap4.task.ReportTaskExecuteManager;
import com.seeyon.cap4.template.cache.CAPReportGuavaCache;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.authenticate.domain.User;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.report.engine.api.bo.ReportQueryParams;
import com.seeyon.ctp.report.engine.api.manager.ReportApi;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReportTaskExecuteManagerImpl
implements ReportTaskExecuteManager {
    private static final Log log = LogFactory.getLog(ReportTaskExecuteManagerImpl.class);
    private static final int threadCount = Runtime.getRuntime().availableProcessors() > 5 ? 5 : Runtime.getRuntime().availableProcessors();
    private static final int clusterNodes = 1;
    private static final int executeThreadCount = threadCount / 1;
    private final ExecutorService executorService = Executors.newCachedThreadPool(new ReportTaskThreadFactory());
    private final Thread thread = new Thread(new CleanTimeOutReqExecutor());
    private static final int queueSize = 100;
    private static final int reqListSize = 20;
    private static final int refreshUnit = 1000;
    private static final int timeOut = 120000;
    public static final String reqIdKey = "reqId";
    public static final String reqParamsKey = "params";
    public static final String resultCodeKey = "code";
    public static final String resultDataKey = "data";
    public static final String resultMsgKey = "message";
    public static final String resultIndexKey = "index";
    public static final String resultRefreshKey = "refresh";
    private BlockingQueue<Map<String, Object>> reqQueue = new LinkedBlockingQueue<Map<String, Object>>(100);
    private List<String> reqList = Collections.synchronizedList(new ArrayList());
    private Map<String, Object> resultMap = new ConcurrentHashMap<String, Object>();
    private Map<String, User> userMap = new ConcurrentHashMap<String, User>();
    private Map<String, Long> timeOutMap = new ConcurrentHashMap<String, Long>();
    private Map<String, Thread> responseThreadMap = new ConcurrentHashMap<String, Thread>();
    private AtomicBoolean exit = new AtomicBoolean(false);
    private ReportApi reportApi;

    public void setReportApi(ReportApi reportApi) {
        this.reportApi = reportApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> addReportReq(Map<String, Object> params) throws BusinessException {
        if (!params.containsKey(reqIdKey) || !params.containsKey(reqParamsKey)) {
            throw new BusinessException("params is not ok");
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        String reqId = params.get(reqIdKey).toString();
        if (this.reqList.size() < 100) {
            this.addReqList(reqId);
            log.info((Object)("reqList size: " + this.reqList.size()));
            log.info((Object)("reqQueue size: " + this.reqQueue.size()));
            log.info((Object)("responseThreadMap size: " + this.responseThreadMap.size()));
            this.reqQueue.offer(params);
            if (this.reqList.size() <= 20) {
                if (this.resultMap.containsKey(reqId)) {
                    this.doResult(result, reqId, ResultEnum.Ok, false);
                } else {
                    this.responseThreadMap.put(reqId, Thread.currentThread());
                    log.info((Object)(" LockSupport.park:" + this.responseThreadMap.get(reqId).getName() + "---reqId:" + reqId));
                    LockSupport.parkNanos(10000000000L);
                }
                Map<String, Thread> map = this.responseThreadMap;
                synchronized (map) {
                    if (this.responseThreadMap.containsKey(reqId)) {
                        log.info((Object)(" LockSupport.unpark:" + this.responseThreadMap.get(reqId).getName() + "---reqId:" + reqId));
                        this.responseThreadMap.remove(reqId);
                    }
                }
                if (this.resultMap.containsKey(reqId)) {
                    this.doResult(result, reqId, ResultEnum.Ok, false);
                } else {
                    this.doResult(result, reqId, ResultEnum.Fail, true);
                }
            } else {
                this.doResult(result, reqId, ResultEnum.Wait, false);
            }
        } else {
            this.doResult(result, reqId, ResultEnum.Retry, false);
        }
        return result;
    }

    private void addReqList(String reqId) {
        this.reqList.add(reqId);
        this.userMap.put(reqId, AppContext.getCurrentUser());
        this.timeOutMap.put(reqId, System.currentTimeMillis());
    }

    private void removeReqList(String reqId) {
        this.reqList.remove(reqId);
        this.userMap.remove(reqId);
        this.timeOutMap.remove(reqId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unpack(String reqId) {
        Map<String, Thread> map = this.responseThreadMap;
        synchronized (map) {
            if (this.responseThreadMap.containsKey(reqId)) {
                LockSupport.unpark(this.responseThreadMap.get(reqId));
                log.info((Object)(" LockSupport.unpark:" + this.responseThreadMap.get(reqId).getName() + "---reqId:" + reqId));
                this.responseThreadMap.remove(reqId);
            }
        }
    }

    @Override
    public Map<String, Object> getReport(String reqId) throws BusinessException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.resultMap.containsKey(reqId)) {
            this.doResult(result, reqId, ResultEnum.Ok, false);
        } else if (this.reqList.contains(reqId)) {
            this.doResult(result, reqId, ResultEnum.Wait, false);
            this.timeOutMap.put(reqId, System.currentTimeMillis());
        } else {
            this.doResult(result, reqId, ResultEnum.Fail, false);
        }
        return result;
    }

    private void doResult(Map<String, Object> result, String reqId, ResultEnum resultEnum, boolean isNowRefresh) {
        log.info((Object)(Thread.currentThread().getName() + ":" + resultEnum.getKey() + "---reqId:" + reqId));
        switch (resultEnum) {
            case Ok: {
                result.put(resultCodeKey, ResultEnum.Ok.getKey());
                result.put(resultDataKey, this.resultMap.remove(reqId));
                break;
            }
            case Wait: {
                result.put(resultCodeKey, ResultEnum.Wait.getKey());
                result.put(resultMsgKey, ResultEnum.Wait.getName());
                result.put(resultIndexKey, this.reqList.indexOf(reqId));
                if (isNowRefresh) {
                    result.put(resultRefreshKey, 1000);
                    break;
                }
                result.put(resultRefreshKey, (this.reqList.indexOf(reqId) + 1) * 1000);
                break;
            }
            case Retry: {
                result.put(resultCodeKey, ResultEnum.Retry.getKey());
                result.put(resultMsgKey, ResultEnum.Retry.getName());
                break;
            }
            case Fail: {
                result.put(resultCodeKey, ResultEnum.Fail.getKey());
                result.put(resultMsgKey, ResultEnum.Fail.getName());
                break;
            }
        }
    }

    @Override
    public boolean cancelReport(String reqId) throws BusinessException {
        this.removeReqList(reqId);
        if (this.resultMap.containsKey(reqId)) {
            this.resultMap.remove(reqId);
        }
        return true;
    }

    @Override
    public void init() {
        CAPReportGuavaCache.instance.init();
        for (int i = 0; i < executeThreadCount; ++i) {
            Executor executor = new Executor();
            this.executorService.submit(executor);
        }
        this.thread.setName("Report clean thread");
        this.thread.start();
    }

    @Override
    public int getCurentTaskBeforeCount(String reqId) throws BusinessException {
        return this.reqList.indexOf(reqId) <= 0 ? 0 : this.reqList.indexOf(reqId);
    }

    @Override
    public int getTaskQueueSize() throws BusinessException {
        return 100;
    }

    public static enum ResultEnum {
        Ok("100", ResourceUtil.getString((String)"cap.template.statistics.task.result.enum.ok")),
        Wait("101", ResourceUtil.getString((String)"cap.template.statistics.task.result.enum.wait")),
        Retry("102", ResourceUtil.getString((String)"cap.template.statistics.task.result.enum.retry")),
        Fail("103", ResourceUtil.getString((String)"cap.template.statistics.task.result.enum.fail"));

        private String key;
        private String name;

        private ResultEnum(String key, String name) {
            this.name = name;
            this.key = key;
        }

        public String getName() {
            return this.name;
        }

        public String getKey() {
            return this.key;
        }

        public static ResultEnum getEnumByKey(String key) {
            for (ResultEnum source : ResultEnum.values()) {
                if (!source.getKey().equals(key)) continue;
                return source;
            }
            throw new IllegalArgumentException("\u672a\u5b9a\u4e49\u7684\u679a\u4e3e\u7c7b\u578b!key=" + key);
        }
    }

    public class ReportTaskThreadFactory
    implements ThreadFactory {
        private AtomicInteger tag = new AtomicInteger(0);

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setName("Report deal thread:" + this.tag.getAndIncrement());
            return thread;
        }
    }

    protected class CleanTimeOutReqExecutor
    implements Runnable {
        protected CleanTimeOutReqExecutor() {
        }

        @Override
        public void run() {
            while (!ReportTaskExecuteManagerImpl.this.exit.get()) {
                try {
                    for (String reqId : ReportTaskExecuteManagerImpl.this.timeOutMap.keySet()) {
                        Long time = (Long)ReportTaskExecuteManagerImpl.this.timeOutMap.get(reqId);
                        Long currentTimeMillis = System.currentTimeMillis();
                        if (currentTimeMillis < time + 120000L) continue;
                        log.info((Object)(reqId + "\u8bf7\u6c42\u8d85\u65f6\uff0c\u9700\u8981\u6e05\u7406"));
                        ReportTaskExecuteManagerImpl.this.cancelReport(reqId);
                    }
                    Thread.sleep(120000L);
                }
                catch (Throwable e) {
                    log.error((Object)"\u6e05\u7406\u62a5\u8868\u8d85\u65f6\u8bf7\u6c42\u5f02\u5e38", e);
                }
            }
        }
    }

    protected class Executor
    implements Runnable {
        protected Executor() {
        }

        @Override
        public void run() {
            while (!ReportTaskExecuteManagerImpl.this.exit.get()) {
                String reqId = null;
                try {
                    Map reqMap = null;
                    reqMap = (Map)ReportTaskExecuteManagerImpl.this.reqQueue.take();
                    if (reqMap == null) continue;
                    reqId = reqMap.get(ReportTaskExecuteManagerImpl.reqIdKey).toString();
                    if (!ReportTaskExecuteManagerImpl.this.reqList.contains(reqId)) continue;
                    ReportQueryParams reportQueryParams = new ReportQueryParams();
                    if (reqMap.get(ReportTaskExecuteManagerImpl.reqParamsKey) instanceof Map) {
                        Map params = (Map)reqMap.get(ReportTaskExecuteManagerImpl.reqParamsKey);
                        reportQueryParams.put((Object)"designId", params.get("designId"));
                        reportQueryParams.put((Object)"userId", params.get("userId"));
                        reportQueryParams.put((Object)"userConditions", params.get("userConditions"));
                    }
                    User user = (User)ReportTaskExecuteManagerImpl.this.userMap.get(reqId);
                    AppContext.putThreadContext((String)"SESSION_CONTEXT_USERINFO_KEY", (Object)user);
                    ReportTaskExecuteManagerImpl.this.resultMap.put(reqId, ReportTaskExecuteManagerImpl.this.reportApi.findResult(reportQueryParams));
                    log.info((Object)" reportApi.findResult is run");
                    ReportTaskExecuteManagerImpl.this.unpack(reqId);
                    ReportTaskExecuteManagerImpl.this.removeReqList(reqId);
                }
                catch (Throwable e) {
                    log.error((Object)"\u62a5\u8868\u7edf\u8ba1\u4efb\u52a1\u6267\u884c\u5f02\u5e38", e);
                    ReportTaskExecuteManagerImpl.this.removeReqList(reqId);
                    ReportTaskExecuteManagerImpl.this.unpack(reqId);
                }
            }
        }
    }
}

