/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.task;

import com.seeyon.cap4.form.bean.FormTriggerBean;
import com.seeyon.cap4.form.modules.business.BizConfigBean;
import com.seeyon.cap4.form.modules.business.BusinessManager;
import com.seeyon.cap4.form.modules.engin.trigger.CAP4FormTriggerTaskDAO;
import com.seeyon.cap4.form.modules.history.CapFormTriggerEventHistoryManager;
import com.seeyon.cap4.form.po.CAPFormTriggerEvent;
import com.seeyon.cap4.form.po.CAPFormTriggerTask;
import com.seeyon.cap4.form.service.CAP4FormCacheManager;
import com.seeyon.cap4.monitor.utils.CAP4MonitorUtil;
import com.seeyon.cap4.task.Constants;
import com.seeyon.cap4.task.ITaskRing;
import com.seeyon.cap4.task.PrepareItem;
import com.seeyon.cap4.task.Task;
import com.seeyon.cap4.task.TaskEvent;
import com.seeyon.cap4.task.TaskEventManager;
import com.seeyon.cap4.task.TaskExecuteManager;
import com.seeyon.cap4.task.TaskLockObj;
import com.seeyon.cap4.task.taskring.BlockRing;
import com.seeyon.cap4.task.taskring.MainRing;
import com.seeyon.cap4.task.taskring.QueueSourceItem;
import com.seeyon.cap4.task.taskring.ShadowRing;
import com.seeyon.cap4.task.taskring.TaskRingMonitor;
import com.seeyon.cap4.task.taskring.TaskRingQueues;
import com.seeyon.ctp.cluster.ClusterConfigBean;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.config.PerformanceConfig;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.form.bean.FormBean;
import com.seeyon.ctp.form.modules.trigger.FormTriggerEventDAO;
import com.seeyon.ctp.form.modules.trigger.FormTriggerEventObject;
import com.seeyon.ctp.form.modules.trigger.FormTriggerExecuteAdapter;
import com.seeyon.ctp.form.modules.trigger.FormTriggerExecuteUtil;
import com.seeyon.ctp.form.modules.trigger.FormTriggerTask;
import com.seeyon.ctp.form.modules.trigger.FormTriggerTaskObject;
import com.seeyon.ctp.form.po.FormTriggerEvent;
import com.seeyon.ctp.form.service.FormCacheManager;
import com.seeyon.ctp.monitor.perf.jdbcmonitor.JMCallingObj;
import com.seeyon.ctp.monitor.perf.jdbcmonitor.proxyobj.JMTrackUtils;
import com.seeyon.ctp.monitor.performance.JMMonitorService;
import com.seeyon.ctp.organization.OrgConstants;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.FlipInfo;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.annotation.AjaxAccess;
import com.seeyon.ctp.util.annotation.CheckRoleAccess;
import com.seeyon.ctp.util.json.JSONUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.songjian.utils.ArrayListFixType;

public class TaskExecuteManagerImpl
implements TaskExecuteManager,
FormTriggerExecuteAdapter {
    private static final Log log = LogFactory.getLog(TaskExecuteManagerImpl.class);
    private TaskEventManager taskEventManager;
    private BusinessManager businessManager4;
    private CAP4FormCacheManager cap4FormCacheManager;
    private FormCacheManager formCacheManager;
    private CAP4FormTriggerTaskDAO cap4FormTriggerTaskDAO;
    private CapFormTriggerEventHistoryManager capFormTriggerEventHistoryManager;
    private FormTriggerEventDAO formTriggerEventDAO;
    private JMMonitorService jmMonitorService = (JMMonitorService)AppContext.getBean((String)"jmMonitorService");
    private static final int threadCount = Runtime.getRuntime().availableProcessors() > 5 ? 5 : Runtime.getRuntime().availableProcessors();
    private static final int threadSleepTime = 5000;
    private static final int taskAndEventFullDefaultCount = 10000;
    private AtomicBoolean exit = new AtomicBoolean(false);
    private final ExecutorService esEvent = Executors.newFixedThreadPool(threadCount, new EventThreadFactory());
    private final ExecutorService esPreTask = Executors.newFixedThreadPool(threadCount, new PreTaskThreadFactory());
    private final ExecutorService esTask = Executors.newFixedThreadPool(threadCount, new TaskThreadFactory());
    private final ExecutorService esTaskRing = Executors.newFixedThreadPool(threadCount, new TaskRingThreadFactory());
    private BlockingQueue<FormTriggerEventObject> eventQueue = new LinkedBlockingQueue<FormTriggerEventObject>();
    private List<FormTriggerEventObject> eventList2Queue = new ArrayList<FormTriggerEventObject>();
    private BlockingQueue<FormTriggerTaskObject> rawTaskQueue = new LinkedBlockingQueue<FormTriggerTaskObject>();
    private Map<String, BlockingQueue<FormTriggerTaskObject>> taskExecuteQueues = new ConcurrentHashMap<String, BlockingQueue<FormTriggerTaskObject>>();
    private Map<String, BlockingQueue<FormTriggerTaskObject>> taskExecutingQueues = new ConcurrentHashMap<String, BlockingQueue<FormTriggerTaskObject>>();
    private BlockingQueue<FormTriggerTaskObject> needAnalysisTaskQueue = new LinkedBlockingQueue<FormTriggerTaskObject>();
    private AnalysisTaskQueueThread analysisTaskThread;
    private TaskRingQueues taskRingQueues = new TaskRingQueues();
    private BlockingQueue<FormTriggerEventObject> waitEventQueue = new LinkedBlockingQueue<FormTriggerEventObject>();
    private BlockingQueue<FormTriggerTaskObject> waitTaskQueue = new LinkedBlockingQueue<FormTriggerTaskObject>();
    private final Object executorLockObj = new Object();

    @Override
    public void init() throws BusinessException {
        this.executeTaskEvent();
        this.executePreTask();
        this.executeAnalysisAndGroupTask();
        this.executeTask();
        this.initTaskEvent();
        FormTriggerExecuteUtil.setTriggerExecuteAdapter((FormTriggerExecuteAdapter)this);
        TaskRingMonitor.getInstance().init(threadCount, this.taskRingQueues, this.needAnalysisTaskQueue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initTaskEvent() throws BusinessException {
        try {
            boolean result;
            JMTrackUtils.getAndNew((String[])new String[]{"\u8ddf\u8e2aSQL", "\u4efb\u52a1\u4e8b\u4ef6\u521d\u59cb\u5316\u89e6\u53d1\u961f\u5217"});
            ClusterConfigBean clusterConfigBean = ClusterConfigBean.getInstance();
            boolean bl = result = !clusterConfigBean.isClusterEnabled() || clusterConfigBean.isClusterMain();
            if (!result) {
                log.info((Object)"\u5f53\u524d\u670d\u52a1\u5668\u4e0d\u662f\u4e3b\u8282\u70b9\uff0c\u65e0\u9700\u52a0\u8f7d\u5386\u53f2\u4e8b\u4ef6\u4efb\u52a1");
                return;
            }
            log.info((Object)"\u5f00\u59cb\u83b7\u53d6\u5f85\u6392\u4efb\u52a1");
            List<Task> tasks = this.taskEventManager.getExecuteTasks();
            for (Task task : tasks) {
                try {
                    this.rawTaskQueue.put(task);
                }
                catch (InterruptedException e) {
                    log.error((Object)"\u83b7\u53d6\u5f85\u6392\u4efb\u52a1\u5f02\u5e38", (Throwable)e);
                }
            }
            log.info((Object)"\u5f00\u59cb\u83b7\u53d6\u5f85\u5904\u7406\u4e8b\u4ef6");
            List<TaskEvent> taskEvents = this.taskEventManager.getPendingEvent();
            for (TaskEvent taskEvent : taskEvents) {
                try {
                    this.eventList2Queue.add((FormTriggerEventObject)taskEvent);
                }
                catch (Exception e) {
                    log.error((Object)"\u83b7\u53d6\u5f85\u5904\u7406\u4e8b\u4ef6\u5f02\u5e38", (Throwable)e);
                }
            }
        }
        catch (Throwable e) {
            log.error((Object)e.getMessage(), e);
        }
        finally {
            JMTrackUtils.clearTrack();
        }
    }

    public void destroy() throws BusinessException {
        this.exit.set(true);
        this.esEvent.shutdownNow();
        this.esPreTask.shutdownNow();
        this.esTask.shutdown();
        this.analysisTaskThread.interrupt();
        this.esTaskRing.shutdownNow();
    }

    public void loadOldEventList(List<? extends FormTriggerEventObject> eventList) {
        this.eventList2Queue.addAll(eventList);
        Collections.sort(this.eventList2Queue, new Comparator<FormTriggerEventObject>(){

            @Override
            public int compare(FormTriggerEventObject o1, FormTriggerEventObject o2) {
                return o1.getPushTime().compareTo(o2.getPushTime());
            }
        });
        this.eventQueue.addAll(this.eventList2Queue);
        this.eventList2Queue.clear();
    }

    public void pushTriggerEvent(FormTriggerEventObject aFormTriggerObj) {
        try {
            this.addTaskEvent(aFormTriggerObj);
        }
        catch (BusinessException e) {
            log.error((Object)"", (Throwable)e);
        }
    }

    protected void executeTaskEvent() {
        TaskEventExecutor taskEventExecutor = new TaskEventExecutor();
        this.esEvent.submit(taskEventExecutor);
    }

    protected void executePreTask() {
        ExecuteQueueLoader loader = new ExecuteQueueLoader();
        this.esPreTask.submit(loader);
    }

    protected void executeTask() {
        for (int i = 0; i < threadCount; ++i) {
            TaskExecutor executor = new TaskExecutor();
            this.esTask.submit(executor);
        }
    }

    protected void executeAnalysisAndGroupTask() {
        this.analysisTaskThread = new AnalysisTaskQueueThread();
        this.startAnalysisThread();
        for (int i = 0; i < threadCount; ++i) {
            TaskRingExecutor executor = new TaskRingExecutor();
            this.esTaskRing.submit(executor);
        }
    }

    private void startAnalysisThread() {
        Thread.State state = this.analysisTaskThread.getState();
        if (state == Thread.State.TERMINATED) {
            this.analysisTaskThread = new AnalysisTaskQueueThread();
        }
        if (state == Thread.State.NEW) {
            this.analysisTaskThread.start();
        }
    }

    private void notifyPreTaskThread() {
        if (this.analysisTaskThread != null) {
            this.analysisTaskThread.notifyRun();
        }
    }

    private ArrayList<ITaskRing> analysisTask() {
        if (Strings.isEmpty(this.needAnalysisTaskQueue)) {
            return new ArrayList<ITaskRing>();
        }
        FormTriggerTaskObject tempTask = null;
        LinkedBlockingQueue<FormTriggerTaskObject> tempTaskQueue = new LinkedBlockingQueue<FormTriggerTaskObject>(this.needAnalysisTaskQueue);
        for (FormTriggerTaskObject taskObject : tempTaskQueue) {
            if (tempTask != null && taskObject != null && !taskObject.isScheduled() && !tempTask.getTargetFormId().equals(taskObject.getTargetFormId())) {
                taskObject.getDependTasks().add(new TaskLockObj(tempTask.getTargetFormId().longValue(), tempTask.getTaskId()));
                taskObject.setScheduled(true);
            }
            tempTask = taskObject;
        }
        FormTriggerTaskObject task = (FormTriggerTaskObject)this.needAnalysisTaskQueue.peek();
        if (task == null) {
            return new ArrayList<ITaskRing>();
        }
        try {
            task = this.needAnalysisTaskQueue.poll(1L, TimeUnit.SECONDS);
        }
        catch (InterruptedException taskObject) {
            // empty catch block
        }
        if (task == null) {
            return new ArrayList<ITaskRing>();
        }
        QueueSourceItem sourceItem = new QueueSourceItem();
        PrepareItem[] prepareResult = sourceItem.prepareData(task);
        if (prepareResult == null || prepareResult.length <= 0) {
            return new ArrayList<ITaskRing>();
        }
        ArrayList<ITaskRing> result = new ArrayList<ITaskRing>();
        for (PrepareItem prepareItem : prepareResult) {
            this.analysisTaskItem(result, prepareItem);
        }
        return result;
    }

    private void analysisTaskItem(ArrayList<ITaskRing> result, PrepareItem prepareItem) {
        if (prepareItem == null) {
            return;
        }
        MainRing mainRing = new MainRing(this.taskRingQueues, prepareItem.getExecItem(), prepareItem.getLockInfo());
        result.add(mainRing);
        ArrayListFixType shadowRings = null;
        TaskLockObj[] taskLockObjArray = prepareItem.getDependTasks();
        if (taskLockObjArray != null && taskLockObjArray.length > 0) {
            shadowRings = new ArrayListFixType(taskLockObjArray.length, ShadowRing.class);
            for (TaskLockObj dependItem : taskLockObjArray) {
                ShadowRing shadowItem = new ShadowRing(this.taskRingQueues, mainRing, dependItem.getFormId(), dependItem.getTaskId(), dependItem.getDataId());
                shadowRings.add((Object)shadowItem);
            }
        }
        ArrayListFixType blockRings = null;
        taskLockObjArray = prepareItem.getBlockTasks();
        if (taskLockObjArray != null && taskLockObjArray.length > 0) {
            blockRings = new ArrayListFixType(10, BlockRing.class);
            for (TaskLockObj blockItem : taskLockObjArray) {
                BlockRing fBlockRingItem = new BlockRing(this.taskRingQueues, mainRing, blockItem.getFormId(), blockItem.getTaskId(), blockItem.getDataId());
                blockRings.add((Object)fBlockRingItem);
            }
        }
        mainRing.putRings(shadowRings == null ? null : (ShadowRing[])shadowRings.exportArray(), blockRings == null ? null : (BlockRing[])blockRings.exportArray());
        if (shadowRings != null) {
            result.addAll((Collection<ITaskRing>)shadowRings);
        }
        if (blockRings != null) {
            result.addAll((Collection<ITaskRing>)blockRings);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyRingExecutorRun() {
        Object object = this.executorLockObj;
        synchronized (object) {
            try {
                this.executorLockObj.notifyAll();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean addTaskEvent(FormTriggerEventObject event) throws BusinessException {
        boolean result = false;
        if (event.isInMemory()) {
            result = this.eventQueue.offer(event);
        } else {
            try {
                TaskEvent taskEvent = (TaskEvent)event;
                this.taskEventManager.addEvent(taskEvent);
                result = this.eventQueue.offer(event);
            }
            catch (Exception e) {
                log.error((Object)"\u4fdd\u5b58CAP4\u89e6\u53d1\u4e8b\u4ef6\u5f02\u5e38", (Throwable)e);
                throw new BusinessException((Throwable)e);
            }
        }
        this.notifyPreTaskThread();
        return result;
    }

    @Override
    @AjaxAccess
    @CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner})
    public int getTaskEventCount() throws BusinessException {
        return this.taskEventManager.getExecuteTasksCount();
    }

    @Override
    @AjaxAccess
    @CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner})
    public FlipInfo getTaskEvents(FlipInfo fi, Map<String, Object> param) throws BusinessException {
        return this.taskEventManager.getTaskEvents(fi, param);
    }

    @Override
    @AjaxAccess
    @CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner})
    public int getTaskEventFullCount() throws BusinessException {
        return Constants.getTaskAndEventFullCount().get();
    }

    @Override
    public boolean isCapacityFull() throws BusinessException {
        int taskAndEventCount = this.taskEventManager.getExecuteTasksCount();
        return taskAndEventCount >= this.getConfigFullCount();
    }

    @Override
    public boolean isCapacityFull(int taskCount) throws BusinessException {
        int taskAndEventCount = this.taskEventManager.getExecuteTasksCount();
        return taskAndEventCount + taskCount >= this.getConfigFullCount();
    }

    @Override
    public boolean isCapacityFull(int taskCount, long formId) throws BusinessException {
        com.seeyon.cap4.form.bean.FormBean formBean = this.cap4FormCacheManager.getForm(formId);
        if (formBean != null) {
            if (CollectionUtils.isEmpty((Collection)formBean.getFormTriggerIdList())) {
                return this.isCapacityFull();
            }
            return this.isCapacityFull(taskCount * formBean.getFormTriggerIdList().size());
        }
        FormBean formBean1 = this.formCacheManager.getForm(formId);
        if (CollectionUtils.isEmpty((Collection)formBean1.getTriggerList())) {
            return this.isCapacityFull();
        }
        return this.isCapacityFull(taskCount * formBean1.getTriggerList().size());
    }

    @Override
    public int capacityLeft(int taskCount) throws BusinessException {
        int taskAndEventCount = this.taskEventManager.getExecuteTasksCount() + this.taskEventManager.getPendingEventCount();
        return this.getConfigFullCount() - taskAndEventCount - taskCount;
    }

    private int getConfigFullCount() {
        String fullCountConfig = PerformanceConfig.getInstance().getConfig("form.trigger.list.count");
        return Strings.isEmpty((String)fullCountConfig) || "null".equals(fullCountConfig) ? 10000 : Integer.valueOf(fullCountConfig);
    }

    @Override
    @AjaxAccess
    @CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner})
    public int capacityLeft() throws BusinessException {
        return this.capacityLeft(0);
    }

    private void sleepIfNull(Object object) {
        boolean needWait = false;
        boolean taskExecuteQueuesNull = true;
        if (object instanceof Collection) {
            needWait = ((Collection)object).isEmpty();
        } else if (object instanceof Map) {
            if (((Map)object).isEmpty()) {
                needWait = true;
            } else {
                needWait = false;
                for (Object objectIn : ((Map)object).values()) {
                    if (!(objectIn instanceof Collection)) continue;
                    if (((Collection)objectIn).isEmpty()) {
                        needWait = true;
                        continue;
                    }
                    needWait = false;
                    taskExecuteQueuesNull = false;
                    break;
                }
            }
        } else if (object == null) {
            needWait = true;
        }
        if (taskExecuteQueuesNull) {
            // empty if block
        }
        if (needWait) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                log.error((Object)"\u7ebf\u7a0b\u7b49\u5f85\u5f02\u5e38", (Throwable)e);
            }
        }
    }

    @Override
    @AjaxAccess
    @CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner})
    public String groupAllNotExecuteEvent() {
        ArrayList<FormTriggerEventObject> events = new ArrayList<FormTriggerEventObject>();
        long start = System.currentTimeMillis();
        events.addAll(this.waitEventQueue);
        HashMap<Long, Integer> waitEventGroupMap = null;
        if (!events.isEmpty()) {
            waitEventGroupMap = new HashMap<Long, Integer>();
            for (FormTriggerEventObject formTriggerEventObject : events) {
                Integer count = (Integer)waitEventGroupMap.get(formTriggerEventObject.getFormId());
                if (count == null) {
                    count = 0;
                }
                waitEventGroupMap.put(formTriggerEventObject.getFormId(), count + 1);
            }
        }
        events = new ArrayList();
        events.addAll(this.eventQueue);
        HashMap<Long, Integer> eventGroupMap = null;
        if (!events.isEmpty()) {
            eventGroupMap = new HashMap<Long, Integer>();
            for (FormTriggerEventObject event : events) {
                Integer count = (Integer)eventGroupMap.get(event.getFormId());
                if (count == null) {
                    count = 0;
                }
                eventGroupMap.put(event.getFormId(), count + 1);
            }
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        try {
            String formName;
            com.seeyon.cap4.form.bean.FormBean formBean1;
            HashMap<String, String> eventInfoMap;
            ArrayList eventInfoMapList = new ArrayList();
            if (waitEventGroupMap != null) {
                for (Map.Entry entry : waitEventGroupMap.entrySet()) {
                    eventInfoMap = new HashMap<String, String>();
                    eventInfoMap.put("formId", ((Long)entry.getKey()).toString());
                    formBean1 = this.cap4FormCacheManager.getForm((Long)entry.getKey());
                    formName = formBean1 == null ? this.formCacheManager.getForm(((Long)entry.getKey()).longValue()).getFormName() : formBean1.getFormName();
                    eventInfoMap.put("formName", formName);
                    eventInfoMap.put("count", ((Integer)entry.getValue()).toString());
                    eventInfoMap.put("state", "wait");
                    eventInfoMapList.add(eventInfoMap);
                }
            }
            if (eventGroupMap != null) {
                for (Map.Entry entry : eventGroupMap.entrySet()) {
                    eventInfoMap = new HashMap();
                    eventInfoMap.put("formId", ((Long)entry.getKey()).toString());
                    formBean1 = this.cap4FormCacheManager.getForm((Long)entry.getKey());
                    formName = formBean1 == null ? this.formCacheManager.getForm(((Long)entry.getKey()).longValue()).getFormName() : formBean1.getFormName();
                    eventInfoMap.put("formName", formName);
                    eventInfoMap.put("count", ((Integer)entry.getValue()).toString());
                    eventInfoMap.put("state", "start");
                    eventInfoMapList.add(eventInfoMap);
                }
            }
            hashMap.put("info", eventInfoMapList);
            hashMap.put("success", true);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            hashMap.put("errMsg", e.getMessage());
            hashMap.put("success", false);
        }
        long end = System.currentTimeMillis();
        log.info((Object)("\u6c47\u603b\u4e8b\u4ef6\u8017\u65f6\uff1a" + (end - start)));
        return JSONUtil.toJSONString(hashMap);
    }

    @Override
    @AjaxAccess
    @CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner})
    public String cancelOrWaitEventByFormId(Map<String, String> param) throws BusinessException {
        Long formId = Long.valueOf(param.get("formId"));
        String type = param.get("type");
        boolean wait = "wait".equals(type);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        long start = System.currentTimeMillis();
        try {
            log.info((Object)("\u5f00\u59cb\u6267\u884c1--" + formId + type));
            int count = 0;
            ArrayList<FormTriggerEventObject> events = new ArrayList<FormTriggerEventObject>();
            events.addAll(this.eventQueue);
            for (FormTriggerEventObject event : events) {
                boolean removeFlag;
                if (!event.getFormId().equals(formId) || !(removeFlag = this.eventQueue.remove(event))) continue;
                if (wait) {
                    this.waitEventQueue.add(event);
                } else if (event instanceof CAPFormTriggerEvent) {
                    this.capFormTriggerEventHistoryManager.saveHistoryByEvent((CAPFormTriggerEvent)event);
                } else {
                    this.formTriggerEventDAO.updateState(((FormTriggerEvent)event).getId(), 1);
                }
                ++count;
            }
            if (!wait) {
                events = new ArrayList();
                events.addAll(this.waitEventQueue);
                for (FormTriggerEventObject event : events) {
                    if (!event.getFormId().equals(formId)) continue;
                    this.waitEventQueue.remove(event);
                    if (event instanceof CAPFormTriggerEvent) {
                        this.capFormTriggerEventHistoryManager.saveHistoryByEvent((CAPFormTriggerEvent)event);
                    } else {
                        this.formTriggerEventDAO.updateState(((FormTriggerEvent)event).getId(), 1);
                    }
                    ++count;
                }
            }
            log.info((Object)((wait ? "\u6682\u505c" : "\u53d6\u6d88") + "\u8868\u5355: " + formId + " \u5f85\u89e3\u6790\u4e8b\u4ef6\uff1a" + count));
            resultMap.put("success", true);
        }
        catch (Exception e) {
            log.error((Object)((wait ? "\u6682\u505c" : "\u53d6\u6d88") + "\u8868\u5355: " + formId + " \u4e8b\u4ef6\u5f02\u5e38" + e.getMessage()), (Throwable)e);
            resultMap.put("errMsg", e.getMessage());
            resultMap.put("success", false);
        }
        long end = System.currentTimeMillis();
        log.info((Object)("\u6682\u505c/\u79fb\u9664\u4e8b\u4ef6\u8017\u65f6\uff1a" + (end - start)));
        return JSONUtil.toJSONString(resultMap);
    }

    @Override
    @AjaxAccess
    @CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner})
    public String restartEventByFormId(Map<String, String> param) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        Long formId = Long.valueOf(param.get("formId"));
        long start = System.currentTimeMillis();
        try {
            log.info((Object)("\u5f00\u59cb\u6267\u884c2--" + formId));
            int count = 0;
            ArrayList<FormTriggerEventObject> events = new ArrayList<FormTriggerEventObject>();
            events.addAll(this.waitEventQueue);
            for (FormTriggerEventObject event : events) {
                boolean removeFlag;
                if (!event.getFormId().equals(formId) || !(removeFlag = this.waitEventQueue.remove(event))) continue;
                this.eventQueue.add(event);
                ++count;
            }
            log.info((Object)("\u542f\u52a8\u8868\u5355: " + formId + " \u5f85\u89e3\u6790\u4efb\u52a1\uff1a" + count));
            resultMap.put("success", true);
        }
        catch (Exception e) {
            log.info((Object)("\u542f\u52a8\u8868\u5355: " + formId + " \u5f85\u89e3\u6790\u4efb\u52a1\u62a5\u9519" + e.getMessage()));
            resultMap.put("errMsg", e.getMessage());
            resultMap.put("success", false);
        }
        long end = System.currentTimeMillis();
        log.info((Object)("\u542f\u52a8\u4e8b\u4ef6\u8017\u65f6\uff1a" + (end - start)));
        return JSONUtil.toJSONString(resultMap);
    }

    @Override
    @AjaxAccess
    @CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner})
    public String cancelOrWaitTaskByEventId(Map<String, String> param) throws BusinessException {
        Long eventId = Long.valueOf(param.get("eventId"));
        String type = param.get("type");
        boolean wait = "wait".equals(type);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        long start = System.currentTimeMillis();
        try {
            boolean removeFlag;
            FormTriggerTask triggerTask;
            log.info((Object)("\u5f00\u59cb\u6267\u884c3--" + eventId + type));
            StringBuilder sb = new StringBuilder();
            ArrayList<FormTriggerTaskObject> tasks = new ArrayList<FormTriggerTaskObject>();
            BlockingQueue<FormTriggerTaskObject> executeTasks = this.taskExecuteQueues.get("all");
            if (executeTasks != null) {
                tasks.addAll((Collection)this.taskExecuteQueues.get("all"));
            }
            for (FormTriggerTaskObject task : tasks) {
                triggerTask = (FormTriggerTask)task;
                if (!triggerTask.getEventId().equals(eventId) || !(removeFlag = this.taskExecuteQueues.get("all").remove(task))) continue;
                if (wait) {
                    this.waitTaskQueue.add(task);
                } else {
                    triggerTask.setState(Integer.valueOf(CAPFormTriggerTask.TriggerTaskState.executeSuccess.getKey()));
                    this.capFormTriggerEventHistoryManager.saveHistoryByTask(triggerTask);
                }
                sb.append(triggerTask.getId()).append(",");
            }
            tasks = new ArrayList();
            tasks.addAll(this.needAnalysisTaskQueue);
            for (FormTriggerTaskObject task : tasks) {
                triggerTask = (FormTriggerTask)task;
                if (!triggerTask.getEventId().equals(eventId) || !(removeFlag = this.needAnalysisTaskQueue.remove(task))) continue;
                if (wait) {
                    this.waitTaskQueue.add(task);
                } else {
                    triggerTask.setState(Integer.valueOf(CAPFormTriggerTask.TriggerTaskState.executeSuccess.getKey()));
                    this.capFormTriggerEventHistoryManager.saveHistoryByTask(triggerTask);
                }
                sb.append(triggerTask.getId()).append(",");
            }
            tasks = new ArrayList();
            tasks.addAll(this.taskRingQueues.waitTaskByEventId(eventId));
            for (FormTriggerTaskObject task : tasks) {
                triggerTask = (FormTriggerTask)task;
                if (wait) {
                    this.waitTaskQueue.add(task);
                } else {
                    triggerTask.setState(Integer.valueOf(CAPFormTriggerTask.TriggerTaskState.executeSuccess.getKey()));
                    this.capFormTriggerEventHistoryManager.saveHistoryByTask(triggerTask);
                }
                sb.append(triggerTask.getId()).append(",");
            }
            if (!wait) {
                tasks = new ArrayList();
                tasks.addAll(this.waitTaskQueue);
                for (FormTriggerTaskObject task : tasks) {
                    triggerTask = (FormTriggerTask)task;
                    if (!triggerTask.getEventId().equals(eventId)) continue;
                    this.waitTaskQueue.remove(task);
                    triggerTask.setState(Integer.valueOf(CAPFormTriggerTask.TriggerTaskState.executeSuccess.getKey()));
                    this.capFormTriggerEventHistoryManager.saveHistoryByTask(triggerTask);
                    sb.append(triggerTask.getId()).append(",");
                }
            }
            log.info((Object)((wait ? "\u6682\u505c" : "\u53d6\u6d88") + "\u4efb\u52a1\uff1a" + sb.toString() + " \u6240\u5c5eevent: " + eventId));
            resultMap.put("success", true);
        }
        catch (Exception e) {
            log.error((Object)((wait ? "\u6682\u505c" : "\u53d6\u6d88") + "\u6240\u5c5eevent: " + eventId + "\u4efb\u52a1\u5f02\u5e38\u3002" + e.getMessage()), (Throwable)e);
            resultMap.put("errMsg", e.getMessage());
            resultMap.put("success", false);
        }
        long end = System.currentTimeMillis();
        log.info((Object)("\u6682\u505c/\u79fb\u9664\u4efb\u52a1\u8017\u65f6\uff1a" + (end - start)));
        return JSONUtil.toJSONString(resultMap);
    }

    @Override
    @AjaxAccess
    @CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner})
    public String restartTaskByEventId(Map<String, String> param) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        Long eventId = Long.valueOf(param.get("eventId"));
        long start = System.currentTimeMillis();
        try {
            log.info((Object)("\u5f00\u59cb\u6267\u884c4--" + eventId));
            StringBuilder sb = new StringBuilder();
            ArrayList<FormTriggerTaskObject> tasks = new ArrayList<FormTriggerTaskObject>();
            tasks.addAll(this.waitTaskQueue);
            for (FormTriggerTaskObject task : tasks) {
                boolean removeFlag;
                FormTriggerTask triggerTask = (FormTriggerTask)task;
                if (!triggerTask.getEventId().equals(eventId) || !(removeFlag = this.waitTaskQueue.remove(task))) continue;
                if (triggerTask.canParallel()) {
                    BlockingQueue<FormTriggerTaskObject> executeTasks = this.taskExecuteQueues.get("all");
                    if (executeTasks == null) {
                        executeTasks = new LinkedBlockingQueue<FormTriggerTaskObject>();
                    }
                    executeTasks.add(task);
                } else {
                    this.needAnalysisTaskQueue.add(task);
                }
                sb.append(triggerTask.getId()).append(",");
            }
            log.info((Object)("\u542f\u52a8\u4efb\u52a1\uff1a" + sb.toString() + " \u6240\u5c5eevent: " + eventId));
            resultMap.put("success", true);
        }
        catch (Exception e) {
            log.info((Object)("\u542f\u52a8\u6240\u5c5eevent: " + eventId + "\u4efb\u52a1\u62a5\u9519" + e.getMessage()));
            resultMap.put("errMsg", e.getMessage());
            resultMap.put("success", false);
        }
        long end = System.currentTimeMillis();
        log.info((Object)("\u542f\u52a8\u4efb\u52a1\u8017\u65f6\uff1a" + (end - start)));
        return JSONUtil.toJSONString(resultMap);
    }

    @Override
    @AjaxAccess
    @CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner})
    public String getWaitTaskIdList() {
        ArrayList<FormTriggerTaskObject> tasks = new ArrayList<FormTriggerTaskObject>();
        tasks.addAll(this.waitTaskQueue);
        StringBuilder sb = new StringBuilder();
        for (FormTriggerTaskObject task : tasks) {
            FormTriggerTask triggerTask = (FormTriggerTask)task;
            sb.append(triggerTask.getId()).append(",");
        }
        log.info((Object)("\u83b7\u53d6\u88ab\u6682\u505c\u7684\u4efb\u52a1\uff1a" + sb.toString()));
        return sb.toString();
    }

    @Override
    @AjaxAccess
    @CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner})
    public String showWaitTaskDetailInfo() {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        long start = System.currentTimeMillis();
        try {
            ArrayList taskInfoList = new ArrayList();
            ArrayList<FormTriggerTaskObject> tasks = new ArrayList<FormTriggerTaskObject>();
            tasks.addAll(this.waitTaskQueue);
            for (FormTriggerTaskObject task : tasks) {
                HashMap<String, Object> taskInfoMap = new HashMap<String, Object>();
                FormTriggerTask triggerTask = (FormTriggerTask)task;
                taskInfoMap.put("id", triggerTask.getTaskId());
                taskInfoMap.put("eventId", triggerTask.getEventId());
                taskInfoMap.put("createTimeStr", DateUtil.format((Date)triggerTask.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                taskInfoMap.put("triggerName", triggerTask.getTriggerName());
                taskInfoMap.put("sourceAppName", triggerTask.getSourceAppName());
                taskInfoMap.put("sourceFormName", triggerTask.getSourceFormName());
                taskInfoMap.put("sourceTitle", triggerTask.getSourceTitle());
                taskInfoMap.put("sourceUserName", triggerTask.getSourceUserName());
                FormTriggerBean.TriggerEventSourceEnum triggerEventSourceEnum = FormTriggerBean.TriggerEventSourceEnum.getEnumByKey((String)triggerTask.getSourceType());
                if (triggerEventSourceEnum != null) {
                    taskInfoMap.put("sourceTypeName", ResourceUtil.getString((String)triggerEventSourceEnum.getI18n()));
                }
                String targetFormName = "";
                if (task.getTargetFormId() != null) {
                    com.seeyon.cap4.form.bean.FormBean formBean = this.cap4FormCacheManager.getForm(task.getTargetFormId());
                    if (formBean != null) {
                        targetFormName = formBean.getFormName();
                    } else {
                        try {
                            FormBean formBean1 = this.formCacheManager.getForm(task.getTargetFormId().longValue());
                            if (formBean1 != null) {
                                targetFormName = formBean1.getFormName();
                            }
                        }
                        catch (Exception e) {
                            log.error((Object)e.getMessage(), (Throwable)e);
                        }
                    }
                }
                String targetContent = Strings.isNotBlank((String)triggerTask.getActionName()) && !"null".equals(triggerTask.getActionName()) ? triggerTask.getActionName() + "-" + targetFormName : targetFormName;
                taskInfoMap.put("targetContent", targetContent);
                taskInfoList.add(taskInfoMap);
            }
            resultMap.put("info", taskInfoList);
            resultMap.put("success", true);
        }
        catch (Exception e) {
            log.info((Object)e.getMessage(), (Throwable)e);
            resultMap.put("errMsg", e.getMessage());
            resultMap.put("success", false);
        }
        long end = System.currentTimeMillis();
        log.info((Object)("\u663e\u793a\u6682\u505c\u4efb\u52a1\u8017\u65f6\uff1a" + (end - start)));
        return JSONUtil.toJSONString(resultMap);
    }

    public void setTaskEventManager(TaskEventManager taskEventManager) {
        this.taskEventManager = taskEventManager;
    }

    public void setBusinessManager4(BusinessManager businessManager4) {
        this.businessManager4 = businessManager4;
    }

    public void setCap4FormCacheManager(CAP4FormCacheManager cap4FormCacheManager) {
        this.cap4FormCacheManager = cap4FormCacheManager;
    }

    public void setFormCacheManager(FormCacheManager formCacheManager) {
        this.formCacheManager = formCacheManager;
    }

    public void setCap4FormTriggerTaskDAO(CAP4FormTriggerTaskDAO cap4FormTriggerTaskDAO) {
        this.cap4FormTriggerTaskDAO = cap4FormTriggerTaskDAO;
    }

    public void setCapFormTriggerEventHistoryManager(CapFormTriggerEventHistoryManager capFormTriggerEventHistoryManager) {
        this.capFormTriggerEventHistoryManager = capFormTriggerEventHistoryManager;
    }

    public void setFormTriggerEventDAO(FormTriggerEventDAO formTriggerEventDAO) {
        this.formTriggerEventDAO = formTriggerEventDAO;
    }

    public class TaskRingThreadFactory
    implements ThreadFactory {
        private AtomicInteger tag = new AtomicInteger(0);

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setName("ExecuteTaskRing:" + this.tag.getAndIncrement());
            return thread;
        }
    }

    public class TaskThreadFactory
    implements ThreadFactory {
        private AtomicInteger tag = new AtomicInteger(0);

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setName("ExecuteTask:" + this.tag.getAndIncrement());
            return thread;
        }
    }

    public class PreTaskThreadFactory
    implements ThreadFactory {
        private AtomicInteger tag = new AtomicInteger(0);

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setName("PreTask:" + this.tag.getAndIncrement());
            return thread;
        }
    }

    public class EventThreadFactory
    implements ThreadFactory {
        private AtomicInteger tag = new AtomicInteger(0);

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setName("Event:" + this.tag.getAndIncrement());
            return thread;
        }
    }

    protected class TaskRingExecutor
    implements Runnable {
        protected TaskRingExecutor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!TaskExecuteManagerImpl.this.exit.get()) {
                try {
                    ITaskRing taskRing = TaskExecuteManagerImpl.this.taskRingQueues.getRing();
                    if (taskRing == null) {
                        Object object = TaskExecuteManagerImpl.this.executorLockObj;
                        synchronized (object) {
                            try {
                                TaskExecuteManagerImpl.this.executorLockObj.wait();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            continue;
                        }
                    }
                    int result = CAPFormTriggerTask.TriggerTaskState.executeSuccess.getKey();
                    try {
                        boolean preFlag = taskRing.preExecTask();
                        result = preFlag ? taskRing.run() : CAPFormTriggerTask.TriggerTaskState.executeNext.getKey();
                    }
                    catch (Throwable e) {
                        log.error((Object)("\u89e6\u53d1\u4efb\u52a1\u6267\u884c\u5f02\u5e38." + e.getMessage()), e);
                    }
                    finally {
                        if (result == CAPFormTriggerTask.TriggerTaskState.executeNext.getKey()) {
                            TaskExecuteManagerImpl.this.needAnalysisTaskQueue.add(taskRing.getQueueExecItem().getTaskObject());
                        }
                        TaskExecuteManagerImpl.this.taskRingQueues.removeRunningTask(taskRing);
                        taskRing.afterRun();
                    }
                    TaskExecuteManagerImpl.this.notifyRingExecutorRun();
                }
                catch (Throwable e) {
                    log.error((Object)"\u89e6\u53d1\u4efb\u52a1\u6267\u884c\u7ebf\u7a0b\u5f02\u5e38", e);
                }
            }
        }
    }

    public class AnalysisTaskQueueThread
    extends Thread {
        private AtomicBoolean waitState;

        public AnalysisTaskQueueThread() {
            this.setName("AnalysisTaskQueueThread");
            this.setDaemon(true);
            this.waitState = new AtomicBoolean(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!TaskExecuteManagerImpl.this.exit.get()) {
                try {
                    ArrayList taskRings;
                    if (this.waitState.get()) {
                        AnalysisTaskQueueThread analysisTaskQueueThread = this;
                        synchronized (analysisTaskQueueThread) {
                            try {
                                this.wait(3000L);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    if (Strings.isEmpty((Collection)(taskRings = TaskExecuteManagerImpl.this.analysisTask()))) {
                        this.waitState.set(true);
                        continue;
                    }
                    for (ITaskRing fTaskRingItem : taskRings) {
                        TaskExecuteManagerImpl.this.taskRingQueues.putRing(fTaskRingItem);
                        TaskExecuteManagerImpl.this.notifyRingExecutorRun();
                    }
                    this.waitState.set(false);
                }
                catch (Throwable e) {
                    log.error((Object)("\u89e6\u53d1\u4efb\u52a1\u9884\u6392\u5f02\u5e38" + e.getMessage()), e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void notifyRun() {
            AnalysisTaskQueueThread analysisTaskQueueThread = this;
            synchronized (analysisTaskQueueThread) {
                this.waitState.set(false);
                this.notifyAll();
            }
        }
    }

    protected class TaskExecutor
    implements Runnable {
        protected TaskExecutor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            while (!TaskExecuteManagerImpl.this.exit.get()) {
                try {
                    TaskExecuteManagerImpl.this.sleepIfNull(TaskExecuteManagerImpl.this.taskExecuteQueues);
                    for (Map.Entry entry : TaskExecuteManagerImpl.this.taskExecuteQueues.entrySet()) {
                        Long singleEnd;
                        JMCallingObj jmCallingObj;
                        FormTriggerTask task;
                        Long singleStart;
                        block32: {
                            BlockingQueue queue;
                            FormTriggerTaskObject formTriggerTaskObject;
                            if (TaskExecuteManagerImpl.this.taskExecutingQueues.containsKey(entry.getKey()) || (formTriggerTaskObject = (FormTriggerTaskObject)(queue = (BlockingQueue)entry.getValue()).poll()) == null) continue;
                            singleStart = System.currentTimeMillis();
                            task = (FormTriggerTask)formTriggerTaskObject;
                            jmCallingObj = null;
                            if (!task.canParallel()) {
                                TaskExecuteManagerImpl.this.taskExecutingQueues.put(entry.getKey(), entry.getValue());
                            }
                            jmCallingObj = TaskExecuteManagerImpl.this.jmMonitorService.putJMCall(task.getSourceFormId().longValue(), (Object)(task.getActionName() + "|" + task.getTriggerName()), "TaskExecutor.execTask", task.getSourceUserName());
                            log.info((Object)("\u5f00\u59cb\u6267\u884c\u4efb\u52a1\uff1a" + task.toString()));
                            if (TaskExecuteManagerImpl.this.cap4FormCacheManager.getForm(task.getSourceFormId()) == null && FormTriggerBean.TriggerEventSourceEnum.cap3.getKey().equals(task.getSourceType())) {
                                int result = task.exec(true);
                                if (result == CAPFormTriggerTask.TriggerTaskState.executeNext.getKey()) {
                                    queue.offer(task);
                                } else {
                                    task.setState(Integer.valueOf(result));
                                }
                                break block32;
                            }
                            CAPFormTriggerTask capFormTriggerTask = null;
                            if (task instanceof CAPFormTriggerTask) {
                                capFormTriggerTask = (CAPFormTriggerTask)task;
                                capFormTriggerTask.setState(CAPFormTriggerTask.TriggerTaskState.executeFail.getKey());
                            }
                            try {
                                BizConfigBean bizConfigBean = TaskExecuteManagerImpl.this.businessManager4.findBizConfigByFormId(capFormTriggerTask.getSourceFormId());
                                com.seeyon.cap4.form.bean.FormBean formBean = TaskExecuteManagerImpl.this.cap4FormCacheManager.getForm(capFormTriggerTask.getSourceFormId());
                                if (null != bizConfigBean) {
                                    JMTrackUtils.getAndNew((String[])new String[]{"\u8ddf\u8e2aSQL", "\u6267\u884c\u4efb\u52a1", CAP4MonitorUtil.contactTag(bizConfigBean), CAP4MonitorUtil.contactTag(formBean)});
                                } else {
                                    JMTrackUtils.getAndNew((String[])new String[]{"\u8ddf\u8e2aSQL", "\u6267\u884c\u4efb\u52a1", CAP4MonitorUtil.contactTag(formBean)});
                                }
                            }
                            catch (Throwable e) {
                                log.error((Object)("\u76d1\u63a7\u690d\u5165\u5931\u8d25" + e.getMessage()), e);
                            }
                            int result = TaskExecuteManagerImpl.this.taskEventManager.handleTask(capFormTriggerTask, true);
                            if (result == CAPFormTriggerTask.TriggerTaskState.executeNext.getKey()) {
                                queue.offer(task);
                                break block32;
                            }
                            capFormTriggerTask.setState(result);
                        }
                        try {
                            if (task.getState().intValue() == CAPFormTriggerTask.TriggerTaskState.executeSuccess.getKey() || task.getState().intValue() == CAPFormTriggerTask.TriggerTaskState.executeFail.getKey()) {
                                TaskExecuteManagerImpl.this.capFormTriggerEventHistoryManager.saveHistoryByTask(task);
                            } else {
                                TaskExecuteManagerImpl.this.cap4FormTriggerTaskDAO.update(task);
                            }
                            TaskExecuteManagerImpl.this.taskExecutingQueues.remove(entry.getKey());
                            singleEnd = System.currentTimeMillis();
                            log.info((Object)("\u6267\u884c\u4efb\u52a1\uff1a" + task.getId() + " \u7ed3\u675f\uff1a" + CAPFormTriggerTask.TriggerTaskState.getByKey(task.getState()).getName() + " \u8017\u65f6:" + (singleEnd - singleStart)));
                            JMTrackUtils.clearTrack();
                            continue;
                        }
                        finally {
                            if (jmCallingObj == null) continue;
                            TaskExecuteManagerImpl.this.jmMonitorService.endJMCall(jmCallingObj);
                            continue;
                        }
                        catch (Throwable e) {
                            try {
                                log.error((Object)("\u89e6\u53d1\u4efb\u52a1\u6267\u884c\u5f02\u5e382\uff1a" + task.getId() + e.getMessage()), e);
                            }
                            catch (Throwable throwable) {
                                try {
                                    if (task.getState().intValue() == CAPFormTriggerTask.TriggerTaskState.executeSuccess.getKey() || task.getState().intValue() == CAPFormTriggerTask.TriggerTaskState.executeFail.getKey()) {
                                        TaskExecuteManagerImpl.this.capFormTriggerEventHistoryManager.saveHistoryByTask(task);
                                    } else {
                                        TaskExecuteManagerImpl.this.cap4FormTriggerTaskDAO.update(task);
                                    }
                                    TaskExecuteManagerImpl.this.taskExecutingQueues.remove(entry.getKey());
                                    Long singleEnd2 = System.currentTimeMillis();
                                    log.info((Object)("\u6267\u884c\u4efb\u52a1\uff1a" + task.getId() + " \u7ed3\u675f\uff1a" + CAPFormTriggerTask.TriggerTaskState.getByKey(task.getState()).getName() + " \u8017\u65f6:" + (singleEnd2 - singleStart)));
                                    JMTrackUtils.clearTrack();
                                    if (jmCallingObj == null) throw throwable;
                                }
                                catch (Throwable throwable2) {
                                    if (jmCallingObj == null) throw throwable2;
                                    TaskExecuteManagerImpl.this.jmMonitorService.endJMCall(jmCallingObj);
                                    throw throwable2;
                                }
                                TaskExecuteManagerImpl.this.jmMonitorService.endJMCall(jmCallingObj);
                                throw throwable;
                            }
                            try {
                                if (task.getState().intValue() == CAPFormTriggerTask.TriggerTaskState.executeSuccess.getKey() || task.getState().intValue() == CAPFormTriggerTask.TriggerTaskState.executeFail.getKey()) {
                                    TaskExecuteManagerImpl.this.capFormTriggerEventHistoryManager.saveHistoryByTask(task);
                                } else {
                                    TaskExecuteManagerImpl.this.cap4FormTriggerTaskDAO.update(task);
                                }
                                TaskExecuteManagerImpl.this.taskExecutingQueues.remove(entry.getKey());
                                singleEnd = System.currentTimeMillis();
                                log.info((Object)("\u6267\u884c\u4efb\u52a1\uff1a" + task.getId() + " \u7ed3\u675f\uff1a" + CAPFormTriggerTask.TriggerTaskState.getByKey(task.getState()).getName() + " \u8017\u65f6:" + (singleEnd - singleStart)));
                                JMTrackUtils.clearTrack();
                            }
                            finally {
                                if (jmCallingObj == null) continue;
                                TaskExecuteManagerImpl.this.jmMonitorService.endJMCall(jmCallingObj);
                            }
                        }
                    }
                }
                catch (Throwable e) {
                    log.error((Object)("\u89e6\u53d1\u4efb\u52a1\u6267\u884c\u7ebf\u7a0b\u5f02\u5e38" + e.getMessage()), e);
                }
            }
        }
    }

    protected class ExecuteQueueLoader
    implements Runnable {
        protected ExecuteQueueLoader() {
        }

        @Override
        public void run() {
            while (!TaskExecuteManagerImpl.this.exit.get()) {
                try {
                    FormTriggerTaskObject task = (FormTriggerTaskObject)TaskExecuteManagerImpl.this.rawTaskQueue.take();
                    if (task.canParallel()) {
                        String key = "all";
                        if (!TaskExecuteManagerImpl.this.taskExecuteQueues.containsKey(key)) {
                            TaskExecuteManagerImpl.this.taskExecuteQueues.put(key, new LinkedBlockingQueue());
                        }
                        ((BlockingQueue)TaskExecuteManagerImpl.this.taskExecuteQueues.get(key)).put(task);
                        continue;
                    }
                    TaskExecuteManagerImpl.this.needAnalysisTaskQueue.add(task);
                }
                catch (Throwable e) {
                    log.error((Object)("\u89e6\u53d1\u4efb\u52a1\u88c5\u8f7d\u5f02\u5e38" + e.getMessage()), e);
                }
            }
        }
    }

    protected class TaskEventExecutor
    implements Runnable {
        protected TaskEventExecutor() {
        }

        @Override
        public void run() {
            while (!TaskExecuteManagerImpl.this.exit.get()) {
                try {
                    FormTriggerEventObject formTriggerEventObject = (FormTriggerEventObject)TaskExecuteManagerImpl.this.eventQueue.take();
                    this.runEventTransferTask(formTriggerEventObject);
                }
                catch (Throwable e) {
                    log.error((Object)("\u5f85\u5904\u7406\u4e8b\u4ef6\u89e3\u6790\u5f02\u5e38\uff0c\u7ee7\u7eed\u89e3\u6790" + e.getMessage()), e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runEventTransferTask(FormTriggerEventObject formTriggerEventObject) throws BusinessException {
            block12: {
                JMCallingObj jmCallingObj = null;
                try {
                    jmCallingObj = TaskExecuteManagerImpl.this.jmMonitorService.putJMCall(formTriggerEventObject.getFormId().longValue(), (Object)"\u89e6\u53d1\u4e8b\u4ef6\u89e3\u6790", "TaskEventExecutor.eventTransferTask", "");
                    log.info((Object)("\u5f00\u59cb\u89e3\u6790\uff1a" + formTriggerEventObject.toString()));
                    Long singleStart = System.currentTimeMillis();
                    AppContext.clearThreadContext();
                    if (formTriggerEventObject.isInMemory()) {
                        List formTriggerTaskObjects = formTriggerEventObject.exec();
                        for (FormTriggerTaskObject task : formTriggerTaskObjects) {
                            TaskExecuteManagerImpl.this.taskEventManager.save(task);
                            TaskExecuteManagerImpl.this.rawTaskQueue.put(task);
                        }
                    } else {
                        TaskEvent taskEvent = (TaskEvent)formTriggerEventObject;
                        if (taskEvent instanceof CAPFormTriggerEvent) {
                            CAPFormTriggerEvent capFormTriggerEvent = (CAPFormTriggerEvent)taskEvent;
                            BizConfigBean bizConfigBean = TaskExecuteManagerImpl.this.businessManager4.findBizConfigByFormId(capFormTriggerEvent.getFormId());
                            com.seeyon.cap4.form.bean.FormBean formBean = TaskExecuteManagerImpl.this.cap4FormCacheManager.getForm(capFormTriggerEvent.getFormId());
                            if (null != bizConfigBean) {
                                JMTrackUtils.getAndNew((String[])new String[]{"\u8ddf\u8e2aSQL", "\u89e3\u6790\u4efb\u52a1\u4e8b\u4ef6", CAP4MonitorUtil.contactTag(bizConfigBean), CAP4MonitorUtil.contactTag(formBean)});
                            } else {
                                JMTrackUtils.getAndNew((String[])new String[]{"\u8ddf\u8e2aSQL", "\u89e3\u6790\u4efb\u52a1\u4e8b\u4ef6", CAP4MonitorUtil.contactTag(formBean)});
                            }
                        }
                        List<Task> tasks = TaskExecuteManagerImpl.this.taskEventManager.eventTransferTask(taskEvent);
                        for (Task task : tasks) {
                            TaskExecuteManagerImpl.this.taskEventManager.save(task);
                            TaskExecuteManagerImpl.this.rawTaskQueue.put(task);
                        }
                    }
                    Long singleEnd = System.currentTimeMillis();
                    log.info((Object)("\u8017\u65f6:" + (singleEnd - singleStart)));
                    if (jmCallingObj == null) break block12;
                }
                catch (Throwable e) {
                    block13: {
                        try {
                            log.error((Object)("\u5f85\u5904\u7406\u4e8b\u4ef6\u89e3\u6790\u5f02\u5e38\uff0c\u7ee7\u7eed\u89e3\u6790" + e.getMessage()), e);
                            if (jmCallingObj == null) break block13;
                        }
                        catch (Throwable throwable) {
                            if (jmCallingObj != null) {
                                TaskExecuteManagerImpl.this.jmMonitorService.endJMCall(jmCallingObj);
                            }
                            JMTrackUtils.clearTrack();
                            throw throwable;
                        }
                        TaskExecuteManagerImpl.this.jmMonitorService.endJMCall(jmCallingObj);
                    }
                    JMTrackUtils.clearTrack();
                }
                TaskExecuteManagerImpl.this.jmMonitorService.endJMCall(jmCallingObj);
            }
            JMTrackUtils.clearTrack();
        }
    }
}

