/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.task.taskring;

import com.seeyon.cap4.task.IQueueExecItem;
import com.seeyon.cap4.task.ITaskRing;
import com.seeyon.cap4.task.RunningTaskInfo;
import com.seeyon.cap4.task.TaskLockObj;
import com.seeyon.cap4.task.taskring.AbsTaskRing;
import com.seeyon.cap4.task.taskring.BlockRing;
import com.seeyon.cap4.task.taskring.ShadowRing;
import com.seeyon.cap4.task.taskring.TaskRingQueues;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MainRing
extends AbsTaskRing
implements ITaskRing {
    private static final Log log = LogFactory.getLog(MainRing.class);
    private TaskRingQueues taskRingQueues;
    private IQueueExecItem queueItem;
    private TaskLockObj lockInfo;
    private BlockRing[] blockRings;
    private ShadowRing[] shadowRings;
    private AtomicInteger shadowRingCount;

    public MainRing(TaskRingQueues aTaskRingQueues, IQueueExecItem aQueueItem, TaskLockObj aLockInfo) {
        this.taskRingQueues = aTaskRingQueues;
        this.queueItem = aQueueItem;
        this.lockInfo = aLockInfo;
    }

    public boolean allowExecute(RunningTaskInfo[] aRunningTasks) {
        boolean result;
        boolean bl = result = this.shadowRingCount.get() <= 0;
        if (!result) {
            return result;
        }
        result = this.queueItem.allowExecute(this.lockInfo.getFormId(), this.lockInfo.getDataId(), aRunningTasks);
        return result;
    }

    public boolean preExecTask() {
        boolean result = this.queueItem.preExecTask();
        if (!result) {
            log.warn((Object)("preExec is not true." + this.queueItem.toString()));
        }
        return result;
    }

    public int run() {
        log.info((Object)("run: " + this.lockInfo.toString() + ",RunningCount=" + this.taskRingQueues.runningTaskCount()));
        return this.queueItem.execTask();
    }

    public void afterRun() {
        if (this.blockRings == null) {
            return;
        }
        for (BlockRing item : this.blockRings) {
            if (item == null) continue;
            item.notifyBlockRingCount();
        }
    }

    public final void putRings(ShadowRing[] shadowRing, BlockRing[] aBlockRings) {
        this.blockRings = aBlockRings;
        this.shadowRingCount = new AtomicInteger(shadowRing == null ? 0 : shadowRing.length);
        this.shadowRings = shadowRing;
    }

    public void notifyShadowRingCount() {
        int count = this.shadowRingCount.decrementAndGet();
        if (count < 0) {
            throw new RuntimeException("error on shadowRingCount,count=" + count);
        }
    }

    public TaskLockObj getLockInfo() {
        return this.lockInfo;
    }

    public IQueueExecItem getQueueExecItem() {
        return this.queueItem;
    }

    @Override
    public final String getDependsJSonInfo() {
        if (this.shadowRings == null) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.shadowRings.length; ++i) {
            if (i > 0) {
                result.append(",");
            }
            ShadowRing fShadowRingItem = this.shadowRings[i];
            TaskLockObj fInfo = fShadowRingItem.getLockInfo();
            result.append(String.format("{\"taskid\":%d,\"tasknum\":%d,\"formdefineid\":%d}", fInfo == null ? 0L : fInfo.getTaskId(), fShadowRingItem.getTaskNum(), fInfo == null ? 0L : fInfo.getFormId()));
        }
        return result.toString();
    }

    @Override
    public final String getShowName() {
        return "main";
    }
}

