/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.task.taskring;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ReadWriteList<E>
implements List<E> {
    private ArrayList<E> innerList;
    private ReadWriteLock lock;

    public ReadWriteList() {
        this.innerList = new ArrayList();
        this.lock = new ReentrantReadWriteLock();
    }

    private ReadWriteList(ArrayList<E> innerList, ReadWriteLock lock) {
        this.innerList = innerList;
        this.lock = lock;
    }

    public ReadWriteList(Collection<? extends E> c) {
        this.innerList = new ArrayList<E>(c);
        this.lock = new ReentrantReadWriteLock();
    }

    public ReadWriteList(int initialCapacity) {
        this.innerList = new ArrayList(initialCapacity);
        this.lock = new ReentrantReadWriteLock();
    }

    public final ReadWriteLock getLock() {
        return this.lock;
    }

    @Override
    public int size() {
        this.lock.readLock().lock();
        try {
            int n = this.innerList.size();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public boolean isEmpty() {
        this.lock.readLock().lock();
        try {
            boolean bl = this.innerList.isEmpty();
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public boolean contains(Object o) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.innerList.contains(o);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public Iterator<E> iterator() {
        this.lock.readLock().lock();
        try {
            Iterator<E> iterator = this.innerList.iterator();
            return iterator;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public Object[] toArray() {
        this.lock.readLock().lock();
        try {
            Object[] objectArray = this.innerList.toArray();
            return objectArray;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public <T> T[] toArray(T[] a) {
        this.lock.readLock().lock();
        try {
            T[] TArray = this.innerList.toArray(a);
            return TArray;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public boolean add(E e) {
        this.lock.writeLock().lock();
        try {
            boolean bl = this.innerList.add(e);
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public boolean remove(Object o) {
        this.lock.writeLock().lock();
        try {
            boolean bl = this.innerList.remove(o);
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.innerList.containsAll(c);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        this.lock.writeLock().lock();
        try {
            boolean bl = this.innerList.addAll(c);
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        this.lock.writeLock().lock();
        try {
            boolean bl = this.innerList.addAll(index, c);
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.lock.writeLock().lock();
        try {
            boolean bl = this.innerList.removeAll(c);
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        this.lock.writeLock().lock();
        try {
            boolean bl = this.innerList.retainAll(c);
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void clear() {
        this.lock.writeLock().lock();
        try {
            this.innerList.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public E get(int index) {
        this.lock.readLock().lock();
        try {
            E e = this.innerList.get(index);
            return e;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E set(int index, E element) {
        this.lock.writeLock().lock();
        try {
            E e = this.innerList.set(index, element);
            return e;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void add(int index, E element) {
        this.lock.writeLock().lock();
        try {
            this.innerList.add(index, element);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public E remove(int index) {
        this.lock.writeLock().lock();
        try {
            E e = this.innerList.remove(index);
            return e;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public int indexOf(Object o) {
        this.lock.readLock().lock();
        try {
            int n = this.innerList.indexOf(o);
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public int lastIndexOf(Object o) {
        this.lock.readLock().lock();
        try {
            int n = this.innerList.lastIndexOf(o);
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public ListIterator<E> listIterator() {
        this.lock.readLock().lock();
        try {
            ListIterator<E> listIterator = this.innerList.listIterator();
            return listIterator;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        this.lock.readLock().lock();
        try {
            ListIterator<E> listIterator = this.innerList.listIterator(index);
            return listIterator;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        this.lock.readLock().lock();
        try {
            List<E> list = this.innerList.subList(fromIndex, toIndex);
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public E getNotThrow(int index) {
        this.lock.readLock().lock();
        try {
            if (index >= this.innerList.size()) {
                E e = null;
                return e;
            }
            E e = this.innerList.get(index);
            return e;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E[] exportArray(Class<E> aClazz) {
        this.lock.readLock().lock();
        try {
            Object[] result = (Object[])Array.newInstance(aClazz, this.innerList.size());
            this.innerList.toArray(result);
            Object[] objectArray = result;
            return objectArray;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReadWriteList<E> exportAndClear() {
        ReadWriteLock currentLock = this.lock;
        currentLock.writeLock().lock();
        try {
            ReadWriteList<E> result = new ReadWriteList<E>(this.innerList, this.lock);
            this.innerList = new ArrayList();
            this.lock = new ReentrantReadWriteLock();
            ReadWriteList<E> readWriteList = result;
            return readWriteList;
        }
        finally {
            currentLock.writeLock().unlock();
        }
    }

    public E popLast() {
        this.lock.writeLock().lock();
        try {
            int fIndex = this.innerList.size() - 1;
            if (fIndex < 0) {
                E e = null;
                return e;
            }
            E e = this.innerList.remove(fIndex);
            return e;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushByLen(E aObject, int aLen) {
        this.lock.writeLock().lock();
        try {
            int fLen = this.innerList.size();
            if (fLen >= aLen) {
                return;
            }
            this.innerList.add(aObject);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        this.lock.writeLock().unlock();
    }
}

