/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.task.taskring;

import com.seeyon.cap4.task.IQueueExecItem;
import com.seeyon.cap4.task.ITaskRing;
import com.seeyon.cap4.task.RunningTaskInfo;
import com.seeyon.cap4.task.TaskLockObj;
import com.seeyon.cap4.task.taskring.AbsTaskRing;
import com.seeyon.cap4.task.taskring.MainRing;
import com.seeyon.cap4.task.taskring.TaskRingQueues;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ShadowRing
extends AbsTaskRing
implements ITaskRing {
    private static final Log log = LogFactory.getLog(ShadowRing.class);
    private MainRing mainRing;
    private TaskLockObj lockInfo;
    private TaskRingQueues taskRingQueues;

    public ShadowRing(TaskRingQueues aTaskRingQueues, MainRing aMainRing, long formDefineId, long taskId, long formDataId) {
        this.mainRing = aMainRing;
        this.taskRingQueues = aTaskRingQueues;
        this.lockInfo = new TaskLockObj(formDefineId, taskId, formDataId);
    }

    public boolean allowExecute(RunningTaskInfo[] aRunningTasks) {
        boolean result = this.notAllowSameFormDefine(this.lockInfo.getFormId(), (TaskLockObj[])aRunningTasks);
        return result;
    }

    private boolean notAllowSameFormDefine(long aFormDefineId, TaskLockObj[] aRunningTasks) {
        for (TaskLockObj fTaskLockObj : aRunningTasks) {
            if (fTaskLockObj == null || aFormDefineId != fTaskLockObj.getFormId()) continue;
            return false;
        }
        return true;
    }

    public boolean preExecTask() {
        return true;
    }

    public int run() {
        log.warn((Object)("run: " + this.lockInfo.toString() + ",runningTasks=" + this.taskRingQueues.runningTaskCount()));
        return 1;
    }

    public void afterRun() {
        this.mainRing.notifyShadowRingCount();
    }

    public TaskLockObj getLockInfo() {
        return this.lockInfo;
    }

    public IQueueExecItem getQueueExecItem() {
        return this.mainRing.getQueueExecItem();
    }

    @Override
    public String getDependsJSonInfo() {
        return "";
    }

    @Override
    public String getShowName() {
        return "shadow";
    }
}

