/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.task.taskring;

import com.seeyon.cap4.task.taskring.TaskRingQueues;
import com.seeyon.cap4.task.taskring.TaskRingSnapshot;
import com.seeyon.ctp.form.modules.trigger.FormTriggerTaskObject;
import com.seeyon.ctp.util.DateUtil;
import java.util.concurrent.BlockingQueue;

public class TaskRingMonitor {
    private int threadCount;
    private TaskRingQueues taskRingQueues;
    private BlockingQueue<FormTriggerTaskObject> needAnalysisTaskQueue;
    private static final TaskRingMonitor instance = new TaskRingMonitor();

    private TaskRingMonitor() {
    }

    public static TaskRingMonitor getInstance() {
        return instance;
    }

    public final void init(int threadCount, TaskRingQueues taskRingQueues, BlockingQueue<FormTriggerTaskObject> needAnalysisTaskQueue) {
        this.threadCount = threadCount;
        this.taskRingQueues = taskRingQueues;
        this.needAnalysisTaskQueue = needAnalysisTaskQueue;
    }

    public final TaskRingSnapshot makeSnapshot() {
        TaskRingSnapshot snapshot = new TaskRingSnapshot();
        snapshot.setSnapshotTime(DateUtil.currentDate().getTime());
        snapshot.setInputQueueCount(this.needAnalysisTaskQueue.size());
        snapshot.setThreadCount(this.threadCount);
        snapshot.setRunningTaskInfo(this.taskRingQueues.getRunningTasks());
        snapshot.setAnalyzedTaskMap(this.taskRingQueues.getRingQueueFormInfo());
        return snapshot;
    }
}

