/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.task.taskring;

import com.seeyon.cap4.task.ITaskRing;
import com.seeyon.cap4.task.RunningTaskInfo;
import com.seeyon.cap4.task.TaskLockObj;
import com.seeyon.cap4.task.taskring.AbsTaskRing;
import com.seeyon.cap4.task.taskring.MainRing;
import com.seeyon.cap4.task.taskring.ReadWriteList;
import com.seeyon.ctp.form.modules.trigger.FormTriggerTask;
import com.seeyon.ctp.form.modules.trigger.FormTriggerTaskObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;

public class TaskRingQueues {
    private ConcurrentHashMap<Long, PrvQueueInfo> hashMap = new ConcurrentHashMap();
    private ReadWriteList<PrvQueueInfo> formDefineList = new ReadWriteList();
    private AtomicInteger getIndex = new AtomicInteger(0);
    private ArrayList<RunningTaskInfo> runningTasks = new ArrayList();

    public final void putRing(ITaskRing ring) {
        if (ring == null) {
            return;
        }
        AbsTaskRing fInitRing = (AbsTaskRing)ring;
        fInitRing.initTaskNum();
        TaskLockObj taskLockObj = ring.getLockInfo();
        PrvQueueInfo queueInfo = this.hashMap.get(taskLockObj.getFormId());
        if (queueInfo == null) {
            queueInfo = new PrvQueueInfo(taskLockObj.getFormId());
            PrvQueueInfo tempInfo = this.hashMap.putIfAbsent(taskLockObj.getFormId(), queueInfo);
            if (tempInfo == null) {
                this.formDefineList.add(queueInfo);
            } else {
                queueInfo = tempInfo;
            }
        }
        queueInfo.offerTask(ring);
    }

    public final boolean isEmptyQueue() {
        int count = this.formDefineList.size();
        if (count <= 0) {
            return true;
        }
        PrvQueueInfo[] queueArray = new PrvQueueInfo[count];
        for (PrvQueueInfo queueItem : queueArray = this.formDefineList.toArray(queueArray)) {
            if (queueItem == null || queueItem.ringQueue.isEmpty()) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int runningTaskCount() {
        ArrayList<RunningTaskInfo> arrayList = this.runningTasks;
        synchronized (arrayList) {
            return this.runningTasks.size();
        }
    }

    public final ITaskRing getRing() {
        ITaskRing result = null;
        int listCount = this.formDefineList.size();
        if (listCount <= 0) {
            return null;
        }
        int pollIndex = 0;
        while (!this.formDefineList.isEmpty()) {
            int defineIndex = this.getIndex.getAndIncrement();
            PrvQueueInfo queueInfo = this.formDefineList.getNotThrow(defineIndex %= listCount);
            if (queueInfo == null || (result = queueInfo.pollTask()) == null && ++pollIndex <= listCount) continue;
        }
        if (this.getIndex.get() > 100000) {
            this.getIndex.set(0);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int removeRunningTask(ITaskRing aTaskRing) {
        ArrayList<RunningTaskInfo> arrayList = this.runningTasks;
        synchronized (arrayList) {
            for (int i = 0; i < this.runningTasks.size(); ++i) {
                RunningTaskInfo fItem = this.runningTasks.get(i);
                if (fItem.getTaskRing() != aTaskRing) continue;
                this.runningTasks.remove(i);
                return i;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRunningTaskInfo() {
        ArrayList<RunningTaskInfo> arrayList = this.runningTasks;
        synchronized (arrayList) {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            RunningTaskInfo[] runningTaskObjArray = this.getRunningTasks();
            for (int i = 0; i < runningTaskObjArray.length; ++i) {
                if (i != 0) {
                    sb.append(",");
                }
                sb.append("{");
                RunningTaskInfo tempTask = runningTaskObjArray[i];
                sb.append(tempTask.toString());
                sb.append("}");
            }
            sb.append("]");
            return sb.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RunningTaskInfo[] getRunningTasks() {
        ArrayList<RunningTaskInfo> arrayList = this.runningTasks;
        synchronized (arrayList) {
            return this.runningTasks.toArray(new RunningTaskInfo[0]);
        }
    }

    public Map<Long, String> getRingQueueFormInfo() {
        HashMap<Long, String> analyzedTaskMap = new HashMap<Long, String>();
        for (Map.Entry<Long, PrvQueueInfo> entry : this.hashMap.entrySet()) {
            analyzedTaskMap.put(entry.getKey(), entry.getValue().getFirstTaskJSonInfo(entry.getValue().ringQueue.size()));
        }
        return analyzedTaskMap;
    }

    public List<FormTriggerTaskObject> waitTaskByEventId(Long eventId) {
        ArrayList<FormTriggerTaskObject> waitTaskList = new ArrayList<FormTriggerTaskObject>();
        for (PrvQueueInfo queueInfo : this.formDefineList) {
            waitTaskList.addAll(queueInfo.waitTaskByEventId(eventId));
        }
        return waitTaskList;
    }

    private class PrvQueueInfo {
        private long prvFormId;
        private long lastTime;
        private ConcurrentLinkedQueue<ITaskRing> ringQueue;

        private PrvQueueInfo(long formDefineId) {
            this.prvFormId = formDefineId;
            this.ringQueue = new ConcurrentLinkedQueue();
            this.lastTime = 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ITaskRing pollTask() {
            ITaskRing result;
            if (this.ringQueue.isEmpty()) {
                if (this.lastTime == 0L) {
                    this.lastTime = System.currentTimeMillis();
                }
                return null;
            }
            ConcurrentLinkedQueue<ITaskRing> concurrentLinkedQueue = this.ringQueue;
            synchronized (concurrentLinkedQueue) {
                RunningTaskInfo[] runningTaskObjArray = TaskRingQueues.this.getRunningTasks();
                result = this.ringQueue.peek();
                if (result == null || !result.allowExecute(runningTaskObjArray)) {
                    return null;
                }
                result = this.ringQueue.poll();
                if (result != null) {
                    this.newRunningTasks(result);
                }
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void newRunningTasks(ITaskRing taskRing) {
            RunningTaskInfo tempObj = new RunningTaskInfo(taskRing);
            ArrayList arrayList = TaskRingQueues.this.runningTasks;
            synchronized (arrayList) {
                TaskRingQueues.this.runningTasks.add(tempObj);
            }
        }

        private void offerTask(ITaskRing taskRing) {
            if (taskRing == null) {
                return;
            }
            this.ringQueue.offer(taskRing);
            this.lastTime = 0L;
        }

        private long getFirstTaskId() {
            if (this.ringQueue.isEmpty()) {
                return 0L;
            }
            return this.ringQueue.peek().getLockInfo().getTaskId();
        }

        private String getFirstTaskJSonInfo(int aCount) {
            if (this.ringQueue.isEmpty()) {
                return String.format("{\"count\":%d}", aCount);
            }
            ITaskRing fRing = this.ringQueue.peek();
            AbsTaskRing fSTaskRing = (AbsTaskRing)fRing;
            return fSTaskRing.getTaskJSonInfo(aCount);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<FormTriggerTaskObject> waitTaskByEventId(Long eventId) {
            ArrayList<FormTriggerTaskObject> waitTaskList = new ArrayList<FormTriggerTaskObject>();
            if (this.ringQueue.isEmpty()) {
                if (this.lastTime == 0L) {
                    this.lastTime = System.currentTimeMillis();
                }
                return waitTaskList;
            }
            ConcurrentLinkedQueue<ITaskRing> concurrentLinkedQueue = this.ringQueue;
            synchronized (concurrentLinkedQueue) {
                ConcurrentLinkedQueue<ITaskRing> tempQueue = new ConcurrentLinkedQueue<ITaskRing>();
                tempQueue.addAll(this.ringQueue);
                for (ITaskRing taskRing : tempQueue) {
                    FormTriggerTask triggerTask;
                    if (!(taskRing instanceof MainRing) || !(triggerTask = (FormTriggerTask)taskRing.getQueueExecItem().getTaskObject()).getEventId().equals(eventId)) continue;
                    waitTaskList.add((FormTriggerTaskObject)triggerTask);
                    this.ringQueue.remove(taskRing);
                }
            }
            return waitTaskList;
        }
    }
}

