/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.api;

import com.seeyon.apps.collaboration.api.NewCollDataHandler;
import com.seeyon.cap4.template.bean.ScreenCaptureParamBean;
import com.seeyon.cap4.template.service.CAPScreenCaptureService;
import com.seeyon.cap4.template.util.CAPParamUtil;
import com.seeyon.ctp.common.content.mainbody.MainbodyType;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.po.filemanager.Attachment;
import com.seeyon.ctp.report.engine.api.manager.ReportApi;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.json.JSONUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;

public class CAPNewCollDataHandler
extends NewCollDataHandler {
    private static final Log LOGGER = CtpLogFactory.getLog(CAPNewCollDataHandler.class);
    private ReportApi reportApi;
    private CAPScreenCaptureService capScreenCaptureService;
    private static final String SOURCE_ID = "sourceId";
    private static final String TITLE = "title";
    private static final String TYPE = "type";

    public String getHandlerName() {
        return "CAP";
    }

    public Map<String, Object> getParams(String sourceId, String extendInfo) {
        Map<String, Object> extendMap = Strings.isBlank((String)extendInfo) ? new HashMap() : (Map)JSONUtil.parseJSONString((String)extendInfo);
        extendMap.put(SOURCE_ID, sourceId);
        return extendMap;
    }

    public String getSubject(Map<String, Object> params) {
        Long sourceId = CAPParamUtil.getLong(params, (String)SOURCE_ID);
        String subject = null;
        try {
            HashMap<String, Long> findDesignParam = new HashMap<String, Long>();
            findDesignParam.put("designId", sourceId);
            List reports = this.reportApi.findDesignWithoutAuth(findDesignParam);
            if (reports != null && reports.size() >= 1) {
                subject = String.valueOf(((Map)reports.get(0)).get(TITLE));
            }
        }
        catch (BusinessException e) {
            LOGGER.error((Object)"getSubject is exception .", (Throwable)e);
        }
        return subject;
    }

    public int getBodyType(Map<String, Object> params) {
        return MainbodyType.HTML.getKey();
    }

    public String getBodyContent(Map<String, Object> params) {
        ScreenCaptureParamBean paramBean = new ScreenCaptureParamBean();
        paramBean.setUrl((String)params.get("url"));
        paramBean.setScreenParams((Map)params.get("screenParams"));
        paramBean.setExtParams((Map)params.get("extParams"));
        return this.capScreenCaptureService.doScreenCapture4base64(paramBean);
    }

    public List<Attachment> getAttachments(Map<String, Object> params) {
        return super.getAttachments(params);
    }

    public void setReportApi(ReportApi reportApi) {
        this.reportApi = reportApi;
    }

    public void setCapScreenCaptureService(CAPScreenCaptureService capScreenCaptureService) {
        this.capScreenCaptureService = capScreenCaptureService;
    }
}

