/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.api;

import com.seeyon.cap4.form.modules.business.BizConfigBean;
import com.seeyon.cap4.form.modules.business.BusinessManager;
import com.seeyon.cap4.form.util.BusinessUtil;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.organization.bo.V3xOrgMember;
import com.seeyon.ctp.organization.manager.OrgManager;
import com.seeyon.ctp.portal.api.AbstractPortalSet;
import com.seeyon.ctp.portal.nav.bo.PortalNavBo;
import com.seeyon.ctp.util.FlipInfo;
import com.seeyon.ctp.util.ParamUtil;
import com.seeyon.ctp.util.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;

public class CAPPortalSetImpl
extends AbstractPortalSet {
    private static final Log LOGGER = CtpLogFactory.getLog(CAPPortalSetImpl.class);
    private BusinessManager businessManager4;
    private OrgManager orgManager;

    public String getPortalType() {
        return "5";
    }

    public String[] getUseAuthArr(String bizId) {
        if (Strings.isNotBlank((String)bizId)) {
            try {
                BizConfigBean bizConfig = this.businessManager4.findBizConfigById(Long.parseLong(bizId));
                if (bizConfig != null) {
                    return new String[]{bizConfig.getAuthValue(), bizConfig.getAuthText(), "disabled"};
                }
            }
            catch (BusinessException e) {
                LOGGER.error((Object)"getUseAuthArr is error ", (Throwable)e);
            }
        }
        return null;
    }

    public String[] getManageAuthArr(String bizId) {
        if (Strings.isNotBlank((String)bizId)) {
            try {
                BizConfigBean bizConfig = this.businessManager4.findBizConfigById(Long.parseLong(bizId));
                if (bizConfig != null && bizConfig.getOwnerId() != null) {
                    V3xOrgMember v3xOrgMember = this.orgManager.getMemberById(bizConfig.getOwnerId());
                    return new String[]{"Member|" + bizConfig.getOwnerId(), v3xOrgMember.getName(), "disabled"};
                }
            }
            catch (BusinessException e) {
                LOGGER.error((Object)"getUseAuthArr is error ", (Throwable)e);
            }
        }
        return null;
    }

    public String getUrl(String navId) {
        return "/seeyon/cap4/businessTemplateController.do?method=businessIndex&bussId=" + navId;
    }

    public List<PortalNavBo> getPortalNavOptional() {
        return this.getAdaptPortalNav(false);
    }

    private List<PortalNavBo> getAdaptPortalNav(boolean ifMobile) {
        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
        parameterMap.put("businessType", "0");
        parameterMap.put("businessSource", "businessSelector");
        try {
            FlipInfo fi = (FlipInfo)this.businessManager4.listBusiness(new FlipInfo(1, -1), parameterMap).get("validBusiness");
            if (fi != null && Strings.isNotEmpty((Collection)fi.getData())) {
                ArrayList<PortalNavBo> portalNavBoList = new ArrayList<PortalNavBo>();
                List listMap = fi.getData();
                for (Map businessInfo : listMap) {
                    String bizConfigId = ParamUtil.getString((Map)businessInfo, (String)"id");
                    BizConfigBean bizConfigBean = this.businessManager4.findBizConfigById(Long.parseLong(bizConfigId));
                    if (!BusinessUtil.isBizPage(bizConfigBean)) continue;
                    Long ownerId = ParamUtil.getLong((Map)businessInfo, (String)"ownerId", (Long)0L);
                    Long userId = AppContext.currentUserId();
                    String authId = ParamUtil.getString((Map)businessInfo, (String)"authId");
                    if (!AppContext.isAdministrator() && !userId.equals(ownerId) && !BusinessUtil.checkRight(userId, authId)) continue;
                    PortalNavBo portalNavBo = new PortalNavBo();
                    if (ifMobile) {
                        portalNavBo.setId(bizConfigBean.getMenuId() + "");
                    } else {
                        portalNavBo.setId(bizConfigBean.getId() + "");
                    }
                    portalNavBo.setNavName(bizConfigBean.getName());
                    portalNavBoList.add(portalNavBo);
                }
                return portalNavBoList;
            }
        }
        catch (BusinessException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        return Collections.EMPTY_LIST;
    }

    public List<PortalNavBo> getAllMobilePortalNav() {
        return this.getAdaptPortalNav(true);
    }

    public String getNavSelectCategoryName() {
        if (AppContext.getCurrentUser().isGroupAdmin()) {
            return "";
        }
        return ResourceUtil.getString((String)"cap.template.type.tpBizIndex");
    }

    public void setBusinessManager4(BusinessManager businessManager4) {
        this.businessManager4 = businessManager4;
    }

    public void setOrgManager(OrgManager orgManager) {
        this.orgManager = orgManager;
    }
}

