/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.api;

import com.seeyon.cap4.template.constant.CAPBusinessEnum;
import com.seeyon.cap4.template.manager.CAPBusinessTemplateManager;
import com.seeyon.cap4.template.manager.CAPDownloadBaseManager;
import com.seeyon.cap4.template.po.CAPBusinessTemplate;
import com.seeyon.cap4.template.util.CAPBusinessTemplateUtil;
import com.seeyon.cap4.template.util.CAPBusinessUtil;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.report.engine.api.ReportConstants;
import com.seeyon.ctp.report.engine.api.interfaces.CapTemplateApi;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.logging.Log;

public class CAPReportTemplateApiImpl
implements CapTemplateApi {
    private static final Log logger = CtpLogFactory.getLog(CAPReportTemplateApiImpl.class);
    private CAPBusinessTemplateManager capBusinessTemplateManager;
    private CAPDownloadBaseManager capDownloadBaseManager;

    public boolean hasCustomTemplate(Long bizId, Long designId, String designType, String platform) {
        Integer type = this.getDesignType(designType);
        if (type == null) {
            return false;
        }
        if (platform == null) {
            return this.capBusinessTemplateManager.isUseCustomTemplate(bizId, designId, type);
        }
        int clientType = "PC".equals(platform) ? CAPBusinessEnum.Platform.PC.getType() : CAPBusinessEnum.Platform.MOBILE.getType();
        return this.capBusinessTemplateManager.isUseCustomTemplate(bizId, designId, type, clientType);
    }

    public void reportTemplateSaveAsNew(Long bizId, Long oldDataId, Long newDataId, String designType) throws BusinessException {
        Integer type = this.getDesignType(designType);
        if (type == null) {
            throw new BusinessException("type not support");
        }
        long startDate = System.currentTimeMillis();
        this.capDownloadBaseManager.reportTemplateSaveAsNew(bizId, oldDataId, newDataId, type);
        logger.info((Object)("reportTemplateSaveAsNew bizId:" + bizId + ", newId:" + newDataId + ", use time: " + (System.currentTimeMillis() - startDate) + " MS"));
    }

    private Integer getDesignType(String designType) {
        Integer type = null;
        if (ReportConstants.DesignType.QUERY.name().equals(designType)) {
            type = CAPBusinessEnum.TemplateType.TP_QUERY.getType();
        } else if (ReportConstants.DesignType.MULTSTATS.name().equals(designType) || ReportConstants.DesignType.STATISTICS.name().equals(designType) || ReportConstants.DesignType.SCHEDULEDSTATS.name().equals(designType)) {
            type = CAPBusinessEnum.TemplateType.TP_CACL.getType();
        }
        return type;
    }

    public Map<String, Object> getReportTemplateConfig(Long designId, String designType) throws BusinessException {
        String name;
        List list;
        String configPath;
        Map<String, Object> cfg;
        CAPBusinessTemplate template;
        HashMap<String, Object> tplMap = new HashMap<String, Object>();
        int clientType = CAPBusinessEnum.Platform.PC.getType();
        int templateType = this.getDesignType(designType);
        try {
            template = this.capBusinessTemplateManager.getCAPBusinessTemplateByPathIdAndTypeAndClient(designId, templateType, clientType);
            if (null != template) {
                tplMap.put("goodId", template.getGoodId());
                tplMap.put("goodName", template.getName());
            }
            if (null != (cfg = CAPBusinessUtil.readConfigJSON(configPath = CAPBusinessTemplateUtil.getTemplateConfigPath("base", clientType, templateType, designId.toString(), null))) && CollectionUtils.isNotEmpty((Collection)(list = (List)cfg.get("columns")))) {
                name = MapUtils.getString((Map)((Map)list.get(0)), (Object)"name");
                tplMap.put("tplName", name);
            }
        }
        catch (Exception e) {
            logger.error((Object)("\u83b7\u53d6cap4\u6a21\u677f\u62a5\u8868pc\u6a21\u677f\u51fa\u9519" + designId), (Throwable)e);
        }
        try {
            clientType = CAPBusinessEnum.Platform.MOBILE.getType();
            template = this.capBusinessTemplateManager.getCAPBusinessTemplateByPathIdAndTypeAndClient(designId, templateType, clientType);
            if (null != template) {
                tplMap.put("mGoodId", template.getGoodId());
                tplMap.put("mGoodName", template.getName());
            }
            if (null != (cfg = CAPBusinessUtil.readConfigJSON(configPath = CAPBusinessTemplateUtil.getTemplateConfigPath("base", clientType, templateType, designId.toString(), null))) && CollectionUtils.isNotEmpty((Collection)(list = (List)cfg.get("columns")))) {
                name = MapUtils.getString((Map)((Map)list.get(0)), (Object)"name");
                tplMap.put("mTplName", name);
            }
        }
        catch (Exception e) {
            logger.error((Object)("\u83b7\u53d6cap4\u6a21\u677f\u62a5\u8868\u79fb\u52a8\u6a21\u677f\u51fa\u9519" + designId), (Throwable)e);
        }
        return tplMap;
    }

    public void setCapBusinessTemplateManager(CAPBusinessTemplateManager capBusinessTemplateManager) {
        this.capBusinessTemplateManager = capBusinessTemplateManager;
    }

    public void setCapDownloadBaseManager(CAPDownloadBaseManager capDownloadBaseManager) {
        this.capDownloadBaseManager = capDownloadBaseManager;
    }
}

