/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.aspect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.util.Assert;

public final class AopUtil {
    public static Method getMethodFromTarget(JoinPoint joinPoint) {
        Method method = null;
        if (joinPoint.getSignature() instanceof MethodSignature) {
            MethodSignature signature = (MethodSignature)joinPoint.getSignature();
            method = signature.getMethod();
        }
        return method;
    }

    public static <T extends Annotation> T getMethodAnnotation(JoinPoint joinPoint, Class<T> annotation) {
        Method method = AopUtil.getMethodFromTarget(joinPoint);
        return method == null ? null : (T)method.getAnnotation(annotation);
    }

    public static Class[] getParameterTypes(JoinPoint joinPoint) {
        Method method = AopUtil.getMethodFromTarget(joinPoint);
        return method == null ? null : method.getParameterTypes();
    }

    @Deprecated
    public static <T extends Annotation> T getAnnotation(Class<?> type, Class<T> annotation) {
        Class<?> superType;
        Assert.notNull(annotation, (String)"annotation can't be null");
        Assert.notNull(type, (String)"type can't be null");
        T t = type.getAnnotation(annotation);
        if (t == null && (superType = type.getSuperclass()) != null && !superType.equals(Object.class)) {
            return AopUtil.getAnnotation(superType, annotation);
        }
        return t;
    }

    @Deprecated
    public static <T extends Annotation> T getAnnotation(JoinPoint joinPoint, Class<T> annotation) {
        return AopUtil.getAnnotation(joinPoint.getTarget().getClass(), annotation);
    }
}

