/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.aspect;

import com.seeyon.cap4.form.bean.FormDataMasterBean;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.log.CtpLogFactory;
import org.apache.commons.logging.Log;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.core.annotation.Order;

@Aspect
@Order(value=1)
public class CAPTimeAspect {
    private static final Log LOGGER = CtpLogFactory.getLog(CAPTimeAspect.class);
    private static final String SERVICE_AROUND_POINT = "execution (* com.seeyon.cap4.template.service.*Service.*(..))";
    private static final String MANAGER_AROUND_POINT = "execution (* com.seeyon.cap4.template.manager.impl.*.*(..))";
    private static final int EXEC_LOG_TIME = 1000;

    @Around(value="execution (* com.seeyon.cap4.template.service.*Service.*(..))")
    public Object serviceTimeAround(ProceedingJoinPoint joinPoint) throws Throwable {
        long startTime = System.currentTimeMillis();
        Object obj = joinPoint.proceed(joinPoint.getArgs());
        long diffTime = System.currentTimeMillis() - startTime;
        if (diffTime > 1000L) {
            MethodSignature signature = (MethodSignature)joinPoint.getSignature();
            String methodName = signature.getDeclaringTypeName() + "." + signature.getName();
            LOGGER.info((Object)(methodName + " : " + diffTime + " MS " + AppContext.currentUserName()));
        }
        return obj;
    }

    @Around(value="execution (* com.seeyon.cap4.template.manager.impl.*.*(..))")
    public Object managerTimeAround(ProceedingJoinPoint joinPoint) throws Throwable {
        long startTime = System.currentTimeMillis();
        Object[] args = joinPoint.getArgs();
        Object obj = joinPoint.proceed(args);
        long diffTime = System.currentTimeMillis() - startTime;
        if (diffTime > 1000L) {
            MethodSignature signature = (MethodSignature)joinPoint.getSignature();
            String methodName = signature.getDeclaringTypeName() + "." + signature.getName();
            String logStr = "";
            if (args != null && args.length > 1 && args[1] instanceof FormDataMasterBean) {
                logStr = logStr + "formMasterId " + ((FormDataMasterBean)args[1]).getId();
            }
            LOGGER.info((Object)(AppContext.currentUserId() + " " + logStr + " " + methodName + " : " + diffTime + " MS " + AppContext.currentUserName()));
        }
        return obj;
    }
}

