/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.aspect;

import com.seeyon.cap4.template.annotation.JMCalling4Service;
import com.seeyon.cap4.template.bean.AbstractParamBean;
import com.seeyon.cap4.template.constant.CAPBusinessEnum;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.authenticate.domain.User;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.monitor.perf.jdbcmonitor.JMCallingObj;
import com.seeyon.ctp.monitor.performance.JMMonitorService;
import java.lang.reflect.Field;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.core.annotation.Order;

@Aspect
@Order(value=2)
public class JMCallingAspect {
    private static final Log LOGGER = CtpLogFactory.getLog(JMCallingAspect.class);
    private JMMonitorService jmMonitorService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="@annotation(com.seeyon.cap4.template.annotation.JMCalling4Service)")
    public Object around(ProceedingJoinPoint joinPoint) throws Throwable {
        Object obj;
        User user = AppContext.getCurrentUser();
        JMCallingObj jmCallingObj = null;
        try {
            MethodSignature signature = (MethodSignature)joinPoint.getSignature();
            JMCalling4Service annotation = signature.getMethod().getAnnotation(JMCalling4Service.class);
            Object[] args = joinPoint.getArgs();
            Long formId = 0L;
            if (args != null && args[0] != null) {
                Object value;
                if (args[0] instanceof AbstractParamBean) {
                    Field field = null;
                    try {
                        field = args[0].getClass().getDeclaredField(annotation.formId());
                    }
                    catch (NoSuchFieldException e) {
                        LOGGER.error((Object)("this class no suchField !" + args[0].getClass().getName() + " " + e.getMessage()));
                        try {
                            field = args[0].getClass().getSuperclass().getDeclaredField(annotation.formId());
                        }
                        catch (NoSuchFieldException e1) {
                            LOGGER.error((Object)e.getMessage(), (Throwable)e1);
                        }
                    }
                    if (field != null) {
                        field.setAccessible(true);
                        Object value2 = field.get(args[0]);
                        if (value2 != null) {
                            formId = value2 instanceof Long ? (Long)value2 : Long.parseLong(String.valueOf(value2));
                        }
                    }
                } else if (args[0] instanceof Map && (value = ((Map)args[0]).get(annotation.formId())) != null) {
                    formId = Long.parseLong(String.valueOf(value));
                }
            }
            Object runType = CAPBusinessEnum.BatchOperationEnum.DEFAULT.equals((Object)annotation.batchRunType()) ? annotation.runType() : annotation.batchRunType().getRealExplain();
            jmCallingObj = this.jmMonitorService.putJMCall(formId.longValue(), runType, signature.getMethod().getName(), user != null ? user.getName() : "-");
            obj = joinPoint.proceed(args);
        }
        catch (Throwable throwable) {
            try {
                this.jmMonitorService.endJMCall(jmCallingObj);
            }
            catch (BusinessException e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
            }
            throw throwable;
        }
        try {
            this.jmMonitorService.endJMCall(jmCallingObj);
        }
        catch (BusinessException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        return obj;
    }

    public void setJmMonitorService(JMMonitorService jmMonitorService) {
        this.jmMonitorService = jmMonitorService;
    }
}

