/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.bean;

import com.seeyon.cap4.form.bean.FormFieldBean;
import com.seeyon.cap4.form.bean.FormFieldComEnum;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.ctp.util.Strings;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ImportUniqueBean {
    private boolean hasMasterField;
    private boolean hasSubField;
    private String display;
    private List<FormFieldBean> uniqueFieldList;
    private String subTableName;
    private boolean updateMark;
    private Map<String, DecimalFormat> fieldDecimalFormat;

    public Map<String, DecimalFormat> getFieldDecimalFormat() {
        if (this.fieldDecimalFormat == null) {
            this.fieldDecimalFormat = new HashMap<String, DecimalFormat>();
            for (FormFieldBean formFieldBean : this.uniqueFieldList) {
                if (!FormFieldComEnum.TEXT.getKey().equals(formFieldBean.getInputType()) || !Enums.FieldType.DECIMAL.getKey().equals(formFieldBean.getFieldType())) continue;
                String digitNum = formFieldBean.getDigitNum();
                StringBuilder formatTypeSb = new StringBuilder("0");
                if (Strings.isNotBlank((String)digitNum) && !"0".equals(digitNum)) {
                    formatTypeSb.append(".");
                    for (int l = 0; l < Integer.parseInt(digitNum); ++l) {
                        formatTypeSb.append("0");
                    }
                }
                this.fieldDecimalFormat.put(formFieldBean.getName(), new DecimalFormat(formatTypeSb.toString()));
            }
        }
        return this.fieldDecimalFormat;
    }

    public void setFieldDecimalFormat(Map<String, DecimalFormat> fieldDecimalFormat) {
        this.fieldDecimalFormat = fieldDecimalFormat;
    }

    public boolean isHasMasterField() {
        return this.hasMasterField;
    }

    public void setHasMasterField(boolean hasMasterField) {
        this.hasMasterField = hasMasterField;
    }

    public boolean isHasSubField() {
        return this.hasSubField;
    }

    public void setHasSubField(boolean hasSubField) {
        this.hasSubField = hasSubField;
    }

    public String getDisplay() {
        return this.display;
    }

    public void setDisplay(String display) {
        this.display = display;
    }

    public List<FormFieldBean> getUniqueFieldList() {
        return this.uniqueFieldList;
    }

    public void setUniqueFieldList(List<FormFieldBean> uniqueFieldList) {
        this.uniqueFieldList = uniqueFieldList;
    }

    public String getSubTableName() {
        return this.subTableName;
    }

    public void setSubTableName(String subTableName) {
        this.subTableName = subTableName;
    }

    public boolean isUpdateMark() {
        return this.updateMark;
    }

    public void setUpdateMark(boolean updateMark) {
        this.updateMark = updateMark;
    }

    public boolean isOnlyMaster() {
        return this.hasMasterField && !this.hasSubField;
    }

    public boolean isOnlySub() {
        return !this.hasMasterField && this.hasSubField;
    }

    public boolean isMasterAndSub() {
        return this.hasMasterField && this.hasSubField;
    }

    public List<String> getUniqueFieldNames() {
        ArrayList<String> str = new ArrayList<String>();
        for (FormFieldBean fieldBean : this.uniqueFieldList) {
            str.add(fieldBean.getName());
        }
        return str;
    }
}

