/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.bo;

import com.seeyon.cap4.template.bo.AbstractMallBO;
import com.seeyon.cap4.template.bo.CAPBusinessElementBO;
import com.seeyon.cap4.template.constant.CAPBusinessEnum;
import com.seeyon.cap4.template.po.CAPBusinessColumn;
import com.seeyon.cap4.template.util.CAPParamUtil;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.organization.manager.OrgManager;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.json.JSONUtil;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CAPBusinessColumnBO
extends AbstractMallBO<CAPBusinessColumn>
implements Cloneable {
    private String name;
    private String createDate;
    private String modifyDate;
    private String createMemberId;
    private String createMemberName;
    private String modifyMemberId;
    private String modifyMemberName;
    private String columnType;
    private String state;
    private String templateId;
    private List<CAPBusinessElementBO> capBusinessElementBOs;
    public static final String NAME = "name";
    public static final String CREATE_DATE = "createDate";
    public static final String MODIFY_DATE = "modifyDate";
    public static final String CREATE_MEMBER_ID = "createMemberId";
    public static final String CREATE_MEMBER_NAME = "createMemberName";
    public static final String MODIFY_MEMBER_ID = "modifyMemberId";
    public static final String MODIFY_MEMBER_NAME = "modifyMemberName";
    public static final String COLUMN_TYPE = "columnType";
    public static final String STATE = "state";
    public static final String TEMPLATE_ID = "templateId";
    public static final String CAP_BUSINESS_ELEMENTBOS = "capBusinessElementBOs";
    private static final String COLUMN_TYPE_NAME = "columnTypeName";
    private static final String COLUMN_TYPE_ALIAS = "columnTypeAlias";

    @Override
    public void importFromJSon(Map<String, Object> jsonObject) {
        this.id = (String)jsonObject.get("id");
        this.name = (String)jsonObject.get(NAME);
        this.createDate = (String)jsonObject.get(CREATE_DATE);
        this.modifyDate = (String)jsonObject.get(MODIFY_DATE);
        this.createMemberId = (String)jsonObject.get(CREATE_MEMBER_ID);
        this.createMemberName = (String)jsonObject.get(CREATE_MEMBER_NAME);
        this.modifyMemberId = (String)jsonObject.get(MODIFY_MEMBER_ID);
        this.modifyMemberName = (String)jsonObject.get(MODIFY_MEMBER_NAME);
        this.columnType = (String)jsonObject.get(COLUMN_TYPE);
        this.state = (String)jsonObject.get(STATE);
        this.goodId = (String)jsonObject.get("goodId");
        this.goodName = (String)jsonObject.get("goodName");
        this.templateId = (String)jsonObject.get(TEMPLATE_ID);
        if (jsonObject.get(CAP_BUSINESS_ELEMENTBOS) != null) {
            List list = CAPParamUtil.getParamsListByKey(jsonObject, (String)CAP_BUSINESS_ELEMENTBOS);
            this.capBusinessElementBOs = new ArrayList<CAPBusinessElementBO>();
            for (Map map : list) {
                CAPBusinessElementBO capBusinessElementBO = new CAPBusinessElementBO();
                capBusinessElementBO.importFromJSon(map);
                this.capBusinessElementBOs.add(capBusinessElementBO);
            }
        }
    }

    @Override
    public void importFromPO(CAPBusinessColumn capBusinessColumn) throws BusinessException {
        this.id = String.valueOf(capBusinessColumn.getId());
        this.name = capBusinessColumn.getName();
        this.createDate = String.valueOf(capBusinessColumn.getCreateDate());
        this.modifyDate = String.valueOf(capBusinessColumn.getModifyDate());
        this.createMemberId = String.valueOf(capBusinessColumn.getCreateMember());
        OrgManager orgManager = (OrgManager)AppContext.getBean((String)"orgManager");
        this.createMemberName = orgManager.getMemberById(capBusinessColumn.getCreateMember()).getName();
        this.modifyMemberId = String.valueOf(capBusinessColumn.getModifyMember());
        this.modifyMemberName = orgManager.getMemberById(capBusinessColumn.getModifyMember()).getName();
        this.columnType = capBusinessColumn.getColumnType() == null ? "" : String.valueOf(capBusinessColumn.getColumnType());
        this.state = capBusinessColumn.getState() == null ? "" : String.valueOf(capBusinessColumn.getState());
        this.goodId = capBusinessColumn.getGoodId() == null ? "" : String.valueOf(capBusinessColumn.getGoodId());
        this.goodName = capBusinessColumn.getGoodName() == null ? "" : capBusinessColumn.getGoodName();
        this.templateId = capBusinessColumn.getTemplateId() == null ? "" : String.valueOf(capBusinessColumn.getTemplateId());
    }

    public Map<String, Object> exportToMapForDesign() {
        HashMap<String, Object> boObject = new HashMap<String, Object>();
        boObject.put("id", this.id);
        boObject.put(NAME, this.name);
        boObject.put("goodName", this.goodName);
        boObject.put("goodId", this.goodId);
        boObject.put(COLUMN_TYPE, this.columnType);
        CAPBusinessEnum.ColumnType columnType = CAPBusinessEnum.ColumnType.getEnumByType(Integer.valueOf(this.columnType));
        boObject.put(COLUMN_TYPE_NAME, columnType == null ? "" : columnType.getName());
        boObject.put(COLUMN_TYPE_ALIAS, columnType == null ? "" : columnType.getAlias());
        boObject.put(STATE, this.state);
        boObject.put(TEMPLATE_ID, this.templateId);
        return boObject;
    }

    public CAPBusinessColumn exportToPO() throws ParseException {
        CAPBusinessColumn capBusinessColumn = new CAPBusinessColumn();
        capBusinessColumn.setId(Long.valueOf(this.id));
        capBusinessColumn.setName(this.name);
        capBusinessColumn.setCreateDate(DateUtil.parseTimestamp((String)this.createDate));
        capBusinessColumn.setCreateMember(Strings.isBlank((String)this.createMemberId) ? null : Long.valueOf(this.createMemberId));
        capBusinessColumn.setModifyDate(DateUtil.parseTimestamp((String)this.modifyDate));
        capBusinessColumn.setModifyMember(Strings.isBlank((String)this.modifyMemberId) ? null : Long.valueOf(this.modifyMemberId));
        capBusinessColumn.setColumnType(Integer.valueOf(this.columnType));
        capBusinessColumn.setState(Integer.valueOf(this.state));
        capBusinessColumn.setGoodId(Strings.isBlank((String)this.goodId) ? null : Long.valueOf(this.goodId));
        capBusinessColumn.setGoodName(this.goodName);
        capBusinessColumn.setTemplateId(Long.valueOf(this.templateId));
        return capBusinessColumn;
    }

    @Override
    public Map<String, Object> exportToJSon() {
        HashMap<String, Object> obj = new HashMap<String, Object>();
        obj.put("id", this.id);
        obj.put(NAME, this.name);
        obj.put(CREATE_DATE, this.createDate);
        obj.put(MODIFY_DATE, this.modifyDate);
        obj.put(CREATE_MEMBER_ID, this.createMemberId);
        obj.put(CREATE_MEMBER_NAME, this.createMemberName);
        obj.put(MODIFY_MEMBER_ID, this.modifyMemberId);
        obj.put(MODIFY_MEMBER_NAME, this.createMemberName);
        obj.put(COLUMN_TYPE, this.columnType);
        obj.put(STATE, this.state);
        obj.put("goodId", this.goodId);
        obj.put("goodName", this.goodName);
        obj.put(TEMPLATE_ID, this.templateId);
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        obj.put(CAP_BUSINESS_ELEMENTBOS, list);
        if (this.capBusinessElementBOs != null) {
            for (CAPBusinessElementBO capBusinessElementBO : this.capBusinessElementBOs) {
                list.add(capBusinessElementBO.exportToJSon());
            }
        }
        return obj;
    }

    @Override
    public void clear() {
        this.id = null;
        this.name = null;
        this.createDate = null;
        this.modifyDate = null;
        this.createMemberId = null;
        this.createMemberName = null;
        this.modifyMemberId = null;
        this.modifyMemberName = null;
        this.columnType = null;
        this.state = null;
        this.templateId = null;
        this.capBusinessElementBOs = null;
        this.clearMallAttr();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(String createDate) {
        this.createDate = createDate;
    }

    public String getModifyDate() {
        return this.modifyDate;
    }

    public void setModifyDate(String modifyDate) {
        this.modifyDate = modifyDate;
    }

    public String getCreateMemberId() {
        return this.createMemberId;
    }

    public void setCreateMemberId(String createMemberId) {
        this.createMemberId = createMemberId;
    }

    public String getCreateMemberName() {
        return this.createMemberName;
    }

    public void setCreateMemberName(String createMemberName) {
        this.createMemberName = createMemberName;
    }

    public String getModifyMemberId() {
        return this.modifyMemberId;
    }

    public void setModifyMemberId(String modifyMemberId) {
        this.modifyMemberId = modifyMemberId;
    }

    public String getModifyMemberName() {
        return this.modifyMemberName;
    }

    public void setModifyMemberName(String modifyMemberName) {
        this.modifyMemberName = modifyMemberName;
    }

    public String getColumnType() {
        return this.columnType;
    }

    public void setColumnType(String columnType) {
        this.columnType = columnType;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public List<CAPBusinessElementBO> getCapBusinessElementBOs() {
        return this.capBusinessElementBOs;
    }

    public void setCapBusinessElementBOs(List<CAPBusinessElementBO> capBusinessElementBOs) {
        this.capBusinessElementBOs = capBusinessElementBOs;
    }

    public String getTemplateId() {
        return this.templateId;
    }

    public void setTemplateId(String templateId) {
        this.templateId = templateId;
    }

    public String toString() {
        return JSONUtil.toJSONString(this.exportToJSon());
    }

    public static class SortCreateDateComparator
    implements Comparator<CAPBusinessColumnBO> {
        @Override
        public int compare(CAPBusinessColumnBO o1, CAPBusinessColumnBO o2) {
            Long sort1 = DateUtil.toDate((String)o1.getCreateDate()).getTime();
            Long sort2 = DateUtil.toDate((String)o2.getCreateDate()).getTime();
            if (sort1 == null || sort2 == null) {
                return 0;
            }
            return sort1.intValue() - sort2.intValue();
        }
    }
}

